<?php
/**
 * Theme Layouts
 *
 * @package TLG Framework
 *
 */

/**
	SITE LAYOUTS
**/
if( !function_exists('tlg_framework_get_site_layouts') ) {
	function tlg_framework_get_site_layouts() {
		return array(
			'normal-layout' 			=> esc_html__( 'Full Width', 'tlg_framework' ),
			'boxed-layout' 				=> esc_html__( 'Boxed', 'tlg_framework' ),
			'frame-layout' 				=> esc_html__( 'Frame', 'tlg_framework' ),
		);	
	}
}

/**
	CONTAINER LAYOUTS
**/
if( !function_exists('tlg_framework_get_container_layouts') ) {
	function tlg_framework_get_container_layouts() {
		return array(
			'normal-container' 			=> esc_html__( 'Standard', 'tlg_framework' ),
			'small-container' 			=> esc_html__( 'Small', 'tlg_framework' ),
		);	
	}
}

/**
	PAGE TITLE LAYOUTS
**/
if( !function_exists('tlg_framework_get_page_title_options') ) {
	function tlg_framework_get_page_title_options() {
		return array(
			'center' 					=> esc_html__( 'Center', 'tlg_framework' ),
			'center-large' 				=> esc_html__( 'Center Large ', 'tlg_framework' ),
			'center-bg' 				=> esc_html__( 'Center Background', 'tlg_framework' ),
			'center-bg-large' 			=> esc_html__( 'Center Background Large', 'tlg_framework' ),
			'center-parallax' 			=> esc_html__( 'Center Parallax', 'tlg_framework' ),
			'center-parallax-large' 	=> esc_html__( 'Center Parallax Large', 'tlg_framework' ), 
			'left' 						=> esc_html__( 'Left', 'tlg_framework' ),
			'left-large' 				=> esc_html__( 'Left Large', 'tlg_framework' ),
			'left-bg' 					=> esc_html__( 'Left Background', 'tlg_framework' ),
			'left-bg-large' 			=> esc_html__( 'Left Background Large', 'tlg_framework' ),
			'left-parallax' 			=> esc_html__( 'Left Parallax', 'tlg_framework' ),
			'left-parallax-large' 		=> esc_html__( 'Left Parallax Large', 'tlg_framework' ),
			'blank' 					=> esc_html__( 'No Title', 'tlg_framework' )
		);	
	}
}

/**
	HEADER LAYOUTS
**/
if( !function_exists('tlg_framework_get_header_options') ) {
	function tlg_framework_get_header_options() {
		return array(
			'standard' 						=> esc_html__( 'Standard Header', 'tlg_framework' ),
			'standard-dark' 				=> esc_html__( 'Standard Header Dark', 'tlg_framework' ),
			'standard-no-top' 				=> esc_html__( 'Standard Header No Topbar', 'tlg_framework' ),
			'standard-no-top-dark' 			=> esc_html__( 'Standard Header No Topbar Dark', 'tlg_framework' ),
			'transparent' 					=> esc_html__( 'Transparent Header', 'tlg_framework' ),
			'transparent-dark' 				=> esc_html__( 'Transparent Header Dark', 'tlg_framework' ),
			'transparent-no-top' 			=> esc_html__( 'Transparent Header No Topbar', 'tlg_framework' ),
			'transparent-no-top-dark' 		=> esc_html__( 'Transparent Header No Topbar Dark', 'tlg_framework' ),
			'minimal-standard' 				=> esc_html__( 'Minimal Standard Header', 'tlg_framework' ),
			'minimal-transparent' 			=> esc_html__( 'Minimal Transparent Header', 'tlg_framework' ),
			'minimal-transparent-dark' 		=> esc_html__( 'Minimal Transparent Header Dark', 'tlg_framework' ),
			'box' 							=> esc_html__( 'Boxed Header', 'tlg_framework' ),
			'box-no-top' 					=> esc_html__( 'Boxed Header No Topbar', 'tlg_framework' ),
			'center-standard' 				=> esc_html__( 'Center Standard Header', 'tlg_framework' ),
			'center-standard-dark' 			=> esc_html__( 'Center Standard Header Dark', 'tlg_framework' ),
			'center-transparent' 			=> esc_html__( 'Center Transparent Header', 'tlg_framework' ),
			'center-transparent-dark' 		=> esc_html__( 'Center Transparent Header Dark', 'tlg_framework' ),
			'center-transparent-no-top' 	=> esc_html__( 'Center Transparent No Topbar', 'tlg_framework' ),
			'center-transparent-dark-no-top'=> esc_html__( 'Center Transparent No Topbar Dark', 'tlg_framework' ),
			'center-left-standard' 			=> esc_html__( 'Center Left Standard Header', 'tlg_framework' ),
			'center-left-standard-dark' 	=> esc_html__( 'Center Left Standard Header Dark', 'tlg_framework' ),
			'center-left-transparent' 		=> esc_html__( 'Center Left Transparent Header', 'tlg_framework' ),
			'center-left-transparent-dark' 	=> esc_html__( 'Center Left Transparent Header Dark', 'tlg_framework' ),
			'offcanvas' 					=> esc_html__( 'Off Canvas Header', 'tlg_framework' ),
			'offcanvas-dark' 				=> esc_html__( 'Off Canvas Header Dark', 'tlg_framework' ),
			'left-vertical' 				=> esc_html__( 'Left Vertical Header', 'tlg_framework' ),
			'left-vertical-dark' 			=> esc_html__( 'Left Vertical Header Dark', 'tlg_framework' ),
			'right-vertical' 				=> esc_html__( 'Right Vertical Header', 'tlg_framework' ),
			'right-vertical-dark' 			=> esc_html__( 'Right Vertical Header Dark', 'tlg_framework' ),
			'blank' 						=> esc_html__( 'No Header', 'tlg_framework' )
		);	
	}
}

/**
	FOOTER LAYOUTS
**/
if( !function_exists('tlg_framework_get_footer_options') ) {
	function tlg_framework_get_footer_options() {
		return array(
			'standard' 					=> esc_html__( 'Standard Footer', 'tlg_framework' ),
			'standard-light' 			=> esc_html__( 'Standard Footer Light', 'tlg_framework' ),
			'basic' 					=> esc_html__( 'Basic Footer', 'tlg_framework' ),
			'basic-light' 				=> esc_html__( 'Basic Footer Light', 'tlg_framework' ),
			'modern' 					=> esc_html__( 'Modern Footer', 'tlg_framework' ),
			'modern-light' 				=> esc_html__( 'Modern Footer Light', 'tlg_framework' ),
			'minimal' 					=> esc_html__( 'Minimal Footer', 'tlg_framework' ),
			'minimal-light' 			=> esc_html__( 'Minimal Footer Light', 'tlg_framework' ),
			'copyright' 				=> esc_html__( 'Copyright Footer', 'tlg_framework' ),
			'copyright-light' 			=> esc_html__( 'Copyright Footer Light', 'tlg_framework' ),
			'blank' 					=> esc_html__( 'No Footer', 'tlg_framework' ),
		);
	}
}

/**
	BLOG LAYOUTS
**/
if( !function_exists('tlg_framework_get_blog_layouts') ) {
	function tlg_framework_get_blog_layouts() {
		return array(
			'sidebar-left' 				=> esc_html__( 'Standard Left Sidebar', 'tlg_framework' ),
			'sidebar-right' 			=> esc_html__( 'Standard Right Sidebar', 'tlg_framework' ),
			'grid-3col' 				=> esc_html__( 'Grid 3 Columns', 'tlg_framework' ),
			'grid-2col' 				=> esc_html__( 'Grid 2 Columns', 'tlg_framework' ),
			'grid-sidebar-left' 		=> esc_html__( 'Grid Left Sidebar', 'tlg_framework' ),
			'grid-sidebar-right' 		=> esc_html__( 'Grid Right Sidebar', 'tlg_framework' ),
			'masonry-sidebar-left' 		=> esc_html__( 'Masonry Left Sidebar', 'tlg_framework' ),
			'masonry-sidebar-right' 	=> esc_html__( 'Masonry Right Sidebar', 'tlg_framework'),
			'masonry-3col' 				=> esc_html__( 'Masonry 3 Columns', 'tlg_framework' ),
			'masonry-2col' 				=> esc_html__( 'Masonry 2 Columns', 'tlg_framework' ),
			'fullwidth' 				=> esc_html__( 'Column Full Width', 'tlg_framework' ),
			'feed' 						=> esc_html__( 'Feed No Sidebar', 'tlg_framework' ),
			'carousel' 					=> esc_html__( 'Carousel 4 Columns', 'tlg_framework' ),
			'carousel-3col' 			=> esc_html__( 'Carousel 3 Columns', 'tlg_framework' ),
			'carouseldetail' 			=> esc_html__( 'Carousel Detail 4 Columns', 'tlg_framework' ),
			'carouseldetail-3col' 		=> esc_html__( 'Carousel Detail 3 Columns', 'tlg_framework' ),
		);	
	}
}

/**
	PORTFOLIO LAYOUTS
**/
if( !function_exists('tlg_framework_get_portfolio_layouts') ) {
	function tlg_framework_get_portfolio_layouts() {
		return array(
			'grid-2col' 	 			=> esc_html__( 'Grid 2 Columns', 'tlg_framework' ),
			'grid-3col' 	 			=> esc_html__( 'Grid 3 Columns', 'tlg_framework' ),
			'grid-4col' 	 			=> esc_html__( 'Grid 4 Columns', 'tlg_framework' ),
			'full-grid-2col'  			=> esc_html__( 'Grid Fullwidth 2 Columns', 'tlg_framework' ),
			'full-grid-3col'  			=> esc_html__( 'Grid Fullwidth 3 Columns', 'tlg_framework' ),
			'full-grid-4col'  			=> esc_html__( 'Grid Fullwidth 4 Columns', 'tlg_framework' ),
			'masonry-2col'  			=> esc_html__( 'Masonry 2 Columns', 'tlg_framework' ),
			'masonry-3col'  			=> esc_html__( 'Masonry 3 Columns', 'tlg_framework' ),
			'masonry-4col'  			=> esc_html__( 'Masonry 4 Columns', 'tlg_framework' ),
			'full-masonry-2col' 		=> esc_html__( 'Masonry Fullwidth 2 Columns', 'tlg_framework' ),
			'full-masonry-3col' 		=> esc_html__( 'Masonry Fullwidth 3 Columns', 'tlg_framework' ),
			'full-masonry-4col' 		=> esc_html__( 'Masonry Fullwidth 4 Columns', 'tlg_framework' ),
			'modern-2col'  				=> esc_html__( 'Modern 2 Columns', 'tlg_framework' ),
			'modern-3col'  				=> esc_html__( 'Modern 3 Columns', 'tlg_framework' ),
			'modern-4col'  				=> esc_html__( 'Modern 4 Columns', 'tlg_framework' ),
			'full-modern-2col' 			=> esc_html__( 'Modern Fullwidth 2 Columns', 'tlg_framework' ),
			'full-modern-3col' 			=> esc_html__( 'Modern Fullwidth 3 Columns', 'tlg_framework' ),
			'full-modern-4col' 			=> esc_html__( 'Modern Fullwidth 4 Columns', 'tlg_framework' ),
			'parallax' 					=> esc_html__( 'Parallax', 'tlg_framework' ),
			'parallax-small' 			=> esc_html__( 'Parallax Small', 'tlg_framework' ),
			'parallax-full' 			=> esc_html__( 'Parallax Large', 'tlg_framework' ),
		);	
	}
}

/**
	TEAM LAYOUTS
**/
if( !function_exists('tlg_framework_get_team_layouts') ) {
	function tlg_framework_get_team_layouts() {
		return array(
			'standard' 					=> esc_html__( 'Standard', 'tlg_framework' ),
			'circle' 					=> esc_html__( 'Circle', 'tlg_framework' ),
			'fullwidth' 				=> esc_html__( 'Fullwidth', 'tlg_framework' ),
		);
	}
}

/**
	CLIENT LAYOUTS
**/
if( !function_exists('tlg_framework_get_client_layouts') ) {
	function tlg_framework_get_client_layouts() {
		return array(
			'standard' 					=> esc_html__( 'Standard', 'tlg_framework' ),
			'carousel' 					=> esc_html__( 'Manual scroll', 'tlg_framework' ),
			'carousel-auto' 			=> esc_html__( 'Auto scroll', 'tlg_framework' ),
		);
	}
}

/**
	TESTIMONIAL LAYOUTS
**/
if( !function_exists('tlg_framework_get_testimonial_layouts') ) {
	function tlg_framework_get_testimonial_layouts() {
		return array(
			'standard' 					=> esc_html__( 'Standard', 'tlg_framework' ),
			'boxed' 					=> esc_html__( 'Boxed', 'tlg_framework' ),
			'carousel-no-control' 		=> esc_html__( 'Carousel rotate', 'tlg_framework' ),
			'carousel-padding' 			=> esc_html__( 'Carousel review', 'tlg_framework' ),
			'carousel' 					=> esc_html__( 'Carousel style 1', 'tlg_framework' ),
			'carousel-quote' 			=> esc_html__( 'Carousel style 2', 'tlg_framework' ),
			'carousel-column' 			=> esc_html__( 'Carousel style 3', 'tlg_framework' ),
			'carousel-widget' 			=> esc_html__( 'Carousel style 4', 'tlg_framework' ),
		);
	}
}

/**
	WOO SHOP LAYOUTS
**/
if( !function_exists('tlg_framework_get_woo_layouts') ) {
	function tlg_framework_get_woo_layouts() {
		return array(
			'carouseldetail-3col' 		=> esc_html__( 'Carousel 3 Columns', 'tlg_framework' ),
			'carouseldetail-4col' 		=> esc_html__( 'Carousel 4 Columns', 'tlg_framework' ),
		);	
	}
}

/**
	SHOP ARCHIVE LAYOUTS
**/
if( !function_exists('tlg_framework_get_shop_layouts') ) {
	function tlg_framework_get_shop_layouts() {
		return array(
			'sidebar-left' 				=> esc_html__( 'Left Sidebar', 'tlg_framework' ),
			'sidebar-right' 			=> esc_html__( 'Right Sidebar', 'tlg_framework' ),
			'4col' 						=> esc_html__( '4 Columns', 'tlg_framework' ),
			'3col' 						=> esc_html__( '3 Columns', 'tlg_framework' ),
			'2col' 						=> esc_html__( '2 Columns', 'tlg_framework' )
		);	
	}
}

/**
	SINGLE LAYOUTS
**/
if( !function_exists('tlg_framework_get_single_layouts') ) {
	function tlg_framework_get_single_layouts() {
		return array(
			'sidebar-left' 				=> esc_html__( 'Left Sidebar', 'tlg_framework' ),
			'sidebar-right' 			=> esc_html__( 'Right Sidebar', 'tlg_framework' ),
			'sidebar-none' 				=> esc_html__( 'No Sidebar', 'tlg_framework' )
		);	
	}
}

/**
	BUTTON LAYOUTS
**/
if( !function_exists('tlg_framework_get_button_layouts') ) {
	function tlg_framework_get_button_layouts() {
		return array(
			esc_html__( 'Standard', 'tlg_framework' ) 						=> 'btn btn-filled',
			esc_html__( 'Standard rounded', 'tlg_framework' ) 				=> 'btn btn-filled btn-rounded',
			esc_html__( 'Standard action', 'tlg_framework' ) 				=> 'btn-action',
			esc_html__( 'Light', 'tlg_framework' ) 							=> 'btn btn-filled btn-light',
			esc_html__( 'Light rounded', 'tlg_framework' ) 					=> 'btn btn-filled btn-light btn-rounded',
			esc_html__( 'Dark', 'tlg_framework' ) 							=> 'btn btn-filled btn-dark',
			esc_html__( 'Dark rounded', 'tlg_framework' ) 					=> 'btn btn-filled btn-dark btn-rounded',
			esc_html__( 'Line', 'tlg_framework' ) 							=> 'btn',
			esc_html__( 'Line rounded', 'tlg_framework' ) 					=> 'btn btn-rounded',
			esc_html__( 'Line primary', 'tlg_framework' ) 					=> 'btn btn-primary-line',
			esc_html__( 'Line primary rounded', 'tlg_framework' ) 			=> 'btn btn-primary-line btn-rounded',
			esc_html__( 'Text', 'tlg_framework' ) 							=> 'btn-text',
			esc_html__( 'Flat', 'tlg_framework' ) 							=> 'btn btn-filled btn-flat',
			esc_html__( 'Flat Line', 'tlg_framework' ) 						=> 'btn btn-flat',
			esc_html__( 'Flat Line Gray', 'tlg_framework' ) 				=> 'btn btn-flat btn-gray',
		);	
	}
}

/**
	HOVER EFFECTS
**/
if( !function_exists('tlg_framework_get_hover_effects') ) {
	function tlg_framework_get_hover_effects() {
		return array(
			esc_html__( 'Default', 'tlg_framework' ) 				=> '',
			esc_html__( 'Grow', 'tlg_framework' ) 					=> 'hvr-grow',
			esc_html__( 'Shrink', 'tlg_framework' ) 				=> 'hvr-shrink',
			esc_html__( 'Push', 'tlg_framework' ) 					=> 'hvr-push',
			esc_html__( 'Pop', 'tlg_framework' ) 					=> 'hvr-pop',
			esc_html__( 'Bounce In', 'tlg_framework' ) 				=> 'hvr-bounce-in',
			esc_html__( 'Bounce Out', 'tlg_framework' ) 			=> 'hvr-bounce-out',
			esc_html__( 'Rotate', 'tlg_framework' ) 				=> 'hvr-rotate',
			esc_html__( 'Grow Rotate', 'tlg_framework' ) 			=> 'hvr-grow-rotate',
			esc_html__( 'Float', 'tlg_framework' ) 					=> 'hvr-float',
			esc_html__( 'Sink', 'tlg_framework' ) 					=> 'hvr-sink',
			esc_html__( 'Bob', 'tlg_framework' ) 					=> 'hvr-bob',
			esc_html__( 'Push', 'tlg_framework' ) 					=> 'hvr-push',
			esc_html__( 'Pop', 'tlg_framework' ) 					=> 'hvr-pop',
			esc_html__( 'Hang', 'tlg_framework' ) 					=> 'hvr-hang',
			esc_html__( 'Skew', 'tlg_framework' ) 					=> 'hvr-skew',
			esc_html__( 'Skew Forward', 'tlg_framework' ) 			=> 'hvr-skew-forward',
			esc_html__( 'Skew Backward', 'tlg_framework' ) 			=> 'hvr-skew-backward',
			esc_html__( 'Wobble Horizontal', 'tlg_framework' ) 		=> 'hvr-wobble-horizontal',
			esc_html__( 'Wobble Vertical', 'tlg_framework' ) 		=> 'hvr-wobble-vertical',
			esc_html__( 'Wobble To Bottom Right', 'tlg_framework' ) => 'hvr-wobble-to-bottom-right',
			esc_html__( 'Wobble To Top Right', 'tlg_framework' ) 	=> 'hvr-wobble-to-top-right',
			esc_html__( 'Wobble Top', 'tlg_framework' ) 			=> 'hvr-wobble-top',
			esc_html__( 'Wobble Bottom', 'tlg_framework' ) 			=> 'hvr-wobble-bottom',
			esc_html__( 'Wobble Skew', 'tlg_framework' ) 			=> 'hvr-wobble-skew',
			esc_html__( 'Buzz Out', 'tlg_framework' ) 				=> 'hvr-buzz-out',
			esc_html__( 'Skew Forward', 'tlg_framework' ) 			=> 'hvr-skew-forward',
			esc_html__( 'Skew Backward', 'tlg_framework' ) 			=> 'hvr-skew-backward',
		);	
	}
}

/**
	THEME ICONS
**/
if( !function_exists('tlg_framework_get_icons') ) {
	function tlg_framework_get_icons() {
		$icons = array("none","ti-arrow-up","ti-arrow-right","ti-arrow-left","ti-arrow-down","ti-arrows-vertical","ti-arrows-horizontal","ti-angle-up","ti-angle-right","ti-angle-left","ti-angle-down","ti-angle-double-up","ti-angle-double-right","ti-angle-double-left","ti-angle-double-down","ti-move","ti-fullscreen","ti-arrow-top-right","ti-arrow-top-left","ti-arrow-circle-up","ti-arrow-circle-right","ti-arrow-circle-left","ti-arrow-circle-down","ti-arrows-corner","ti-split-v","ti-split-v-alt","ti-split-h","ti-hand-point-up","ti-hand-point-right","ti-hand-point-left","ti-hand-point-down","ti-back-right","ti-back-left","ti-exchange-vertical","ti-wand","ti-save","ti-save-alt","ti-direction","ti-direction-alt","ti-user","ti-link","ti-unlink","ti-trash","ti-target","ti-tag","ti-desktop","ti-tablet","ti-mobile","ti-email","ti-star","ti-spray","ti-signal","ti-shopping-cart","ti-shopping-cart-full","ti-settings","ti-search","ti-zoom-in","ti-zoom-out","ti-cut","ti-ruler","ti-ruler-alt-2","ti-ruler-pencil","ti-ruler-alt","ti-bookmark","ti-bookmark-alt","ti-reload","ti-plus","ti-minus","ti-close","ti-pin","ti-pencil","ti-pencil-alt","ti-paint-roller","ti-paint-bucket","ti-na","ti-medall","ti-medall-alt","ti-marker","ti-marker-alt","ti-lock","ti-unlock","ti-location-arrow","ti-layout","ti-layers","ti-layers-alt","ti-key","ti-image","ti-heart","ti-heart-broken","ti-hand-stop","ti-hand-open","ti-hand-drag","ti-flag","ti-flag-alt","ti-flag-alt-2","ti-eye","ti-import","ti-export","ti-cup","ti-crown","ti-comments","ti-comment","ti-comment-alt","ti-thought","ti-clip","ti-check","ti-check-box","ti-camera","ti-announcement","ti-brush","ti-brush-alt","ti-palette","ti-briefcase","ti-bolt","ti-bolt-alt","ti-blackboard","ti-bag","ti-world","ti-wheelchair","ti-car","ti-truck","ti-timer","ti-ticket","ti-thumb-up","ti-thumb-down","ti-stats-up","ti-stats-down","ti-shine","ti-shift-right","ti-shift-left","ti-shift-right-alt","ti-shift-left-alt","ti-shield","ti-notepad","ti-server","ti-pulse","ti-printer","ti-power-off","ti-plug","ti-pie-chart","ti-panel","ti-package","ti-music","ti-music-alt","ti-mouse","ti-mouse-alt","ti-money","ti-microphone","ti-menu","ti-menu-alt","ti-map","ti-map-alt","ti-location-pin","ti-light-bulb","ti-info","ti-infinite","ti-id-badge","ti-hummer","ti-home","ti-help","ti-headphone","ti-harddrives","ti-harddrive","ti-gift","ti-game","ti-filter","ti-files","ti-file","ti-zip","ti-folder","ti-envelope","ti-dashboard","ti-cloud","ti-cloud-up","ti-cloud-down","ti-clipboard","ti-calendar","ti-book","ti-bell","ti-basketball","ti-bar-chart","ti-bar-chart-alt","ti-archive","ti-anchor","ti-alert","ti-alarm-clock","ti-agenda","ti-write","ti-wallet","ti-video-clapper","ti-video-camera","ti-vector","ti-support","ti-stamp","ti-slice","ti-shortcode","ti-receipt","ti-pin2","ti-pin-alt","ti-pencil-alt2","ti-eraser","ti-more","ti-more-alt","ti-microphone-alt","ti-magnet","ti-line-double","ti-line-dotted","ti-line-dashed","ti-ink-pen","ti-info-alt","ti-help-alt","ti-headphone-alt","ti-gallery","ti-face-smile","ti-face-sad","ti-credit-card","ti-comments-smiley","ti-time","ti-share","ti-share-alt","ti-rocket","ti-new-window","ti-rss","ti-rss-alt","ti-control-stop","ti-control-shuffle","ti-control-play","ti-control-pause","ti-control-forward","ti-control-backward","ti-volume","ti-control-skip-forward","ti-control-skip-backward","ti-control-record","ti-control-eject","ti-paragraph","ti-uppercase","ti-underline","ti-text","ti-Italic","ti-smallcap","ti-list","ti-list-ol","ti-align-right","ti-align-left","ti-align-justify","ti-align-center","ti-quote-right","ti-quote-left","ti-layout-width-full","ti-layout-width-default","ti-layout-width-default-alt","ti-layout-tab","ti-layout-tab-window","ti-layout-tab-v","ti-layout-tab-min","ti-layout-slider","ti-layout-slider-alt","ti-layout-sidebar-right","ti-layout-sidebar-none","ti-layout-sidebar-left","ti-layout-placeholder","ti-layout-menu","ti-layout-menu-v","ti-layout-menu-separated","ti-layout-menu-full","ti-layout-media-right","ti-layout-media-right-alt","ti-layout-media-overlay","ti-layout-media-overlay-alt","ti-layout-media-overlay-alt-2","ti-layout-media-left","ti-layout-media-left-alt","ti-layout-media-center","ti-layout-media-center-alt","ti-layout-list-thumb","ti-layout-list-thumb-alt","ti-layout-list-post","ti-layout-list-large-image","ti-layout-line-solid","ti-layout-grid4","ti-layout-grid3","ti-layout-grid2","ti-layout-grid2-thumb","ti-layout-cta-right","ti-layout-cta-left","ti-layout-cta-center","ti-layout-cta-btn-right","ti-layout-cta-btn-left","ti-layout-column4","ti-layout-column3","ti-layout-column2","ti-layout-accordion-separated","ti-layout-accordion-merged","ti-layout-accordion-list","ti-widgetized","ti-widget","ti-widget-alt","ti-view-list","ti-view-list-alt","ti-view-grid","ti-upload","ti-download","ti-loop","ti-layout-sidebar-2","ti-layout-grid4-alt","ti-layout-grid3-alt","ti-layout-grid2-alt","ti-layout-column4-alt","ti-layout-column3-alt","ti-layout-column2-alt","ti-flickr","ti-flickr-alt","ti-instagram","ti-google","ti-github","ti-facebook","ti-dropbox","ti-dropbox-alt","ti-dribbble","ti-apple","ti-android","ti-yahoo","ti-trello","ti-stack-overflow","ti-soundcloud","ti-sharethis","ti-sharethis-alt","ti-reddit","ti-microsoft","ti-microsoft-alt","ti-linux","ti-jsfiddle","ti-joomla","ti-html5","ti-css3","ti-drupal","ti-wordpress","ti-tumblr","ti-tumblr-alt","ti-skype","ti-youtube","fa fa-youtube-play","ti-vimeo","ti-vimeo-alt","ti-twitter","ti-twitter-alt","ti-linkedin","ti-pinterest","ti-pinterest-alt","fa fa-tripadvisor","fa fa-vk","fa fa-behance","fa fa-500px","ti-email","fa fa-envelope","fa fa-envelope-o","fa fa-phone","fa fa-phone-square","fa fa-home");
		$custom_icons = get_option( 'tlg_framework_custom_icons', '' );
		if (!empty($custom_icons)) {
			$pieces_icons = explode(",", $custom_icons);
			if (!empty($pieces_icons)) {
				foreach ($pieces_icons as $icon) {
					$icons[] = $icon;
				}
			}
		}
		return $icons;
	}
}

/**
	SOCIAL ICONS
**/
if( !function_exists('tlg_framework_get_social_icons') ) {
	function tlg_framework_get_social_icons() {
		$icons = array("none","ti-flickr","ti-flickr-alt","ti-instagram","ti-google","ti-github","ti-facebook","ti-dropbox","ti-dropbox-alt","ti-dribbble","ti-apple","ti-android","ti-yahoo","ti-trello","ti-stack-overflow","ti-soundcloud","ti-sharethis","ti-sharethis-alt","ti-reddit","ti-microsoft","ti-microsoft-alt","ti-linux","ti-jsfiddle","ti-joomla","ti-html5","ti-css3","ti-drupal","ti-wordpress","ti-tumblr","ti-tumblr-alt","ti-skype","ti-youtube","fa fa-youtube-play","ti-vimeo","ti-vimeo-alt","ti-twitter","ti-twitter-alt","ti-linkedin","ti-pinterest","ti-pinterest-alt","fa fa-tripadvisor","fa fa-vk","fa fa-behance","fa fa-500px","ti-email","fa fa-envelope","fa fa-envelope-o","fa fa-phone","fa fa-phone-square","fa fa-home","ti-map","ti-map-alt","ti-location-pin","ti-cloud","ti-cloud-up","ti-cloud-down");
		$custom_icons = get_option( 'tlg_framework_custom_icons', '' );
		if (!empty($custom_icons)) {
			$pieces_icons = explode(",", $custom_icons);
			if (!empty($pieces_icons)) {
				foreach ($pieces_icons as $icon) {
					$icons[] = $icon;
				}
			}
		}
		return $icons;
	}
}

/**
	GET CONTACT FORM 7
**/
if( !function_exists('tlg_framework_get_contact_form') ) {
    function tlg_framework_get_contact_form() {
    	$wpcf7_form_options = get_posts( array( 'post_type' => 'wpcf7_contact_form', 'posts_per_page' => -1) );
    	$wpcf7_forms = array();
		$wpcf7_forms[0] = esc_html__( 'No', 'tlg_framework' );
		if( count( $wpcf7_form_options ) ) {
			foreach( $wpcf7_form_options as $form_option ) {
				$wpcf7_forms[$form_option->post_title] = $form_option->ID;
			}
		}
        return $wpcf7_forms;
    }
}

/**
	GET GOOGLE FONTS
**/
if( !function_exists('tlg_framework_get_font_options') ) {
	function tlg_framework_get_font_options() {
		$fonts = array(
			"0" => esc_html__( "(default)", "tlg_framework"),"ABeeZee:tlg://fonts.gstatic.com/s/abeezee/v9/mE5BOuZKGln_Ex0uYKpIaw.ttf:tlg:regular" => esc_html__( "ABeeZee - regular", "tlg_framework"),"ABeeZee:tlg://fonts.gstatic.com/s/abeezee/v9/kpplLynmYgP0YtlJA3atRw.ttf:tlg:italic" => esc_html__( "ABeeZee - italic", "tlg_framework"),"Abel:tlg://fonts.gstatic.com/s/abel/v6/RpUKfqNxoyNe_ka23bzQ2A.ttf:tlg:regular" => esc_html__( "Abel - regular", "tlg_framework"),"Abril Fatface:tlg://fonts.gstatic.com/s/abrilfatface/v8/X1g_KwGeBV3ajZIXQ9VnDojjx0o0jr6fNXxPgYh_a8Q.ttf:tlg:regular" => esc_html__( "Abril Fatface - regular", "tlg_framework"),"Aclonica:tlg://fonts.gstatic.com/s/aclonica/v6/M6pHZMPwK3DiBSlo3jwAKQ.ttf:tlg:regular" => esc_html__( "Aclonica - regular", "tlg_framework"),"Acme:tlg://fonts.gstatic.com/s/acme/v5/-J6XNtAHPZBEbsifCdBt-g.ttf:tlg:regular" => esc_html__( "Acme - regular", "tlg_framework"),"Actor:tlg://fonts.gstatic.com/s/actor/v6/ugMf40CrRK6Jf6Yz_xNSmQ.ttf:tlg:regular" => esc_html__( "Actor - regular", "tlg_framework"),"Adamina:tlg://fonts.gstatic.com/s/adamina/v8/RUQfOodOMiVVYqFZcSlT9w.ttf:tlg:regular" => esc_html__( "Adamina - regular", "tlg_framework"),"Advent Pro:tlg://fonts.gstatic.com/s/adventpro/v4/87-JOpSUecTG50PBYK4ysi3USBnSvpkopQaUR-2r7iU.ttf:tlg:100" => esc_html__( "Advent Pro - 100", "tlg_framework"),"Advent Pro:tlg://fonts.gstatic.com/s/adventpro/v4/URTSSjIp0Wr-GrjxFdFWnGeudeTO44zf-ht3k-KNzwg.ttf:tlg:200" => esc_html__( "Advent Pro - 200", "tlg_framework"),"Advent Pro:tlg://fonts.gstatic.com/s/adventpro/v4/sJaBfJYSFgoB80OL1_66m0eOrDcLawS7-ssYqLr2Xp4.ttf:tlg:300" => esc_html__( "Advent Pro - 300", "tlg_framework"),"Advent Pro:tlg://fonts.gstatic.com/s/adventpro/v4/1NxMBeKVcNNH2H46AUR3wfesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Advent Pro - regular", "tlg_framework"),"Advent Pro:tlg://fonts.gstatic.com/s/adventpro/v4/7kBth2-rT8tP40RmMMXMLJp-63r6doWhTEbsfBIRJ7A.ttf:tlg:500" => esc_html__( "Advent Pro - 500", "tlg_framework"),"Advent Pro:tlg://fonts.gstatic.com/s/adventpro/v4/3Jo-2maCzv2QLzQBzaKHV_pTEJqju4Hz1txDWij77d4.ttf:tlg:600" => esc_html__( "Advent Pro - 600", "tlg_framework"),"Advent Pro:tlg://fonts.gstatic.com/s/adventpro/v4/M4I6QiICt-ey_wZTpR2gKwJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700" => esc_html__( "Advent Pro - 700", "tlg_framework"),"Aguafina Script:tlg://fonts.gstatic.com/s/aguafinascript/v5/65g7cgMtMGnNlNyq_Z6CvMxLhO8OSNnfAp53LK1_iRs.ttf:tlg:regular" => esc_html__( "Aguafina Script - regular", "tlg_framework"),"Akronim:tlg://fonts.gstatic.com/s/akronim/v5/qA0L2CSArk3tuOWE1AR1DA.ttf:tlg:regular" => esc_html__( "Akronim - regular", "tlg_framework"),"Aladin:tlg://fonts.gstatic.com/s/aladin/v5/PyuJ5cVHkduO0j5fAMKvAA.ttf:tlg:regular" => esc_html__( "Aladin - regular", "tlg_framework"),"Aldrich:tlg://fonts.gstatic.com/s/aldrich/v6/kMMW1S56gFx7RP_mW1g-Eg.ttf:tlg:regular" => esc_html__( "Aldrich - regular", "tlg_framework"),"Alef:tlg://fonts.gstatic.com/s/alef/v6/ENvZ_P0HBDQxNZYCQO0lUA.ttf:tlg:regular" => esc_html__( "Alef - regular", "tlg_framework"),"Alef:tlg://fonts.gstatic.com/s/alef/v6/VDgZJhEwudtOzOFQpZ8MEA.ttf:tlg:700" => esc_html__( "Alef - 700", "tlg_framework"),"Alegreya:tlg://fonts.gstatic.com/s/alegreya/v7/62J3atXd6bvMU4qO_ca-eA.ttf:tlg:regular" => esc_html__( "Alegreya - regular", "tlg_framework"),"Alegreya:tlg://fonts.gstatic.com/s/alegreya/v7/cbshnQGxwmlHBjUil7DaIfesZW2xOQ-xsNqO47m55DA.ttf:tlg:italic" => esc_html__( "Alegreya - italic", "tlg_framework"),"Alegreya:tlg://fonts.gstatic.com/s/alegreya/v7/5oZtdI5-wQwgAFrd9erCsaCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Alegreya - 700", "tlg_framework"),"Alegreya:tlg://fonts.gstatic.com/s/alegreya/v7/IWi8e5bpnqhMRsZKTcTUWgJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700italic" => esc_html__( "Alegreya - 700italic", "tlg_framework"),"Alegreya:tlg://fonts.gstatic.com/s/alegreya/v7/oQeMxX-vxGImzDgX6nxA7KCWcynf_cDxXwCLxiixG1c.ttf:tlg:900" => esc_html__( "Alegreya - 900", "tlg_framework"),"Alegreya:tlg://fonts.gstatic.com/s/alegreya/v7/-L71QLH_XqgYWaI1GbOVhp0EAVxt0G0biEntp43Qt6E.ttf:tlg:900italic" => esc_html__( "Alegreya - 900italic", "tlg_framework"),"Alegreya SC:tlg://fonts.gstatic.com/s/alegreyasc/v6/3ozeFnTbygMK6PfHh8B-iqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Alegreya SC - regular", "tlg_framework"),"Alegreya SC:tlg://fonts.gstatic.com/s/alegreyasc/v6/GOqmv3FLsJ2r6ZALMZVBmkeOrDcLawS7-ssYqLr2Xp4.ttf:tlg:italic" => esc_html__( "Alegreya SC - italic", "tlg_framework"),"Alegreya SC:tlg://fonts.gstatic.com/s/alegreyasc/v6/M9OIREoxDkvynwTpBAYUq3e1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Alegreya SC - 700", "tlg_framework"),"Alegreya SC:tlg://fonts.gstatic.com/s/alegreyasc/v6/5PCoU7IUfCicpKBJtBmP6c_zJjSACmk0BRPxQqhnNLU.ttf:tlg:700italic" => esc_html__( "Alegreya SC - 700italic", "tlg_framework"),"Alegreya SC:tlg://fonts.gstatic.com/s/alegreyasc/v6/M9OIREoxDkvynwTpBAYUqyenaqEuufTBk9XMKnKmgDA.ttf:tlg:900" => esc_html__( "Alegreya SC - 900", "tlg_framework"),"Alegreya SC:tlg://fonts.gstatic.com/s/alegreyasc/v6/5PCoU7IUfCicpKBJtBmP6U_yTOUGsoC54csJe1b-IRw.ttf:tlg:900italic" => esc_html__( "Alegreya SC - 900italic", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/TKyx_-JJ6MdpQruNk-t-PJFGFO4uyVFMfB6LZsii7kI.ttf:tlg:100" => esc_html__( "Alegreya Sans - 100", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/gRkSP2lBpqoMTVxg7DmVn2cDnjsrnI9_xJ-5gnBaHsE.ttf:tlg:100italic" => esc_html__( "Alegreya Sans - 100italic", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/11EDm-lum6tskJMBbdy9acB1LjARzAvdqa1uQC32v70.ttf:tlg:300" => esc_html__( "Alegreya Sans - 300", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/WfiXipsmjqRqsDBQ1bA9CnfqlVoxTUFFx1C8tBqmbcg.ttf:tlg:300italic" => esc_html__( "Alegreya Sans - 300italic", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/KYNzioYhDai7mTMnx_gDgn8f0n03UdmQgF_CLvNR2vg.ttf:tlg:regular" => esc_html__( "Alegreya Sans - regular", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/TKyx_-JJ6MdpQruNk-t-PD4G9C9ttb0Oz5Cvf0qOitE.ttf:tlg:italic" => esc_html__( "Alegreya Sans - italic", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/11EDm-lum6tskJMBbdy9aQqQmZ7VjhwksfpNVG0pqGc.ttf:tlg:500" => esc_html__( "Alegreya Sans - 500", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/WfiXipsmjqRqsDBQ1bA9Cs7DCVO6wo6i5LKIyZDzK40.ttf:tlg:500italic" => esc_html__( "Alegreya Sans - 500italic", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/11EDm-lum6tskJMBbdy9aVCbmAUID8LN-q3pJpOk3Ys.ttf:tlg:700" => esc_html__( "Alegreya Sans - 700", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/WfiXipsmjqRqsDBQ1bA9CpF66r9C4AnxxlBlGd7xY4g.ttf:tlg:700italic" => esc_html__( "Alegreya Sans - 700italic", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/11EDm-lum6tskJMBbdy9acxnD5BewVtRRHHljCwR2bM.ttf:tlg:800" => esc_html__( "Alegreya Sans - 800", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/WfiXipsmjqRqsDBQ1bA9CicOAJ_9MkLPbDmrtXDPbIU.ttf:tlg:800italic" => esc_html__( "Alegreya Sans - 800italic", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/11EDm-lum6tskJMBbdy9aW42xlVP-j5dagE7-AU2zwg.ttf:tlg:900" => esc_html__( "Alegreya Sans - 900", "tlg_framework"),"Alegreya Sans:tlg://fonts.gstatic.com/s/alegreyasans/v3/WfiXipsmjqRqsDBQ1bA9ChRaDUI9aE8-k7PrIG2iiuo.ttf:tlg:900italic" => esc_html__( "Alegreya Sans - 900italic", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/trwFkDJLOJf6hqM93944kVnzStfdnFU-MXbO84aBs_M.ttf:tlg:100" => esc_html__( "Alegreya Sans SC - 100", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/qG3gA9iy5RpXMH4crZboqqakMVR0XlJhO7VdJ8yYvA4.ttf:tlg:100italic" => esc_html__( "Alegreya Sans SC - 100italic", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/AjAmkoP1y0Vaad0UPPR46-1IqtfxJspFjzJp0SaQRcI.ttf:tlg:300" => esc_html__( "Alegreya Sans SC - 300", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/0VweK-TO3aQgazdxg8fs0CnTKaH808trtzttbEg4yVA.ttf:tlg:300italic" => esc_html__( "Alegreya Sans SC - 300italic", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/6kgb6ZvOagoVIRZyl8XV-EklWX-XdLVn1WTiuGuvKIU.ttf:tlg:regular" => esc_html__( "Alegreya Sans SC - regular", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/trwFkDJLOJf6hqM93944kTfqo69HNOlCNZvbwAmUtiA.ttf:tlg:italic" => esc_html__( "Alegreya Sans SC - italic", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/AjAmkoP1y0Vaad0UPPR46_hHTluI57wqxl55RvSYo3s.ttf:tlg:500" => esc_html__( "Alegreya Sans SC - 500", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/0VweK-TO3aQgazdxg8fs0NqVvxKdFVwqwzilqfVd39U.ttf:tlg:500italic" => esc_html__( "Alegreya Sans SC - 500italic", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/AjAmkoP1y0Vaad0UPPR4600aId5t1FC-xZ8nmpa_XLk.ttf:tlg:700" => esc_html__( "Alegreya Sans SC - 700", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/0VweK-TO3aQgazdxg8fs0IBYn3VD6xMEnodOh8pnFw4.ttf:tlg:700italic" => esc_html__( "Alegreya Sans SC - 700italic", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/AjAmkoP1y0Vaad0UPPR46wQgSHD3Lo1Mif2Wkk5swWA.ttf:tlg:800" => esc_html__( "Alegreya Sans SC - 800", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/0VweK-TO3aQgazdxg8fs0HStmCm6Rs90XeztCALm0H8.ttf:tlg:800italic" => esc_html__( "Alegreya Sans SC - 800italic", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/AjAmkoP1y0Vaad0UPPR461Rf9EWUSEX_PR1d_gLKfpM.ttf:tlg:900" => esc_html__( "Alegreya Sans SC - 900", "tlg_framework"),"Alegreya Sans SC:tlg://fonts.gstatic.com/s/alegreyasanssc/v3/0VweK-TO3aQgazdxg8fs0IvtwEfTCJoOJugANj-jWDI.ttf:tlg:900italic" => esc_html__( "Alegreya Sans SC - 900italic", "tlg_framework"),"Alex Brush:tlg://fonts.gstatic.com/s/alexbrush/v6/ooh3KJFbKJSUoIRWfiu8o_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Alex Brush - regular", "tlg_framework"),"Alfa Slab One:tlg://fonts.gstatic.com/s/alfaslabone/v5/Qx6FPcitRwTC_k88tLPc-Yjjx0o0jr6fNXxPgYh_a8Q.ttf:tlg:regular" => esc_html__( "Alfa Slab One - regular", "tlg_framework"),"Alice:tlg://fonts.gstatic.com/s/alice/v7/wZTAfivekBqIg-rk63nFvQ.ttf:tlg:regular" => esc_html__( "Alice - regular", "tlg_framework"),"Alike:tlg://fonts.gstatic.com/s/alike/v8/Ho8YpRKNk_202fwDiGNIyw.ttf:tlg:regular" => esc_html__( "Alike - regular", "tlg_framework"),"Alike Angular:tlg://fonts.gstatic.com/s/alikeangular/v6/OpeCu4xxI3qO1C7CZcJtPT3XH2uEnVI__ynTBvNyki8.ttf:tlg:regular" => esc_html__( "Alike Angular - regular", "tlg_framework"),"Allan:tlg://fonts.gstatic.com/s/allan/v7/T3lemhgZmLQkQI2Qc2bQHA.ttf:tlg:regular" => esc_html__( "Allan - regular", "tlg_framework"),"Allan:tlg://fonts.gstatic.com/s/allan/v7/zSxQiwo7wgnr7KkMXhSiag.ttf:tlg:700" => esc_html__( "Allan - 700", "tlg_framework"),"Allerta:tlg://fonts.gstatic.com/s/allerta/v7/s9FOEuiJFTNbMe06ifzV8g.ttf:tlg:regular" => esc_html__( "Allerta - regular", "tlg_framework"),"Allerta Stencil:tlg://fonts.gstatic.com/s/allertastencil/v7/CdSZfRtHbQrBohqmzSdDYFf2eT4jUldwg_9fgfY_tHc.ttf:tlg:regular" => esc_html__( "Allerta Stencil - regular", "tlg_framework"),"Allura:tlg://fonts.gstatic.com/s/allura/v4/4hcqgZanyuJ2gMYWffIR6A.ttf:tlg:regular" => esc_html__( "Allura - regular", "tlg_framework"),"Almendra:tlg://fonts.gstatic.com/s/almendra/v8/PDpbB-ZF7deXAAEYPkQOeg.ttf:tlg:regular" => esc_html__( "Almendra - regular", "tlg_framework"),"Almendra:tlg://fonts.gstatic.com/s/almendra/v8/CNWLyiDucqVKVgr4EMidi_esZW2xOQ-xsNqO47m55DA.ttf:tlg:italic" => esc_html__( "Almendra - italic", "tlg_framework"),"Almendra:tlg://fonts.gstatic.com/s/almendra/v8/ZpLdQMj7Q2AFio4nNO6A76CWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Almendra - 700", "tlg_framework"),"Almendra:tlg://fonts.gstatic.com/s/almendra/v8/-tXHKMcnn6FqrhJV3l1e3QJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700italic" => esc_html__( "Almendra - 700italic", "tlg_framework"),"Almendra Display:tlg://fonts.gstatic.com/s/almendradisplay/v6/2Zuu97WJ_ez-87yz5Ai8fF6uyC_qD11hrFQ6EGgTJWI.ttf:tlg:regular" => esc_html__( "Almendra Display - regular", "tlg_framework"),"Almendra SC:tlg://fonts.gstatic.com/s/almendrasc/v6/IuiLd8Fm9I6raSalxMoWeaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Almendra SC - regular", "tlg_framework"),"Amarante:tlg://fonts.gstatic.com/s/amarante/v4/2dQHjIBWSpydit5zkJZnOw.ttf:tlg:regular" => esc_html__( "Amarante - regular", "tlg_framework"),"Amaranth:tlg://fonts.gstatic.com/s/amaranth/v6/7VcBog22JBHsHXHdnnycTA.ttf:tlg:regular" => esc_html__( "Amaranth - regular", "tlg_framework"),"Amaranth:tlg://fonts.gstatic.com/s/amaranth/v6/UrJlRY9LcVERJSvggsdBqPesZW2xOQ-xsNqO47m55DA.ttf:tlg:italic" => esc_html__( "Amaranth - italic", "tlg_framework"),"Amaranth:tlg://fonts.gstatic.com/s/amaranth/v6/j5OFHqadfxyLnQRxFeox6qCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Amaranth - 700", "tlg_framework"),"Amaranth:tlg://fonts.gstatic.com/s/amaranth/v6/BHyuYFj9nqLFNvOvGh0xTwJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700italic" => esc_html__( "Amaranth - 700italic", "tlg_framework"),"Amatic SC:tlg://fonts.gstatic.com/s/amaticsc/v8/MldbRWLFytvqxU1y81xSVg.ttf:tlg:regular" => esc_html__( "Amatic SC - regular", "tlg_framework"),"Amatic SC:tlg://fonts.gstatic.com/s/amaticsc/v8/IDnkRTPGcrSVo50UyYNK7y3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Amatic SC - 700", "tlg_framework"),"Amethysta:tlg://fonts.gstatic.com/s/amethysta/v4/1jEo9tOFIJDolAUpBnWbnA.ttf:tlg:regular" => esc_html__( "Amethysta - regular", "tlg_framework"),"Amiri:tlg://fonts.gstatic.com/s/amiri/v7/ATARrPmSew75SlpOw2YABQ.ttf:tlg:regular" => esc_html__( "Amiri - regular", "tlg_framework"),"Amiri:tlg://fonts.gstatic.com/s/amiri/v7/3t1yTQlLUXBw8htrqlXBrw.ttf:tlg:italic" => esc_html__( "Amiri - italic", "tlg_framework"),"Amiri:tlg://fonts.gstatic.com/s/amiri/v7/WQsR_moz-FNqVwGYgptqiA.ttf:tlg:700" => esc_html__( "Amiri - 700", "tlg_framework"),"Amiri:tlg://fonts.gstatic.com/s/amiri/v7/uF8aNEyD0bxMeTBg9bFDSPesZW2xOQ-xsNqO47m55DA.ttf:tlg:700italic" => esc_html__( "Amiri - 700italic", "tlg_framework"),"Amita:tlg://fonts.gstatic.com/s/amita/v1/RhdhGBXSJqkHo6g7miTEcQ.ttf:tlg:regular" => esc_html__( "Amita - regular", "tlg_framework"),"Amita:tlg://fonts.gstatic.com/s/amita/v1/cIYA2Lzp7l2pcGsqpUidBg.ttf:tlg:700" => esc_html__( "Amita - 700", "tlg_framework"),"Anaheim:tlg://fonts.gstatic.com/s/anaheim/v4/t-z8aXHMpgI2gjN_rIflKA.ttf:tlg:regular" => esc_html__( "Anaheim - regular", "tlg_framework"),"Andada:tlg://fonts.gstatic.com/s/andada/v7/rSFaDqNNQBRw3y19MB5Y4w.ttf:tlg:regular" => esc_html__( "Andada - regular", "tlg_framework"),"Andika:tlg://fonts.gstatic.com/s/andika/v7/oe-ag1G0lcqZ3IXfeEgaGg.ttf:tlg:regular" => esc_html__( "Andika - regular", "tlg_framework"),"Angkor:tlg://fonts.gstatic.com/s/angkor/v8/DLpLgIS-8F10ecwKqCm95Q.ttf:tlg:regular" => esc_html__( "Angkor - regular", "tlg_framework"),"Annie Use Your Telescope:tlg://fonts.gstatic.com/s/annieuseyourtelescope/v6/2cuiO5VmaR09C8SLGEQjGqbp7mtG8sPlcZvOaO8HBak.ttf:tlg:regular" => esc_html__( "Annie Use Your Telescope - regular", "tlg_framework"),"Anonymous Pro:tlg://fonts.gstatic.com/s/anonymouspro/v8/Zhfjj_gat3waL4JSju74E-V_5zh5b-_HiooIRUBwn1A.ttf:tlg:regular" => esc_html__( "Anonymous Pro - regular", "tlg_framework"),"Anonymous Pro:tlg://fonts.gstatic.com/s/anonymouspro/v8/q0u6LFHwttnT_69euiDbWKwIsuKDCXG0NQm7BvAgx-c.ttf:tlg:italic" => esc_html__( "Anonymous Pro - italic", "tlg_framework"),"Anonymous Pro:tlg://fonts.gstatic.com/s/anonymouspro/v8/WDf5lZYgdmmKhO8E1AQud--Cz_5MeePnXDAcLNWyBME.ttf:tlg:700" => esc_html__( "Anonymous Pro - 700", "tlg_framework"),"Anonymous Pro:tlg://fonts.gstatic.com/s/anonymouspro/v8/_fVr_XGln-cetWSUc-JpfA1LL9bfs7wyIp6F8OC9RxA.ttf:tlg:700italic" => esc_html__( "Anonymous Pro - 700italic", "tlg_framework"),"Antic:tlg://fonts.gstatic.com/s/antic/v7/hEa8XCNM7tXGzD0Uk0AipA.ttf:tlg:regular" => esc_html__( "Antic - regular", "tlg_framework"),"Antic Didone:tlg://fonts.gstatic.com/s/anticdidone/v4/r3nJcTDuOluOL6LGDV1vRy3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Antic Didone - regular", "tlg_framework"),"Antic Slab:tlg://fonts.gstatic.com/s/anticslab/v4/PSbJCTKkAS7skPdkd7AKEvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Antic Slab - regular", "tlg_framework"),"Anton:tlg://fonts.gstatic.com/s/anton/v7/XIbCenm-W0IRHWYIh7CGUQ.ttf:tlg:regular" => esc_html__( "Anton - regular", "tlg_framework"),"Arapey:tlg://fonts.gstatic.com/s/arapey/v5/dqu823lrSYn8T2gApTdslA.ttf:tlg:regular" => esc_html__( "Arapey - regular", "tlg_framework"),"Arapey:tlg://fonts.gstatic.com/s/arapey/v5/pY-Xi5JNBpaWxy2tZhEm5A.ttf:tlg:italic" => esc_html__( "Arapey - italic", "tlg_framework"),"Arbutus:tlg://fonts.gstatic.com/s/arbutus/v5/Go_hurxoUsn5MnqNVQgodQ.ttf:tlg:regular" => esc_html__( "Arbutus - regular", "tlg_framework"),"Arbutus Slab:tlg://fonts.gstatic.com/s/arbutusslab/v4/6k3Yp6iS9l4jRIpynA8qMy3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Arbutus Slab - regular", "tlg_framework"),"Architects Daughter:tlg://fonts.gstatic.com/s/architectsdaughter/v6/RXTgOOQ9AAtaVOHxx0IUBMCy0EhZjHzu-y0e6uLf4Fg.ttf:tlg:regular" => esc_html__( "Architects Daughter - regular", "tlg_framework"),"Archivo Black:tlg://fonts.gstatic.com/s/archivoblack/v4/WoAoVT7K3k7hHfxKbvB6B51XQG8isOYYJhPIYAyrESQ.ttf:tlg:regular" => esc_html__( "Archivo Black - regular", "tlg_framework"),"Archivo Narrow:tlg://fonts.gstatic.com/s/archivonarrow/v5/DsLzC9scoPnrGiwYYMQXppTvAuddT2xDMbdz0mdLyZY.ttf:tlg:regular" => esc_html__( "Archivo Narrow - regular", "tlg_framework"),"Archivo Narrow:tlg://fonts.gstatic.com/s/archivonarrow/v5/vqsrtPCpTU3tJlKfuXP5zUpmlyBQEFfdE6dERLXdQGQ.ttf:tlg:italic" => esc_html__( "Archivo Narrow - italic", "tlg_framework"),"Archivo Narrow:tlg://fonts.gstatic.com/s/archivonarrow/v5/M__Wu4PAmHf4YZvQM8tWsMLtdzs3iyjn_YuT226ZsLU.ttf:tlg:700" => esc_html__( "Archivo Narrow - 700", "tlg_framework"),"Archivo Narrow:tlg://fonts.gstatic.com/s/archivonarrow/v5/wG6O733y5zHl4EKCOh8rSTg5KB8MNJ4uPAETq9naQO8.ttf:tlg:700italic" => esc_html__( "Archivo Narrow - 700italic", "tlg_framework"),"Arimo:tlg://fonts.gstatic.com/s/arimo/v9/Gpeo80g-5ji2CcyXWnzh7g.ttf:tlg:regular" => esc_html__( "Arimo - regular", "tlg_framework"),"Arimo:tlg://fonts.gstatic.com/s/arimo/v9/_OdGbnX2-qQ96C4OjhyuPw.ttf:tlg:italic" => esc_html__( "Arimo - italic", "tlg_framework"),"Arimo:tlg://fonts.gstatic.com/s/arimo/v9/ZItXugREyvV9LnbY_gxAmw.ttf:tlg:700" => esc_html__( "Arimo - 700", "tlg_framework"),"Arimo:tlg://fonts.gstatic.com/s/arimo/v9/__nOLWqmeXdhfr0g7GaFePesZW2xOQ-xsNqO47m55DA.ttf:tlg:700italic" => esc_html__( "Arimo - 700italic", "tlg_framework"),"Arizonia:tlg://fonts.gstatic.com/s/arizonia/v6/yzJqkHZqryZBTM7RKYV9Wg.ttf:tlg:regular" => esc_html__( "Arizonia - regular", "tlg_framework"),"Armata:tlg://fonts.gstatic.com/s/armata/v6/1H8FwGgIRrbYtxSfXhOHlQ.ttf:tlg:regular" => esc_html__( "Armata - regular", "tlg_framework"),"Artifika:tlg://fonts.gstatic.com/s/artifika/v6/Ekfp4H4QG7D-WsABDOyj8g.ttf:tlg:regular" => esc_html__( "Artifika - regular", "tlg_framework"),"Arvo:tlg://fonts.gstatic.com/s/arvo/v9/vvWPwz-PlZEwjOOIKqoZzA.ttf:tlg:regular" => esc_html__( "Arvo - regular", "tlg_framework"),"Arvo:tlg://fonts.gstatic.com/s/arvo/v9/id5a4BCjbenl5Gkqonw_Rw.ttf:tlg:italic" => esc_html__( "Arvo - italic", "tlg_framework"),"Arvo:tlg://fonts.gstatic.com/s/arvo/v9/OB3FDST7U38u3OjPK_vvRQ.ttf:tlg:700" => esc_html__( "Arvo - 700", "tlg_framework"),"Arvo:tlg://fonts.gstatic.com/s/arvo/v9/Hvl2MuWoXLaCy2v6MD4Yvw.ttf:tlg:700italic" => esc_html__( "Arvo - 700italic", "tlg_framework"),"Arya:tlg://fonts.gstatic.com/s/arya/v1/xEVqtU3v8QLospHKpDaYEw.ttf:tlg:regular" => esc_html__( "Arya - regular", "tlg_framework"),"Arya:tlg://fonts.gstatic.com/s/arya/v1/N13tgOvG7VTXawiI-fJiQA.ttf:tlg:700" => esc_html__( "Arya - 700", "tlg_framework"),"Asap:tlg://fonts.gstatic.com/s/asap/v4/2lf-1MDR8tsTpEtvJmr2hA.ttf:tlg:regular" => esc_html__( "Asap - regular", "tlg_framework"),"Asap:tlg://fonts.gstatic.com/s/asap/v4/mwxNHf8QS8gNWCAMwkJNIg.ttf:tlg:italic" => esc_html__( "Asap - italic", "tlg_framework"),"Asap:tlg://fonts.gstatic.com/s/asap/v4/o5RUA7SsJ80M8oDFBnrDbg.ttf:tlg:700" => esc_html__( "Asap - 700", "tlg_framework"),"Asap:tlg://fonts.gstatic.com/s/asap/v4/_rZz9y2oXc09jT5T6BexLQ.ttf:tlg:700italic" => esc_html__( "Asap - 700italic", "tlg_framework"),"Asar:tlg://fonts.gstatic.com/s/asar/v1/mSmn3H5CcMA84CZ586X7WQ.ttf:tlg:regular" => esc_html__( "Asar - regular", "tlg_framework"),"Asset:tlg://fonts.gstatic.com/s/asset/v6/hfPmqY-JzuR1lULlQf9iTg.ttf:tlg:regular" => esc_html__( "Asset - regular", "tlg_framework"),"Astloch:tlg://fonts.gstatic.com/s/astloch/v6/fmbitVmHYLQP7MGPuFgpag.ttf:tlg:regular" => esc_html__( "Astloch - regular", "tlg_framework"),"Astloch:tlg://fonts.gstatic.com/s/astloch/v6/aPkhM2tL-tz1jX6aX2rvo_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Astloch - 700", "tlg_framework"),"Asul:tlg://fonts.gstatic.com/s/asul/v5/9qpsNR_OOwyOYyo2N0IbBw.ttf:tlg:regular" => esc_html__( "Asul - regular", "tlg_framework"),"Asul:tlg://fonts.gstatic.com/s/asul/v5/uO8uNmxaq87-DdPmkEg5Gg.ttf:tlg:700" => esc_html__( "Asul - 700", "tlg_framework"),"Atomic Age:tlg://fonts.gstatic.com/s/atomicage/v7/WvBMe4FxANIKpo6Oi0mVJ_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Atomic Age - regular", "tlg_framework"),"Aubrey:tlg://fonts.gstatic.com/s/aubrey/v8/zo9w8klO8bmOQIMajQ2aTA.ttf:tlg:regular" => esc_html__( "Aubrey - regular", "tlg_framework"),"Audiowide:tlg://fonts.gstatic.com/s/audiowide/v4/yGcwRZB6VmoYhPUYT-mEow.ttf:tlg:regular" => esc_html__( "Audiowide - regular", "tlg_framework"),"Autour One:tlg://fonts.gstatic.com/s/autourone/v4/2xmQBcg7FN72jaQRFZPIDvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Autour One - regular", "tlg_framework"),"Average:tlg://fonts.gstatic.com/s/average/v4/aHUibBqdDbVYl5FM48pxyQ.ttf:tlg:regular" => esc_html__( "Average - regular", "tlg_framework"),"Average Sans:tlg://fonts.gstatic.com/s/averagesans/v4/dnU3R-5A_43y5bIyLztPsS3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Average Sans - regular", "tlg_framework"),"Averia Gruesa Libre:tlg://fonts.gstatic.com/s/averiagruesalibre/v4/10vbZTOoN6T8D-nvDzwRFyXcKHuZXlCN8VkWHpkUzKM.ttf:tlg:regular" => esc_html__( "Averia Gruesa Libre - regular", "tlg_framework"),"Averia Libre:tlg://fonts.gstatic.com/s/averialibre/v4/r6hGL8sSLm4dTzOPXgx5XacQoVhARpoaILP7amxE_8g.ttf:tlg:300" => esc_html__( "Averia Libre - 300", "tlg_framework"),"Averia Libre:tlg://fonts.gstatic.com/s/averialibre/v4/I6wAYuAvOgT7el2ePj2nkina0FLWfcB-J_SAYmcAXaI.ttf:tlg:300italic" => esc_html__( "Averia Libre - 300italic", "tlg_framework"),"Averia Libre:tlg://fonts.gstatic.com/s/averialibre/v4/rYVgHZZQICWnhjguGsBspC3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Averia Libre - regular", "tlg_framework"),"Averia Libre:tlg://fonts.gstatic.com/s/averialibre/v4/1etzuoNxVHR8F533EkD1WfMZXuCXbOrAvx5R0IT5Oyo.ttf:tlg:italic" => esc_html__( "Averia Libre - italic", "tlg_framework"),"Averia Libre:tlg://fonts.gstatic.com/s/averialibre/v4/r6hGL8sSLm4dTzOPXgx5XUD2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Averia Libre - 700", "tlg_framework"),"Averia Libre:tlg://fonts.gstatic.com/s/averialibre/v4/I6wAYuAvOgT7el2ePj2nkvAs9-1nE9qOqhChW0m4nDE.ttf:tlg:700italic" => esc_html__( "Averia Libre - 700italic", "tlg_framework"),"Averia Sans Libre:tlg://fonts.gstatic.com/s/averiasanslibre/v4/_9-jTfQjaBsWAF_yp5z-V4CP_KG_g80s1KXiBtJHoNc.ttf:tlg:300" => esc_html__( "Averia Sans Libre - 300", "tlg_framework"),"Averia Sans Libre:tlg://fonts.gstatic.com/s/averiasanslibre/v4/o7BEIK-fG3Ykc5Rzteh88YuyGu4JqttndUh4gRKxic0.ttf:tlg:300italic" => esc_html__( "Averia Sans Libre - 300italic", "tlg_framework"),"Averia Sans Libre:tlg://fonts.gstatic.com/s/averiasanslibre/v4/yRJpjT39KxACO9F31mj_LqV8_KRn4epKAjTFK1s1fsg.ttf:tlg:regular" => esc_html__( "Averia Sans Libre - regular", "tlg_framework"),"Averia Sans Libre:tlg://fonts.gstatic.com/s/averiasanslibre/v4/COEzR_NPBSUOl3pFwPbPoCZU2HnUZT1xVKaIrHDioao.ttf:tlg:italic" => esc_html__( "Averia Sans Libre - italic", "tlg_framework"),"Averia Sans Libre:tlg://fonts.gstatic.com/s/averiasanslibre/v4/_9-jTfQjaBsWAF_yp5z-V8QwVOrz1y5GihpZmtKLhlI.ttf:tlg:700" => esc_html__( "Averia Sans Libre - 700", "tlg_framework"),"Averia Sans Libre:tlg://fonts.gstatic.com/s/averiasanslibre/v4/o7BEIK-fG3Ykc5Rzteh88bXy1DXgmJcVtKjM5UWamMs.ttf:tlg:700italic" => esc_html__( "Averia Sans Libre - 700italic", "tlg_framework"),"Averia Serif Libre:tlg://fonts.gstatic.com/s/averiaseriflibre/v5/yvITAdr5D1nlsdFswJAb8SmC4gFJ2PHmfdVKEd_5S9M.ttf:tlg:300" => esc_html__( "Averia Serif Libre - 300", "tlg_framework"),"Averia Serif Libre:tlg://fonts.gstatic.com/s/averiaseriflibre/v5/YOLFXyye4sZt6AZk1QybCG2okl0bU63CauowU4iApig.ttf:tlg:300italic" => esc_html__( "Averia Serif Libre - 300italic", "tlg_framework"),"Averia Serif Libre:tlg://fonts.gstatic.com/s/averiaseriflibre/v5/fdtF30xa_Erw0zAzOoG4BZqY66i8AUyI16fGqw0iAew.ttf:tlg:regular" => esc_html__( "Averia Serif Libre - regular", "tlg_framework"),"Averia Serif Libre:tlg://fonts.gstatic.com/s/averiaseriflibre/v5/o9qhvK9iT5iDWfyhQUe-6Ru_b0bTq5iipbJ9hhgHJ6U.ttf:tlg:italic" => esc_html__( "Averia Serif Libre - italic", "tlg_framework"),"Averia Serif Libre:tlg://fonts.gstatic.com/s/averiaseriflibre/v5/yvITAdr5D1nlsdFswJAb8Q50KV5TaOVolur4zV2iZsg.ttf:tlg:700" => esc_html__( "Averia Serif Libre - 700", "tlg_framework"),"Averia Serif Libre:tlg://fonts.gstatic.com/s/averiaseriflibre/v5/YOLFXyye4sZt6AZk1QybCNxohRXP4tNDqG3X4Hqn21k.ttf:tlg:700italic" => esc_html__( "Averia Serif Libre - 700italic", "tlg_framework"),"Bad Script:tlg://fonts.gstatic.com/s/badscript/v5/cRyUs0nJ2eMQFHwBsZNRXfesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Bad Script - regular", "tlg_framework"),"Balthazar:tlg://fonts.gstatic.com/s/balthazar/v5/WgbaSIs6dJAGXJ0qbz2xlw.ttf:tlg:regular" => esc_html__( "Balthazar - regular", "tlg_framework"),"Bangers:tlg://fonts.gstatic.com/s/bangers/v8/WAffdge5w99Xif-DLeqmcA.ttf:tlg:regular" => esc_html__( "Bangers - regular", "tlg_framework"),"Basic:tlg://fonts.gstatic.com/s/basic/v6/hNII2mS5Dxw5C0u_m3mXgA.ttf:tlg:regular" => esc_html__( "Basic - regular", "tlg_framework"),"Battambang:tlg://fonts.gstatic.com/s/battambang/v9/MzrUfQLefYum5vVGM3EZVPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Battambang - regular", "tlg_framework"),"Battambang:tlg://fonts.gstatic.com/s/battambang/v9/dezbRtMzfzAA99DmrCYRMgJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700" => esc_html__( "Battambang - 700", "tlg_framework"),"Baumans:tlg://fonts.gstatic.com/s/baumans/v5/o0bFdPW1H5kd5saqqOcoVg.ttf:tlg:regular" => esc_html__( "Baumans - regular", "tlg_framework"),"Bayon:tlg://fonts.gstatic.com/s/bayon/v8/yTubusjTnpNRZwA4_50iVw.ttf:tlg:regular" => esc_html__( "Bayon - regular", "tlg_framework"),"Belgrano:tlg://fonts.gstatic.com/s/belgrano/v6/iq8DUa2s7g6WRCeMiFrmtQ.ttf:tlg:regular" => esc_html__( "Belgrano - regular", "tlg_framework"),"Belleza:tlg://fonts.gstatic.com/s/belleza/v4/wchA3BWJlVqvIcSeNZyXew.ttf:tlg:regular" => esc_html__( "Belleza - regular", "tlg_framework"),"BenchNine:tlg://fonts.gstatic.com/s/benchnine/v4/ah9xtUy9wLQ3qnWa2p-piS3USBnSvpkopQaUR-2r7iU.ttf:tlg:300" => esc_html__( "BenchNine - 300", "tlg_framework"),"BenchNine:tlg://fonts.gstatic.com/s/benchnine/v4/h3OAlYqU3aOeNkuXgH2Q2w.ttf:tlg:regular" => esc_html__( "BenchNine - regular", "tlg_framework"),"BenchNine:tlg://fonts.gstatic.com/s/benchnine/v4/qZpi6ZVZg3L2RL_xoBLxWS3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "BenchNine - 700", "tlg_framework"),"Bentham:tlg://fonts.gstatic.com/s/bentham/v6/5-Mo8Fe7yg5tzV0GlQIuzQ.ttf:tlg:regular" => esc_html__( "Bentham - regular", "tlg_framework"),"Berkshire Swash:tlg://fonts.gstatic.com/s/berkshireswash/v4/4RZJjVRPjYnC2939hKCAimKfbtsIjCZP_edQljX9gR0.ttf:tlg:regular" => esc_html__( "Berkshire Swash - regular", "tlg_framework"),"Bevan:tlg://fonts.gstatic.com/s/bevan/v7/Rtg3zDsCeQiaJ_Qno22OJA.ttf:tlg:regular" => esc_html__( "Bevan - regular", "tlg_framework"),"Bigelow Rules:tlg://fonts.gstatic.com/s/bigelowrules/v4/FEJCPLwo07FS-6SK6Al50X8f0n03UdmQgF_CLvNR2vg.ttf:tlg:regular" => esc_html__( "Bigelow Rules - regular", "tlg_framework"),"Bigshot One:tlg://fonts.gstatic.com/s/bigshotone/v6/wSyZjBNTWDQHnvWE2jt6j6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Bigshot One - regular", "tlg_framework"),"Bilbo:tlg://fonts.gstatic.com/s/bilbo/v6/-ty-lPs5H7OIucWbnpFrkA.ttf:tlg:regular" => esc_html__( "Bilbo - regular", "tlg_framework"),"Bilbo Swash Caps:tlg://fonts.gstatic.com/s/bilboswashcaps/v7/UB_-crLvhx-PwGKW1oosDmYeFSdnSpRYv5h9gpdlD1g.ttf:tlg:regular" => esc_html__( "Bilbo Swash Caps - regular", "tlg_framework"),"Biryani:tlg://fonts.gstatic.com/s/biryani/v1/Xx38YzyTFF8n6mRS1Yd88vesZW2xOQ-xsNqO47m55DA.ttf:tlg:200" => esc_html__( "Biryani - 200", "tlg_framework"),"Biryani:tlg://fonts.gstatic.com/s/biryani/v1/u-bneRbizmFMd0VQp5Ze6vesZW2xOQ-xsNqO47m55DA.ttf:tlg:300" => esc_html__( "Biryani - 300", "tlg_framework"),"Biryani:tlg://fonts.gstatic.com/s/biryani/v1/W7bfR8-IY76Xz0QoB8L2xw.ttf:tlg:regular" => esc_html__( "Biryani - regular", "tlg_framework"),"Biryani:tlg://fonts.gstatic.com/s/biryani/v1/1EdcPCVxBR2txgjrza6_YPesZW2xOQ-xsNqO47m55DA.ttf:tlg:600" => esc_html__( "Biryani - 600", "tlg_framework"),"Biryani:tlg://fonts.gstatic.com/s/biryani/v1/qN2MTZ0j1sKSCtfXLB2dR_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Biryani - 700", "tlg_framework"),"Biryani:tlg://fonts.gstatic.com/s/biryani/v1/DJyziS7FEy441v22InYdevesZW2xOQ-xsNqO47m55DA.ttf:tlg:800" => esc_html__( "Biryani - 800", "tlg_framework"),"Biryani:tlg://fonts.gstatic.com/s/biryani/v1/trcLkrIut0lM_PPSyQfAMPesZW2xOQ-xsNqO47m55DA.ttf:tlg:900" => esc_html__( "Biryani - 900", "tlg_framework"),"Bitter:tlg://fonts.gstatic.com/s/bitter/v7/w_BNdJvVZDRmqy5aSfB2kQ.ttf:tlg:regular" => esc_html__( "Bitter - regular", "tlg_framework"),"Bitter:tlg://fonts.gstatic.com/s/bitter/v7/TC0FZEVzXQIGgzmRfKPZbA.ttf:tlg:italic" => esc_html__( "Bitter - italic", "tlg_framework"),"Bitter:tlg://fonts.gstatic.com/s/bitter/v7/4dUtr_4BvHuoRU35suyOAg.ttf:tlg:700" => esc_html__( "Bitter - 700", "tlg_framework"),"Black Ops One:tlg://fonts.gstatic.com/s/blackopsone/v7/2XW-DmDsGbDLE372KrMW1Yjjx0o0jr6fNXxPgYh_a8Q.ttf:tlg:regular" => esc_html__( "Black Ops One - regular", "tlg_framework"),"Bokor:tlg://fonts.gstatic.com/s/bokor/v8/uAKdo0A85WW23Gs6mcbw7A.ttf:tlg:regular" => esc_html__( "Bokor - regular", "tlg_framework"),"Bonbon:tlg://fonts.gstatic.com/s/bonbon/v7/IW3u1yzG1knyW5oz0s9_6Q.ttf:tlg:regular" => esc_html__( "Bonbon - regular", "tlg_framework"),"Boogaloo:tlg://fonts.gstatic.com/s/boogaloo/v6/4Wu1tvFMoB80fSu8qLgQfQ.ttf:tlg:regular" => esc_html__( "Boogaloo - regular", "tlg_framework"),"Bowlby One:tlg://fonts.gstatic.com/s/bowlbyone/v7/eKpHjHfjoxM2bX36YNucefesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Bowlby One - regular", "tlg_framework"),"Bowlby One SC:tlg://fonts.gstatic.com/s/bowlbyonesc/v8/8ZkeXftTuzKBtmxOYXoRedDkZCMxWJecxjvKm2f8MJw.ttf:tlg:regular" => esc_html__( "Bowlby One SC - regular", "tlg_framework"),"Brawler:tlg://fonts.gstatic.com/s/brawler/v6/3gfSw6imxQnQxweVITqUrg.ttf:tlg:regular" => esc_html__( "Brawler - regular", "tlg_framework"),"Bree Serif:tlg://fonts.gstatic.com/s/breeserif/v5/5h9crBVIrvZqgf34FHcnEfesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Bree Serif - regular", "tlg_framework"),"Bubblegum Sans:tlg://fonts.gstatic.com/s/bubblegumsans/v5/Y9iTUUNz6lbl6TrvV4iwsytnKWgpfO2iSkLzTz-AABg.ttf:tlg:regular" => esc_html__( "Bubblegum Sans - regular", "tlg_framework"),"Bubbler One:tlg://fonts.gstatic.com/s/bubblerone/v4/e8S0qevkZAFaBybtt_SU4qCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Bubbler One - regular", "tlg_framework"),"Buda:tlg://fonts.gstatic.com/s/buda/v6/hLtAmNUmEMJH2yx7NGUjnA.ttf:tlg:300" => esc_html__( "Buda - 300", "tlg_framework"),"Buenard:tlg://fonts.gstatic.com/s/buenard/v7/NSpMPGKAUgrLrlstYVvIXQ.ttf:tlg:regular" => esc_html__( "Buenard - regular", "tlg_framework"),"Buenard:tlg://fonts.gstatic.com/s/buenard/v7/yUlGE115dGr7O9w9FlP3UvesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Buenard - 700", "tlg_framework"),"Butcherman:tlg://fonts.gstatic.com/s/butcherman/v7/bxiJmD567sPBVpJsT0XR0vesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Butcherman - regular", "tlg_framework"),"Butterfly Kids:tlg://fonts.gstatic.com/s/butterflykids/v4/J4NTF5M25htqeTffYImtlUZaDk62iwTBnbnvwSjZciA.ttf:tlg:regular" => esc_html__( "Butterfly Kids - regular", "tlg_framework"),"Cabin:tlg://fonts.gstatic.com/s/cabin/v8/XeuAFYo2xAPHxZGBbQtHhA.ttf:tlg:regular" => esc_html__( "Cabin - regular", "tlg_framework"),"Cabin:tlg://fonts.gstatic.com/s/cabin/v8/0tJ9k3DI5xC4GBgs1E_Jxw.ttf:tlg:italic" => esc_html__( "Cabin - italic", "tlg_framework"),"Cabin:tlg://fonts.gstatic.com/s/cabin/v8/HgsCQ-k3_Z_uQ86aFolNBg.ttf:tlg:500" => esc_html__( "Cabin - 500", "tlg_framework"),"Cabin:tlg://fonts.gstatic.com/s/cabin/v8/50sjhrGE0njyO-7mGDhGP_esZW2xOQ-xsNqO47m55DA.ttf:tlg:500italic" => esc_html__( "Cabin - 500italic", "tlg_framework"),"Cabin:tlg://fonts.gstatic.com/s/cabin/v8/eUDAvKhBtmTCkeVBsFk34A.ttf:tlg:600" => esc_html__( "Cabin - 600", "tlg_framework"),"Cabin:tlg://fonts.gstatic.com/s/cabin/v8/sFQpQDBd3G2om0Nl5dD2CvesZW2xOQ-xsNqO47m55DA.ttf:tlg:600italic" => esc_html__( "Cabin - 600italic", "tlg_framework"),"Cabin:tlg://fonts.gstatic.com/s/cabin/v8/4EKhProuY1hq_WCAomq9Dg.ttf:tlg:700" => esc_html__( "Cabin - 700", "tlg_framework"),"Cabin:tlg://fonts.gstatic.com/s/cabin/v8/K83QKi8MOKLEqj6bgZ7LrfesZW2xOQ-xsNqO47m55DA.ttf:tlg:700italic" => esc_html__( "Cabin - 700italic", "tlg_framework"),"Cabin Condensed:tlg://fonts.gstatic.com/s/cabincondensed/v7/B0txb0blf2N29WdYPJjMSiQPsWWoiv__AzYJ9Zzn9II.ttf:tlg:regular" => esc_html__( "Cabin Condensed - regular", "tlg_framework"),"Cabin Condensed:tlg://fonts.gstatic.com/s/cabincondensed/v7/Ez4zJbsGr2BgXcNUWBVgEARL_-ABKXdjsJSPT0lc2Bk.ttf:tlg:500" => esc_html__( "Cabin Condensed - 500", "tlg_framework"),"Cabin Condensed:tlg://fonts.gstatic.com/s/cabincondensed/v7/Ez4zJbsGr2BgXcNUWBVgELS5sSASxc8z4EQTQj7DCAI.ttf:tlg:600" => esc_html__( "Cabin Condensed - 600", "tlg_framework"),"Cabin Condensed:tlg://fonts.gstatic.com/s/cabincondensed/v7/Ez4zJbsGr2BgXcNUWBVgEMAWgzcA047xWLixhLCofl8.ttf:tlg:700" => esc_html__( "Cabin Condensed - 700", "tlg_framework"),"Cabin Sketch:tlg://fonts.gstatic.com/s/cabinsketch/v8/d9fijO34zQajqQvl3YHRCS3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Cabin Sketch - regular", "tlg_framework"),"Cabin Sketch:tlg://fonts.gstatic.com/s/cabinsketch/v8/ki3SSN5HMOO0-IOLOj069ED2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Cabin Sketch - 700", "tlg_framework"),"Caesar Dressing:tlg://fonts.gstatic.com/s/caesardressing/v5/2T_WzBgE2Xz3FsyJMq34T9gR43u4FvCuJwIfF5Zxl6Y.ttf:tlg:regular" => esc_html__( "Caesar Dressing - regular", "tlg_framework"),"Cagliostro:tlg://fonts.gstatic.com/s/cagliostro/v5/i85oXbtdSatNEzss99bpj_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Cagliostro - regular", "tlg_framework"),"Calligraffitti:tlg://fonts.gstatic.com/s/calligraffitti/v7/vLVN2Y-z65rVu1R7lWdvyDXz_orj3gX0_NzfmYulrko.ttf:tlg:regular" => esc_html__( "Calligraffitti - regular", "tlg_framework"),"Cambay:tlg://fonts.gstatic.com/s/cambay/v1/etU9Bab4VuhzS-OKsb1VXg.ttf:tlg:regular" => esc_html__( "Cambay - regular", "tlg_framework"),"Cambay:tlg://fonts.gstatic.com/s/cambay/v1/ZEz9yNqpEOgejaw1rBhugQ.ttf:tlg:italic" => esc_html__( "Cambay - italic", "tlg_framework"),"Cambay:tlg://fonts.gstatic.com/s/cambay/v1/jw9niBxa04eEhnSwTWCEgw.ttf:tlg:700" => esc_html__( "Cambay - 700", "tlg_framework"),"Cambay:tlg://fonts.gstatic.com/s/cambay/v1/j-5v_uUr0NXTumWN0siOiaCWcynf_cDxXwCLxiixG1c.ttf:tlg:700italic" => esc_html__( "Cambay - 700italic", "tlg_framework"),"Cambo:tlg://fonts.gstatic.com/s/cambo/v5/PnwpRuTdkYCf8qk4ajmNRA.ttf:tlg:regular" => esc_html__( "Cambo - regular", "tlg_framework"),"Candal:tlg://fonts.gstatic.com/s/candal/v6/x44dDW28zK7GR1gGDBmj9g.ttf:tlg:regular" => esc_html__( "Candal - regular", "tlg_framework"),"Cantarell:tlg://fonts.gstatic.com/s/cantarell/v6/p5ydP_uWQ5lsFzcP_XVMEw.ttf:tlg:regular" => esc_html__( "Cantarell - regular", "tlg_framework"),"Cantarell:tlg://fonts.gstatic.com/s/cantarell/v6/DTCLtOSqP-7dgM-V_xKUjqCWcynf_cDxXwCLxiixG1c.ttf:tlg:italic" => esc_html__( "Cantarell - italic", "tlg_framework"),"Cantarell:tlg://fonts.gstatic.com/s/cantarell/v6/Yir4ZDsCn4g1kWopdg-ehC3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Cantarell - 700", "tlg_framework"),"Cantarell:tlg://fonts.gstatic.com/s/cantarell/v6/weehrwMeZBXb0QyrWnRwFXe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700italic" => esc_html__( "Cantarell - 700italic", "tlg_framework"),"Cantata One:tlg://fonts.gstatic.com/s/cantataone/v5/-a5FDvnBqaBMDaGgZYnEfqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Cantata One - regular", "tlg_framework"),"Cantora One:tlg://fonts.gstatic.com/s/cantoraone/v5/oI-DS62RbHI8ZREjp73ehqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Cantora One - regular", "tlg_framework"),"Capriola:tlg://fonts.gstatic.com/s/capriola/v4/JxXPlkdzWwF9Cwelbvi9jA.ttf:tlg:regular" => esc_html__( "Capriola - regular", "tlg_framework"),"Cardo:tlg://fonts.gstatic.com/s/cardo/v8/jbkF2_R0FKUEZTq5dwSknQ.ttf:tlg:regular" => esc_html__( "Cardo - regular", "tlg_framework"),"Cardo:tlg://fonts.gstatic.com/s/cardo/v8/pcv4Np9tUkq0YREYUcEEJQ.ttf:tlg:italic" => esc_html__( "Cardo - italic", "tlg_framework"),"Cardo:tlg://fonts.gstatic.com/s/cardo/v8/lQN30weILimrKvp8rZhF1w.ttf:tlg:700" => esc_html__( "Cardo - 700", "tlg_framework"),"Carme:tlg://fonts.gstatic.com/s/carme/v7/08E0NP1eRBEyFRUadmMfgA.ttf:tlg:regular" => esc_html__( "Carme - regular", "tlg_framework"),"Carrois Gothic:tlg://fonts.gstatic.com/s/carroisgothic/v4/GCgb7bssGpwp7V5ynxmWy2x3d0cwUleGuRTmCYfCUaM.ttf:tlg:regular" => esc_html__( "Carrois Gothic - regular", "tlg_framework"),"Carrois Gothic SC:tlg://fonts.gstatic.com/s/carroisgothicsc/v4/bVp4nhwFIXU-r3LqUR8DSJTdPW1ioadGi2uRiKgJVCY.ttf:tlg:regular" => esc_html__( "Carrois Gothic SC - regular", "tlg_framework"),"Carter One:tlg://fonts.gstatic.com/s/carterone/v8/5X_LFvdbcB7OBG7hBgZ7fPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Carter One - regular", "tlg_framework"),"Catamaran:tlg://fonts.gstatic.com/s/catamaran/v1/ilWHBiy0krUPdlmYxDuqC6CWcynf_cDxXwCLxiixG1c.ttf:tlg:100" => esc_html__( "Catamaran - 100", "tlg_framework"),"Catamaran:tlg://fonts.gstatic.com/s/catamaran/v1/hFc-HKSsGk6M-psujei1MC3USBnSvpkopQaUR-2r7iU.ttf:tlg:200" => esc_html__( "Catamaran - 200", "tlg_framework"),"Catamaran:tlg://fonts.gstatic.com/s/catamaran/v1/Aaag4ccR7Oh_4eai-jbrYC3USBnSvpkopQaUR-2r7iU.ttf:tlg:300" => esc_html__( "Catamaran - 300", "tlg_framework"),"Catamaran:tlg://fonts.gstatic.com/s/catamaran/v1/MdNkM-DU8f6R-25Nxpr_XA.ttf:tlg:regular" => esc_html__( "Catamaran - regular", "tlg_framework"),"Catamaran:tlg://fonts.gstatic.com/s/catamaran/v1/83WSX3F86qsvj1Z4EI0tQi3USBnSvpkopQaUR-2r7iU.ttf:tlg:500" => esc_html__( "Catamaran - 500", "tlg_framework"),"Catamaran:tlg://fonts.gstatic.com/s/catamaran/v1/a9PlHHnuBWiGGk0TwuFKTi3USBnSvpkopQaUR-2r7iU.ttf:tlg:600" => esc_html__( "Catamaran - 600", "tlg_framework"),"Catamaran:tlg://fonts.gstatic.com/s/catamaran/v1/PpgVtUHUdnBZYNpnzGbScy3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Catamaran - 700", "tlg_framework"),"Catamaran:tlg://fonts.gstatic.com/s/catamaran/v1/6VjB_uSfn3DZ93IQv58CmC3USBnSvpkopQaUR-2r7iU.ttf:tlg:800" => esc_html__( "Catamaran - 800", "tlg_framework"),"Catamaran:tlg://fonts.gstatic.com/s/catamaran/v1/5ys9TqpQc9Q6gHqbSox6py3USBnSvpkopQaUR-2r7iU.ttf:tlg:900" => esc_html__( "Catamaran - 900", "tlg_framework"),"Caudex:tlg://fonts.gstatic.com/s/caudex/v6/PWEexiHLDmQbn2b1OPZWfg.ttf:tlg:regular" => esc_html__( "Caudex - regular", "tlg_framework"),"Caudex:tlg://fonts.gstatic.com/s/caudex/v6/XjMZF6XCisvV3qapD4oJdw.ttf:tlg:italic" => esc_html__( "Caudex - italic", "tlg_framework"),"Caudex:tlg://fonts.gstatic.com/s/caudex/v6/PetCI4GyQ5Q3LiOzUu_mMg.ttf:tlg:700" => esc_html__( "Caudex - 700", "tlg_framework"),"Caudex:tlg://fonts.gstatic.com/s/caudex/v6/yT8YeHLjaJvQXlUEYOA8gqCWcynf_cDxXwCLxiixG1c.ttf:tlg:700italic" => esc_html__( "Caudex - 700italic", "tlg_framework"),"Caveat:tlg://fonts.gstatic.com/s/caveat/v1/8I23b6N-6rRVbh-C_Vx3yA.ttf:tlg:regular" => esc_html__( "Caveat - regular", "tlg_framework"),"Caveat:tlg://fonts.gstatic.com/s/caveat/v1/LkaFtQENGJry2eUMwGRTeA.ttf:tlg:700" => esc_html__( "Caveat - 700", "tlg_framework"),"Caveat Brush:tlg://fonts.gstatic.com/s/caveatbrush/v1/_d7bgsk3hfC4DXnUEeYKsy3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Caveat Brush - regular", "tlg_framework"),"Cedarville Cursive:tlg://fonts.gstatic.com/s/cedarvillecursive/v7/cuCe6HrkcqrWTWTUE7dw-41zwq9-z_Lf44CzRAA0d0Y.ttf:tlg:regular" => esc_html__( "Cedarville Cursive - regular", "tlg_framework"),"Ceviche One:tlg://fonts.gstatic.com/s/cevicheone/v7/WOaXIMBD4VYMy39MsobJhKCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Ceviche One - regular", "tlg_framework"),"Changa One:tlg://fonts.gstatic.com/s/changaone/v9/dr4qjce4W3kxFrZRkVD87fesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Changa One - regular", "tlg_framework"),"Changa One:tlg://fonts.gstatic.com/s/changaone/v9/wJVQlUs1lAZel-WdTo2U9y3USBnSvpkopQaUR-2r7iU.ttf:tlg:italic" => esc_html__( "Changa One - italic", "tlg_framework"),"Chango:tlg://fonts.gstatic.com/s/chango/v5/3W3AeMMtRTH08t5qLOjBmg.ttf:tlg:regular" => esc_html__( "Chango - regular", "tlg_framework"),"Chau Philomene One:tlg://fonts.gstatic.com/s/chauphilomeneone/v4/KKc5egCL-a2fFVoOA2x6tBFi5dxgSTdxqnMJgWkBJcg.ttf:tlg:regular" => esc_html__( "Chau Philomene One - regular", "tlg_framework"),"Chau Philomene One:tlg://fonts.gstatic.com/s/chauphilomeneone/v4/eJj1PY_iN4KiIuyOvtMHJP6uyLkxyiC4WcYA74sfquE.ttf:tlg:italic" => esc_html__( "Chau Philomene One - italic", "tlg_framework"),"Chela One:tlg://fonts.gstatic.com/s/chelaone/v5/h5O0dEnpnIq6jQnWxZybrA.ttf:tlg:regular" => esc_html__( "Chela One - regular", "tlg_framework"),"Chelsea Market:tlg://fonts.gstatic.com/s/chelseamarket/v4/qSdzwh2A4BbNemy78sJLfAAI1i8fIftCBXsBF2v9UMI.ttf:tlg:regular" => esc_html__( "Chelsea Market - regular", "tlg_framework"),"Chenla:tlg://fonts.gstatic.com/s/chenla/v9/aLNpdAUDq2MZbWz2U1a16g.ttf:tlg:regular" => esc_html__( "Chenla - regular", "tlg_framework"),"Cherry Cream Soda:tlg://fonts.gstatic.com/s/cherrycreamsoda/v6/OrD-AUnFcZeeKa6F_c0_WxOiHiuAPYA9ry3O1RG2XIU.ttf:tlg:regular" => esc_html__( "Cherry Cream Soda - regular", "tlg_framework"),"Cherry Swash:tlg://fonts.gstatic.com/s/cherryswash/v4/HqOk7C7J1TZ5i3L-ejF0vi3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Cherry Swash - regular", "tlg_framework"),"Cherry Swash:tlg://fonts.gstatic.com/s/cherryswash/v4/-CfyMyQqfucZPQNB0nvYyED2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Cherry Swash - 700", "tlg_framework"),"Chewy:tlg://fonts.gstatic.com/s/chewy/v7/hcDN5cvQdIu6Bx4mg_TSyw.ttf:tlg:regular" => esc_html__( "Chewy - regular", "tlg_framework"),"Chicle:tlg://fonts.gstatic.com/s/chicle/v5/xg4q57Ut9ZmyFwLp51JLgg.ttf:tlg:regular" => esc_html__( "Chicle - regular", "tlg_framework"),"Chivo:tlg://fonts.gstatic.com/s/chivo/v7/L88PEuzS9eRfHRZhAPhZyw.ttf:tlg:regular" => esc_html__( "Chivo - regular", "tlg_framework"),"Chivo:tlg://fonts.gstatic.com/s/chivo/v7/Oe3-Q-a2kBzPnhHck_baMg.ttf:tlg:italic" => esc_html__( "Chivo - italic", "tlg_framework"),"Chivo:tlg://fonts.gstatic.com/s/chivo/v7/JAdkiWd46QCW4vOsj3dzTA.ttf:tlg:900" => esc_html__( "Chivo - 900", "tlg_framework"),"Chivo:tlg://fonts.gstatic.com/s/chivo/v7/LoszYnE86q2wJEOjCigBQ_esZW2xOQ-xsNqO47m55DA.ttf:tlg:900italic" => esc_html__( "Chivo - 900italic", "tlg_framework"),"Chonburi:tlg://fonts.gstatic.com/s/chonburi/v1/jd9PfbW0x_8Myt_XeUxvSQ.ttf:tlg:regular" => esc_html__( "Chonburi - regular", "tlg_framework"),"Cinzel:tlg://fonts.gstatic.com/s/cinzel/v4/GF7dy_Nc-a6EaHYSyGd-EA.ttf:tlg:regular" => esc_html__( "Cinzel - regular", "tlg_framework"),"Cinzel:tlg://fonts.gstatic.com/s/cinzel/v4/nYcFQ6_3pf_6YDrOFjBR8Q.ttf:tlg:700" => esc_html__( "Cinzel - 700", "tlg_framework"),"Cinzel:tlg://fonts.gstatic.com/s/cinzel/v4/FTBj72ozM2cEOSxiVsRb3A.ttf:tlg:900" => esc_html__( "Cinzel - 900", "tlg_framework"),"Cinzel Decorative:tlg://fonts.gstatic.com/s/cinzeldecorative/v4/fmgK7oaJJIXAkhd9798yQgT5USbJx2F82lQbogPy2bY.ttf:tlg:regular" => esc_html__( "Cinzel Decorative - regular", "tlg_framework"),"Cinzel Decorative:tlg://fonts.gstatic.com/s/cinzeldecorative/v4/pXhIVnhFtL_B9Vb1wq2F95-YYVDmZkJErg0zgx9XuZI.ttf:tlg:700" => esc_html__( "Cinzel Decorative - 700", "tlg_framework"),"Cinzel Decorative:tlg://fonts.gstatic.com/s/cinzeldecorative/v4/pXhIVnhFtL_B9Vb1wq2F97Khqbv0zQZa0g-9HOXAalU.ttf:tlg:900" => esc_html__( "Cinzel Decorative - 900", "tlg_framework"),"Clicker Script:tlg://fonts.gstatic.com/s/clickerscript/v4/Zupmk8XwADjufGxWB9KThBnpV0hQCek3EmWnCPrvGRM.ttf:tlg:regular" => esc_html__( "Clicker Script - regular", "tlg_framework"),"Coda:tlg://fonts.gstatic.com/s/coda/v11/yHDvulhg-P-p2KRgRrnUYw.ttf:tlg:regular" => esc_html__( "Coda - regular", "tlg_framework"),"Coda:tlg://fonts.gstatic.com/s/coda/v11/6ZIw0sbALY0KTMWllZB3hQ.ttf:tlg:800" => esc_html__( "Coda - 800", "tlg_framework"),"Coda Caption:tlg://fonts.gstatic.com/s/codacaption/v9/YDl6urZh-DUFhiMBTgAnz_qsay_1ZmRGmC8pVRdIfAg.ttf:tlg:800" => esc_html__( "Coda Caption - 800", "tlg_framework"),"Codystar:tlg://fonts.gstatic.com/s/codystar/v4/EVaUzfJkcb8Zqx9kzQLXqqCWcynf_cDxXwCLxiixG1c.ttf:tlg:300" => esc_html__( "Codystar - 300", "tlg_framework"),"Codystar:tlg://fonts.gstatic.com/s/codystar/v4/EN-CPFKYowSI7SuR7-0cZA.ttf:tlg:regular" => esc_html__( "Codystar - regular", "tlg_framework"),"Combo:tlg://fonts.gstatic.com/s/combo/v5/Nab98KjR3JZSSPGtzLyXNw.ttf:tlg:regular" => esc_html__( "Combo - regular", "tlg_framework"),"Comfortaa:tlg://fonts.gstatic.com/s/comfortaa/v7/r_tUZNl0G8xCoOmp_JkSCi3USBnSvpkopQaUR-2r7iU.ttf:tlg:300" => esc_html__( "Comfortaa - 300", "tlg_framework"),"Comfortaa:tlg://fonts.gstatic.com/s/comfortaa/v7/lZx6C1VViPgSOhCBUP7hXA.ttf:tlg:regular" => esc_html__( "Comfortaa - regular", "tlg_framework"),"Comfortaa:tlg://fonts.gstatic.com/s/comfortaa/v7/fND5XPYKrF2tQDwwfWZJIy3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Comfortaa - 700", "tlg_framework"),"Coming Soon:tlg://fonts.gstatic.com/s/comingsoon/v6/Yz2z3IAe2HSQAOWsSG8COKCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Coming Soon - regular", "tlg_framework"),"Concert One:tlg://fonts.gstatic.com/s/concertone/v7/N5IWCIGhUNdPZn_efTxKN6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Concert One - regular", "tlg_framework"),"Condiment:tlg://fonts.gstatic.com/s/condiment/v4/CstmdiPpgFSV0FUNL5LrJA.ttf:tlg:regular" => esc_html__( "Condiment - regular", "tlg_framework"),"Content:tlg://fonts.gstatic.com/s/content/v8/l8qaLjygvOkDEU2G6-cjfQ.ttf:tlg:regular" => esc_html__( "Content - regular", "tlg_framework"),"Content:tlg://fonts.gstatic.com/s/content/v8/7PivP8Zvs2qn6F6aNbSQe_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Content - 700", "tlg_framework"),"Contrail One:tlg://fonts.gstatic.com/s/contrailone/v6/b41KxjgiyqX-hkggANDU6C3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Contrail One - regular", "tlg_framework"),"Convergence:tlg://fonts.gstatic.com/s/convergence/v5/eykrGz1NN_YpQmkAZjW-qKCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Convergence - regular", "tlg_framework"),"Cookie:tlg://fonts.gstatic.com/s/cookie/v7/HxeUC62y_YdDbiFlze357A.ttf:tlg:regular" => esc_html__( "Cookie - regular", "tlg_framework"),"Copse:tlg://fonts.gstatic.com/s/copse/v6/wikLrtPGjZDvZ5w2i5HLWg.ttf:tlg:regular" => esc_html__( "Copse - regular", "tlg_framework"),"Corben:tlg://fonts.gstatic.com/s/corben/v9/tTysMZkt-j8Y5yhkgsoajQ.ttf:tlg:regular" => esc_html__( "Corben - regular", "tlg_framework"),"Corben:tlg://fonts.gstatic.com/s/corben/v9/lirJaFSQWdGQuV--fksg5g.ttf:tlg:700" => esc_html__( "Corben - 700", "tlg_framework"),"Courgette:tlg://fonts.gstatic.com/s/courgette/v4/2YO0EYtyE9HUPLZprahpZA.ttf:tlg:regular" => esc_html__( "Courgette - regular", "tlg_framework"),"Cousine:tlg://fonts.gstatic.com/s/cousine/v10/GYX4bPXObJNJo63QJEUnLg.ttf:tlg:regular" => esc_html__( "Cousine - regular", "tlg_framework"),"Cousine:tlg://fonts.gstatic.com/s/cousine/v10/1WtIuajLoo8vjVwsrZ3eOg.ttf:tlg:italic" => esc_html__( "Cousine - italic", "tlg_framework"),"Cousine:tlg://fonts.gstatic.com/s/cousine/v10/FXEOnNUcCzhdtoBxiq-lovesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Cousine - 700", "tlg_framework"),"Cousine:tlg://fonts.gstatic.com/s/cousine/v10/y_AZ5Sz-FwL1lux2xLSTZS3USBnSvpkopQaUR-2r7iU.ttf:tlg:700italic" => esc_html__( "Cousine - 700italic", "tlg_framework"),"Coustard:tlg://fonts.gstatic.com/s/coustard/v6/iO2Rs5PmqAEAXoU3SkMVBg.ttf:tlg:regular" => esc_html__( "Coustard - regular", "tlg_framework"),"Coustard:tlg://fonts.gstatic.com/s/coustard/v6/W02OCWO6OfMUHz6aVyegQ6CWcynf_cDxXwCLxiixG1c.ttf:tlg:900" => esc_html__( "Coustard - 900", "tlg_framework"),"Covered By Your Grace:tlg://fonts.gstatic.com/s/coveredbyyourgrace/v6/6ozZp4BPlrbDRWPe3EBGA6CVUMdvnk-GcAiZQrX9Gek.ttf:tlg:regular" => esc_html__( "Covered By Your Grace - regular", "tlg_framework"),"Crafty Girls:tlg://fonts.gstatic.com/s/craftygirls/v5/0Sv8UWFFdhQmesHL32H8oy3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Crafty Girls - regular", "tlg_framework"),"Creepster:tlg://fonts.gstatic.com/s/creepster/v5/0vdr5kWJ6aJlOg5JvxnXzQ.ttf:tlg:regular" => esc_html__( "Creepster - regular", "tlg_framework"),"Crete Round:tlg://fonts.gstatic.com/s/creteround/v5/B8EwN421qqOCCT8vOH4wJ6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Crete Round - regular", "tlg_framework"),"Crete Round:tlg://fonts.gstatic.com/s/creteround/v5/5xAt7XK2vkUdjhGtt98unUeOrDcLawS7-ssYqLr2Xp4.ttf:tlg:italic" => esc_html__( "Crete Round - italic", "tlg_framework"),"Crimson Text:tlg://fonts.gstatic.com/s/crimsontext/v6/3IFMwfRa07i-auYR-B-zNS3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Crimson Text - regular", "tlg_framework"),"Crimson Text:tlg://fonts.gstatic.com/s/crimsontext/v6/a5QZnvmn5amyNI-t2BMkWPMZXuCXbOrAvx5R0IT5Oyo.ttf:tlg:italic" => esc_html__( "Crimson Text - italic", "tlg_framework"),"Crimson Text:tlg://fonts.gstatic.com/s/crimsontext/v6/rEy5tGc5HdXy56Xvd4f3I2v8CylhIUtwUiYO7Z2wXbE.ttf:tlg:600" => esc_html__( "Crimson Text - 600", "tlg_framework"),"Crimson Text:tlg://fonts.gstatic.com/s/crimsontext/v6/4j4TR-EfnvCt43InYpUNDIR-5-urNOGAobhAyctHvW8.ttf:tlg:600italic" => esc_html__( "Crimson Text - 600italic", "tlg_framework"),"Crimson Text:tlg://fonts.gstatic.com/s/crimsontext/v6/rEy5tGc5HdXy56Xvd4f3I0D2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Crimson Text - 700", "tlg_framework"),"Crimson Text:tlg://fonts.gstatic.com/s/crimsontext/v6/4j4TR-EfnvCt43InYpUNDPAs9-1nE9qOqhChW0m4nDE.ttf:tlg:700italic" => esc_html__( "Crimson Text - 700italic", "tlg_framework"),"Croissant One:tlg://fonts.gstatic.com/s/croissantone/v4/mPjsOObnC77fp1cvZlOfIYjjx0o0jr6fNXxPgYh_a8Q.ttf:tlg:regular" => esc_html__( "Croissant One - regular", "tlg_framework"),"Crushed:tlg://fonts.gstatic.com/s/crushed/v6/aHwSejs3Kt0Lg95u7j32jA.ttf:tlg:regular" => esc_html__( "Crushed - regular", "tlg_framework"),"Cuprum:tlg://fonts.gstatic.com/s/cuprum/v7/JgXs0F_UiaEdAS74msmFNg.ttf:tlg:regular" => esc_html__( "Cuprum - regular", "tlg_framework"),"Cuprum:tlg://fonts.gstatic.com/s/cuprum/v7/cLEz0KV6OxInnktSzpk58g.ttf:tlg:italic" => esc_html__( "Cuprum - italic", "tlg_framework"),"Cuprum:tlg://fonts.gstatic.com/s/cuprum/v7/6tl3_FkDeXSD72oEHuJh4w.ttf:tlg:700" => esc_html__( "Cuprum - 700", "tlg_framework"),"Cuprum:tlg://fonts.gstatic.com/s/cuprum/v7/bnkXaBfoYvaJ75axRPSwVKCWcynf_cDxXwCLxiixG1c.ttf:tlg:700italic" => esc_html__( "Cuprum - 700italic", "tlg_framework"),"Cutive:tlg://fonts.gstatic.com/s/cutive/v8/G2bW-ImyOCwKxBkLyz39YQ.ttf:tlg:regular" => esc_html__( "Cutive - regular", "tlg_framework"),"Cutive Mono:tlg://fonts.gstatic.com/s/cutivemono/v4/ncWQtFVKcSs8OW798v30k6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Cutive Mono - regular", "tlg_framework"),"Damion:tlg://fonts.gstatic.com/s/damion/v6/13XtECwKxhD_VrOqXL4SiA.ttf:tlg:regular" => esc_html__( "Damion - regular", "tlg_framework"),"Dancing Script:tlg://fonts.gstatic.com/s/dancingscript/v6/DK0eTGXiZjN6yA8zAEyM2RnpV0hQCek3EmWnCPrvGRM.ttf:tlg:regular" => esc_html__( "Dancing Script - regular", "tlg_framework"),"Dancing Script:tlg://fonts.gstatic.com/s/dancingscript/v6/KGBfwabt0ZRLA5W1ywjowb_dAmXiKjTPGCuO6G2MbfA.ttf:tlg:700" => esc_html__( "Dancing Script - 700", "tlg_framework"),"Dangrek:tlg://fonts.gstatic.com/s/dangrek/v8/LOaFhBT-EHNxZjV8DAW_ew.ttf:tlg:regular" => esc_html__( "Dangrek - regular", "tlg_framework"),"Dawning of a New Day:tlg://fonts.gstatic.com/s/dawningofanewday/v7/JiDsRhiKZt8uz3NJ5xA06gXLnohmOYWQZqo_sW8GLTk.ttf:tlg:regular" => esc_html__( "Dawning of a New Day - regular", "tlg_framework"),"Days One:tlg://fonts.gstatic.com/s/daysone/v6/kzwZjNhc1iabMsrc_hKBIA.ttf:tlg:regular" => esc_html__( "Days One - regular", "tlg_framework"),"Dekko:tlg://fonts.gstatic.com/s/dekko/v2/AKtgABKC1rUxgIgS-bpojw.ttf:tlg:regular" => esc_html__( "Dekko - regular", "tlg_framework"),"Delius:tlg://fonts.gstatic.com/s/delius/v6/TQA163qafki2-gV-B6F_ag.ttf:tlg:regular" => esc_html__( "Delius - regular", "tlg_framework"),"Delius Swash Caps:tlg://fonts.gstatic.com/s/deliusswashcaps/v8/uXyrEUnoWApxIOICunRq7yIrxb5zDVgU2N3VzXm7zq4.ttf:tlg:regular" => esc_html__( "Delius Swash Caps - regular", "tlg_framework"),"Delius Unicase:tlg://fonts.gstatic.com/s/deliusunicase/v9/b2sKujV3Q48RV2PQ0k1vqu6rPKfVZo7L2bERcf0BDns.ttf:tlg:regular" => esc_html__( "Delius Unicase - regular", "tlg_framework"),"Delius Unicase:tlg://fonts.gstatic.com/s/deliusunicase/v9/7FTMTITcb4dxUp99FAdTqNy5weKXdcrx-wE0cgECMq8.ttf:tlg:700" => esc_html__( "Delius Unicase - 700", "tlg_framework"),"Della Respira:tlg://fonts.gstatic.com/s/dellarespira/v4/F4E6Lo_IZ6L9AJCcbqtDVeDcg5akpSnIcsPhLOFv7l8.ttf:tlg:regular" => esc_html__( "Della Respira - regular", "tlg_framework"),"Denk One:tlg://fonts.gstatic.com/s/denkone/v4/TdXOeA4eA_hEx4W8Sh9wPw.ttf:tlg:regular" => esc_html__( "Denk One - regular", "tlg_framework"),"Devonshire:tlg://fonts.gstatic.com/s/devonshire/v5/I3ct_2t12SYizP8ZC-KFi_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Devonshire - regular", "tlg_framework"),"Dhurjati:tlg://fonts.gstatic.com/s/dhurjati/v4/uV6jO5e2iFMbGB0z79Cy5g.ttf:tlg:regular" => esc_html__( "Dhurjati - regular", "tlg_framework"),"Didact Gothic:tlg://fonts.gstatic.com/s/didactgothic/v7/v8_72sD3DYMKyM0dn3LtWotBLojGU5Qdl8-5NL4v70w.ttf:tlg:regular" => esc_html__( "Didact Gothic - regular", "tlg_framework"),"Diplomata:tlg://fonts.gstatic.com/s/diplomata/v6/u-ByBiKgN6rTMA36H3kcKg.ttf:tlg:regular" => esc_html__( "Diplomata - regular", "tlg_framework"),"Diplomata SC:tlg://fonts.gstatic.com/s/diplomatasc/v5/JdVwAwfE1a_pahXjk5qpNi3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Diplomata SC - regular", "tlg_framework"),"Domine:tlg://fonts.gstatic.com/s/domine/v4/wfVIgamVFjMNQAEWurCiHA.ttf:tlg:regular" => esc_html__( "Domine - regular", "tlg_framework"),"Domine:tlg://fonts.gstatic.com/s/domine/v4/phBcG1ZbQFxUIt18hPVxnw.ttf:tlg:700" => esc_html__( "Domine - 700", "tlg_framework"),"Donegal One:tlg://fonts.gstatic.com/s/donegalone/v4/6kN4-fDxz7T9s5U61HwfF6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Donegal One - regular", "tlg_framework"),"Doppio One:tlg://fonts.gstatic.com/s/doppioone/v4/WHZ3HJQotpk_4aSMNBo_t_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Doppio One - regular", "tlg_framework"),"Dorsa:tlg://fonts.gstatic.com/s/dorsa/v7/wCc3cUe6XrmG2LQE6GlIrw.ttf:tlg:regular" => esc_html__( "Dorsa - regular", "tlg_framework"),"Dosis:tlg://fonts.gstatic.com/s/dosis/v4/ztftab0r6hcd7AeurUGrSQ.ttf:tlg:200" => esc_html__( "Dosis - 200", "tlg_framework"),"Dosis:tlg://fonts.gstatic.com/s/dosis/v4/awIB6L0h5mb0plIKorXmuA.ttf:tlg:300" => esc_html__( "Dosis - 300", "tlg_framework"),"Dosis:tlg://fonts.gstatic.com/s/dosis/v4/rJRlixu-w0JZ1MyhJpao_Q.ttf:tlg:regular" => esc_html__( "Dosis - regular", "tlg_framework"),"Dosis:tlg://fonts.gstatic.com/s/dosis/v4/ruEXDOFMxDPGnjCBKRqdAQ.ttf:tlg:500" => esc_html__( "Dosis - 500", "tlg_framework"),"Dosis:tlg://fonts.gstatic.com/s/dosis/v4/KNAswRNwm3tfONddYyidxg.ttf:tlg:600" => esc_html__( "Dosis - 600", "tlg_framework"),"Dosis:tlg://fonts.gstatic.com/s/dosis/v4/AEEAj0ONidK8NQQMBBlSig.ttf:tlg:700" => esc_html__( "Dosis - 700", "tlg_framework"),"Dosis:tlg://fonts.gstatic.com/s/dosis/v4/nlrKd8E69vvUU39XGsvR7Q.ttf:tlg:800" => esc_html__( "Dosis - 800", "tlg_framework"),"Dr Sugiyama:tlg://fonts.gstatic.com/s/drsugiyama/v5/S5Yx3MIckgoyHhhS4C9Tv6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Dr Sugiyama - regular", "tlg_framework"),"Droid Sans:tlg://fonts.gstatic.com/s/droidsans/v6/rS9BT6-asrfjpkcV3DXf__esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Droid Sans - regular", "tlg_framework"),"Droid Sans:tlg://fonts.gstatic.com/s/droidsans/v6/EFpQQyG9GqCrobXxL-KRMQJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700" => esc_html__( "Droid Sans - 700", "tlg_framework"),"Droid Sans Mono:tlg://fonts.gstatic.com/s/droidsansmono/v7/ns-m2xQYezAtqh7ai59hJcwD6PD0c3_abh9zHKQtbGU.ttf:tlg:regular" => esc_html__( "Droid Sans Mono - regular", "tlg_framework"),"Droid Serif:tlg://fonts.gstatic.com/s/droidserif/v6/DgAtPy6rIVa2Zx3Xh9KaNaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Droid Serif - regular", "tlg_framework"),"Droid Serif:tlg://fonts.gstatic.com/s/droidserif/v6/cj2hUnSRBhwmSPr9kS5890eOrDcLawS7-ssYqLr2Xp4.ttf:tlg:italic" => esc_html__( "Droid Serif - italic", "tlg_framework"),"Droid Serif:tlg://fonts.gstatic.com/s/droidserif/v6/QQt14e8dY39u-eYBZmppwXe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Droid Serif - 700", "tlg_framework"),"Droid Serif:tlg://fonts.gstatic.com/s/droidserif/v6/c92rD_x0V1LslSFt3-QEps_zJjSACmk0BRPxQqhnNLU.ttf:tlg:700italic" => esc_html__( "Droid Serif - 700italic", "tlg_framework"),"Duru Sans:tlg://fonts.gstatic.com/s/durusans/v9/xn7iYH8xwmSyTvEV_HOxTw.ttf:tlg:regular" => esc_html__( "Duru Sans - regular", "tlg_framework"),"Dynalight:tlg://fonts.gstatic.com/s/dynalight/v5/-CWsIe8OUDWTIHjSAh41kA.ttf:tlg:regular" => esc_html__( "Dynalight - regular", "tlg_framework"),"EB Garamond:tlg://fonts.gstatic.com/s/ebgaramond/v7/CDR0kuiFK7I1OZ2hSdR7G6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "EB Garamond - regular", "tlg_framework"),"Eagle Lake:tlg://fonts.gstatic.com/s/eaglelake/v4/ZKlYin7caemhx9eSg6RvPfesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Eagle Lake - regular", "tlg_framework"),"Eater:tlg://fonts.gstatic.com/s/eater/v5/gm6f3OmYEdbs3lPQtUfBkA.ttf:tlg:regular" => esc_html__( "Eater - regular", "tlg_framework"),"Economica:tlg://fonts.gstatic.com/s/economica/v4/G4rJRujzZbq9Nxngu9l3hg.ttf:tlg:regular" => esc_html__( "Economica - regular", "tlg_framework"),"Economica:tlg://fonts.gstatic.com/s/economica/v4/p5O9AVeUqx_n35xQRinNYaCWcynf_cDxXwCLxiixG1c.ttf:tlg:italic" => esc_html__( "Economica - italic", "tlg_framework"),"Economica:tlg://fonts.gstatic.com/s/economica/v4/UK4l2VEpwjv3gdcwbwXE9C3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Economica - 700", "tlg_framework"),"Economica:tlg://fonts.gstatic.com/s/economica/v4/ac5dlUsedQ03RqGOeay-3Xe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700italic" => esc_html__( "Economica - 700italic", "tlg_framework"),"Eczar:tlg://fonts.gstatic.com/s/eczar/v4/uKZcAQ5JBBs1UbeXFRbBRg.ttf:tlg:regular" => esc_html__( "Eczar - regular", "tlg_framework"),"Eczar:tlg://fonts.gstatic.com/s/eczar/v4/Ooe4KaPp2594tF8TbMfdlQ.ttf:tlg:500" => esc_html__( "Eczar - 500", "tlg_framework"),"Eczar:tlg://fonts.gstatic.com/s/eczar/v4/IjQsWW0bmgkZ6lnN72cnTQ.ttf:tlg:600" => esc_html__( "Eczar - 600", "tlg_framework"),"Eczar:tlg://fonts.gstatic.com/s/eczar/v4/ELC8RVXfBMb3VuuHtMwBOA.ttf:tlg:700" => esc_html__( "Eczar - 700", "tlg_framework"),"Eczar:tlg://fonts.gstatic.com/s/eczar/v4/9Uyt6nTZLx_Qj5_WRah-iQ.ttf:tlg:800" => esc_html__( "Eczar - 800", "tlg_framework"),"Ek Mukta:tlg://fonts.gstatic.com/s/ekmukta/v7/crtkNHh5JcM3VJKG0E-B36CWcynf_cDxXwCLxiixG1c.ttf:tlg:200" => esc_html__( "Ek Mukta - 200", "tlg_framework"),"Ek Mukta:tlg://fonts.gstatic.com/s/ekmukta/v7/mpaAv7CIyk0VnZlqSneVxKCWcynf_cDxXwCLxiixG1c.ttf:tlg:300" => esc_html__( "Ek Mukta - 300", "tlg_framework"),"Ek Mukta:tlg://fonts.gstatic.com/s/ekmukta/v7/aFcjXdC5jyJ1p8w54wIIrg.ttf:tlg:regular" => esc_html__( "Ek Mukta - regular", "tlg_framework"),"Ek Mukta:tlg://fonts.gstatic.com/s/ekmukta/v7/PZ1y2MstFczWvBlFSgzMyaCWcynf_cDxXwCLxiixG1c.ttf:tlg:500" => esc_html__( "Ek Mukta - 500", "tlg_framework"),"Ek Mukta:tlg://fonts.gstatic.com/s/ekmukta/v7/Z5Mfzeu6M3emakcJO2QeTqCWcynf_cDxXwCLxiixG1c.ttf:tlg:600" => esc_html__( "Ek Mukta - 600", "tlg_framework"),"Ek Mukta:tlg://fonts.gstatic.com/s/ekmukta/v7/4ugcOGR28Jn-oBIn0-qLYaCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Ek Mukta - 700", "tlg_framework"),"Ek Mukta:tlg://fonts.gstatic.com/s/ekmukta/v7/O68TH5OjEhVmn9_gIrcfS6CWcynf_cDxXwCLxiixG1c.ttf:tlg:800" => esc_html__( "Ek Mukta - 800", "tlg_framework"),"Electrolize:tlg://fonts.gstatic.com/s/electrolize/v5/yFVu5iokC-nt4B1Cyfxb9aCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Electrolize - regular", "tlg_framework"),"Elsie:tlg://fonts.gstatic.com/s/elsie/v5/gwspePauE45BJu6Ok1QrfQ.ttf:tlg:regular" => esc_html__( "Elsie - regular", "tlg_framework"),"Elsie:tlg://fonts.gstatic.com/s/elsie/v5/1t-9f0N2NFYwAgN7oaISqg.ttf:tlg:900" => esc_html__( "Elsie - 900", "tlg_framework"),"Elsie Swash Caps:tlg://fonts.gstatic.com/s/elsieswashcaps/v4/9L3hIJMPCf6sxCltnxd6X2YeFSdnSpRYv5h9gpdlD1g.ttf:tlg:regular" => esc_html__( "Elsie Swash Caps - regular", "tlg_framework"),"Elsie Swash Caps:tlg://fonts.gstatic.com/s/elsieswashcaps/v4/iZnus9qif0tR5pGaDv5zdKoKBWBozTtxi30NfZDOXXU.ttf:tlg:900" => esc_html__( "Elsie Swash Caps - 900", "tlg_framework"),"Emblema One:tlg://fonts.gstatic.com/s/emblemaone/v5/7IlBUjBWPIiw7cr_O2IfSaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Emblema One - regular", "tlg_framework"),"Emilys Candy:tlg://fonts.gstatic.com/s/emilyscandy/v4/PofLVm6v1SwZGOzC8s-I3S3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Emilys Candy - regular", "tlg_framework"),"Engagement:tlg://fonts.gstatic.com/s/engagement/v5/4Uz0Jii7oVPcaFRYmbpU6vesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Engagement - regular", "tlg_framework"),"Englebert:tlg://fonts.gstatic.com/s/englebert/v4/sll38iOvOuarDTYBchlP3Q.ttf:tlg:regular" => esc_html__( "Englebert - regular", "tlg_framework"),"Enriqueta:tlg://fonts.gstatic.com/s/enriqueta/v5/_p90TrIwR1SC-vDKtmrv6A.ttf:tlg:regular" => esc_html__( "Enriqueta - regular", "tlg_framework"),"Enriqueta:tlg://fonts.gstatic.com/s/enriqueta/v5/I27Pb-wEGH2ajLYP0QrtSC3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Enriqueta - 700", "tlg_framework"),"Erica One:tlg://fonts.gstatic.com/s/ericaone/v7/cIBnH2VAqQMIGYAcE4ufvQ.ttf:tlg:regular" => esc_html__( "Erica One - regular", "tlg_framework"),"Esteban:tlg://fonts.gstatic.com/s/esteban/v4/ESyhLgqDDyK5JcFPp2svDw.ttf:tlg:regular" => esc_html__( "Esteban - regular", "tlg_framework"),"Euphoria Script:tlg://fonts.gstatic.com/s/euphoriascript/v4/c4XB4Iijj_NvSsCF4I0O2MxLhO8OSNnfAp53LK1_iRs.ttf:tlg:regular" => esc_html__( "Euphoria Script - regular", "tlg_framework"),"Ewert:tlg://fonts.gstatic.com/s/ewert/v4/Em8hrzuzSbfHcTVqMjbAQg.ttf:tlg:regular" => esc_html__( "Ewert - regular", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/RI7A9uwjRmPbVp0n8e-Jvg.ttf:tlg:100" => esc_html__( "Exo - 100", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/qtGyZZlWb2EEvby3ZPosxw.ttf:tlg:100italic" => esc_html__( "Exo - 100italic", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/F8OfC_swrRRxpFt-tlXZQg.ttf:tlg:200" => esc_html__( "Exo - 200", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/fr4HBfXHYiIngW2_bhlgRw.ttf:tlg:200italic" => esc_html__( "Exo - 200italic", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/SBrN7TKUqgGUvfxqHqsnNw.ttf:tlg:300" => esc_html__( "Exo - 300", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/3gmiLjBegIfcDLISjTGA1g.ttf:tlg:300italic" => esc_html__( "Exo - 300italic", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/eUEzTFueNXRVhbt4PEB8kQ.ttf:tlg:regular" => esc_html__( "Exo - regular", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/cfgolWisMSURhpQeVHl_NA.ttf:tlg:italic" => esc_html__( "Exo - italic", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/jCg6DmGGXt_OVyp5ofQHPw.ttf:tlg:500" => esc_html__( "Exo - 500", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/lo5eTdCNJZQVN08p8RnzAQ.ttf:tlg:500italic" => esc_html__( "Exo - 500italic", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/q_SG5kXUmOcIvFpgtdZnlw.ttf:tlg:600" => esc_html__( "Exo - 600", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/0cExa8K_pxS2lTuMr68XUA.ttf:tlg:600italic" => esc_html__( "Exo - 600italic", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/3_jwsL4v9uHjl5Q37G57mw.ttf:tlg:700" => esc_html__( "Exo - 700", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/0me55yJIxd5vyQ9bF7SsiA.ttf:tlg:700italic" => esc_html__( "Exo - 700italic", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/yLPuxBuV0lzqibRJyooOJg.ttf:tlg:800" => esc_html__( "Exo - 800", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/n3LejeKVj_8gtZq5fIgNYw.ttf:tlg:800italic" => esc_html__( "Exo - 800italic", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/97d0nd6Yv4-SA_X92xAuZA.ttf:tlg:900" => esc_html__( "Exo - 900", "tlg_framework"),"Exo:tlg://fonts.gstatic.com/s/exo/v4/JHTkQVhzyLtkY13Ye95TJQ.ttf:tlg:900italic" => esc_html__( "Exo - 900italic", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/oVOtQy53isv97g4UhBUDqg.ttf:tlg:100" => esc_html__( "Exo 2 - 100", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/LNYVgsJcaCxoKFHmd4AZcg.ttf:tlg:100italic" => esc_html__( "Exo 2 - 100italic", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/qa-Ci2pBwJdCxciE1ErifQ.ttf:tlg:200" => esc_html__( "Exo 2 - 200", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/DCrVxDVvS69n50O-5erZVvesZW2xOQ-xsNqO47m55DA.ttf:tlg:200italic" => esc_html__( "Exo 2 - 200italic", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/nLUBdz_lHHoVIPor05Byhw.ttf:tlg:300" => esc_html__( "Exo 2 - 300", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/iSy9VTeUTiqiurQg2ywtu_esZW2xOQ-xsNqO47m55DA.ttf:tlg:300italic" => esc_html__( "Exo 2 - 300italic", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/Pf_kZuIH5c5WKVkQUaeSWQ.ttf:tlg:regular" => esc_html__( "Exo 2 - regular", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/xxA5ZscX9sTU6U0lZJUlYA.ttf:tlg:italic" => esc_html__( "Exo 2 - italic", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/oM0rzUuPqVJpW-VEIpuW5w.ttf:tlg:500" => esc_html__( "Exo 2 - 500", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/amzRVCB-gipwdihZZ2LtT_esZW2xOQ-xsNqO47m55DA.ttf:tlg:500italic" => esc_html__( "Exo 2 - 500italic", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/YnSn3HsyvyI1feGSdRMYqA.ttf:tlg:600" => esc_html__( "Exo 2 - 600", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/Vmo58BiptGwfVFb0teU5gPesZW2xOQ-xsNqO47m55DA.ttf:tlg:600italic" => esc_html__( "Exo 2 - 600italic", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/2DiK4XkdTckfTk6we73-bQ.ttf:tlg:700" => esc_html__( "Exo 2 - 700", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/Sdo-zW-4_--pDkTg6bYrY_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700italic" => esc_html__( "Exo 2 - 700italic", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/IVYl_7dJruOg8zKRpC8Hrw.ttf:tlg:800" => esc_html__( "Exo 2 - 800", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/p0TA6KeOz1o4rySEbvUxI_esZW2xOQ-xsNqO47m55DA.ttf:tlg:800italic" => esc_html__( "Exo 2 - 800italic", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/e8csG8Wnu87AF6uCndkFRQ.ttf:tlg:900" => esc_html__( "Exo 2 - 900", "tlg_framework"),"Exo 2:tlg://fonts.gstatic.com/s/exo2/v3/KPhsGCoT2-7Uj6pMlRscH_esZW2xOQ-xsNqO47m55DA.ttf:tlg:900italic" => esc_html__( "Exo 2 - 900italic", "tlg_framework"),"Expletus Sans:tlg://fonts.gstatic.com/s/expletussans/v9/gegTSDBDs5le3g6uxU1ZsX8f0n03UdmQgF_CLvNR2vg.ttf:tlg:regular" => esc_html__( "Expletus Sans - regular", "tlg_framework"),"Expletus Sans:tlg://fonts.gstatic.com/s/expletussans/v9/Y-erXmY0b6DU_i2Qu0hTJj4G9C9ttb0Oz5Cvf0qOitE.ttf:tlg:italic" => esc_html__( "Expletus Sans - italic", "tlg_framework"),"Expletus Sans:tlg://fonts.gstatic.com/s/expletussans/v9/cl6rhMY77Ilk8lB_uYRRwAqQmZ7VjhwksfpNVG0pqGc.ttf:tlg:500" => esc_html__( "Expletus Sans - 500", "tlg_framework"),"Expletus Sans:tlg://fonts.gstatic.com/s/expletussans/v9/sRBNtc46w65uJE451UYmW87DCVO6wo6i5LKIyZDzK40.ttf:tlg:500italic" => esc_html__( "Expletus Sans - 500italic", "tlg_framework"),"Expletus Sans:tlg://fonts.gstatic.com/s/expletussans/v9/cl6rhMY77Ilk8lB_uYRRwCvj1tU7IJMS3CS9kCx2B3U.ttf:tlg:600" => esc_html__( "Expletus Sans - 600", "tlg_framework"),"Expletus Sans:tlg://fonts.gstatic.com/s/expletussans/v9/sRBNtc46w65uJE451UYmW8yKH23ZS6zCKOFHG0e_4JE.ttf:tlg:600italic" => esc_html__( "Expletus Sans - 600italic", "tlg_framework"),"Expletus Sans:tlg://fonts.gstatic.com/s/expletussans/v9/cl6rhMY77Ilk8lB_uYRRwFCbmAUID8LN-q3pJpOk3Ys.ttf:tlg:700" => esc_html__( "Expletus Sans - 700", "tlg_framework"),"Expletus Sans:tlg://fonts.gstatic.com/s/expletussans/v9/sRBNtc46w65uJE451UYmW5F66r9C4AnxxlBlGd7xY4g.ttf:tlg:700italic" => esc_html__( "Expletus Sans - 700italic", "tlg_framework"),"Fanwood Text:tlg://fonts.gstatic.com/s/fanwoodtext/v6/hDNDHUlsSb8bgnEmDp4T_i3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Fanwood Text - regular", "tlg_framework"),"Fanwood Text:tlg://fonts.gstatic.com/s/fanwoodtext/v6/0J3SBbkMZqBV-3iGxs5E9_MZXuCXbOrAvx5R0IT5Oyo.ttf:tlg:italic" => esc_html__( "Fanwood Text - italic", "tlg_framework"),"Fascinate:tlg://fonts.gstatic.com/s/fascinate/v5/ZE0637WWkBPKt1AmFaqD3Q.ttf:tlg:regular" => esc_html__( "Fascinate - regular", "tlg_framework"),"Fascinate Inline:tlg://fonts.gstatic.com/s/fascinateinline/v6/lRguYfMfWArflkm5aOQ5QJmp8DTZ6iHear7UV05iykg.ttf:tlg:regular" => esc_html__( "Fascinate Inline - regular", "tlg_framework"),"Faster One:tlg://fonts.gstatic.com/s/fasterone/v6/YxTOW2sf56uxD1T7byP5K_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Faster One - regular", "tlg_framework"),"Fasthand:tlg://fonts.gstatic.com/s/fasthand/v7/6XAagHH_KmpZL67wTvsETQ.ttf:tlg:regular" => esc_html__( "Fasthand - regular", "tlg_framework"),"Fauna One:tlg://fonts.gstatic.com/s/faunaone/v4/8kL-wpAPofcAMELI_5NRnQ.ttf:tlg:regular" => esc_html__( "Fauna One - regular", "tlg_framework"),"Federant:tlg://fonts.gstatic.com/s/federant/v8/tddZFSiGvxICNOGra0i5aA.ttf:tlg:regular" => esc_html__( "Federant - regular", "tlg_framework"),"Federo:tlg://fonts.gstatic.com/s/federo/v8/JPhe1S2tujeyaR79gXBLeQ.ttf:tlg:regular" => esc_html__( "Federo - regular", "tlg_framework"),"Felipa:tlg://fonts.gstatic.com/s/felipa/v4/SeyfyFZY7abAQXGrOIYnYg.ttf:tlg:regular" => esc_html__( "Felipa - regular", "tlg_framework"),"Fenix:tlg://fonts.gstatic.com/s/fenix/v4/Ak8wR3VSlAN7VN_eMeJj7Q.ttf:tlg:regular" => esc_html__( "Fenix - regular", "tlg_framework"),"Finger Paint:tlg://fonts.gstatic.com/s/fingerpaint/v4/m_ZRbiY-aPb13R3DWPBGXy3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Finger Paint - regular", "tlg_framework"),"Fira Mono:tlg://fonts.gstatic.com/s/firamono/v3/WQOm1D4RO-yvA9q9trJc8g.ttf:tlg:regular" => esc_html__( "Fira Mono - regular", "tlg_framework"),"Fira Mono:tlg://fonts.gstatic.com/s/firamono/v3/l24Wph3FsyKAbJ8dfExTZy3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Fira Mono - 700", "tlg_framework"),"Fira Sans:tlg://fonts.gstatic.com/s/firasans/v5/VTBnrK42EiOBncVyQXZ7jy3USBnSvpkopQaUR-2r7iU.ttf:tlg:300" => esc_html__( "Fira Sans - 300", "tlg_framework"),"Fira Sans:tlg://fonts.gstatic.com/s/firasans/v5/6s0YCA9oCTF6hM60YM-qTS9-WlPSxbfiI49GsXo3q0g.ttf:tlg:300italic" => esc_html__( "Fira Sans - 300italic", "tlg_framework"),"Fira Sans:tlg://fonts.gstatic.com/s/firasans/v5/nsT0isDy56OkSX99sFQbXw.ttf:tlg:regular" => esc_html__( "Fira Sans - regular", "tlg_framework"),"Fira Sans:tlg://fonts.gstatic.com/s/firasans/v5/cPT_2ddmoxsUuMtQqa8zGqCWcynf_cDxXwCLxiixG1c.ttf:tlg:italic" => esc_html__( "Fira Sans - italic", "tlg_framework"),"Fira Sans:tlg://fonts.gstatic.com/s/firasans/v5/zM2u8V3CuPVwAAXFQcDi4C3USBnSvpkopQaUR-2r7iU.ttf:tlg:500" => esc_html__( "Fira Sans - 500", "tlg_framework"),"Fira Sans:tlg://fonts.gstatic.com/s/firasans/v5/6s0YCA9oCTF6hM60YM-qTcCNfqCYlB_eIx7H1TVXe60.ttf:tlg:500italic" => esc_html__( "Fira Sans - 500italic", "tlg_framework"),"Fira Sans:tlg://fonts.gstatic.com/s/firasans/v5/DugPdSljmOTocZOR2CItOi3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Fira Sans - 700", "tlg_framework"),"Fira Sans:tlg://fonts.gstatic.com/s/firasans/v5/6s0YCA9oCTF6hM60YM-qTXe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700italic" => esc_html__( "Fira Sans - 700italic", "tlg_framework"),"Fjalla One:tlg://fonts.gstatic.com/s/fjallaone/v4/3b7vWCfOZsU53vMa8LWsf_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Fjalla One - regular", "tlg_framework"),"Fjord One:tlg://fonts.gstatic.com/s/fjordone/v5/R_YHK8au2uFPw5tNu5N7zw.ttf:tlg:regular" => esc_html__( "Fjord One - regular", "tlg_framework"),"Flamenco:tlg://fonts.gstatic.com/s/flamenco/v6/x9iI5CogvuZVCGoRHwXuo6CWcynf_cDxXwCLxiixG1c.ttf:tlg:300" => esc_html__( "Flamenco - 300", "tlg_framework"),"Flamenco:tlg://fonts.gstatic.com/s/flamenco/v6/HC0ugfLLgt26I5_BWD1PZA.ttf:tlg:regular" => esc_html__( "Flamenco - regular", "tlg_framework"),"Flavors:tlg://fonts.gstatic.com/s/flavors/v5/SPJi5QclATvon8ExcKGRvQ.ttf:tlg:regular" => esc_html__( "Flavors - regular", "tlg_framework"),"Fondamento:tlg://fonts.gstatic.com/s/fondamento/v5/6LWXcjT1B7bnWluAOSNfMPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Fondamento - regular", "tlg_framework"),"Fondamento:tlg://fonts.gstatic.com/s/fondamento/v5/y6TmwhSbZ8rYq7OTFyo7OS3USBnSvpkopQaUR-2r7iU.ttf:tlg:italic" => esc_html__( "Fondamento - italic", "tlg_framework"),"Fontdiner Swanky:tlg://fonts.gstatic.com/s/fontdinerswanky/v6/8_GxIO5ixMtn5P6COsF3TlBjMPLzPAFJwRBn-s1U7kA.ttf:tlg:regular" => esc_html__( "Fontdiner Swanky - regular", "tlg_framework"),"Forum:tlg://fonts.gstatic.com/s/forum/v7/MZUpsq1VfLrqv8eSDcbrrQ.ttf:tlg:regular" => esc_html__( "Forum - regular", "tlg_framework"),"Francois One:tlg://fonts.gstatic.com/s/francoisone/v9/bYbkq2nU2TSx4SwFbz5sCC3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Francois One - regular", "tlg_framework"),"Freckle Face:tlg://fonts.gstatic.com/s/freckleface/v4/7-B8j9BPJgazdHIGqPNv8y3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Freckle Face - regular", "tlg_framework"),"Fredericka the Great:tlg://fonts.gstatic.com/s/frederickathegreat/v5/7Es8Lxoku-e5eOZWpxw18nrnet6gXN1McwdQxS1dVrI.ttf:tlg:regular" => esc_html__( "Fredericka the Great - regular", "tlg_framework"),"Fredoka One:tlg://fonts.gstatic.com/s/fredokaone/v4/QKfwXi-z-KtJAlnO2ethYqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Fredoka One - regular", "tlg_framework"),"Freehand:tlg://fonts.gstatic.com/s/freehand/v8/uEBQxvA0lnn_BrD6krlxMw.ttf:tlg:regular" => esc_html__( "Freehand - regular", "tlg_framework"),"Fresca:tlg://fonts.gstatic.com/s/fresca/v5/2q7Qm9sCo1tWvVgSDVWNIw.ttf:tlg:regular" => esc_html__( "Fresca - regular", "tlg_framework"),"Frijole:tlg://fonts.gstatic.com/s/frijole/v5/L2MfZse-2gCascuD-nLhWg.ttf:tlg:regular" => esc_html__( "Frijole - regular", "tlg_framework"),"Fruktur:tlg://fonts.gstatic.com/s/fruktur/v8/PnQvfEi1LssAvhJsCwH__w.ttf:tlg:regular" => esc_html__( "Fruktur - regular", "tlg_framework"),"Fugaz One:tlg://fonts.gstatic.com/s/fugazone/v6/5tteVDCwxsr8-5RuSiRWOw.ttf:tlg:regular" => esc_html__( "Fugaz One - regular", "tlg_framework"),"GFS Didot:tlg://fonts.gstatic.com/s/gfsdidot/v6/jQKxZy2RU-h9tkPZcRVluA.ttf:tlg:regular" => esc_html__( "GFS Didot - regular", "tlg_framework"),"GFS Neohellenic:tlg://fonts.gstatic.com/s/gfsneohellenic/v7/B4xRqbn-tANVqVgamMsSDiayCZa0z7CpFzlkqoCHztc.ttf:tlg:regular" => esc_html__( "GFS Neohellenic - regular", "tlg_framework"),"GFS Neohellenic:tlg://fonts.gstatic.com/s/gfsneohellenic/v7/KnaWrO4awITAqigQIIYXKkCTdomiyJpIzPbEbIES3rU.ttf:tlg:italic" => esc_html__( "GFS Neohellenic - italic", "tlg_framework"),"GFS Neohellenic:tlg://fonts.gstatic.com/s/gfsneohellenic/v7/7HwjPQa7qNiOsnUce2h4448_BwCLZY3eDSV6kppAwI8.ttf:tlg:700" => esc_html__( "GFS Neohellenic - 700", "tlg_framework"),"GFS Neohellenic:tlg://fonts.gstatic.com/s/gfsneohellenic/v7/FwWjoX6XqT-szJFyqsu_GYFF0fM4h-krcpQk7emtCpE.ttf:tlg:700italic" => esc_html__( "GFS Neohellenic - 700italic", "tlg_framework"),"Gabriela:tlg://fonts.gstatic.com/s/gabriela/v4/B-2ZfbAO3HDrxqV6lR5tdA.ttf:tlg:regular" => esc_html__( "Gabriela - regular", "tlg_framework"),"Gafata:tlg://fonts.gstatic.com/s/gafata/v5/aTFqlki_3Dc3geo-FxHTvQ.ttf:tlg:regular" => esc_html__( "Gafata - regular", "tlg_framework"),"Galdeano:tlg://fonts.gstatic.com/s/galdeano/v6/ZKFMQI6HxEG1jOT0UGSZUg.ttf:tlg:regular" => esc_html__( "Galdeano - regular", "tlg_framework"),"Galindo:tlg://fonts.gstatic.com/s/galindo/v4/2lafAS_ZEfB33OJryhXDUg.ttf:tlg:regular" => esc_html__( "Galindo - regular", "tlg_framework"),"Gentium Basic:tlg://fonts.gstatic.com/s/gentiumbasic/v8/KCktj43blvLkhOTolFn-MYtBLojGU5Qdl8-5NL4v70w.ttf:tlg:regular" => esc_html__( "Gentium Basic - regular", "tlg_framework"),"Gentium Basic:tlg://fonts.gstatic.com/s/gentiumbasic/v8/qoFz4NSMaYC2UmsMAG3lyTj3mvXnCeAk09uTtmkJGRc.ttf:tlg:italic" => esc_html__( "Gentium Basic - italic", "tlg_framework"),"Gentium Basic:tlg://fonts.gstatic.com/s/gentiumbasic/v8/2qL6yulgGf0wwgOp-UqGyLNuTeOOLg3nUymsEEGmdO0.ttf:tlg:700" => esc_html__( "Gentium Basic - 700", "tlg_framework"),"Gentium Basic:tlg://fonts.gstatic.com/s/gentiumbasic/v8/8N9-c_aQDJ8LbI1NGVMrwtswO1vWwP9exiF8s0wqW10.ttf:tlg:700italic" => esc_html__( "Gentium Basic - 700italic", "tlg_framework"),"Gentium Book Basic:tlg://fonts.gstatic.com/s/gentiumbookbasic/v7/IRFxB2matTxrjZt6a3FUnrWDjKAyldGEr6eEi2MBNeY.ttf:tlg:regular" => esc_html__( "Gentium Book Basic - regular", "tlg_framework"),"Gentium Book Basic:tlg://fonts.gstatic.com/s/gentiumbookbasic/v7/qHqW2lwKO8-uTfIkh8FsUfXfjMwrYnmPVsQth2IcAPY.ttf:tlg:italic" => esc_html__( "Gentium Book Basic - italic", "tlg_framework"),"Gentium Book Basic:tlg://fonts.gstatic.com/s/gentiumbookbasic/v7/T2vUYmWzlqUtgLYdlemGnaWESMHIjnSjm9UUxYtEOko.ttf:tlg:700" => esc_html__( "Gentium Book Basic - 700", "tlg_framework"),"Gentium Book Basic:tlg://fonts.gstatic.com/s/gentiumbookbasic/v7/632u7TMIoFDWQYUaHFUp5PA2A9KyRZEkn4TZVuhsWRM.ttf:tlg:700italic" => esc_html__( "Gentium Book Basic - 700italic", "tlg_framework"),"Geo:tlg://fonts.gstatic.com/s/geo/v8/mJuJYk5Pww84B4uHAQ1XaA.ttf:tlg:regular" => esc_html__( "Geo - regular", "tlg_framework"),"Geo:tlg://fonts.gstatic.com/s/geo/v8/8_r1wToF7nPdDuX1qxel6Q.ttf:tlg:italic" => esc_html__( "Geo - italic", "tlg_framework"),"Geostar:tlg://fonts.gstatic.com/s/geostar/v6/A8WQbhQbpYx3GWWaShJ9GA.ttf:tlg:regular" => esc_html__( "Geostar - regular", "tlg_framework"),"Geostar Fill:tlg://fonts.gstatic.com/s/geostarfill/v6/Y5ovXPPOHYTfQzK2aM-hui3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Geostar Fill - regular", "tlg_framework"),"Germania One:tlg://fonts.gstatic.com/s/germaniaone/v4/3_6AyUql_-FbDi1e68jHdC3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Germania One - regular", "tlg_framework"),"Gidugu:tlg://fonts.gstatic.com/s/gidugu/v3/Ey6Eq3hrT6MM58iFItFcgw.ttf:tlg:regular" => esc_html__( "Gidugu - regular", "tlg_framework"),"Gilda Display:tlg://fonts.gstatic.com/s/gildadisplay/v4/8yAVUZLLZ3wb7dSsjix0CADHmap7fRWINAsw8-RaxNg.ttf:tlg:regular" => esc_html__( "Gilda Display - regular", "tlg_framework"),"Give You Glory:tlg://fonts.gstatic.com/s/giveyouglory/v6/DFEWZFgGmfseyIdGRJAxuBwwkpSPZdvjnMtysdqprfI.ttf:tlg:regular" => esc_html__( "Give You Glory - regular", "tlg_framework"),"Glass Antiqua:tlg://fonts.gstatic.com/s/glassantiqua/v4/0yLrXKplgdUDIMz5TnCHNODcg5akpSnIcsPhLOFv7l8.ttf:tlg:regular" => esc_html__( "Glass Antiqua - regular", "tlg_framework"),"Glegoo:tlg://fonts.gstatic.com/s/glegoo/v5/2tf-h3n2A_SNYXEO0C8bKw.ttf:tlg:regular" => esc_html__( "Glegoo - regular", "tlg_framework"),"Glegoo:tlg://fonts.gstatic.com/s/glegoo/v5/TlLolbauH0-0Aiz1LUH5og.ttf:tlg:700" => esc_html__( "Glegoo - 700", "tlg_framework"),"Gloria Hallelujah:tlg://fonts.gstatic.com/s/gloriahallelujah/v8/CA1k7SlXcY5kvI81M_R28Q3RdPdyebSUyJECJouPsvA.ttf:tlg:regular" => esc_html__( "Gloria Hallelujah - regular", "tlg_framework"),"Goblin One:tlg://fonts.gstatic.com/s/goblinone/v6/331XtzoXgpVEvNTVcBJ_C_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Goblin One - regular", "tlg_framework"),"Gochi Hand:tlg://fonts.gstatic.com/s/gochihand/v7/KT1-WxgHsittJ34_20IfAPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Gochi Hand - regular", "tlg_framework"),"Gorditas:tlg://fonts.gstatic.com/s/gorditas/v4/uMgZhXUyH6qNGF3QsjQT5Q.ttf:tlg:regular" => esc_html__( "Gorditas - regular", "tlg_framework"),"Gorditas:tlg://fonts.gstatic.com/s/gorditas/v4/6-XCeknmxaon8AUqVkMnHaCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Gorditas - 700", "tlg_framework"),"Goudy Bookletter 1911:tlg://fonts.gstatic.com/s/goudybookletter1911/v6/l5lwlGTN3pEY5Bf-rQEuIIjNDsyURsIKu4GSfvSE4mA.ttf:tlg:regular" => esc_html__( "Goudy Bookletter 1911 - regular", "tlg_framework"),"Graduate:tlg://fonts.gstatic.com/s/graduate/v4/JpAmYLHqcIh9_Ff35HHwiA.ttf:tlg:regular" => esc_html__( "Graduate - regular", "tlg_framework"),"Grand Hotel:tlg://fonts.gstatic.com/s/grandhotel/v4/C_A8HiFZjXPpnMt38XnK7qCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Grand Hotel - regular", "tlg_framework"),"Gravitas One:tlg://fonts.gstatic.com/s/gravitasone/v6/nBHdBv6zVNU8MtP6w9FwTS3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Gravitas One - regular", "tlg_framework"),"Great Vibes:tlg://fonts.gstatic.com/s/greatvibes/v4/4Mi5RG_9LjQYrTU55GN_L6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Great Vibes - regular", "tlg_framework"),"Griffy:tlg://fonts.gstatic.com/s/griffy/v4/vWkyYGBSyE5xjnShNtJtzw.ttf:tlg:regular" => esc_html__( "Griffy - regular", "tlg_framework"),"Gruppo:tlg://fonts.gstatic.com/s/gruppo/v7/pS_JM0cK_piBZve-lfUq9w.ttf:tlg:regular" => esc_html__( "Gruppo - regular", "tlg_framework"),"Gudea:tlg://fonts.gstatic.com/s/gudea/v4/S-4QqBlkMPiiA3jNeCR5yw.ttf:tlg:regular" => esc_html__( "Gudea - regular", "tlg_framework"),"Gudea:tlg://fonts.gstatic.com/s/gudea/v4/7mNgsGw_vfS-uUgRVXNDSw.ttf:tlg:italic" => esc_html__( "Gudea - italic", "tlg_framework"),"Gudea:tlg://fonts.gstatic.com/s/gudea/v4/lsip4aiWhJ9bx172Y9FN_w.ttf:tlg:700" => esc_html__( "Gudea - 700", "tlg_framework"),"Gurajada:tlg://fonts.gstatic.com/s/gurajada/v4/6Adfkl4PCRyq6XTENACEyA.ttf:tlg:regular" => esc_html__( "Gurajada - regular", "tlg_framework"),"Habibi:tlg://fonts.gstatic.com/s/habibi/v5/YYyqXF6pWpL7kmKgS_2iUA.ttf:tlg:regular" => esc_html__( "Habibi - regular", "tlg_framework"),"Halant:tlg://fonts.gstatic.com/s/halant/v1/dM3ItAOWNNod_Cf3MnLlEg.ttf:tlg:300" => esc_html__( "Halant - 300", "tlg_framework"),"Halant:tlg://fonts.gstatic.com/s/halant/v1/rEs7Jk3SVyt3cTx6DoTu1w.ttf:tlg:regular" => esc_html__( "Halant - regular", "tlg_framework"),"Halant:tlg://fonts.gstatic.com/s/halant/v1/tlsNj3K-hJKtiirTDtUbkQ.ttf:tlg:500" => esc_html__( "Halant - 500", "tlg_framework"),"Halant:tlg://fonts.gstatic.com/s/halant/v1/zNR2WvI_V8o652vIZp3X4Q.ttf:tlg:600" => esc_html__( "Halant - 600", "tlg_framework"),"Halant:tlg://fonts.gstatic.com/s/halant/v1/D9FN7OH89AuCmZDLHbPQfA.ttf:tlg:700" => esc_html__( "Halant - 700", "tlg_framework"),"Hammersmith One:tlg://fonts.gstatic.com/s/hammersmithone/v7/FWNn6ITYqL6or7ZTmBxRhjjVlsJB_M_Q_LtZxsoxvlw.ttf:tlg:regular" => esc_html__( "Hammersmith One - regular", "tlg_framework"),"Hanalei:tlg://fonts.gstatic.com/s/hanalei/v6/Sx8vVMBnXSQyK6Cn0CBJ3A.ttf:tlg:regular" => esc_html__( "Hanalei - regular", "tlg_framework"),"Hanalei Fill:tlg://fonts.gstatic.com/s/hanaleifill/v5/5uPeWLnaDdtm4UBG26Ds6C3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Hanalei Fill - regular", "tlg_framework"),"Handlee:tlg://fonts.gstatic.com/s/handlee/v5/6OfkXkyC0E5NZN80ED8u3A.ttf:tlg:regular" => esc_html__( "Handlee - regular", "tlg_framework"),"Hanuman:tlg://fonts.gstatic.com/s/hanuman/v9/hRhwOGGmElJSl6KSPvEnOQ.ttf:tlg:regular" => esc_html__( "Hanuman - regular", "tlg_framework"),"Hanuman:tlg://fonts.gstatic.com/s/hanuman/v9/lzzXZ2l84x88giDrbfq76vesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Hanuman - 700", "tlg_framework"),"Happy Monkey:tlg://fonts.gstatic.com/s/happymonkey/v5/c2o0ps8nkBmaOYctqBq1rS3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Happy Monkey - regular", "tlg_framework"),"Headland One:tlg://fonts.gstatic.com/s/headlandone/v4/iGmBeOvQGfq9DSbjJ8jDVy3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Headland One - regular", "tlg_framework"),"Henny Penny:tlg://fonts.gstatic.com/s/hennypenny/v4/XRgo3ogXyi3tpsFfjImRF6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Henny Penny - regular", "tlg_framework"),"Herr Von Muellerhoff:tlg://fonts.gstatic.com/s/herrvonmuellerhoff/v6/mmy24EUmk4tjm4gAEjUd7NLGIYrUsBdh-JWHYgiDiMU.ttf:tlg:regular" => esc_html__( "Herr Von Muellerhoff - regular", "tlg_framework"),"Hind:tlg://fonts.gstatic.com/s/hind/v5/qa346Adgv9kPDXoD1my4kA.ttf:tlg:300" => esc_html__( "Hind - 300", "tlg_framework"),"Hind:tlg://fonts.gstatic.com/s/hind/v5/mktFHh5Z5P9YjGKSslSUtA.ttf:tlg:regular" => esc_html__( "Hind - regular", "tlg_framework"),"Hind:tlg://fonts.gstatic.com/s/hind/v5/2cs8RCVcYtiv4iNDH1UsQQ.ttf:tlg:500" => esc_html__( "Hind - 500", "tlg_framework"),"Hind:tlg://fonts.gstatic.com/s/hind/v5/TUKUmFMXSoxloBP1ni08oA.ttf:tlg:600" => esc_html__( "Hind - 600", "tlg_framework"),"Hind:tlg://fonts.gstatic.com/s/hind/v5/cXJJavLdUbCfjxlsA6DqTw.ttf:tlg:700" => esc_html__( "Hind - 700", "tlg_framework"),"Hind Siliguri:tlg://fonts.gstatic.com/s/hindsiliguri/v1/fBpmjMpv5Rh6S25yVfWJnzoJ52uD-1fmXmi8u0n_zsc.ttf:tlg:300" => esc_html__( "Hind Siliguri - 300", "tlg_framework"),"Hind Siliguri:tlg://fonts.gstatic.com/s/hindsiliguri/v1/f2eEi2pbIa8eBfNwpUl0Am_MnNA9OgK8I1F23mNWOpE.ttf:tlg:regular" => esc_html__( "Hind Siliguri - regular", "tlg_framework"),"Hind Siliguri:tlg://fonts.gstatic.com/s/hindsiliguri/v1/fBpmjMpv5Rh6S25yVfWJn__2zpxNHQ3utWt_82o9dAo.ttf:tlg:500" => esc_html__( "Hind Siliguri - 500", "tlg_framework"),"Hind Siliguri:tlg://fonts.gstatic.com/s/hindsiliguri/v1/fBpmjMpv5Rh6S25yVfWJn-x91FDzFvnud68bXrNkpDA.ttf:tlg:600" => esc_html__( "Hind Siliguri - 600", "tlg_framework"),"Hind Siliguri:tlg://fonts.gstatic.com/s/hindsiliguri/v1/fBpmjMpv5Rh6S25yVfWJn6iiXuG_rGcOxkuidirlnJE.ttf:tlg:700" => esc_html__( "Hind Siliguri - 700", "tlg_framework"),"Hind Vadodara:tlg://fonts.gstatic.com/s/hindvadodara/v1/KrZ6f_YevRawHvh0qDBkTbDwfZ__Dotj_J8NiWv76DQ.ttf:tlg:300" => esc_html__( "Hind Vadodara - 300", "tlg_framework"),"Hind Vadodara:tlg://fonts.gstatic.com/s/hindvadodara/v1/9c6KKeibr6NtFqknnNxZB-Dcg5akpSnIcsPhLOFv7l8.ttf:tlg:regular" => esc_html__( "Hind Vadodara - regular", "tlg_framework"),"Hind Vadodara:tlg://fonts.gstatic.com/s/hindvadodara/v1/KrZ6f_YevRawHvh0qDBkTZzEKvFIU9WyojfbAkhDb6c.ttf:tlg:500" => esc_html__( "Hind Vadodara - 500", "tlg_framework"),"Hind Vadodara:tlg://fonts.gstatic.com/s/hindvadodara/v1/KrZ6f_YevRawHvh0qDBkTfgXs2VXrZsRiQ1c96pXZKI.ttf:tlg:600" => esc_html__( "Hind Vadodara - 600", "tlg_framework"),"Hind Vadodara:tlg://fonts.gstatic.com/s/hindvadodara/v1/KrZ6f_YevRawHvh0qDBkTYGjoH95IEFGA7BjhXnx_eg.ttf:tlg:700" => esc_html__( "Hind Vadodara - 700", "tlg_framework"),"Holtwood One SC:tlg://fonts.gstatic.com/s/holtwoodonesc/v7/sToOq3cIxbfnhbEkgYNuBbAgSRh1LpJXlLfl8IbsmHg.ttf:tlg:regular" => esc_html__( "Holtwood One SC - regular", "tlg_framework"),"Homemade Apple:tlg://fonts.gstatic.com/s/homemadeapple/v6/yg3UMEsefgZ8IHz_ryz86BiPOmFWYV1WlrJkRafc4c0.ttf:tlg:regular" => esc_html__( "Homemade Apple - regular", "tlg_framework"),"Homenaje:tlg://fonts.gstatic.com/s/homenaje/v5/v0YBU0iBRrGdVjDNQILxtA.ttf:tlg:regular" => esc_html__( "Homenaje - regular", "tlg_framework"),"IM Fell DW Pica:tlg://fonts.gstatic.com/s/imfelldwpica/v6/W81bfaWiUicLSPbJhW-ATsA5qm663gJGVdtpamafG5A.ttf:tlg:regular" => esc_html__( "IM Fell DW Pica - regular", "tlg_framework"),"IM Fell DW Pica:tlg://fonts.gstatic.com/s/imfelldwpica/v6/alQJ8SK5aSOZVaelYoyT4PL2asmh5DlYQYCosKo6yQs.ttf:tlg:italic" => esc_html__( "IM Fell DW Pica - italic", "tlg_framework"),"IM Fell DW Pica SC:tlg://fonts.gstatic.com/s/imfelldwpicasc/v6/xBKKJV4z2KsrtQnmjGO17JZ9RBdEL0H9o5qzT1Rtof4.ttf:tlg:regular" => esc_html__( "IM Fell DW Pica SC - regular", "tlg_framework"),"IM Fell Double Pica:tlg://fonts.gstatic.com/s/imfelldoublepica/v6/yN1wY_01BkQnO0LYAhXdUol14jEdVOhEmvtCMCVwYak.ttf:tlg:regular" => esc_html__( "IM Fell Double Pica - regular", "tlg_framework"),"IM Fell Double Pica:tlg://fonts.gstatic.com/s/imfelldoublepica/v6/64odUh2hAw8D9dkFKTlWYq0AWwkgdQfsRHec8TYi4mI.ttf:tlg:italic" => esc_html__( "IM Fell Double Pica - italic", "tlg_framework"),"IM Fell Double Pica SC:tlg://fonts.gstatic.com/s/imfelldoublepicasc/v6/jkrUtrLFpMw4ZazhfkKsGwc4LoC4OJUqLw9omnT3VOU.ttf:tlg:regular" => esc_html__( "IM Fell Double Pica SC - regular", "tlg_framework"),"IM Fell English:tlg://fonts.gstatic.com/s/imfellenglish/v6/xwIisCqGFi8pff-oa9uSVHGNmx1fDm-u2eBJHQkdrmk.ttf:tlg:regular" => esc_html__( "IM Fell English - regular", "tlg_framework"),"IM Fell English:tlg://fonts.gstatic.com/s/imfellenglish/v6/Z3cnIAI_L3XTRfz4JuZKbuewladMPCWTthtMv9cPS-c.ttf:tlg:italic" => esc_html__( "IM Fell English - italic", "tlg_framework"),"IM Fell English SC:tlg://fonts.gstatic.com/s/imfellenglishsc/v6/h3Tn6yWfw4b5qaLD1RWvz5ATixNthKRRR1XVH3rJNiw.ttf:tlg:regular" => esc_html__( "IM Fell English SC - regular", "tlg_framework"),"IM Fell French Canon:tlg://fonts.gstatic.com/s/imfellfrenchcanon/v6/iKB0WL1BagSpNPz3NLMdsJ3V2FNpBrlLSvqUnERhBP8.ttf:tlg:regular" => esc_html__( "IM Fell French Canon - regular", "tlg_framework"),"IM Fell French Canon:tlg://fonts.gstatic.com/s/imfellfrenchcanon/v6/owCuNQkLLFW7TBBPJbMnhRa-QL94KdW80H29tcyld2A.ttf:tlg:italic" => esc_html__( "IM Fell French Canon - italic", "tlg_framework"),"IM Fell French Canon SC:tlg://fonts.gstatic.com/s/imfellfrenchcanonsc/v6/kA3bS19-tQbeT_iG32EZmaiyyzHwYrAbmNulTz423iM.ttf:tlg:regular" => esc_html__( "IM Fell French Canon SC - regular", "tlg_framework"),"IM Fell Great Primer:tlg://fonts.gstatic.com/s/imfellgreatprimer/v6/AL8ALGNthei20f9Cu3e93rgeX3ROgtTz44CitKAxzKI.ttf:tlg:regular" => esc_html__( "IM Fell Great Primer - regular", "tlg_framework"),"IM Fell Great Primer:tlg://fonts.gstatic.com/s/imfellgreatprimer/v6/1a-artkXMVg682r7TTxVY1_YG2SFv8Ma7CxRl1S3o7g.ttf:tlg:italic" => esc_html__( "IM Fell Great Primer - italic", "tlg_framework"),"IM Fell Great Primer SC:tlg://fonts.gstatic.com/s/imfellgreatprimersc/v6/A313vRj97hMMGFjt6rgSJtRg-ciw1Y27JeXb2Zv4lZQ.ttf:tlg:regular" => esc_html__( "IM Fell Great Primer SC - regular", "tlg_framework"),"Iceberg:tlg://fonts.gstatic.com/s/iceberg/v4/p2XVm4M-N0AOEEOymFKC5w.ttf:tlg:regular" => esc_html__( "Iceberg - regular", "tlg_framework"),"Iceland:tlg://fonts.gstatic.com/s/iceland/v5/kq3uTMGgvzWGNi39B_WxGA.ttf:tlg:regular" => esc_html__( "Iceland - regular", "tlg_framework"),"Imprima:tlg://fonts.gstatic.com/s/imprima/v4/eRjquWLjwLGnTEhLH7u3kA.ttf:tlg:regular" => esc_html__( "Imprima - regular", "tlg_framework"),"Inconsolata:tlg://fonts.gstatic.com/s/inconsolata/v12/7bMKuoy6Nh0ft0SHnIGMuaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Inconsolata - regular", "tlg_framework"),"Inconsolata:tlg://fonts.gstatic.com/s/inconsolata/v12/AIed271kqQlcIRSOnQH0yXe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Inconsolata - 700", "tlg_framework"),"Inder:tlg://fonts.gstatic.com/s/inder/v5/C38TwecLTfKxIHDc_Adcrw.ttf:tlg:regular" => esc_html__( "Inder - regular", "tlg_framework"),"Indie Flower:tlg://fonts.gstatic.com/s/indieflower/v8/10JVD_humAd5zP2yrFqw6i3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Indie Flower - regular", "tlg_framework"),"Inika:tlg://fonts.gstatic.com/s/inika/v4/eZCrULQGaIxkrRoGz_DjhQ.ttf:tlg:regular" => esc_html__( "Inika - regular", "tlg_framework"),"Inika:tlg://fonts.gstatic.com/s/inika/v4/bl3ZoTyrWsFun2zYbsgJrA.ttf:tlg:700" => esc_html__( "Inika - 700", "tlg_framework"),"Inknut Antiqua:tlg://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVIg6hmPNSXwHGnJQCeQHKUMo.ttf:tlg:300" => esc_html__( "Inknut Antiqua - 300", "tlg_framework"),"Inknut Antiqua:tlg://fonts.gstatic.com/s/inknutantiqua/v1/VlmmTfOrxr3HfcnhMueX9arFJ4O13IHVxZbM6yoslpo.ttf:tlg:regular" => esc_html__( "Inknut Antiqua - regular", "tlg_framework"),"Inknut Antiqua:tlg://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVIiYCDvi1XFzRnTV7qUFsNgk.ttf:tlg:500" => esc_html__( "Inknut Antiqua - 500", "tlg_framework"),"Inknut Antiqua:tlg://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVIjLEgY6PI0GrY6L00mykcEQ.ttf:tlg:600" => esc_html__( "Inknut Antiqua - 600", "tlg_framework"),"Inknut Antiqua:tlg://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVIlRhfXn9P4_QueZ7VkUHUNc.ttf:tlg:700" => esc_html__( "Inknut Antiqua - 700", "tlg_framework"),"Inknut Antiqua:tlg://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVInARjXVu2t2krcNTHiCb1qY.ttf:tlg:800" => esc_html__( "Inknut Antiqua - 800", "tlg_framework"),"Inknut Antiqua:tlg://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVIrTsNy1JrFNT1qKy8j7W3CU.ttf:tlg:900" => esc_html__( "Inknut Antiqua - 900", "tlg_framework"),"Irish Grover:tlg://fonts.gstatic.com/s/irishgrover/v6/kUp7uUPooL-KsLGzeVJbBC3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Irish Grover - regular", "tlg_framework"),"Istok Web:tlg://fonts.gstatic.com/s/istokweb/v10/RYLSjEXQ0nNtLLc4n7--dQ.ttf:tlg:regular" => esc_html__( "Istok Web - regular", "tlg_framework"),"Istok Web:tlg://fonts.gstatic.com/s/istokweb/v10/kvcT2SlTjmGbC3YlZxmrl6CWcynf_cDxXwCLxiixG1c.ttf:tlg:italic" => esc_html__( "Istok Web - italic", "tlg_framework"),"Istok Web:tlg://fonts.gstatic.com/s/istokweb/v10/2koEo4AKFSvK4B52O_Mwai3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Istok Web - 700", "tlg_framework"),"Istok Web:tlg://fonts.gstatic.com/s/istokweb/v10/ycQ3g52ELrh3o_HYCNNUw3e1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700italic" => esc_html__( "Istok Web - 700italic", "tlg_framework"),"Italiana:tlg://fonts.gstatic.com/s/italiana/v4/dt95fkCSTOF-c6QNjwSycA.ttf:tlg:regular" => esc_html__( "Italiana - regular", "tlg_framework"),"Italianno:tlg://fonts.gstatic.com/s/italianno/v6/HsyHnLpKf8uP7aMpDQHZmg.ttf:tlg:regular" => esc_html__( "Italianno - regular", "tlg_framework"),"Itim:tlg://fonts.gstatic.com/s/itim/v1/HHV9WK2x5lUkc5bxMXG8Tw.ttf:tlg:regular" => esc_html__( "Itim - regular", "tlg_framework"),"Jacques Francois:tlg://fonts.gstatic.com/s/jacquesfrancois/v4/_-0XWPQIW6tOzTHg4KaJ_M13D_4KM32Q4UmTSjpuNGQ.ttf:tlg:regular" => esc_html__( "Jacques Francois - regular", "tlg_framework"),"Jacques Francois Shadow:tlg://fonts.gstatic.com/s/jacquesfrancoisshadow/v4/V14y0H3vq56fY9SV4OL_FASt0D_oLVawA8L8b9iKjbs.ttf:tlg:regular" => esc_html__( "Jacques Francois Shadow - regular", "tlg_framework"),"Jaldi:tlg://fonts.gstatic.com/s/jaldi/v2/x1vR-bPW9a1EB-BUVqttCw.ttf:tlg:regular" => esc_html__( "Jaldi - regular", "tlg_framework"),"Jaldi:tlg://fonts.gstatic.com/s/jaldi/v2/OIbtgjjEp3aVWtjF6WY8mA.ttf:tlg:700" => esc_html__( "Jaldi - 700", "tlg_framework"),"Jim Nightshade:tlg://fonts.gstatic.com/s/jimnightshade/v4/_n43lYHXVWNgXegdYRIK9CF1W_bo0EdycfH0kHciIic.ttf:tlg:regular" => esc_html__( "Jim Nightshade - regular", "tlg_framework"),"Jockey One:tlg://fonts.gstatic.com/s/jockeyone/v6/cAucnOZLvFo07w2AbufBCfesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Jockey One - regular", "tlg_framework"),"Jolly Lodger:tlg://fonts.gstatic.com/s/jollylodger/v4/RX8HnkBgaEKQSHQyP9itiS3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Jolly Lodger - regular", "tlg_framework"),"Josefin Sans:tlg://fonts.gstatic.com/s/josefinsans/v9/q9w3H4aeBxj0hZ8Osfi3d8SVQ0giZ-l_NELu3lgGyYw.ttf:tlg:100" => esc_html__( "Josefin Sans - 100", "tlg_framework"),"Josefin Sans:tlg://fonts.gstatic.com/s/josefinsans/v9/s7-P1gqRNRNn-YWdOYnAOXXcj1rQwlNLIS625o-SrL0.ttf:tlg:100italic" => esc_html__( "Josefin Sans - 100italic", "tlg_framework"),"Josefin Sans:tlg://fonts.gstatic.com/s/josefinsans/v9/C6HYlRF50SGJq1XyXj04z6cQoVhARpoaILP7amxE_8g.ttf:tlg:300" => esc_html__( "Josefin Sans - 300", "tlg_framework"),"Josefin Sans:tlg://fonts.gstatic.com/s/josefinsans/v9/ppse0J9fKSaoxCIIJb33Gyna0FLWfcB-J_SAYmcAXaI.ttf:tlg:300italic" => esc_html__( "Josefin Sans - 300italic", "tlg_framework"),"Josefin Sans:tlg://fonts.gstatic.com/s/josefinsans/v9/xgzbb53t8j-Mo-vYa23n5i3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Josefin Sans - regular", "tlg_framework"),"Josefin Sans:tlg://fonts.gstatic.com/s/josefinsans/v9/q9w3H4aeBxj0hZ8Osfi3d_MZXuCXbOrAvx5R0IT5Oyo.ttf:tlg:italic" => esc_html__( "Josefin Sans - italic", "tlg_framework"),"Josefin Sans:tlg://fonts.gstatic.com/s/josefinsans/v9/C6HYlRF50SGJq1XyXj04z2v8CylhIUtwUiYO7Z2wXbE.ttf:tlg:600" => esc_html__( "Josefin Sans - 600", "tlg_framework"),"Josefin Sans:tlg://fonts.gstatic.com/s/josefinsans/v9/ppse0J9fKSaoxCIIJb33G4R-5-urNOGAobhAyctHvW8.ttf:tlg:600italic" => esc_html__( "Josefin Sans - 600italic", "tlg_framework"),"Josefin Sans:tlg://fonts.gstatic.com/s/josefinsans/v9/C6HYlRF50SGJq1XyXj04z0D2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Josefin Sans - 700", "tlg_framework"),"Josefin Sans:tlg://fonts.gstatic.com/s/josefinsans/v9/ppse0J9fKSaoxCIIJb33G_As9-1nE9qOqhChW0m4nDE.ttf:tlg:700italic" => esc_html__( "Josefin Sans - 700italic", "tlg_framework"),"Josefin Slab:tlg://fonts.gstatic.com/s/josefinslab/v6/etsUjZYO8lTLU85lDhZwUsSVQ0giZ-l_NELu3lgGyYw.ttf:tlg:100" => esc_html__( "Josefin Slab - 100", "tlg_framework"),"Josefin Slab:tlg://fonts.gstatic.com/s/josefinslab/v6/8BjDChqLgBF3RJKfwHIYh3Xcj1rQwlNLIS625o-SrL0.ttf:tlg:100italic" => esc_html__( "Josefin Slab - 100italic", "tlg_framework"),"Josefin Slab:tlg://fonts.gstatic.com/s/josefinslab/v6/NbE6ykYuM2IyEwxQxOIi2KcQoVhARpoaILP7amxE_8g.ttf:tlg:300" => esc_html__( "Josefin Slab - 300", "tlg_framework"),"Josefin Slab:tlg://fonts.gstatic.com/s/josefinslab/v6/af9sBoKGPbGO0r21xJulyyna0FLWfcB-J_SAYmcAXaI.ttf:tlg:300italic" => esc_html__( "Josefin Slab - 300italic", "tlg_framework"),"Josefin Slab:tlg://fonts.gstatic.com/s/josefinslab/v6/46aYWdgz-1oFX11flmyEfS3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Josefin Slab - regular", "tlg_framework"),"Josefin Slab:tlg://fonts.gstatic.com/s/josefinslab/v6/etsUjZYO8lTLU85lDhZwUvMZXuCXbOrAvx5R0IT5Oyo.ttf:tlg:italic" => esc_html__( "Josefin Slab - italic", "tlg_framework"),"Josefin Slab:tlg://fonts.gstatic.com/s/josefinslab/v6/NbE6ykYuM2IyEwxQxOIi2Gv8CylhIUtwUiYO7Z2wXbE.ttf:tlg:600" => esc_html__( "Josefin Slab - 600", "tlg_framework"),"Josefin Slab:tlg://fonts.gstatic.com/s/josefinslab/v6/af9sBoKGPbGO0r21xJuly4R-5-urNOGAobhAyctHvW8.ttf:tlg:600italic" => esc_html__( "Josefin Slab - 600italic", "tlg_framework"),"Josefin Slab:tlg://fonts.gstatic.com/s/josefinslab/v6/NbE6ykYuM2IyEwxQxOIi2ED2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Josefin Slab - 700", "tlg_framework"),"Josefin Slab:tlg://fonts.gstatic.com/s/josefinslab/v6/af9sBoKGPbGO0r21xJuly_As9-1nE9qOqhChW0m4nDE.ttf:tlg:700italic" => esc_html__( "Josefin Slab - 700italic", "tlg_framework"),"Joti One:tlg://fonts.gstatic.com/s/jotione/v4/P3r_Th0ESHJdzunsvWgUfQ.ttf:tlg:regular" => esc_html__( "Joti One - regular", "tlg_framework"),"Judson:tlg://fonts.gstatic.com/s/judson/v9/znM1AAs0eytUaJzf1CrYZQ.ttf:tlg:regular" => esc_html__( "Judson - regular", "tlg_framework"),"Judson:tlg://fonts.gstatic.com/s/judson/v9/GVqQW9P52ygW-ySq-CLwAA.ttf:tlg:italic" => esc_html__( "Judson - italic", "tlg_framework"),"Judson:tlg://fonts.gstatic.com/s/judson/v9/he4a2LwiPJc7r8x0oKCKiA.ttf:tlg:700" => esc_html__( "Judson - 700", "tlg_framework"),"Julee:tlg://fonts.gstatic.com/s/julee/v6/CAib-jsUsSO8SvVRnE9fHA.ttf:tlg:regular" => esc_html__( "Julee - regular", "tlg_framework"),"Julius Sans One:tlg://fonts.gstatic.com/s/juliussansone/v5/iU65JP9acQHPDLkdalCF7jjVlsJB_M_Q_LtZxsoxvlw.ttf:tlg:regular" => esc_html__( "Julius Sans One - regular", "tlg_framework"),"Junge:tlg://fonts.gstatic.com/s/junge/v4/j4IXCXtxrw9qIBheercp3A.ttf:tlg:regular" => esc_html__( "Junge - regular", "tlg_framework"),"Jura:tlg://fonts.gstatic.com/s/jura/v7/Rqx_xy1UnN0C7wD3FUSyPQ.ttf:tlg:300" => esc_html__( "Jura - 300", "tlg_framework"),"Jura:tlg://fonts.gstatic.com/s/jura/v7/YAWMwF3sN0KCbynMq-Yr_Q.ttf:tlg:regular" => esc_html__( "Jura - regular", "tlg_framework"),"Jura:tlg://fonts.gstatic.com/s/jura/v7/16xhfjHCiaLj3tsqqgmtGg.ttf:tlg:500" => esc_html__( "Jura - 500", "tlg_framework"),"Jura:tlg://fonts.gstatic.com/s/jura/v7/iwseduOwJSdY8wQ1Y6CJdA.ttf:tlg:600" => esc_html__( "Jura - 600", "tlg_framework"),"Just Another Hand:tlg://fonts.gstatic.com/s/justanotherhand/v7/fKV8XYuRNNagXr38eqbRf99BnJIEGrvoojniP57E51c.ttf:tlg:regular" => esc_html__( "Just Another Hand - regular", "tlg_framework"),"Just Me Again Down Here:tlg://fonts.gstatic.com/s/justmeagaindownhere/v8/sN06iTc9ITubLTgXoG-kc3M9eVLpVTSK6TqZTIgBrWQ.ttf:tlg:regular" => esc_html__( "Just Me Again Down Here - regular", "tlg_framework"),"Kadwa:tlg://fonts.gstatic.com/s/kadwa/v1/VwEN8oKGqaa0ug9kRpvSSg.ttf:tlg:regular" => esc_html__( "Kadwa - regular", "tlg_framework"),"Kadwa:tlg://fonts.gstatic.com/s/kadwa/v1/NFPZaBfekj_Io-7vUMz4Ww.ttf:tlg:700" => esc_html__( "Kadwa - 700", "tlg_framework"),"Kalam:tlg://fonts.gstatic.com/s/kalam/v7/MgQQlk1SgPEHdlkWMNh7Jg.ttf:tlg:300" => esc_html__( "Kalam - 300", "tlg_framework"),"Kalam:tlg://fonts.gstatic.com/s/kalam/v7/hNEJkp2K-aql7e5WQish4Q.ttf:tlg:regular" => esc_html__( "Kalam - regular", "tlg_framework"),"Kalam:tlg://fonts.gstatic.com/s/kalam/v7/95nLItUGyWtNLZjSckluLQ.ttf:tlg:700" => esc_html__( "Kalam - 700", "tlg_framework"),"Kameron:tlg://fonts.gstatic.com/s/kameron/v7/9r8HYhqDSwcq9WMjupL82A.ttf:tlg:regular" => esc_html__( "Kameron - regular", "tlg_framework"),"Kameron:tlg://fonts.gstatic.com/s/kameron/v7/rabVVbzlflqvmXJUFlKnu_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Kameron - 700", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/CYl4qOK-NWwZp3iTKW1eIA.ttf:tlg:100" => esc_html__( "Kanit - 100", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/NLNtc56MpXmHl1yOrop8oQ.ttf:tlg:100italic" => esc_html__( "Kanit - 100italic", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/wfLWkj1C4tYl7MoiFWS3bA.ttf:tlg:200" => esc_html__( "Kanit - 200", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/D8gkrAAM2bvNJ-1i4ot-1_esZW2xOQ-xsNqO47m55DA.ttf:tlg:200italic" => esc_html__( "Kanit - 200italic", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/SM5qHynYGdOmMKEwGUFIPA.ttf:tlg:300" => esc_html__( "Kanit - 300", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/IePislKOKy3Bqfpb9V5VM_esZW2xOQ-xsNqO47m55DA.ttf:tlg:300italic" => esc_html__( "Kanit - 300italic", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/L6VKvM17ZmevDynOiw7H9w.ttf:tlg:regular" => esc_html__( "Kanit - regular", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/sHLq5U0-T0oSMTnwTKgv-A.ttf:tlg:italic" => esc_html__( "Kanit - italic", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/GxoU_USIJyIy8WIcYSUO2g.ttf:tlg:500" => esc_html__( "Kanit - 500", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/hrCiWCaNv9AaF0mDY1F2zPesZW2xOQ-xsNqO47m55DA.ttf:tlg:500italic" => esc_html__( "Kanit - 500italic", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/n_qoIVxojeQY0D1pvoNDhA.ttf:tlg:600" => esc_html__( "Kanit - 600", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/9BkP85yRDoVayTWQwdGLqPesZW2xOQ-xsNqO47m55DA.ttf:tlg:600italic" => esc_html__( "Kanit - 600italic", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/kEGmYvO8My36j5ILmbUPRg.ttf:tlg:700" => esc_html__( "Kanit - 700", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/WNo3ZZ9xtOZJknNlvHAFWfesZW2xOQ-xsNqO47m55DA.ttf:tlg:700italic" => esc_html__( "Kanit - 700italic", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/YTp-zAuKXxwnA1YnJIF1rg.ttf:tlg:800" => esc_html__( "Kanit - 800", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/qiTGrW5sCa9UQp841fWjc_esZW2xOQ-xsNqO47m55DA.ttf:tlg:800italic" => esc_html__( "Kanit - 800italic", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/1NIEkusi3bG3GgO9Hor3fQ.ttf:tlg:900" => esc_html__( "Kanit - 900", "tlg_framework"),"Kanit:tlg://fonts.gstatic.com/s/kanit/v1/ogN5dFD1r4BfxNV4Nb-TXfesZW2xOQ-xsNqO47m55DA.ttf:tlg:900italic" => esc_html__( "Kanit - 900italic", "tlg_framework"),"Kantumruy:tlg://fonts.gstatic.com/s/kantumruy/v3/ERRwQE0WG5uanaZWmOFXNi3USBnSvpkopQaUR-2r7iU.ttf:tlg:300" => esc_html__( "Kantumruy - 300", "tlg_framework"),"Kantumruy:tlg://fonts.gstatic.com/s/kantumruy/v3/kQfXNYElQxr5dS8FyjD39Q.ttf:tlg:regular" => esc_html__( "Kantumruy - regular", "tlg_framework"),"Kantumruy:tlg://fonts.gstatic.com/s/kantumruy/v3/gie_zErpGf_rNzs920C2Ji3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Kantumruy - 700", "tlg_framework"),"Karla:tlg://fonts.gstatic.com/s/karla/v5/78UgGRwJFkhqaoFimqoKpQ.ttf:tlg:regular" => esc_html__( "Karla - regular", "tlg_framework"),"Karla:tlg://fonts.gstatic.com/s/karla/v5/51UBKly9RQOnOkj95ZwEFw.ttf:tlg:italic" => esc_html__( "Karla - italic", "tlg_framework"),"Karla:tlg://fonts.gstatic.com/s/karla/v5/JS501sZLxZ4zraLQdncOUA.ttf:tlg:700" => esc_html__( "Karla - 700", "tlg_framework"),"Karla:tlg://fonts.gstatic.com/s/karla/v5/3YDyi09gQjCRh-5-SVhTTvesZW2xOQ-xsNqO47m55DA.ttf:tlg:700italic" => esc_html__( "Karla - 700italic", "tlg_framework"),"Karma:tlg://fonts.gstatic.com/s/karma/v5/lH6ijJnguWR2Sz7tEl6MQQ.ttf:tlg:300" => esc_html__( "Karma - 300", "tlg_framework"),"Karma:tlg://fonts.gstatic.com/s/karma/v5/wvqTxAGBUrTqU0urTEoPIw.ttf:tlg:regular" => esc_html__( "Karma - regular", "tlg_framework"),"Karma:tlg://fonts.gstatic.com/s/karma/v5/9YGjxi6Hcvz2Kh-rzO_cAw.ttf:tlg:500" => esc_html__( "Karma - 500", "tlg_framework"),"Karma:tlg://fonts.gstatic.com/s/karma/v5/h_CVzXXtqSxjfS2sIwaejA.ttf:tlg:600" => esc_html__( "Karma - 600", "tlg_framework"),"Karma:tlg://fonts.gstatic.com/s/karma/v5/smuSM08oApsQPPVYbHd1CA.ttf:tlg:700" => esc_html__( "Karma - 700", "tlg_framework"),"Kaushan Script:tlg://fonts.gstatic.com/s/kaushanscript/v4/qx1LSqts-NtiKcLw4N03IBnpV0hQCek3EmWnCPrvGRM.ttf:tlg:regular" => esc_html__( "Kaushan Script - regular", "tlg_framework"),"Kavoon:tlg://fonts.gstatic.com/s/kavoon/v5/382m-6baKXqJFQjEgobt6Q.ttf:tlg:regular" => esc_html__( "Kavoon - regular", "tlg_framework"),"Kdam Thmor:tlg://fonts.gstatic.com/s/kdamthmor/v3/otCdP6UU-VBIrBfVDWBQJ_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Kdam Thmor - regular", "tlg_framework"),"Keania One:tlg://fonts.gstatic.com/s/keaniaone/v4/PACrDKZWngXzgo-ucl6buvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Keania One - regular", "tlg_framework"),"Kelly Slab:tlg://fonts.gstatic.com/s/kellyslab/v6/F_2oS1e9XdYx1MAi8XEVefesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Kelly Slab - regular", "tlg_framework"),"Kenia:tlg://fonts.gstatic.com/s/kenia/v8/OLM9-XfITK9PsTLKbGBrwg.ttf:tlg:regular" => esc_html__( "Kenia - regular", "tlg_framework"),"Khand:tlg://fonts.gstatic.com/s/khand/v4/072zRl4OU9Pinjjkg174LA.ttf:tlg:300" => esc_html__( "Khand - 300", "tlg_framework"),"Khand:tlg://fonts.gstatic.com/s/khand/v4/HdLdTNFqNIDGJZl1ZEj84w.ttf:tlg:regular" => esc_html__( "Khand - regular", "tlg_framework"),"Khand:tlg://fonts.gstatic.com/s/khand/v4/46_p-SqtuMe56nxQdteWxg.ttf:tlg:500" => esc_html__( "Khand - 500", "tlg_framework"),"Khand:tlg://fonts.gstatic.com/s/khand/v4/zggGWYIiPJyMTgkfxP_kaA.ttf:tlg:600" => esc_html__( "Khand - 600", "tlg_framework"),"Khand:tlg://fonts.gstatic.com/s/khand/v4/0I0UWaN-X5QBmfexpXKhqg.ttf:tlg:700" => esc_html__( "Khand - 700", "tlg_framework"),"Khmer:tlg://fonts.gstatic.com/s/khmer/v9/vWaBJIbaQuBNz02ALIKJ3A.ttf:tlg:regular" => esc_html__( "Khmer - regular", "tlg_framework"),"Khula:tlg://fonts.gstatic.com/s/khula/v1/_1LySU5Upq-sc4OZ1b_GIw.ttf:tlg:300" => esc_html__( "Khula - 300", "tlg_framework"),"Khula:tlg://fonts.gstatic.com/s/khula/v1/izcPIFyCSd16XI1Ak_Wk7Q.ttf:tlg:regular" => esc_html__( "Khula - regular", "tlg_framework"),"Khula:tlg://fonts.gstatic.com/s/khula/v1/4ZH86Hce-aeFDaedTnbkbg.ttf:tlg:600" => esc_html__( "Khula - 600", "tlg_framework"),"Khula:tlg://fonts.gstatic.com/s/khula/v1/UGVExGl-Jjs-YPpGv-MZ6w.ttf:tlg:700" => esc_html__( "Khula - 700", "tlg_framework"),"Khula:tlg://fonts.gstatic.com/s/khula/v1/Sccp_oOo8FWgbx5smie7xQ.ttf:tlg:800" => esc_html__( "Khula - 800", "tlg_framework"),"Kite One:tlg://fonts.gstatic.com/s/kiteone/v4/8ojWmgUc97m0f_i6sTqLoQ.ttf:tlg:regular" => esc_html__( "Kite One - regular", "tlg_framework"),"Knewave:tlg://fonts.gstatic.com/s/knewave/v5/KGHM4XWr4iKnBMqzZLkPBg.ttf:tlg:regular" => esc_html__( "Knewave - regular", "tlg_framework"),"Kotta One:tlg://fonts.gstatic.com/s/kottaone/v4/AB2Q7hVw6niJYDgLvFXu5w.ttf:tlg:regular" => esc_html__( "Kotta One - regular", "tlg_framework"),"Koulen:tlg://fonts.gstatic.com/s/koulen/v10/AAYOK8RSRO7FTskTzFuzNw.ttf:tlg:regular" => esc_html__( "Koulen - regular", "tlg_framework"),"Kranky:tlg://fonts.gstatic.com/s/kranky/v6/C8dxxTS99-fZ84vWk8SDrg.ttf:tlg:regular" => esc_html__( "Kranky - regular", "tlg_framework"),"Kreon:tlg://fonts.gstatic.com/s/kreon/v9/HKtJRiq5C2zbq5N1IX32sA.ttf:tlg:300" => esc_html__( "Kreon - 300", "tlg_framework"),"Kreon:tlg://fonts.gstatic.com/s/kreon/v9/zA_IZt0u0S3cvHJu-n1oEg.ttf:tlg:regular" => esc_html__( "Kreon - regular", "tlg_framework"),"Kreon:tlg://fonts.gstatic.com/s/kreon/v9/jh0dSmaPodjxISiblIUTkw.ttf:tlg:700" => esc_html__( "Kreon - 700", "tlg_framework"),"Kristi:tlg://fonts.gstatic.com/s/kristi/v7/aRsgBQrkQkMlu4UPSnJyOQ.ttf:tlg:regular" => esc_html__( "Kristi - regular", "tlg_framework"),"Krona One:tlg://fonts.gstatic.com/s/kronaone/v4/zcQj4ljqTo166AdourlF9w.ttf:tlg:regular" => esc_html__( "Krona One - regular", "tlg_framework"),"Kurale:tlg://fonts.gstatic.com/s/kurale/v1/rxeyIcvQlT4XAWwNbXFCfw.ttf:tlg:regular" => esc_html__( "Kurale - regular", "tlg_framework"),"La Belle Aurore:tlg://fonts.gstatic.com/s/labelleaurore/v7/Irdbc4ASuUoWDjd_Wc3md123K2iuuhwZgaKapkyRTY8.ttf:tlg:regular" => esc_html__( "La Belle Aurore - regular", "tlg_framework"),"Laila:tlg://fonts.gstatic.com/s/laila/v1/bLbIVEZF3IWSZ-in72GJvA.ttf:tlg:300" => esc_html__( "Laila - 300", "tlg_framework"),"Laila:tlg://fonts.gstatic.com/s/laila/v1/6iYor3edprH7360qtBGoag.ttf:tlg:regular" => esc_html__( "Laila - regular", "tlg_framework"),"Laila:tlg://fonts.gstatic.com/s/laila/v1/tkf8VtFvW9g3VsxQCA6WOQ.ttf:tlg:500" => esc_html__( "Laila - 500", "tlg_framework"),"Laila:tlg://fonts.gstatic.com/s/laila/v1/3EMP2L6JRQ4GaHIxCldCeA.ttf:tlg:600" => esc_html__( "Laila - 600", "tlg_framework"),"Laila:tlg://fonts.gstatic.com/s/laila/v1/R7P4z1xjcjecmjZ9GyhqHQ.ttf:tlg:700" => esc_html__( "Laila - 700", "tlg_framework"),"Lakki Reddy:tlg://fonts.gstatic.com/s/lakkireddy/v3/Q5EpFa91FjW37t0FCnedaKCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Lakki Reddy - regular", "tlg_framework"),"Lancelot:tlg://fonts.gstatic.com/s/lancelot/v6/XMT7T_oo_MQUGAnU2v-sdA.ttf:tlg:regular" => esc_html__( "Lancelot - regular", "tlg_framework"),"Lateef:tlg://fonts.gstatic.com/s/lateef/v10/PAsKCgi1qc7XPwvzo_I-DQ.ttf:tlg:regular" => esc_html__( "Lateef - regular", "tlg_framework"),"Lato:tlg://fonts.gstatic.com/s/lato/v11/Upp-ka9rLQmHYCsFgwL-eg.ttf:tlg:100" => esc_html__( "Lato - 100", "tlg_framework"),"Lato:tlg://fonts.gstatic.com/s/lato/v11/zLegi10uS_9-fnUDISl0KA.ttf:tlg:100italic" => esc_html__( "Lato - 100italic", "tlg_framework"),"Lato:tlg://fonts.gstatic.com/s/lato/v11/Ja02qOppOVq9jeRjWekbHg.ttf:tlg:300" => esc_html__( "Lato - 300", "tlg_framework"),"Lato:tlg://fonts.gstatic.com/s/lato/v11/dVebFcn7EV7wAKwgYestUg.ttf:tlg:300italic" => esc_html__( "Lato - 300italic", "tlg_framework"),"Lato:tlg://fonts.gstatic.com/s/lato/v11/h7rISIcQapZBpei-sXwIwg.ttf:tlg:regular" => esc_html__( "Lato - regular", "tlg_framework"),"Lato:tlg://fonts.gstatic.com/s/lato/v11/P_dJOFJylV3A870UIOtr0w.ttf:tlg:italic" => esc_html__( "Lato - italic", "tlg_framework"),"Lato:tlg://fonts.gstatic.com/s/lato/v11/iX_QxBBZLhNj5JHlTzHQzg.ttf:tlg:700" => esc_html__( "Lato - 700", "tlg_framework"),"Lato:tlg://fonts.gstatic.com/s/lato/v11/WFcZakHrrCKeUJxHA4T_gw.ttf:tlg:700italic" => esc_html__( "Lato - 700italic", "tlg_framework"),"Lato:tlg://fonts.gstatic.com/s/lato/v11/8TPEV6NbYWZlNsXjbYVv7w.ttf:tlg:900" => esc_html__( "Lato - 900", "tlg_framework"),"Lato:tlg://fonts.gstatic.com/s/lato/v11/draWperrI7n2xi35Cl08fA.ttf:tlg:900italic" => esc_html__( "Lato - 900italic", "tlg_framework"),"League Script:tlg://fonts.gstatic.com/s/leaguescript/v7/wnRFLvfabWK_DauqppD6vSeUSrabuTpOsMEiRLtKwk0.ttf:tlg:regular" => esc_html__( "League Script - regular", "tlg_framework"),"Leckerli One:tlg://fonts.gstatic.com/s/leckerlione/v7/S2Y_iLrItTu8kIJTkS7DrC3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Leckerli One - regular", "tlg_framework"),"Ledger:tlg://fonts.gstatic.com/s/ledger/v4/G432jp-tahOfWHbCYkI0jw.ttf:tlg:regular" => esc_html__( "Ledger - regular", "tlg_framework"),"Lekton:tlg://fonts.gstatic.com/s/lekton/v7/r483JYmxf5PjIm4jVAm8Yg.ttf:tlg:regular" => esc_html__( "Lekton - regular", "tlg_framework"),"Lekton:tlg://fonts.gstatic.com/s/lekton/v7/_UbDIPBA1wDqSbhp-OED7A.ttf:tlg:italic" => esc_html__( "Lekton - italic", "tlg_framework"),"Lekton:tlg://fonts.gstatic.com/s/lekton/v7/WZw-uL8WTkx3SBVfTlevXQ.ttf:tlg:700" => esc_html__( "Lekton - 700", "tlg_framework"),"Lemon:tlg://fonts.gstatic.com/s/lemon/v5/wed1nNu4LNSu-3RoRVUhUw.ttf:tlg:regular" => esc_html__( "Lemon - regular", "tlg_framework"),"Libre Baskerville:tlg://fonts.gstatic.com/s/librebaskerville/v4/pR0sBQVcY0JZc_ciXjFsKyyZRYCSvpCzQKuMWnP5NDY.ttf:tlg:regular" => esc_html__( "Libre Baskerville - regular", "tlg_framework"),"Libre Baskerville:tlg://fonts.gstatic.com/s/librebaskerville/v4/QHIOz1iKF3bIEzRdDFaf5QnhapNS5Oi8FPrBRDLbsW4.ttf:tlg:italic" => esc_html__( "Libre Baskerville - italic", "tlg_framework"),"Libre Baskerville:tlg://fonts.gstatic.com/s/librebaskerville/v4/kH7K4InNTm7mmOXXjrA5v-xuswJKUVpBRfYFpz0W3Iw.ttf:tlg:700" => esc_html__( "Libre Baskerville - 700", "tlg_framework"),"Life Savers:tlg://fonts.gstatic.com/s/lifesavers/v6/g49cUDk4Y1P0G5NMkMAm7qCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Life Savers - regular", "tlg_framework"),"Life Savers:tlg://fonts.gstatic.com/s/lifesavers/v6/THQKqChyYUm97rNPVFdGGXe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Life Savers - 700", "tlg_framework"),"Lilita One:tlg://fonts.gstatic.com/s/lilitaone/v4/vTxJQjbNV6BCBHx8sGDCVvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Lilita One - regular", "tlg_framework"),"Lily Script One:tlg://fonts.gstatic.com/s/lilyscriptone/v4/uPWsLVW8uiXqIBnE8ZwGPDjVlsJB_M_Q_LtZxsoxvlw.ttf:tlg:regular" => esc_html__( "Lily Script One - regular", "tlg_framework"),"Limelight:tlg://fonts.gstatic.com/s/limelight/v7/5dTfN6igsXjLjOy8QQShcg.ttf:tlg:regular" => esc_html__( "Limelight - regular", "tlg_framework"),"Linden Hill:tlg://fonts.gstatic.com/s/lindenhill/v6/UgsC0txqd-E1yjvjutwm_KCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Linden Hill - regular", "tlg_framework"),"Linden Hill:tlg://fonts.gstatic.com/s/lindenhill/v6/OcS3bZcu8vJvIDH8Zic83keOrDcLawS7-ssYqLr2Xp4.ttf:tlg:italic" => esc_html__( "Linden Hill - italic", "tlg_framework"),"Lobster:tlg://fonts.gstatic.com/s/lobster/v16/9LpJGtNuM1D8FAZ2BkJH2Q.ttf:tlg:regular" => esc_html__( "Lobster - regular", "tlg_framework"),"Lobster Two:tlg://fonts.gstatic.com/s/lobstertwo/v8/xb9aY4w9ceh8JRzobID1naCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Lobster Two - regular", "tlg_framework"),"Lobster Two:tlg://fonts.gstatic.com/s/lobstertwo/v8/Ul_16MSbfayQv1I4QhLEoEeOrDcLawS7-ssYqLr2Xp4.ttf:tlg:italic" => esc_html__( "Lobster Two - italic", "tlg_framework"),"Lobster Two:tlg://fonts.gstatic.com/s/lobstertwo/v8/bmdxOflBqMqjEC0-kGsIiHe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Lobster Two - 700", "tlg_framework"),"Lobster Two:tlg://fonts.gstatic.com/s/lobstertwo/v8/LEkN2_no_6kFvRfiBZ8xpM_zJjSACmk0BRPxQqhnNLU.ttf:tlg:700italic" => esc_html__( "Lobster Two - 700italic", "tlg_framework"),"Londrina Outline:tlg://fonts.gstatic.com/s/londrinaoutline/v5/lls08GOa1eT74p072l1AWJmp8DTZ6iHear7UV05iykg.ttf:tlg:regular" => esc_html__( "Londrina Outline - regular", "tlg_framework"),"Londrina Shadow:tlg://fonts.gstatic.com/s/londrinashadow/v4/dNYuzPS_7eYgXFJBzMoKdbw6Z3rVA5KDSi7aQxS92Nk.ttf:tlg:regular" => esc_html__( "Londrina Shadow - regular", "tlg_framework"),"Londrina Sketch:tlg://fonts.gstatic.com/s/londrinasketch/v4/p7Ai06aT1Ycp_D2fyE3z69d6z_uhFGnpCOifUY1fJQo.ttf:tlg:regular" => esc_html__( "Londrina Sketch - regular", "tlg_framework"),"Londrina Solid:tlg://fonts.gstatic.com/s/londrinasolid/v4/yysorIEiYSBb0ylZjg791MR125CwGqh8XBqkBzea0LA.ttf:tlg:regular" => esc_html__( "Londrina Solid - regular", "tlg_framework"),"Lora:tlg://fonts.gstatic.com/s/lora/v9/aXJ7KVIGcejEy1abawZazg.ttf:tlg:regular" => esc_html__( "Lora - regular", "tlg_framework"),"Lora:tlg://fonts.gstatic.com/s/lora/v9/AN2EZaj2tFRpyveuNn9BOg.ttf:tlg:italic" => esc_html__( "Lora - italic", "tlg_framework"),"Lora:tlg://fonts.gstatic.com/s/lora/v9/enKND5SfzQKkggBA_VnT1A.ttf:tlg:700" => esc_html__( "Lora - 700", "tlg_framework"),"Lora:tlg://fonts.gstatic.com/s/lora/v9/ivs9j3kYU65pR9QD9YFdzQ.ttf:tlg:700italic" => esc_html__( "Lora - 700italic", "tlg_framework"),"Love Ya Like A Sister:tlg://fonts.gstatic.com/s/loveyalikeasister/v7/LzkxWS-af0Br2Sk_YgSJY-ad1xEP8DQfgfY8MH9aBUg.ttf:tlg:regular" => esc_html__( "Love Ya Like A Sister - regular", "tlg_framework"),"Loved by the King:tlg://fonts.gstatic.com/s/lovedbytheking/v6/wg03xD4cWigj4YDufLBSr8io2AFEwwMpu7y5KyiyAJc.ttf:tlg:regular" => esc_html__( "Loved by the King - regular", "tlg_framework"),"Lovers Quarrel:tlg://fonts.gstatic.com/s/loversquarrel/v4/gipdZ8b7pKb89MzQLAtJHLHLxci2ElvNEmOB303HLk0.ttf:tlg:regular" => esc_html__( "Lovers Quarrel - regular", "tlg_framework"),"Luckiest Guy:tlg://fonts.gstatic.com/s/luckiestguy/v6/5718gH8nDy3hFVihOpkY5C3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Luckiest Guy - regular", "tlg_framework"),"Lusitana:tlg://fonts.gstatic.com/s/lusitana/v4/l1h9VDomkwbdzbPdmLcUIw.ttf:tlg:regular" => esc_html__( "Lusitana - regular", "tlg_framework"),"Lusitana:tlg://fonts.gstatic.com/s/lusitana/v4/GWtZyUsONxgkdl3Mc1P7FKCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Lusitana - 700", "tlg_framework"),"Lustria:tlg://fonts.gstatic.com/s/lustria/v4/gXAk0s4ai0X-TAOhYzZd1w.ttf:tlg:regular" => esc_html__( "Lustria - regular", "tlg_framework"),"Macondo:tlg://fonts.gstatic.com/s/macondo/v5/G6yPNUscRPQ8ufBXs_8yRQ.ttf:tlg:regular" => esc_html__( "Macondo - regular", "tlg_framework"),"Macondo Swash Caps:tlg://fonts.gstatic.com/s/macondoswashcaps/v4/SsSR706z-MlvEH7_LS6JAPkkgYRHs6GSG949m-K6x2k.ttf:tlg:regular" => esc_html__( "Macondo Swash Caps - regular", "tlg_framework"),"Magra:tlg://fonts.gstatic.com/s/magra/v4/hoZ13bwCXBxuGZqAudgc5A.ttf:tlg:regular" => esc_html__( "Magra - regular", "tlg_framework"),"Magra:tlg://fonts.gstatic.com/s/magra/v4/6fOM5sq5cIn8D0RjX8Lztw.ttf:tlg:700" => esc_html__( "Magra - 700", "tlg_framework"),"Maiden Orange:tlg://fonts.gstatic.com/s/maidenorange/v6/ZhKIA2SPisEwdhW7g0RUWojjx0o0jr6fNXxPgYh_a8Q.ttf:tlg:regular" => esc_html__( "Maiden Orange - regular", "tlg_framework"),"Mako:tlg://fonts.gstatic.com/s/mako/v7/z5zSLmfPlv1uTVAdmJBLXg.ttf:tlg:regular" => esc_html__( "Mako - regular", "tlg_framework"),"Mallanna:tlg://fonts.gstatic.com/s/mallanna/v4/krCTa-CfMbtxqF0689CbuQ.ttf:tlg:regular" => esc_html__( "Mallanna - regular", "tlg_framework"),"Mandali:tlg://fonts.gstatic.com/s/mandali/v4/0lF8yJ7fkyjXuqtSi5bWbQ.ttf:tlg:regular" => esc_html__( "Mandali - regular", "tlg_framework"),"Marcellus:tlg://fonts.gstatic.com/s/marcellus/v4/UjiLZzumxWC9whJ86UtaYw.ttf:tlg:regular" => esc_html__( "Marcellus - regular", "tlg_framework"),"Marcellus SC:tlg://fonts.gstatic.com/s/marcellussc/v4/_jugwxhkkynrvsfrxVx8gS3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Marcellus SC - regular", "tlg_framework"),"Marck Script:tlg://fonts.gstatic.com/s/marckscript/v7/O_D1NAZVOFOobLbVtW3bci3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Marck Script - regular", "tlg_framework"),"Margarine:tlg://fonts.gstatic.com/s/margarine/v5/DJnJwIrcO_cGkjSzY3MERw.ttf:tlg:regular" => esc_html__( "Margarine - regular", "tlg_framework"),"Marko One:tlg://fonts.gstatic.com/s/markoone/v6/hpP7j861sOAco43iDc4n4w.ttf:tlg:regular" => esc_html__( "Marko One - regular", "tlg_framework"),"Marmelad:tlg://fonts.gstatic.com/s/marmelad/v6/jI0_FBlSOIRLL0ePWOhOwQ.ttf:tlg:regular" => esc_html__( "Marmelad - regular", "tlg_framework"),"Martel:tlg://fonts.gstatic.com/s/martel/v1/_wfGdswZbat7P4tupHLA1w.ttf:tlg:200" => esc_html__( "Martel - 200", "tlg_framework"),"Martel:tlg://fonts.gstatic.com/s/martel/v1/SghoV2F2VPdVU3P0a4fa9w.ttf:tlg:300" => esc_html__( "Martel - 300", "tlg_framework"),"Martel:tlg://fonts.gstatic.com/s/martel/v1/9ALu5czkaaf5zsYk6GJEnQ.ttf:tlg:regular" => esc_html__( "Martel - regular", "tlg_framework"),"Martel:tlg://fonts.gstatic.com/s/martel/v1/Kt9uPhH1PvUwuZ5Y6zuAMQ.ttf:tlg:600" => esc_html__( "Martel - 600", "tlg_framework"),"Martel:tlg://fonts.gstatic.com/s/martel/v1/4OzIiKB5wE36xXL2U0vzWQ.ttf:tlg:700" => esc_html__( "Martel - 700", "tlg_framework"),"Martel:tlg://fonts.gstatic.com/s/martel/v1/RVF8drcQoRkRL7l_ZkpTlQ.ttf:tlg:800" => esc_html__( "Martel - 800", "tlg_framework"),"Martel:tlg://fonts.gstatic.com/s/martel/v1/iS0YUpFJoiLRlnyl40rpEA.ttf:tlg:900" => esc_html__( "Martel - 900", "tlg_framework"),"Martel Sans:tlg://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQEnzyIngrzGjGh22wPb6cGM.ttf:tlg:200" => esc_html__( "Martel Sans - 200", "tlg_framework"),"Martel Sans:tlg://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQC9-WlPSxbfiI49GsXo3q0g.ttf:tlg:300" => esc_html__( "Martel Sans - 300", "tlg_framework"),"Martel Sans:tlg://fonts.gstatic.com/s/martelsans/v2/91c8DPDZncMc0RFfhmc2RqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Martel Sans - regular", "tlg_framework"),"Martel Sans:tlg://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQJZ7xm-Bj30Bj2KNdXDzSZg.ttf:tlg:600" => esc_html__( "Martel Sans - 600", "tlg_framework"),"Martel Sans:tlg://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQHe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Martel Sans - 700", "tlg_framework"),"Martel Sans:tlg://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQA89PwPrYLaRFJ-HNCU9NbA.ttf:tlg:800" => esc_html__( "Martel Sans - 800", "tlg_framework"),"Martel Sans:tlg://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQCenaqEuufTBk9XMKnKmgDA.ttf:tlg:900" => esc_html__( "Martel Sans - 900", "tlg_framework"),"Marvel:tlg://fonts.gstatic.com/s/marvel/v6/Fg1dO8tWVb-MlyqhsbXEkg.ttf:tlg:regular" => esc_html__( "Marvel - regular", "tlg_framework"),"Marvel:tlg://fonts.gstatic.com/s/marvel/v6/HzyjFB-oR5usrc7Lxz9g8w.ttf:tlg:italic" => esc_html__( "Marvel - italic", "tlg_framework"),"Marvel:tlg://fonts.gstatic.com/s/marvel/v6/WrHDBL1RupWGo2UcdgxB3Q.ttf:tlg:700" => esc_html__( "Marvel - 700", "tlg_framework"),"Marvel:tlg://fonts.gstatic.com/s/marvel/v6/Gzf5NT09Y6xskdQRj2kz1qCWcynf_cDxXwCLxiixG1c.ttf:tlg:700italic" => esc_html__( "Marvel - 700italic", "tlg_framework"),"Mate:tlg://fonts.gstatic.com/s/mate/v5/ooFviPcJ6hZP5bAE71Cawg.ttf:tlg:regular" => esc_html__( "Mate - regular", "tlg_framework"),"Mate:tlg://fonts.gstatic.com/s/mate/v5/5XwW6_cbisGvCX5qmNiqfA.ttf:tlg:italic" => esc_html__( "Mate - italic", "tlg_framework"),"Mate SC:tlg://fonts.gstatic.com/s/matesc/v5/-YkIT2TZoPZF6pawKzDpWw.ttf:tlg:regular" => esc_html__( "Mate SC - regular", "tlg_framework"),"Maven Pro:tlg://fonts.gstatic.com/s/mavenpro/v7/sqPJIFG4gqsjl-0q_46Gbw.ttf:tlg:regular" => esc_html__( "Maven Pro - regular", "tlg_framework"),"Maven Pro:tlg://fonts.gstatic.com/s/mavenpro/v7/SQVfzoJBbj9t3aVcmbspRi3USBnSvpkopQaUR-2r7iU.ttf:tlg:500" => esc_html__( "Maven Pro - 500", "tlg_framework"),"Maven Pro:tlg://fonts.gstatic.com/s/mavenpro/v7/uDssvmXgp7Nj3i336k_dSi3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Maven Pro - 700", "tlg_framework"),"Maven Pro:tlg://fonts.gstatic.com/s/mavenpro/v7/-91TwiFzqeL1F7Kh91APwS3USBnSvpkopQaUR-2r7iU.ttf:tlg:900" => esc_html__( "Maven Pro - 900", "tlg_framework"),"McLaren:tlg://fonts.gstatic.com/s/mclaren/v4/OprvTGxaiINBKW_1_U0eoQ.ttf:tlg:regular" => esc_html__( "McLaren - regular", "tlg_framework"),"Meddon:tlg://fonts.gstatic.com/s/meddon/v9/f8zJO98uu2EtSj9p7ci9RA.ttf:tlg:regular" => esc_html__( "Meddon - regular", "tlg_framework"),"MedievalSharp:tlg://fonts.gstatic.com/s/medievalsharp/v8/85X_PjV6tftJ0-rX7KYQkOe45sJkivqprK7VkUlzfg0.ttf:tlg:regular" => esc_html__( "MedievalSharp - regular", "tlg_framework"),"Medula One:tlg://fonts.gstatic.com/s/medulaone/v6/AasPgDQak81dsTGQHc5zUPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Medula One - regular", "tlg_framework"),"Megrim:tlg://fonts.gstatic.com/s/megrim/v7/e-9jVUC9lv1zxaFQARuftw.ttf:tlg:regular" => esc_html__( "Megrim - regular", "tlg_framework"),"Meie Script:tlg://fonts.gstatic.com/s/meiescript/v4/oTIWE5MmPye-rCyVp_6KEqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Meie Script - regular", "tlg_framework"),"Merienda:tlg://fonts.gstatic.com/s/merienda/v4/MYY6Og1qZlOQtPW2G95Y3A.ttf:tlg:regular" => esc_html__( "Merienda - regular", "tlg_framework"),"Merienda:tlg://fonts.gstatic.com/s/merienda/v4/GlwcvRLlgiVE2MBFQ4r0sKCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Merienda - 700", "tlg_framework"),"Merienda One:tlg://fonts.gstatic.com/s/meriendaone/v7/bCA-uDdUx6nTO8SjzCLXvS3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Merienda One - regular", "tlg_framework"),"Merriweather:tlg://fonts.gstatic.com/s/merriweather/v11/ZvcMqxEwPfh2qDWBPxn6nqcQoVhARpoaILP7amxE_8g.ttf:tlg:300" => esc_html__( "Merriweather - 300", "tlg_framework"),"Merriweather:tlg://fonts.gstatic.com/s/merriweather/v11/EYh7Vl4ywhowqULgRdYwICna0FLWfcB-J_SAYmcAXaI.ttf:tlg:300italic" => esc_html__( "Merriweather - 300italic", "tlg_framework"),"Merriweather:tlg://fonts.gstatic.com/s/merriweather/v11/RFda8w1V0eDZheqfcyQ4EC3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Merriweather - regular", "tlg_framework"),"Merriweather:tlg://fonts.gstatic.com/s/merriweather/v11/So5lHxHT37p2SS4-t60SlPMZXuCXbOrAvx5R0IT5Oyo.ttf:tlg:italic" => esc_html__( "Merriweather - italic", "tlg_framework"),"Merriweather:tlg://fonts.gstatic.com/s/merriweather/v11/ZvcMqxEwPfh2qDWBPxn6nkD2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Merriweather - 700", "tlg_framework"),"Merriweather:tlg://fonts.gstatic.com/s/merriweather/v11/EYh7Vl4ywhowqULgRdYwIPAs9-1nE9qOqhChW0m4nDE.ttf:tlg:700italic" => esc_html__( "Merriweather - 700italic", "tlg_framework"),"Merriweather:tlg://fonts.gstatic.com/s/merriweather/v11/ZvcMqxEwPfh2qDWBPxn6nqObDOjC3UL77puoeHsE3fw.ttf:tlg:900" => esc_html__( "Merriweather - 900", "tlg_framework"),"Merriweather:tlg://fonts.gstatic.com/s/merriweather/v11/EYh7Vl4ywhowqULgRdYwIBd0_s6jQr9r5s5OZYvtzBY.ttf:tlg:900italic" => esc_html__( "Merriweather - 900italic", "tlg_framework"),"Merriweather Sans:tlg://fonts.gstatic.com/s/merriweathersans/v7/6LmGj5dOJopQKEkt88Gowan5N8K-_DP0e9e_v51obXQ.ttf:tlg:300" => esc_html__( "Merriweather Sans - 300", "tlg_framework"),"Merriweather Sans:tlg://fonts.gstatic.com/s/merriweathersans/v7/nAqt4hiqwq3tzCecpgPmVdytE4nGXk2hYD5nJ740tBw.ttf:tlg:300italic" => esc_html__( "Merriweather Sans - 300italic", "tlg_framework"),"Merriweather Sans:tlg://fonts.gstatic.com/s/merriweathersans/v7/AKu1CjQ4qnV8MUltkAX3sOAj_ty82iuwwDTNEYXGiyQ.ttf:tlg:regular" => esc_html__( "Merriweather Sans - regular", "tlg_framework"),"Merriweather Sans:tlg://fonts.gstatic.com/s/merriweathersans/v7/3Mz4hOHzs2npRMG3B1ascZ32VBCoA_HLsn85tSWZmdo.ttf:tlg:italic" => esc_html__( "Merriweather Sans - italic", "tlg_framework"),"Merriweather Sans:tlg://fonts.gstatic.com/s/merriweathersans/v7/6LmGj5dOJopQKEkt88GowbqxG25nQNOioCZSK4sU-CA.ttf:tlg:700" => esc_html__( "Merriweather Sans - 700", "tlg_framework"),"Merriweather Sans:tlg://fonts.gstatic.com/s/merriweathersans/v7/nAqt4hiqwq3tzCecpgPmVbuqAJxizi8Dk_SK5et7kMg.ttf:tlg:700italic" => esc_html__( "Merriweather Sans - 700italic", "tlg_framework"),"Merriweather Sans:tlg://fonts.gstatic.com/s/merriweathersans/v7/6LmGj5dOJopQKEkt88GowYufzO2zUYSj5LqoJ3UGkco.ttf:tlg:800" => esc_html__( "Merriweather Sans - 800", "tlg_framework"),"Merriweather Sans:tlg://fonts.gstatic.com/s/merriweathersans/v7/nAqt4hiqwq3tzCecpgPmVdDmPrYMy3aZO4LmnZsxTQw.ttf:tlg:800italic" => esc_html__( "Merriweather Sans - 800italic", "tlg_framework"),"Metal:tlg://fonts.gstatic.com/s/metal/v9/zA3UOP13ooQcxjv04BZX5g.ttf:tlg:regular" => esc_html__( "Metal - regular", "tlg_framework"),"Metal Mania:tlg://fonts.gstatic.com/s/metalmania/v6/isriV_rAUgj6bPWPN6l9QKCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Metal Mania - regular", "tlg_framework"),"Metamorphous:tlg://fonts.gstatic.com/s/metamorphous/v6/wGqUKXRinIYggz-BTRU9ei3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Metamorphous - regular", "tlg_framework"),"Metrophobic:tlg://fonts.gstatic.com/s/metrophobic/v6/SaglWZWCrrv_D17u1i4v_aCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Metrophobic - regular", "tlg_framework"),"Michroma:tlg://fonts.gstatic.com/s/michroma/v7/0c2XrW81_QsiKV8T9thumA.ttf:tlg:regular" => esc_html__( "Michroma - regular", "tlg_framework"),"Milonga:tlg://fonts.gstatic.com/s/milonga/v4/dzNdIUSTGFmy2ahovDRcWg.ttf:tlg:regular" => esc_html__( "Milonga - regular", "tlg_framework"),"Miltonian:tlg://fonts.gstatic.com/s/miltonian/v9/Z4HrYZyqm0BnNNzcCUfzoQ.ttf:tlg:regular" => esc_html__( "Miltonian - regular", "tlg_framework"),"Miltonian Tattoo:tlg://fonts.gstatic.com/s/miltoniantattoo/v10/1oU_8OGYwW46eh02YHydn2uk0YtI6thZkz1Hmh-odwg.ttf:tlg:regular" => esc_html__( "Miltonian Tattoo - regular", "tlg_framework"),"Miniver:tlg://fonts.gstatic.com/s/miniver/v5/4yTQohOH_cWKRS5laRFhYg.ttf:tlg:regular" => esc_html__( "Miniver - regular", "tlg_framework"),"Miss Fajardose:tlg://fonts.gstatic.com/s/missfajardose/v6/WcXjlQPKn6nBfr8LY3ktNu6rPKfVZo7L2bERcf0BDns.ttf:tlg:regular" => esc_html__( "Miss Fajardose - regular", "tlg_framework"),"Modak:tlg://fonts.gstatic.com/s/modak/v1/lMsN0QIKid-pCPvL0hH4nw.ttf:tlg:regular" => esc_html__( "Modak - regular", "tlg_framework"),"Modern Antiqua:tlg://fonts.gstatic.com/s/modernantiqua/v6/8qX_tr6Xzy4t9fvZDXPkh6rFJ4O13IHVxZbM6yoslpo.ttf:tlg:regular" => esc_html__( "Modern Antiqua - regular", "tlg_framework"),"Molengo:tlg://fonts.gstatic.com/s/molengo/v7/jcjgeGuzv83I55AzOTpXNQ.ttf:tlg:regular" => esc_html__( "Molengo - regular", "tlg_framework"),"Molle:tlg://fonts.gstatic.com/s/molle/v4/9XTdCsjPXifLqo5et-YoGA.ttf:tlg:italic" => esc_html__( "Molle - italic", "tlg_framework"),"Monda:tlg://fonts.gstatic.com/s/monda/v4/qFMHZ9zvR6B_gnoIgosPrw.ttf:tlg:regular" => esc_html__( "Monda - regular", "tlg_framework"),"Monda:tlg://fonts.gstatic.com/s/monda/v4/EVOzZUyc_j1w2GuTgTAW1g.ttf:tlg:700" => esc_html__( "Monda - 700", "tlg_framework"),"Monofett:tlg://fonts.gstatic.com/s/monofett/v6/C6K5L799Rgxzg2brgOaqAw.ttf:tlg:regular" => esc_html__( "Monofett - regular", "tlg_framework"),"Monoton:tlg://fonts.gstatic.com/s/monoton/v6/aCz8ja_bE4dg-7agSvExdw.ttf:tlg:regular" => esc_html__( "Monoton - regular", "tlg_framework"),"Monsieur La Doulaise:tlg://fonts.gstatic.com/s/monsieurladoulaise/v5/IMAdMj6Eq9jZ46CPctFtMKP61oAqTJXlx5ZVOBmcPdM.ttf:tlg:regular" => esc_html__( "Monsieur La Doulaise - regular", "tlg_framework"),"Montaga:tlg://fonts.gstatic.com/s/montaga/v4/PwTwUboiD-M4-mFjZfJs2A.ttf:tlg:regular" => esc_html__( "Montaga - regular", "tlg_framework"),"Montez:tlg://fonts.gstatic.com/s/montez/v6/kx58rLOWQQLGFM4pDHv5Ng.ttf:tlg:regular" => esc_html__( "Montez - regular", "tlg_framework"),"Montserrat:tlg://fonts.gstatic.com/s/montserrat/v6/Kqy6-utIpx_30Xzecmeo8_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Montserrat - regular", "tlg_framework"),"Montserrat:tlg://fonts.gstatic.com/s/montserrat/v6/IQHow_FEYlDC4Gzy_m8fcgJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700" => esc_html__( "Montserrat - 700", "tlg_framework"),"Montserrat Alternates:tlg://fonts.gstatic.com/s/montserratalternates/v4/z2n1Sjxk9souK3HCtdHuklPuEVRGaG9GCQnmM16YWq0.ttf:tlg:regular" => esc_html__( "Montserrat Alternates - regular", "tlg_framework"),"Montserrat Alternates:tlg://fonts.gstatic.com/s/montserratalternates/v4/YENqOGAVzwIHjYNjmKuAZpeqBKvsAhm-s2I4RVSXFfc.ttf:tlg:700" => esc_html__( "Montserrat Alternates - 700", "tlg_framework"),"Montserrat Subrayada:tlg://fonts.gstatic.com/s/montserratsubrayada/v4/nzoCWCz0e9c7Mr2Gl8bbgrJymm6ilkk9f0nDA_sC_qk.ttf:tlg:regular" => esc_html__( "Montserrat Subrayada - regular", "tlg_framework"),"Montserrat Subrayada:tlg://fonts.gstatic.com/s/montserratsubrayada/v4/wf-IKpsHcfm0C9uaz9IeGJvEcF1LWArDbGWgKZSH9go.ttf:tlg:700" => esc_html__( "Montserrat Subrayada - 700", "tlg_framework"),"Moul:tlg://fonts.gstatic.com/s/moul/v8/Kb0ALQnfyXawP1a_P_gpTQ.ttf:tlg:regular" => esc_html__( "Moul - regular", "tlg_framework"),"Moulpali:tlg://fonts.gstatic.com/s/moulpali/v9/diD74BprGhmVkJoerKmrKA.ttf:tlg:regular" => esc_html__( "Moulpali - regular", "tlg_framework"),"Mountains of Christmas:tlg://fonts.gstatic.com/s/mountainsofchristmas/v8/dVGBFPwd6G44IWDbQtPew2Auds3jz1Fxb61CgfaGDr4.ttf:tlg:regular" => esc_html__( "Mountains of Christmas - regular", "tlg_framework"),"Mountains of Christmas:tlg://fonts.gstatic.com/s/mountainsofchristmas/v8/PymufKtHszoLrY0uiAYKNM9cPTbSBTrQyTa5TWAe3vE.ttf:tlg:700" => esc_html__( "Mountains of Christmas - 700", "tlg_framework"),"Mouse Memoirs:tlg://fonts.gstatic.com/s/mousememoirs/v4/NBFaaJFux_j0AQbAsW3QeH8f0n03UdmQgF_CLvNR2vg.ttf:tlg:regular" => esc_html__( "Mouse Memoirs - regular", "tlg_framework"),"Mr Bedfort:tlg://fonts.gstatic.com/s/mrbedfort/v5/81bGgHTRikLs_puEGshl7_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Mr Bedfort - regular", "tlg_framework"),"Mr Dafoe:tlg://fonts.gstatic.com/s/mrdafoe/v5/s32Q1S6ZkT7EaX53mUirvQ.ttf:tlg:regular" => esc_html__( "Mr Dafoe - regular", "tlg_framework"),"Mr De Haviland:tlg://fonts.gstatic.com/s/mrdehaviland/v5/fD8y4L6PJ4vqDk7z8Y8e27v4lrhng1lzu7-weKO6cw8.ttf:tlg:regular" => esc_html__( "Mr De Haviland - regular", "tlg_framework"),"Mrs Saint Delafield:tlg://fonts.gstatic.com/s/mrssaintdelafield/v4/vuWagfFT7bj9lFtZOFBwmjHMBelqWf3tJeGyts2SmKU.ttf:tlg:regular" => esc_html__( "Mrs Saint Delafield - regular", "tlg_framework"),"Mrs Sheppards:tlg://fonts.gstatic.com/s/mrssheppards/v5/2WFsWMV3VUeCz6UVH7UjCn8f0n03UdmQgF_CLvNR2vg.ttf:tlg:regular" => esc_html__( "Mrs Sheppards - regular", "tlg_framework"),"Muli:tlg://fonts.gstatic.com/s/muli/v7/VJw4F3ZHRAZ7Hmg3nQu5YQ.ttf:tlg:300" => esc_html__( "Muli - 300", "tlg_framework"),"Muli:tlg://fonts.gstatic.com/s/muli/v7/s-NKMCru8HiyjEt0ZDoBoA.ttf:tlg:300italic" => esc_html__( "Muli - 300italic", "tlg_framework"),"Muli:tlg://fonts.gstatic.com/s/muli/v7/KJiP6KznxbALQgfJcDdPAw.ttf:tlg:regular" => esc_html__( "Muli - regular", "tlg_framework"),"Muli:tlg://fonts.gstatic.com/s/muli/v7/Cg0K_IWANs9xkNoxV7H1_w.ttf:tlg:italic" => esc_html__( "Muli - italic", "tlg_framework"),"Mystery Quest:tlg://fonts.gstatic.com/s/mysteryquest/v4/467jJvg0c7HgucvBB9PLDyeUSrabuTpOsMEiRLtKwk0.ttf:tlg:regular" => esc_html__( "Mystery Quest - regular", "tlg_framework"),"NTR:tlg://fonts.gstatic.com/s/ntr/v4/e7H4ZLtGfVOYyOupo6T12g.ttf:tlg:regular" => esc_html__( "NTR - regular", "tlg_framework"),"Neucha:tlg://fonts.gstatic.com/s/neucha/v8/bijdhB-TzQdtpl0ykhGh4Q.ttf:tlg:regular" => esc_html__( "Neucha - regular", "tlg_framework"),"Neuton:tlg://fonts.gstatic.com/s/neuton/v8/DA3Mkew3XqSkPpi1f4tJow.ttf:tlg:200" => esc_html__( "Neuton - 200", "tlg_framework"),"Neuton:tlg://fonts.gstatic.com/s/neuton/v8/xrc_aZ2hx-gdeV0mlY8Vww.ttf:tlg:300" => esc_html__( "Neuton - 300", "tlg_framework"),"Neuton:tlg://fonts.gstatic.com/s/neuton/v8/9R-MGIOQUdjAVeB6nE6PcQ.ttf:tlg:regular" => esc_html__( "Neuton - regular", "tlg_framework"),"Neuton:tlg://fonts.gstatic.com/s/neuton/v8/uVMT3JOB5BNFi3lgPp6kEg.ttf:tlg:italic" => esc_html__( "Neuton - italic", "tlg_framework"),"Neuton:tlg://fonts.gstatic.com/s/neuton/v8/gnWpkWY7DirkKiovncYrfg.ttf:tlg:700" => esc_html__( "Neuton - 700", "tlg_framework"),"Neuton:tlg://fonts.gstatic.com/s/neuton/v8/XPzBQV4lY6enLxQG9cF1jw.ttf:tlg:800" => esc_html__( "Neuton - 800", "tlg_framework"),"New Rocker:tlg://fonts.gstatic.com/s/newrocker/v5/EFUWzHJedEkpW399zYOHofesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "New Rocker - regular", "tlg_framework"),"News Cycle:tlg://fonts.gstatic.com/s/newscycle/v13/xyMAr8VfiUzIOvS1abHJO_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "News Cycle - regular", "tlg_framework"),"News Cycle:tlg://fonts.gstatic.com/s/newscycle/v13/G28Ny31cr5orMqEQy6ljtwJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700" => esc_html__( "News Cycle - 700", "tlg_framework"),"Niconne:tlg://fonts.gstatic.com/s/niconne/v6/ZA-mFw2QNXodx5y7kfELBg.ttf:tlg:regular" => esc_html__( "Niconne - regular", "tlg_framework"),"Nixie One:tlg://fonts.gstatic.com/s/nixieone/v7/h6kQfmzm0Shdnp3eswRaqQ.ttf:tlg:regular" => esc_html__( "Nixie One - regular", "tlg_framework"),"Nobile:tlg://fonts.gstatic.com/s/nobile/v7/lC_lPi1ddtN38iXTCRh6ow.ttf:tlg:regular" => esc_html__( "Nobile - regular", "tlg_framework"),"Nobile:tlg://fonts.gstatic.com/s/nobile/v7/vGmrpKzWQQSrb-PR6FWBIA.ttf:tlg:italic" => esc_html__( "Nobile - italic", "tlg_framework"),"Nobile:tlg://fonts.gstatic.com/s/nobile/v7/9p6M-Yrg_r_QPmSD1skrOg.ttf:tlg:700" => esc_html__( "Nobile - 700", "tlg_framework"),"Nobile:tlg://fonts.gstatic.com/s/nobile/v7/oQ1eYPaXV638N03KvsNvyKCWcynf_cDxXwCLxiixG1c.ttf:tlg:700italic" => esc_html__( "Nobile - 700italic", "tlg_framework"),"Nokora:tlg://fonts.gstatic.com/s/nokora/v9/dRyz1JfnyKPNaRcBNX9F9A.ttf:tlg:regular" => esc_html__( "Nokora - regular", "tlg_framework"),"Nokora:tlg://fonts.gstatic.com/s/nokora/v9/QMqqa4QEOhQpiig3cAPmbQ.ttf:tlg:700" => esc_html__( "Nokora - 700", "tlg_framework"),"Norican:tlg://fonts.gstatic.com/s/norican/v4/SHnSqhYAWG5sZTWcPzEHig.ttf:tlg:regular" => esc_html__( "Norican - regular", "tlg_framework"),"Nosifer:tlg://fonts.gstatic.com/s/nosifer/v5/7eJGoIuHRrtcG00j6CptSA.ttf:tlg:regular" => esc_html__( "Nosifer - regular", "tlg_framework"),"Nothing You Could Do:tlg://fonts.gstatic.com/s/nothingyoucoulddo/v6/jpk1K3jbJoyoK0XKaSyQAf-TpkXjXYGWiJZAEtBRjPU.ttf:tlg:regular" => esc_html__( "Nothing You Could Do - regular", "tlg_framework"),"Noticia Text:tlg://fonts.gstatic.com/s/noticiatext/v6/wdyV6x3eKpdeUPQ7BJ5uUC3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Noticia Text - regular", "tlg_framework"),"Noticia Text:tlg://fonts.gstatic.com/s/noticiatext/v6/dAuxVpkYE_Q_IwIm6elsKPMZXuCXbOrAvx5R0IT5Oyo.ttf:tlg:italic" => esc_html__( "Noticia Text - italic", "tlg_framework"),"Noticia Text:tlg://fonts.gstatic.com/s/noticiatext/v6/pEko-RqEtp45bE2P80AAKUD2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Noticia Text - 700", "tlg_framework"),"Noticia Text:tlg://fonts.gstatic.com/s/noticiatext/v6/-rQ7V8ARjf28_b7kRa0JuvAs9-1nE9qOqhChW0m4nDE.ttf:tlg:700italic" => esc_html__( "Noticia Text - 700italic", "tlg_framework"),"Noto Sans:tlg://fonts.gstatic.com/s/notosans/v6/0Ue9FiUJwVhi4NGfHJS5uA.ttf:tlg:regular" => esc_html__( "Noto Sans - regular", "tlg_framework"),"Noto Sans:tlg://fonts.gstatic.com/s/notosans/v6/dLcNKMgJ1H5RVoZFraDz0qCWcynf_cDxXwCLxiixG1c.ttf:tlg:italic" => esc_html__( "Noto Sans - italic", "tlg_framework"),"Noto Sans:tlg://fonts.gstatic.com/s/notosans/v6/PIbvSEyHEdL91QLOQRnZ1y3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Noto Sans - 700", "tlg_framework"),"Noto Sans:tlg://fonts.gstatic.com/s/notosans/v6/9Z3uUWMRR7crzm1TjRicDne1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700italic" => esc_html__( "Noto Sans - 700italic", "tlg_framework"),"Noto Serif:tlg://fonts.gstatic.com/s/notoserif/v4/zW6mc7bC1CWw8dH0yxY8JfesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Noto Serif - regular", "tlg_framework"),"Noto Serif:tlg://fonts.gstatic.com/s/notoserif/v4/HQXBIwLHsOJCNEQeX9kNzy3USBnSvpkopQaUR-2r7iU.ttf:tlg:italic" => esc_html__( "Noto Serif - italic", "tlg_framework"),"Noto Serif:tlg://fonts.gstatic.com/s/notoserif/v4/lJAvZoKA5NttpPc9yc6lPQJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700" => esc_html__( "Noto Serif - 700", "tlg_framework"),"Noto Serif:tlg://fonts.gstatic.com/s/notoserif/v4/Wreg0Be4tcFGM2t6VWytvED2ttfZwueP-QU272T9-k4.ttf:tlg:700italic" => esc_html__( "Noto Serif - 700italic", "tlg_framework"),"Nova Cut:tlg://fonts.gstatic.com/s/novacut/v8/6q12jWcBvj0KO2cMRP97tA.ttf:tlg:regular" => esc_html__( "Nova Cut - regular", "tlg_framework"),"Nova Flat:tlg://fonts.gstatic.com/s/novaflat/v8/pK7a0CoGzI684qe_XSHBqQ.ttf:tlg:regular" => esc_html__( "Nova Flat - regular", "tlg_framework"),"Nova Mono:tlg://fonts.gstatic.com/s/novamono/v7/6-SChr5ZIaaasJFBkgrLNw.ttf:tlg:regular" => esc_html__( "Nova Mono - regular", "tlg_framework"),"Nova Oval:tlg://fonts.gstatic.com/s/novaoval/v8/VuukVpKP8BwUf8o9W5LYQQ.ttf:tlg:regular" => esc_html__( "Nova Oval - regular", "tlg_framework"),"Nova Round:tlg://fonts.gstatic.com/s/novaround/v8/7-cK3Ari_8XYYFgVMxVhDvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Nova Round - regular", "tlg_framework"),"Nova Script:tlg://fonts.gstatic.com/s/novascript/v8/dEvxQDLgx1M1TKY-NmBWYaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Nova Script - regular", "tlg_framework"),"Nova Slim:tlg://fonts.gstatic.com/s/novaslim/v8/rPYXC81_VL2EW-4CzBX65g.ttf:tlg:regular" => esc_html__( "Nova Slim - regular", "tlg_framework"),"Nova Square:tlg://fonts.gstatic.com/s/novasquare/v8/BcBzXoaDzYX78rquGXVuSqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Nova Square - regular", "tlg_framework"),"Numans:tlg://fonts.gstatic.com/s/numans/v6/g5snI2p6OEjjTNmTHyBdiQ.ttf:tlg:regular" => esc_html__( "Numans - regular", "tlg_framework"),"Nunito:tlg://fonts.gstatic.com/s/nunito/v7/zXQvrWBJqUooM7Xv98MrQw.ttf:tlg:300" => esc_html__( "Nunito - 300", "tlg_framework"),"Nunito:tlg://fonts.gstatic.com/s/nunito/v7/ySZTeT3IuzJj0GK6uGpbBg.ttf:tlg:regular" => esc_html__( "Nunito - regular", "tlg_framework"),"Nunito:tlg://fonts.gstatic.com/s/nunito/v7/aEdlqgMuYbpe4U3TnqOQMA.ttf:tlg:700" => esc_html__( "Nunito - 700", "tlg_framework"),"Odor Mean Chey:tlg://fonts.gstatic.com/s/odormeanchey/v8/GK3E7EjPoBkeZhYshGFo0eVKG8sq4NyGgdteJLvqLDs.ttf:tlg:regular" => esc_html__( "Odor Mean Chey - regular", "tlg_framework"),"Offside:tlg://fonts.gstatic.com/s/offside/v4/v0C913SB8wqQUvcu1faUqw.ttf:tlg:regular" => esc_html__( "Offside - regular", "tlg_framework"),"Old Standard TT:tlg://fonts.gstatic.com/s/oldstandardtt/v7/n6RTCDcIPWSE8UNBa4k-DLcB5jyhm1VsHs65c3QNDr0.ttf:tlg:regular" => esc_html__( "Old Standard TT - regular", "tlg_framework"),"Old Standard TT:tlg://fonts.gstatic.com/s/oldstandardtt/v7/QQT_AUSp4AV4dpJfIN7U5PWrQzeMtsHf8QsWQ2cZg3c.ttf:tlg:italic" => esc_html__( "Old Standard TT - italic", "tlg_framework"),"Old Standard TT:tlg://fonts.gstatic.com/s/oldstandardtt/v7/5Ywdce7XEbTSbxs__4X1_HJqbZqK7TdZ58X80Q_Lw8Y.ttf:tlg:700" => esc_html__( "Old Standard TT - 700", "tlg_framework"),"Oldenburg:tlg://fonts.gstatic.com/s/oldenburg/v4/dqA_M_uoCVXZbCO-oKBTnQ.ttf:tlg:regular" => esc_html__( "Oldenburg - regular", "tlg_framework"),"Oleo Script:tlg://fonts.gstatic.com/s/oleoscript/v5/21stZcmPyzbQVXtmGegyqKCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Oleo Script - regular", "tlg_framework"),"Oleo Script:tlg://fonts.gstatic.com/s/oleoscript/v5/hudNQFKFl98JdNnlo363fne1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Oleo Script - 700", "tlg_framework"),"Oleo Script Swash Caps:tlg://fonts.gstatic.com/s/oleoscriptswashcaps/v4/vdWhGqsBUAP-FF3NOYTe4iMF4kXAPemmyaDpMXQ31P0.ttf:tlg:regular" => esc_html__( "Oleo Script Swash Caps - regular", "tlg_framework"),"Oleo Script Swash Caps:tlg://fonts.gstatic.com/s/oleoscriptswashcaps/v4/HMO3ftxA9AU5floml9c755reFYaXZ4zuJXJ8fr8OO1g.ttf:tlg:700" => esc_html__( "Oleo Script Swash Caps - 700", "tlg_framework"),"Open Sans:tlg://fonts.gstatic.com/s/opensans/v13/DXI1ORHCpsQm3Vp6mXoaTS3USBnSvpkopQaUR-2r7iU.ttf:tlg:300" => esc_html__( "Open Sans - 300", "tlg_framework"),"Open Sans:tlg://fonts.gstatic.com/s/opensans/v13/PRmiXeptR36kaC0GEAetxi9-WlPSxbfiI49GsXo3q0g.ttf:tlg:300italic" => esc_html__( "Open Sans - 300italic", "tlg_framework"),"Open Sans:tlg://fonts.gstatic.com/s/opensans/v13/IgZJs4-7SA1XX_edsoXWog.ttf:tlg:regular" => esc_html__( "Open Sans - regular", "tlg_framework"),"Open Sans:tlg://fonts.gstatic.com/s/opensans/v13/O4NhV7_qs9r9seTo7fnsVKCWcynf_cDxXwCLxiixG1c.ttf:tlg:italic" => esc_html__( "Open Sans - italic", "tlg_framework"),"Open Sans:tlg://fonts.gstatic.com/s/opensans/v13/MTP_ySUJH_bn48VBG8sNSi3USBnSvpkopQaUR-2r7iU.ttf:tlg:600" => esc_html__( "Open Sans - 600", "tlg_framework"),"Open Sans:tlg://fonts.gstatic.com/s/opensans/v13/PRmiXeptR36kaC0GEAetxpZ7xm-Bj30Bj2KNdXDzSZg.ttf:tlg:600italic" => esc_html__( "Open Sans - 600italic", "tlg_framework"),"Open Sans:tlg://fonts.gstatic.com/s/opensans/v13/k3k702ZOKiLJc3WVjuplzC3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Open Sans - 700", "tlg_framework"),"Open Sans:tlg://fonts.gstatic.com/s/opensans/v13/PRmiXeptR36kaC0GEAetxne1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700italic" => esc_html__( "Open Sans - 700italic", "tlg_framework"),"Open Sans:tlg://fonts.gstatic.com/s/opensans/v13/EInbV5DfGHOiMmvb1Xr-hi3USBnSvpkopQaUR-2r7iU.ttf:tlg:800" => esc_html__( "Open Sans - 800", "tlg_framework"),"Open Sans:tlg://fonts.gstatic.com/s/opensans/v13/PRmiXeptR36kaC0GEAetxg89PwPrYLaRFJ-HNCU9NbA.ttf:tlg:800italic" => esc_html__( "Open Sans - 800italic", "tlg_framework"),"Open Sans Condensed:tlg://fonts.gstatic.com/s/opensanscondensed/v10/gk5FxslNkTTHtojXrkp-xEMwSSh38KQVJx4ABtsZTnA.ttf:tlg:300" => esc_html__( "Open Sans Condensed - 300", "tlg_framework"),"Open Sans Condensed:tlg://fonts.gstatic.com/s/opensanscondensed/v10/jIXlqT1WKafUSwj6s9AzV4_LkTZ_uhAwfmGJ084hlvM.ttf:tlg:300italic" => esc_html__( "Open Sans Condensed - 300italic", "tlg_framework"),"Open Sans Condensed:tlg://fonts.gstatic.com/s/opensanscondensed/v10/gk5FxslNkTTHtojXrkp-xBEM87DM3yorPOrvA-vB930.ttf:tlg:700" => esc_html__( "Open Sans Condensed - 700", "tlg_framework"),"Oranienbaum:tlg://fonts.gstatic.com/s/oranienbaum/v5/M98jYwCSn0PaFhXXgviCoaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Oranienbaum - regular", "tlg_framework"),"Orbitron:tlg://fonts.gstatic.com/s/orbitron/v7/DY8swouAZjR3RaUPRf0HDQ.ttf:tlg:regular" => esc_html__( "Orbitron - regular", "tlg_framework"),"Orbitron:tlg://fonts.gstatic.com/s/orbitron/v7/p-y_ffzMdo5JN_7ia0vYEqCWcynf_cDxXwCLxiixG1c.ttf:tlg:500" => esc_html__( "Orbitron - 500", "tlg_framework"),"Orbitron:tlg://fonts.gstatic.com/s/orbitron/v7/PS9_6SLkY1Y6OgPO3APr6qCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Orbitron - 700", "tlg_framework"),"Orbitron:tlg://fonts.gstatic.com/s/orbitron/v7/2I3-8i9hT294TE_pyjy9SaCWcynf_cDxXwCLxiixG1c.ttf:tlg:900" => esc_html__( "Orbitron - 900", "tlg_framework"),"Oregano:tlg://fonts.gstatic.com/s/oregano/v4/UiLhqNixVv2EpjRoBG6axA.ttf:tlg:regular" => esc_html__( "Oregano - regular", "tlg_framework"),"Oregano:tlg://fonts.gstatic.com/s/oregano/v4/_iwqGEht6XsAuEaCbYG64Q.ttf:tlg:italic" => esc_html__( "Oregano - italic", "tlg_framework"),"Orienta:tlg://fonts.gstatic.com/s/orienta/v4/_NKSk93mMs0xsqtfjCsB3Q.ttf:tlg:regular" => esc_html__( "Orienta - regular", "tlg_framework"),"Original Surfer:tlg://fonts.gstatic.com/s/originalsurfer/v5/gdHw6HpSIN4D6Xt7pi1-qIkEz33TDwAZczo_6fY7eg0.ttf:tlg:regular" => esc_html__( "Original Surfer - regular", "tlg_framework"),"Oswald:tlg://fonts.gstatic.com/s/oswald/v10/y3tZpCdiRD4oNRRYFcAR5Q.ttf:tlg:300" => esc_html__( "Oswald - 300", "tlg_framework"),"Oswald:tlg://fonts.gstatic.com/s/oswald/v10/uLEd2g2vJglLPfsBF91DCg.ttf:tlg:regular" => esc_html__( "Oswald - regular", "tlg_framework"),"Oswald:tlg://fonts.gstatic.com/s/oswald/v10/7wj8ldV_5Ti37rHa0m1DDw.ttf:tlg:700" => esc_html__( "Oswald - 700", "tlg_framework"),"Over the Rainbow:tlg://fonts.gstatic.com/s/overtherainbow/v7/6gp-gkpI2kie2dHQQLM2jQBdxkZd83xOSx-PAQ2QmiI.ttf:tlg:regular" => esc_html__( "Over the Rainbow - regular", "tlg_framework"),"Overlock:tlg://fonts.gstatic.com/s/overlock/v5/Z8oYsGi88-E1cUB8YBFMAg.ttf:tlg:regular" => esc_html__( "Overlock - regular", "tlg_framework"),"Overlock:tlg://fonts.gstatic.com/s/overlock/v5/rq6EacukHROOBrFrK_zF6_esZW2xOQ-xsNqO47m55DA.ttf:tlg:italic" => esc_html__( "Overlock - italic", "tlg_framework"),"Overlock:tlg://fonts.gstatic.com/s/overlock/v5/Fexr8SqXM8Bm_gEVUA7AKaCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Overlock - 700", "tlg_framework"),"Overlock:tlg://fonts.gstatic.com/s/overlock/v5/wFWnYgeXKYBks6gEUwYnfAJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700italic" => esc_html__( "Overlock - 700italic", "tlg_framework"),"Overlock:tlg://fonts.gstatic.com/s/overlock/v5/YPJCVTT8ZbG3899l_-KIGqCWcynf_cDxXwCLxiixG1c.ttf:tlg:900" => esc_html__( "Overlock - 900", "tlg_framework"),"Overlock:tlg://fonts.gstatic.com/s/overlock/v5/iOZhxT2zlg7W5ij_lb-oDp0EAVxt0G0biEntp43Qt6E.ttf:tlg:900italic" => esc_html__( "Overlock - 900italic", "tlg_framework"),"Overlock SC:tlg://fonts.gstatic.com/s/overlocksc/v5/8D7HYDsvS_g1GhBnlHzgzaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Overlock SC - regular", "tlg_framework"),"Ovo:tlg://fonts.gstatic.com/s/ovo/v7/mFg27dimu3s9t09qjCwB1g.ttf:tlg:regular" => esc_html__( "Ovo - regular", "tlg_framework"),"Oxygen:tlg://fonts.gstatic.com/s/oxygen/v5/lZ31r0bR1Bzt_DfGZu1S8A.ttf:tlg:300" => esc_html__( "Oxygen - 300", "tlg_framework"),"Oxygen:tlg://fonts.gstatic.com/s/oxygen/v5/uhoyAE7XlQL22abzQieHjw.ttf:tlg:regular" => esc_html__( "Oxygen - regular", "tlg_framework"),"Oxygen:tlg://fonts.gstatic.com/s/oxygen/v5/yLqkmDwuNtt5pSqsJmhyrg.ttf:tlg:700" => esc_html__( "Oxygen - 700", "tlg_framework"),"Oxygen Mono:tlg://fonts.gstatic.com/s/oxygenmono/v4/DigTu7k4b7OmM8ubt1Qza6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Oxygen Mono - regular", "tlg_framework"),"PT Mono:tlg://fonts.gstatic.com/s/ptmono/v4/QUbM8H9yJK5NhpQ0REO6Wg.ttf:tlg:regular" => esc_html__( "PT Mono - regular", "tlg_framework"),"PT Sans:tlg://fonts.gstatic.com/s/ptsans/v8/UFoEz2uiuMypUGZL1NKoeg.ttf:tlg:regular" => esc_html__( "PT Sans - regular", "tlg_framework"),"PT Sans:tlg://fonts.gstatic.com/s/ptsans/v8/yls9EYWOd496wiu7qzfgNg.ttf:tlg:italic" => esc_html__( "PT Sans - italic", "tlg_framework"),"PT Sans:tlg://fonts.gstatic.com/s/ptsans/v8/F51BEgHuR0tYHxF0bD4vwvesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "PT Sans - 700", "tlg_framework"),"PT Sans:tlg://fonts.gstatic.com/s/ptsans/v8/lILlYDvubYemzYzN7GbLkC3USBnSvpkopQaUR-2r7iU.ttf:tlg:700italic" => esc_html__( "PT Sans - 700italic", "tlg_framework"),"PT Sans Caption:tlg://fonts.gstatic.com/s/ptsanscaption/v9/OXYTDOzBcXU8MTNBvBHeSW8by34Z3mUMtM-o4y-SHCY.ttf:tlg:regular" => esc_html__( "PT Sans Caption - regular", "tlg_framework"),"PT Sans Caption:tlg://fonts.gstatic.com/s/ptsanscaption/v9/Q-gJrFokeE7JydPpxASt25tc0eyfI4QDEsobEEpk_hA.ttf:tlg:700" => esc_html__( "PT Sans Caption - 700", "tlg_framework"),"PT Sans Narrow:tlg://fonts.gstatic.com/s/ptsansnarrow/v7/UyYrYy3ltEffJV9QueSi4ZTvAuddT2xDMbdz0mdLyZY.ttf:tlg:regular" => esc_html__( "PT Sans Narrow - regular", "tlg_framework"),"PT Sans Narrow:tlg://fonts.gstatic.com/s/ptsansnarrow/v7/Q_pTky3Sc3ubRibGToTAYsLtdzs3iyjn_YuT226ZsLU.ttf:tlg:700" => esc_html__( "PT Sans Narrow - 700", "tlg_framework"),"PT Serif:tlg://fonts.gstatic.com/s/ptserif/v8/sAo427rn3-QL9sWCbMZXhA.ttf:tlg:regular" => esc_html__( "PT Serif - regular", "tlg_framework"),"PT Serif:tlg://fonts.gstatic.com/s/ptserif/v8/9khWhKzhpkH0OkNnBKS3n_esZW2xOQ-xsNqO47m55DA.ttf:tlg:italic" => esc_html__( "PT Serif - italic", "tlg_framework"),"PT Serif:tlg://fonts.gstatic.com/s/ptserif/v8/kyZw18tqQ5if-_wpmxxOeKCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "PT Serif - 700", "tlg_framework"),"PT Serif:tlg://fonts.gstatic.com/s/ptserif/v8/Foydq9xJp--nfYIx2TBz9QJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700italic" => esc_html__( "PT Serif - 700italic", "tlg_framework"),"PT Serif Caption:tlg://fonts.gstatic.com/s/ptserifcaption/v8/7xkFOeTxxO1GMC1suOUYWVsRioCqs5fohhaYel24W3k.ttf:tlg:regular" => esc_html__( "PT Serif Caption - regular", "tlg_framework"),"PT Serif Caption:tlg://fonts.gstatic.com/s/ptserifcaption/v8/0kfPsmrmTSgiec7u_Wa0DB1mqvzPHelJwRcF_s_EUM0.ttf:tlg:italic" => esc_html__( "PT Serif Caption - italic", "tlg_framework"),"Pacifico:tlg://fonts.gstatic.com/s/pacifico/v7/GIrpeRY1r5CzbfL8r182lw.ttf:tlg:regular" => esc_html__( "Pacifico - regular", "tlg_framework"),"Palanquin:tlg://fonts.gstatic.com/s/palanquin/v1/Hu0eGDVGK_g4saUFu6AK3KCWcynf_cDxXwCLxiixG1c.ttf:tlg:100" => esc_html__( "Palanquin - 100", "tlg_framework"),"Palanquin:tlg://fonts.gstatic.com/s/palanquin/v1/pqXYXD7-VI5ezTjeqQOcyC3USBnSvpkopQaUR-2r7iU.ttf:tlg:200" => esc_html__( "Palanquin - 200", "tlg_framework"),"Palanquin:tlg://fonts.gstatic.com/s/palanquin/v1/c0-J5OCAagpFCKkKraz-Ey3USBnSvpkopQaUR-2r7iU.ttf:tlg:300" => esc_html__( "Palanquin - 300", "tlg_framework"),"Palanquin:tlg://fonts.gstatic.com/s/palanquin/v1/xCwBUoAEV0kzCDwerAZ0Aw.ttf:tlg:regular" => esc_html__( "Palanquin - regular", "tlg_framework"),"Palanquin:tlg://fonts.gstatic.com/s/palanquin/v1/wLvvkEcZMKy95afLWh2EfC3USBnSvpkopQaUR-2r7iU.ttf:tlg:500" => esc_html__( "Palanquin - 500", "tlg_framework"),"Palanquin:tlg://fonts.gstatic.com/s/palanquin/v1/405UIAv95_yZkCECrH6y-i3USBnSvpkopQaUR-2r7iU.ttf:tlg:600" => esc_html__( "Palanquin - 600", "tlg_framework"),"Palanquin:tlg://fonts.gstatic.com/s/palanquin/v1/-UtkePo3NFvxEN3rGCtTvi3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Palanquin - 700", "tlg_framework"),"Palanquin Dark:tlg://fonts.gstatic.com/s/palanquindark/v1/PamTqrrgbBh_M3702w39rOfChn3JSg5yz_Q_xmrKQN0.ttf:tlg:regular" => esc_html__( "Palanquin Dark - regular", "tlg_framework"),"Palanquin Dark:tlg://fonts.gstatic.com/s/palanquindark/v1/iXyBGf5UbFUu6BG8hOY-maMZTo-EwKMRQt3RWHocLi0.ttf:tlg:500" => esc_html__( "Palanquin Dark - 500", "tlg_framework"),"Palanquin Dark:tlg://fonts.gstatic.com/s/palanquindark/v1/iXyBGf5UbFUu6BG8hOY-mVNxaunw8i4Gywrk2SigRnk.ttf:tlg:600" => esc_html__( "Palanquin Dark - 600", "tlg_framework"),"Palanquin Dark:tlg://fonts.gstatic.com/s/palanquindark/v1/iXyBGf5UbFUu6BG8hOY-mWToair6W0TEE44XrlfKbiM.ttf:tlg:700" => esc_html__( "Palanquin Dark - 700", "tlg_framework"),"Paprika:tlg://fonts.gstatic.com/s/paprika/v4/b-VpyoRSieBdB5BPJVF8HQ.ttf:tlg:regular" => esc_html__( "Paprika - regular", "tlg_framework"),"Parisienne:tlg://fonts.gstatic.com/s/parisienne/v4/TW74B5QISJNx9moxGlmJfvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Parisienne - regular", "tlg_framework"),"Passero One:tlg://fonts.gstatic.com/s/passeroone/v8/Yc-7nH5deCCv9Ed0MMnAQqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Passero One - regular", "tlg_framework"),"Passion One:tlg://fonts.gstatic.com/s/passionone/v6/1UIK1tg3bKJ4J3o35M4heqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Passion One - regular", "tlg_framework"),"Passion One:tlg://fonts.gstatic.com/s/passionone/v6/feOcYDy2R-f3Ysy72PYJ2ne1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Passion One - 700", "tlg_framework"),"Passion One:tlg://fonts.gstatic.com/s/passionone/v6/feOcYDy2R-f3Ysy72PYJ2ienaqEuufTBk9XMKnKmgDA.ttf:tlg:900" => esc_html__( "Passion One - 900", "tlg_framework"),"Pathway Gothic One:tlg://fonts.gstatic.com/s/pathwaygothicone/v4/Lqv9ztoTUV8Q0FmQZzPqaA6A6xIYD7vYcYDop1i-K-c.ttf:tlg:regular" => esc_html__( "Pathway Gothic One - regular", "tlg_framework"),"Patrick Hand:tlg://fonts.gstatic.com/s/patrickhand/v10/9BG3JJgt_HlF3NpEUehL0C3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Patrick Hand - regular", "tlg_framework"),"Patrick Hand SC:tlg://fonts.gstatic.com/s/patrickhandsc/v4/OYFWCgfCR-7uHIovjUZXsbAgSRh1LpJXlLfl8IbsmHg.ttf:tlg:regular" => esc_html__( "Patrick Hand SC - regular", "tlg_framework"),"Patua One:tlg://fonts.gstatic.com/s/patuaone/v6/njZwotTYjswR4qdhsW-kJw.ttf:tlg:regular" => esc_html__( "Patua One - regular", "tlg_framework"),"Paytone One:tlg://fonts.gstatic.com/s/paytoneone/v8/3WCxC7JAJjQHQVoIE0ZwvqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Paytone One - regular", "tlg_framework"),"Peddana:tlg://fonts.gstatic.com/s/peddana/v4/zaSZuj_GhmC8AOTugOROnA.ttf:tlg:regular" => esc_html__( "Peddana - regular", "tlg_framework"),"Peralta:tlg://fonts.gstatic.com/s/peralta/v4/cTJX5KEuc0GKRU9NXSm-8Q.ttf:tlg:regular" => esc_html__( "Peralta - regular", "tlg_framework"),"Permanent Marker:tlg://fonts.gstatic.com/s/permanentmarker/v5/9vYsg5VgPHKK8SXYbf3sMol14xj5tdg9OHF8w4E7StQ.ttf:tlg:regular" => esc_html__( "Permanent Marker - regular", "tlg_framework"),"Petit Formal Script:tlg://fonts.gstatic.com/s/petitformalscript/v4/OEZwr2-ovBsq2n3ACCKoEvVPl2Gjtxj0D6F7QLy1VQc.ttf:tlg:regular" => esc_html__( "Petit Formal Script - regular", "tlg_framework"),"Petrona:tlg://fonts.gstatic.com/s/petrona/v5/nnQwxlP6dhrGovYEFtemTg.ttf:tlg:regular" => esc_html__( "Petrona - regular", "tlg_framework"),"Philosopher:tlg://fonts.gstatic.com/s/philosopher/v7/oZLTrB9jmJsyV0u_T0TKEaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Philosopher - regular", "tlg_framework"),"Philosopher:tlg://fonts.gstatic.com/s/philosopher/v7/_9Hnc_gz9k7Qq6uKaeHKmUeOrDcLawS7-ssYqLr2Xp4.ttf:tlg:italic" => esc_html__( "Philosopher - italic", "tlg_framework"),"Philosopher:tlg://fonts.gstatic.com/s/philosopher/v7/napvkewXG9Gqby5vwGHICHe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Philosopher - 700", "tlg_framework"),"Philosopher:tlg://fonts.gstatic.com/s/philosopher/v7/PuKlryTcvTj7-qZWfLCFIM_zJjSACmk0BRPxQqhnNLU.ttf:tlg:700italic" => esc_html__( "Philosopher - 700italic", "tlg_framework"),"Piedra:tlg://fonts.gstatic.com/s/piedra/v5/owf-AvEEyAj9LJ2tVZ_3Mw.ttf:tlg:regular" => esc_html__( "Piedra - regular", "tlg_framework"),"Pinyon Script:tlg://fonts.gstatic.com/s/pinyonscript/v6/TzghnhfCn7TuE73f-CBQ0CeUSrabuTpOsMEiRLtKwk0.ttf:tlg:regular" => esc_html__( "Pinyon Script - regular", "tlg_framework"),"Pirata One:tlg://fonts.gstatic.com/s/pirataone/v4/WnbD86B4vB2ckYcL7oxuhvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Pirata One - regular", "tlg_framework"),"Plaster:tlg://fonts.gstatic.com/s/plaster/v7/O4QG9Z5116CXyfJdR9zxLw.ttf:tlg:regular" => esc_html__( "Plaster - regular", "tlg_framework"),"Play:tlg://fonts.gstatic.com/s/play/v7/GWvfObW8LhtsOX333MCpBg.ttf:tlg:regular" => esc_html__( "Play - regular", "tlg_framework"),"Play:tlg://fonts.gstatic.com/s/play/v7/crPhg6I0alLI-MpB3vW-zw.ttf:tlg:700" => esc_html__( "Play - 700", "tlg_framework"),"Playball:tlg://fonts.gstatic.com/s/playball/v6/3hOFiQm_EUzycTpcN9uz4w.ttf:tlg:regular" => esc_html__( "Playball - regular", "tlg_framework"),"Playfair Display:tlg://fonts.gstatic.com/s/playfairdisplay/v10/2NBgzUtEeyB-Xtpr9bm1CV6uyC_qD11hrFQ6EGgTJWI.ttf:tlg:regular" => esc_html__( "Playfair Display - regular", "tlg_framework"),"Playfair Display:tlg://fonts.gstatic.com/s/playfairdisplay/v10/9MkijrV-dEJ0-_NWV7E6NzMsbnvDNEBX25F5HWk9AhI.ttf:tlg:italic" => esc_html__( "Playfair Display - italic", "tlg_framework"),"Playfair Display:tlg://fonts.gstatic.com/s/playfairdisplay/v10/UC3ZEjagJi85gF9qFaBgICsv6SrURqJprbhH_C1Mw8w.ttf:tlg:700" => esc_html__( "Playfair Display - 700", "tlg_framework"),"Playfair Display:tlg://fonts.gstatic.com/s/playfairdisplay/v10/n7G4PqJvFP2Kubl0VBLDECsYW3XoOVcYyYdp9NzzS9E.ttf:tlg:700italic" => esc_html__( "Playfair Display - 700italic", "tlg_framework"),"Playfair Display:tlg://fonts.gstatic.com/s/playfairdisplay/v10/UC3ZEjagJi85gF9qFaBgIKqwMe2wjvZrAR44M0BJZ48.ttf:tlg:900" => esc_html__( "Playfair Display - 900", "tlg_framework"),"Playfair Display:tlg://fonts.gstatic.com/s/playfairdisplay/v10/n7G4PqJvFP2Kubl0VBLDEC0JfJ4xmm7j1kL6D7mPxrA.ttf:tlg:900italic" => esc_html__( "Playfair Display - 900italic", "tlg_framework"),"Playfair Display SC:tlg://fonts.gstatic.com/s/playfairdisplaysc/v5/G0-tvBxd4eQRdwFKB8dRkcpjYTDWIvcAwAccqeW9uNM.ttf:tlg:regular" => esc_html__( "Playfair Display SC - regular", "tlg_framework"),"Playfair Display SC:tlg://fonts.gstatic.com/s/playfairdisplaysc/v5/myuYiFR-4NTrUT4w6TKls2klJsJYggW8rlNoTOTuau0.ttf:tlg:italic" => esc_html__( "Playfair Display SC - italic", "tlg_framework"),"Playfair Display SC:tlg://fonts.gstatic.com/s/playfairdisplaysc/v5/5ggqGkvWJU_TtW2W8cEubA-Amcyomnuy4WsCiPxGHjw.ttf:tlg:700" => esc_html__( "Playfair Display SC - 700", "tlg_framework"),"Playfair Display SC:tlg://fonts.gstatic.com/s/playfairdisplaysc/v5/6X0OQrQhEEnPo56RalREX4krgPi80XvBcbTwmz-rgmU.ttf:tlg:700italic" => esc_html__( "Playfair Display SC - 700italic", "tlg_framework"),"Playfair Display SC:tlg://fonts.gstatic.com/s/playfairdisplaysc/v5/5ggqGkvWJU_TtW2W8cEubKXL3C32k275YmX_AcBPZ7w.ttf:tlg:900" => esc_html__( "Playfair Display SC - 900", "tlg_framework"),"Playfair Display SC:tlg://fonts.gstatic.com/s/playfairdisplaysc/v5/6X0OQrQhEEnPo56RalREX8Zag2q3ssKz8uH1RU4a9gs.ttf:tlg:900italic" => esc_html__( "Playfair Display SC - 900italic", "tlg_framework"),"Podkova:tlg://fonts.gstatic.com/s/podkova/v8/eylljyGVfB8ZUQjYY3WZRQ.ttf:tlg:regular" => esc_html__( "Podkova - regular", "tlg_framework"),"Podkova:tlg://fonts.gstatic.com/s/podkova/v8/SqW4aa8m_KVrOgYSydQ33vesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Podkova - 700", "tlg_framework"),"Poiret One:tlg://fonts.gstatic.com/s/poiretone/v4/dWcYed048E5gHGDIt8i1CPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Poiret One - regular", "tlg_framework"),"Poller One:tlg://fonts.gstatic.com/s/pollerone/v6/dkctmDlTPcZ6boC8662RA_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Poller One - regular", "tlg_framework"),"Poly:tlg://fonts.gstatic.com/s/poly/v7/bcMAuiacS2qkd54BcwW6_Q.ttf:tlg:regular" => esc_html__( "Poly - regular", "tlg_framework"),"Poly:tlg://fonts.gstatic.com/s/poly/v7/Zkx-eIlZSjKUrPGYhV5PeA.ttf:tlg:italic" => esc_html__( "Poly - italic", "tlg_framework"),"Pompiere:tlg://fonts.gstatic.com/s/pompiere/v6/o_va2p9CD5JfmFohAkGZIA.ttf:tlg:regular" => esc_html__( "Pompiere - regular", "tlg_framework"),"Pontano Sans:tlg://fonts.gstatic.com/s/pontanosans/v4/gTHiwyxi6S7iiHpqAoiE3C3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Pontano Sans - regular", "tlg_framework"),"Poppins:tlg://fonts.gstatic.com/s/poppins/v1/VIeViZ2fPtYBt3B2fQZplvesZW2xOQ-xsNqO47m55DA.ttf:tlg:300" => esc_html__( "Poppins - 300", "tlg_framework"),"Poppins:tlg://fonts.gstatic.com/s/poppins/v1/hlvAxH6aIdOjWlLzgm0jqg.ttf:tlg:regular" => esc_html__( "Poppins - regular", "tlg_framework"),"Poppins:tlg://fonts.gstatic.com/s/poppins/v1/4WGKlFyjcmCFVl8pRsgZ9vesZW2xOQ-xsNqO47m55DA.ttf:tlg:500" => esc_html__( "Poppins - 500", "tlg_framework"),"Poppins:tlg://fonts.gstatic.com/s/poppins/v1/-zOABrCWORC3lyDh-ajNnPesZW2xOQ-xsNqO47m55DA.ttf:tlg:600" => esc_html__( "Poppins - 600", "tlg_framework"),"Poppins:tlg://fonts.gstatic.com/s/poppins/v1/8JitanEsk5aDh7mDYs-fYfesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Poppins - 700", "tlg_framework"),"Port Lligat Sans:tlg://fonts.gstatic.com/s/portlligatsans/v5/CUEdhRk7oC7up0p6t0g4P6mASEpx5X0ZpsuJOuvfOGA.ttf:tlg:regular" => esc_html__( "Port Lligat Sans - regular", "tlg_framework"),"Port Lligat Slab:tlg://fonts.gstatic.com/s/portlligatslab/v5/CUEdhRk7oC7up0p6t0g4PxLSPACXvawUYCBEnHsOe30.ttf:tlg:regular" => esc_html__( "Port Lligat Slab - regular", "tlg_framework"),"Pragati Narrow:tlg://fonts.gstatic.com/s/pragatinarrow/v2/HzG2TfC862qPNsZsV_djPpTvAuddT2xDMbdz0mdLyZY.ttf:tlg:regular" => esc_html__( "Pragati Narrow - regular", "tlg_framework"),"Pragati Narrow:tlg://fonts.gstatic.com/s/pragatinarrow/v2/DnSI1zRkc0CY-hI5SC3q3MLtdzs3iyjn_YuT226ZsLU.ttf:tlg:700" => esc_html__( "Pragati Narrow - 700", "tlg_framework"),"Prata:tlg://fonts.gstatic.com/s/prata/v6/3gmx8r842loRRm9iQkCDGg.ttf:tlg:regular" => esc_html__( "Prata - regular", "tlg_framework"),"Preahvihear:tlg://fonts.gstatic.com/s/preahvihear/v8/82tDI-xTc53CxxOzEG4hDaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Preahvihear - regular", "tlg_framework"),"Press Start 2P:tlg://fonts.gstatic.com/s/pressstart2p/v4/8Lg6LX8-ntOHUQnvQ0E7o1jfl3W46Sz5gOkEVhcFWF4.ttf:tlg:regular" => esc_html__( "Press Start 2P - regular", "tlg_framework"),"Princess Sofia:tlg://fonts.gstatic.com/s/princesssofia/v4/8g5l8r9BM0t1QsXLTajDe-wjmA7ie-lFcByzHGRhCIg.ttf:tlg:regular" => esc_html__( "Princess Sofia - regular", "tlg_framework"),"Prociono:tlg://fonts.gstatic.com/s/prociono/v6/43ZYDHWogdFeNBWTl6ksmw.ttf:tlg:regular" => esc_html__( "Prociono - regular", "tlg_framework"),"Prosto One:tlg://fonts.gstatic.com/s/prostoone/v5/bsqnAElAqk9kX7eABTRFJPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Prosto One - regular", "tlg_framework"),"Puritan:tlg://fonts.gstatic.com/s/puritan/v8/wv_RtgVBSCn-or2MC0n4Kg.ttf:tlg:regular" => esc_html__( "Puritan - regular", "tlg_framework"),"Puritan:tlg://fonts.gstatic.com/s/puritan/v8/BqZX8Tp200LeMv1KlzXgLQ.ttf:tlg:italic" => esc_html__( "Puritan - italic", "tlg_framework"),"Puritan:tlg://fonts.gstatic.com/s/puritan/v8/pJS2SdwI0SCiVnO0iQSFT_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Puritan - 700", "tlg_framework"),"Puritan:tlg://fonts.gstatic.com/s/puritan/v8/rFG3XkMJL75nUNZwCEIJqC3USBnSvpkopQaUR-2r7iU.ttf:tlg:700italic" => esc_html__( "Puritan - 700italic", "tlg_framework"),"Purple Purse:tlg://fonts.gstatic.com/s/purplepurse/v5/Q5heFUrdmei9axbMITxxxS3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Purple Purse - regular", "tlg_framework"),"Quando:tlg://fonts.gstatic.com/s/quando/v4/03nDiEZuO2-h3xvtG6UmHg.ttf:tlg:regular" => esc_html__( "Quando - regular", "tlg_framework"),"Quantico:tlg://fonts.gstatic.com/s/quantico/v5/pwSnP8Xpaix2rIz99HrSlQ.ttf:tlg:regular" => esc_html__( "Quantico - regular", "tlg_framework"),"Quantico:tlg://fonts.gstatic.com/s/quantico/v5/KQhDd2OsZi6HiITUeFQ2U_esZW2xOQ-xsNqO47m55DA.ttf:tlg:italic" => esc_html__( "Quantico - italic", "tlg_framework"),"Quantico:tlg://fonts.gstatic.com/s/quantico/v5/OVZZzjcZ3Hkq2ojVcUtDjaCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Quantico - 700", "tlg_framework"),"Quantico:tlg://fonts.gstatic.com/s/quantico/v5/HeCYRcZbdRso3ZUu01ELbQJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700italic" => esc_html__( "Quantico - 700italic", "tlg_framework"),"Quattrocento:tlg://fonts.gstatic.com/s/quattrocento/v7/WZDISdyil4HsmirlOdBRFC3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Quattrocento - regular", "tlg_framework"),"Quattrocento:tlg://fonts.gstatic.com/s/quattrocento/v7/Uvi-cRwyvqFpl9j3oT2mqkD2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Quattrocento - 700", "tlg_framework"),"Quattrocento Sans:tlg://fonts.gstatic.com/s/quattrocentosans/v8/efd6FGWWGX5Z3ztwLBrG9eAj_ty82iuwwDTNEYXGiyQ.ttf:tlg:regular" => esc_html__( "Quattrocento Sans - regular", "tlg_framework"),"Quattrocento Sans:tlg://fonts.gstatic.com/s/quattrocentosans/v8/8PXYbvM__bjl0rBnKiByg532VBCoA_HLsn85tSWZmdo.ttf:tlg:italic" => esc_html__( "Quattrocento Sans - italic", "tlg_framework"),"Quattrocento Sans:tlg://fonts.gstatic.com/s/quattrocentosans/v8/tXSgPxDl7Lk8Zr_5qX8FIbqxG25nQNOioCZSK4sU-CA.ttf:tlg:700" => esc_html__( "Quattrocento Sans - 700", "tlg_framework"),"Quattrocento Sans:tlg://fonts.gstatic.com/s/quattrocentosans/v8/8N1PdXpbG6RtFvTjl-5E7buqAJxizi8Dk_SK5et7kMg.ttf:tlg:700italic" => esc_html__( "Quattrocento Sans - 700italic", "tlg_framework"),"Questrial:tlg://fonts.gstatic.com/s/questrial/v6/MoHHaw_WwNs_hd9ob1zTVw.ttf:tlg:regular" => esc_html__( "Questrial - regular", "tlg_framework"),"Quicksand:tlg://fonts.gstatic.com/s/quicksand/v5/qhfoJiLu10kFjChCCTvGlC3USBnSvpkopQaUR-2r7iU.ttf:tlg:300" => esc_html__( "Quicksand - 300", "tlg_framework"),"Quicksand:tlg://fonts.gstatic.com/s/quicksand/v5/Ngv3fIJjKB7sD-bTUGIFCA.ttf:tlg:regular" => esc_html__( "Quicksand - regular", "tlg_framework"),"Quicksand:tlg://fonts.gstatic.com/s/quicksand/v5/32nyIRHyCu6iqEka_hbKsi3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Quicksand - 700", "tlg_framework"),"Quintessential:tlg://fonts.gstatic.com/s/quintessential/v4/mmk6ioesnTrEky_Zb92E5s02lXbtMOtZWfuxKeMZO8Q.ttf:tlg:regular" => esc_html__( "Quintessential - regular", "tlg_framework"),"Qwigley:tlg://fonts.gstatic.com/s/qwigley/v6/aDqxws-KubFID85TZHFouw.ttf:tlg:regular" => esc_html__( "Qwigley - regular", "tlg_framework"),"Racing Sans One:tlg://fonts.gstatic.com/s/racingsansone/v4/1r3DpWaCiT7y3PD4KgkNyDjVlsJB_M_Q_LtZxsoxvlw.ttf:tlg:regular" => esc_html__( "Racing Sans One - regular", "tlg_framework"),"Radley:tlg://fonts.gstatic.com/s/radley/v9/FgE9di09a-mXGzAIyI6Q9Q.ttf:tlg:regular" => esc_html__( "Radley - regular", "tlg_framework"),"Radley:tlg://fonts.gstatic.com/s/radley/v9/Z_JcACuPAOO2f9kzQcGRug.ttf:tlg:italic" => esc_html__( "Radley - italic", "tlg_framework"),"Rajdhani:tlg://fonts.gstatic.com/s/rajdhani/v5/9pItuEhQZVGdq8spnHTku6CWcynf_cDxXwCLxiixG1c.ttf:tlg:300" => esc_html__( "Rajdhani - 300", "tlg_framework"),"Rajdhani:tlg://fonts.gstatic.com/s/rajdhani/v5/Wfy5zp4PGFAFS7-Wetehzw.ttf:tlg:regular" => esc_html__( "Rajdhani - regular", "tlg_framework"),"Rajdhani:tlg://fonts.gstatic.com/s/rajdhani/v5/nd_5ZpVwm710HcLual0fBqCWcynf_cDxXwCLxiixG1c.ttf:tlg:500" => esc_html__( "Rajdhani - 500", "tlg_framework"),"Rajdhani:tlg://fonts.gstatic.com/s/rajdhani/v5/5fnmZahByDeTtgxIiqbJSaCWcynf_cDxXwCLxiixG1c.ttf:tlg:600" => esc_html__( "Rajdhani - 600", "tlg_framework"),"Rajdhani:tlg://fonts.gstatic.com/s/rajdhani/v5/UBK6d2Hg7X7wYLlF92aXW6CWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Rajdhani - 700", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/UDfD6oxBaBnmFJwQ7XAFNw.ttf:tlg:100" => esc_html__( "Raleway - 100", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/hUpHtml6IPNuUR-FwVi2UKCWcynf_cDxXwCLxiixG1c.ttf:tlg:100italic" => esc_html__( "Raleway - 100italic", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/LAQwev4hdCtYkOYX4Oc7nPesZW2xOQ-xsNqO47m55DA.ttf:tlg:200" => esc_html__( "Raleway - 200", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/N2DIbZG4399cPGfifZUEQi3USBnSvpkopQaUR-2r7iU.ttf:tlg:200italic" => esc_html__( "Raleway - 200italic", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/2VvSZU2kb4DZwFfRM4fLQPesZW2xOQ-xsNqO47m55DA.ttf:tlg:300" => esc_html__( "Raleway - 300", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/TVSB8ogXDKMcnAAJ5CqrUi3USBnSvpkopQaUR-2r7iU.ttf:tlg:300italic" => esc_html__( "Raleway - 300italic", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/_dCzxpXzIS3sL-gdJWAP8A.ttf:tlg:regular" => esc_html__( "Raleway - regular", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/utU2m1gdZSfuQpArSy5Dbw.ttf:tlg:italic" => esc_html__( "Raleway - italic", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/348gn6PEmbLDWlHbbV15d_esZW2xOQ-xsNqO47m55DA.ttf:tlg:500" => esc_html__( "Raleway - 500", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/S7vGLZZ40c85SJgiptJGVy3USBnSvpkopQaUR-2r7iU.ttf:tlg:500italic" => esc_html__( "Raleway - 500italic", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/M7no6oPkwKYJkedjB1wqEvesZW2xOQ-xsNqO47m55DA.ttf:tlg:600" => esc_html__( "Raleway - 600", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/OY22yoG8EJ3IN_muVWm29C3USBnSvpkopQaUR-2r7iU.ttf:tlg:600italic" => esc_html__( "Raleway - 600italic", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/VGEV9-DrblisWOWLbK-1XPesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Raleway - 700", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/lFxvRPuGFG5ktd7P0WRwKi3USBnSvpkopQaUR-2r7iU.ttf:tlg:700italic" => esc_html__( "Raleway - 700italic", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/mMh0JrsYMXcLO69jgJwpUvesZW2xOQ-xsNqO47m55DA.ttf:tlg:800" => esc_html__( "Raleway - 800", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/us4LjTCmlYgh3W8CKujEJi3USBnSvpkopQaUR-2r7iU.ttf:tlg:800italic" => esc_html__( "Raleway - 800italic", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/ajQQGcDBLcyLpaUfD76UuPesZW2xOQ-xsNqO47m55DA.ttf:tlg:900" => esc_html__( "Raleway - 900", "tlg_framework"),"Raleway:tlg://fonts.gstatic.com/s/raleway/v10/oY2RadnkHfshu5f0FLsgVS3USBnSvpkopQaUR-2r7iU.ttf:tlg:900italic" => esc_html__( "Raleway - 900italic", "tlg_framework"),"Raleway Dots:tlg://fonts.gstatic.com/s/ralewaydots/v4/lhLgmWCRcyz-QXo8LCzTfC3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Raleway Dots - regular", "tlg_framework"),"Ramabhadra:tlg://fonts.gstatic.com/s/ramabhadra/v5/JyhxLXRVQChLDGADS_c5MPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Ramabhadra - regular", "tlg_framework"),"Ramaraja:tlg://fonts.gstatic.com/s/ramaraja/v1/XIqzxFapVczstBedHdQTiw.ttf:tlg:regular" => esc_html__( "Ramaraja - regular", "tlg_framework"),"Rambla:tlg://fonts.gstatic.com/s/rambla/v4/YaTmpvm5gFg_ShJKTQmdzg.ttf:tlg:regular" => esc_html__( "Rambla - regular", "tlg_framework"),"Rambla:tlg://fonts.gstatic.com/s/rambla/v4/mhUgsKmp0qw3uATdDDAuwA.ttf:tlg:italic" => esc_html__( "Rambla - italic", "tlg_framework"),"Rambla:tlg://fonts.gstatic.com/s/rambla/v4/C5VZH8BxQKmnBuoC00UPpw.ttf:tlg:700" => esc_html__( "Rambla - 700", "tlg_framework"),"Rambla:tlg://fonts.gstatic.com/s/rambla/v4/ziMzUZya6QahrKONSI1TzqCWcynf_cDxXwCLxiixG1c.ttf:tlg:700italic" => esc_html__( "Rambla - 700italic", "tlg_framework"),"Rammetto One:tlg://fonts.gstatic.com/s/rammettoone/v5/mh0uQ1tV8QgSx9v_KyEYPC3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Rammetto One - regular", "tlg_framework"),"Ranchers:tlg://fonts.gstatic.com/s/ranchers/v4/9ya8CZYhqT66VERfjQ7eLA.ttf:tlg:regular" => esc_html__( "Ranchers - regular", "tlg_framework"),"Rancho:tlg://fonts.gstatic.com/s/rancho/v6/ekp3-4QykC4--6KaslRgHA.ttf:tlg:regular" => esc_html__( "Rancho - regular", "tlg_framework"),"Ranga:tlg://fonts.gstatic.com/s/ranga/v1/xpW6zFTNzY1JykoBIqE1Zg.ttf:tlg:regular" => esc_html__( "Ranga - regular", "tlg_framework"),"Ranga:tlg://fonts.gstatic.com/s/ranga/v1/h8G_gEUH7vHKH-NkjAs34A.ttf:tlg:700" => esc_html__( "Ranga - 700", "tlg_framework"),"Rationale:tlg://fonts.gstatic.com/s/rationale/v7/7M2eN-di0NGLQse7HzJRfg.ttf:tlg:regular" => esc_html__( "Rationale - regular", "tlg_framework"),"Ravi Prakash:tlg://fonts.gstatic.com/s/raviprakash/v3/8EzbM7Rymjk25jWeHxbO6C3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Ravi Prakash - regular", "tlg_framework"),"Redressed:tlg://fonts.gstatic.com/s/redressed/v6/3aZ5sTBppH3oSm5SabegtA.ttf:tlg:regular" => esc_html__( "Redressed - regular", "tlg_framework"),"Reenie Beanie:tlg://fonts.gstatic.com/s/reeniebeanie/v7/ljpKc6CdXusL1cnGUSamX4jjx0o0jr6fNXxPgYh_a8Q.ttf:tlg:regular" => esc_html__( "Reenie Beanie - regular", "tlg_framework"),"Revalia:tlg://fonts.gstatic.com/s/revalia/v4/1TKw66fF5_poiL0Ktgo4_A.ttf:tlg:regular" => esc_html__( "Revalia - regular", "tlg_framework"),"Rhodium Libre:tlg://fonts.gstatic.com/s/rhodiumlibre/v1/Vxr7A4-xE2zsBDDI8BcseIjjx0o0jr6fNXxPgYh_a8Q.ttf:tlg:regular" => esc_html__( "Rhodium Libre - regular", "tlg_framework"),"Ribeye:tlg://fonts.gstatic.com/s/ribeye/v5/e5w3VE8HnWBln4Ll6lUj3Q.ttf:tlg:regular" => esc_html__( "Ribeye - regular", "tlg_framework"),"Ribeye Marrow:tlg://fonts.gstatic.com/s/ribeyemarrow/v6/q7cBSA-4ErAXBCDFPrhlY0cTNmV93fYG7UKgsLQNQWs.ttf:tlg:regular" => esc_html__( "Ribeye Marrow - regular", "tlg_framework"),"Righteous:tlg://fonts.gstatic.com/s/righteous/v5/0nRRWM_gCGCt2S-BCfN8WQ.ttf:tlg:regular" => esc_html__( "Righteous - regular", "tlg_framework"),"Risque:tlg://fonts.gstatic.com/s/risque/v4/92RnElGnl8yHP97-KV3Fyg.ttf:tlg:regular" => esc_html__( "Risque - regular", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/7MygqTe2zs9YkP0adA9QQQ.ttf:tlg:100" => esc_html__( "Roboto - 100", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/T1xnudodhcgwXCmZQ490TPesZW2xOQ-xsNqO47m55DA.ttf:tlg:100italic" => esc_html__( "Roboto - 100italic", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/dtpHsbgPEm2lVWciJZ0P-A.ttf:tlg:300" => esc_html__( "Roboto - 300", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/iE8HhaRzdhPxC93dOdA056CWcynf_cDxXwCLxiixG1c.ttf:tlg:300italic" => esc_html__( "Roboto - 300italic", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/W5F8_SL0XFawnjxHGsZjJA.ttf:tlg:regular" => esc_html__( "Roboto - regular", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/hcKoSgxdnKlbH5dlTwKbow.ttf:tlg:italic" => esc_html__( "Roboto - italic", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/Uxzkqj-MIMWle-XP2pDNAA.ttf:tlg:500" => esc_html__( "Roboto - 500", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/daIfzbEw-lbjMyv4rMUUTqCWcynf_cDxXwCLxiixG1c.ttf:tlg:500italic" => esc_html__( "Roboto - 500italic", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/bdHGHleUa-ndQCOrdpfxfw.ttf:tlg:700" => esc_html__( "Roboto - 700", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/owYYXKukxFDFjr0ZO8NXh6CWcynf_cDxXwCLxiixG1c.ttf:tlg:700italic" => esc_html__( "Roboto - 700italic", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/H1vB34nOKWXqzKotq25pcg.ttf:tlg:900" => esc_html__( "Roboto - 900", "tlg_framework"),"Roboto:tlg://fonts.gstatic.com/s/roboto/v15/b9PWBSMHrT2zM5FgUdtu0aCWcynf_cDxXwCLxiixG1c.ttf:tlg:900italic" => esc_html__( "Roboto - 900italic", "tlg_framework"),"Roboto Condensed:tlg://fonts.gstatic.com/s/robotocondensed/v13/b9QBgL0iMZfDSpmcXcE8nJRhFVcex_hajThhFkHyhYk.ttf:tlg:300" => esc_html__( "Roboto Condensed - 300", "tlg_framework"),"Roboto Condensed:tlg://fonts.gstatic.com/s/robotocondensed/v13/mg0cGfGRUERshzBlvqxeAPYa9bgCHecWXGgisnodcS0.ttf:tlg:300italic" => esc_html__( "Roboto Condensed - 300italic", "tlg_framework"),"Roboto Condensed:tlg://fonts.gstatic.com/s/robotocondensed/v13/Zd2E9abXLFGSr9G3YK2MsKDbm6fPDOZJsR8PmdG62gY.ttf:tlg:regular" => esc_html__( "Roboto Condensed - regular", "tlg_framework"),"Roboto Condensed:tlg://fonts.gstatic.com/s/robotocondensed/v13/BP5K8ZAJv9qEbmuFp8RpJY_eiqgTfYGaH0bJiUDZ5GA.ttf:tlg:italic" => esc_html__( "Roboto Condensed - italic", "tlg_framework"),"Roboto Condensed:tlg://fonts.gstatic.com/s/robotocondensed/v13/b9QBgL0iMZfDSpmcXcE8nPOYkGiSOYDq_T7HbIOV1hA.ttf:tlg:700" => esc_html__( "Roboto Condensed - 700", "tlg_framework"),"Roboto Condensed:tlg://fonts.gstatic.com/s/robotocondensed/v13/mg0cGfGRUERshzBlvqxeAE2zk2RGRC3SlyyLLQfjS_8.ttf:tlg:700italic" => esc_html__( "Roboto Condensed - 700italic", "tlg_framework"),"Roboto Mono:tlg://fonts.gstatic.com/s/robotomono/v4/aOIeRp72J9_Hp_8KwQ9M-YAWxXGWZ3yJw6KhWS7MxOk.ttf:tlg:100" => esc_html__( "Roboto Mono - 100", "tlg_framework"),"Roboto Mono:tlg://fonts.gstatic.com/s/robotomono/v4/rqQ1zSE-ZGCKVZgew-A9dgyDtfpXZi-8rXUZYR4dumU.ttf:tlg:100italic" => esc_html__( "Roboto Mono - 100italic", "tlg_framework"),"Roboto Mono:tlg://fonts.gstatic.com/s/robotomono/v4/N4duVc9C58uwPiY8_59Fzy9-WlPSxbfiI49GsXo3q0g.ttf:tlg:300" => esc_html__( "Roboto Mono - 300", "tlg_framework"),"Roboto Mono:tlg://fonts.gstatic.com/s/robotomono/v4/1OsMuiiO6FCF2x67vzDKA2o9eWDfYYxG3A176Zl7aIg.ttf:tlg:300italic" => esc_html__( "Roboto Mono - 300italic", "tlg_framework"),"Roboto Mono:tlg://fonts.gstatic.com/s/robotomono/v4/eJ4cxQe85Lo39t-LVoKa26CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Roboto Mono - regular", "tlg_framework"),"Roboto Mono:tlg://fonts.gstatic.com/s/robotomono/v4/mE0EPT_93c7f86_WQexR3EeOrDcLawS7-ssYqLr2Xp4.ttf:tlg:italic" => esc_html__( "Roboto Mono - italic", "tlg_framework"),"Roboto Mono:tlg://fonts.gstatic.com/s/robotomono/v4/N4duVc9C58uwPiY8_59Fz8CNfqCYlB_eIx7H1TVXe60.ttf:tlg:500" => esc_html__( "Roboto Mono - 500", "tlg_framework"),"Roboto Mono:tlg://fonts.gstatic.com/s/robotomono/v4/1OsMuiiO6FCF2x67vzDKA2nWRcJAYo5PSCx8UfGMHCI.ttf:tlg:500italic" => esc_html__( "Roboto Mono - 500italic", "tlg_framework"),"Roboto Mono:tlg://fonts.gstatic.com/s/robotomono/v4/N4duVc9C58uwPiY8_59Fz3e1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Roboto Mono - 700", "tlg_framework"),"Roboto Mono:tlg://fonts.gstatic.com/s/robotomono/v4/1OsMuiiO6FCF2x67vzDKA8_zJjSACmk0BRPxQqhnNLU.ttf:tlg:700italic" => esc_html__( "Roboto Mono - 700italic", "tlg_framework"),"Roboto Slab:tlg://fonts.gstatic.com/s/robotoslab/v6/MEz38VLIFL-t46JUtkIEgIAWxXGWZ3yJw6KhWS7MxOk.ttf:tlg:100" => esc_html__( "Roboto Slab - 100", "tlg_framework"),"Roboto Slab:tlg://fonts.gstatic.com/s/robotoslab/v6/dazS1PrQQuCxC3iOAJFEJS9-WlPSxbfiI49GsXo3q0g.ttf:tlg:300" => esc_html__( "Roboto Slab - 300", "tlg_framework"),"Roboto Slab:tlg://fonts.gstatic.com/s/robotoslab/v6/3__ulTNA7unv0UtplybPiqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Roboto Slab - regular", "tlg_framework"),"Roboto Slab:tlg://fonts.gstatic.com/s/robotoslab/v6/dazS1PrQQuCxC3iOAJFEJXe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Roboto Slab - 700", "tlg_framework"),"Rochester:tlg://fonts.gstatic.com/s/rochester/v6/bnj8tmQBiOkdji_G_yvypg.ttf:tlg:regular" => esc_html__( "Rochester - regular", "tlg_framework"),"Rock Salt:tlg://fonts.gstatic.com/s/rocksalt/v6/Zy7JF9h9WbhD9V3SFMQ1UQ.ttf:tlg:regular" => esc_html__( "Rock Salt - regular", "tlg_framework"),"Rokkitt:tlg://fonts.gstatic.com/s/rokkitt/v10/GMA7Z_ToF8uSvpZAgnp_VQ.ttf:tlg:regular" => esc_html__( "Rokkitt - regular", "tlg_framework"),"Rokkitt:tlg://fonts.gstatic.com/s/rokkitt/v10/gxlo-sr3rPmvgSixYog_ofesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Rokkitt - 700", "tlg_framework"),"Romanesco:tlg://fonts.gstatic.com/s/romanesco/v5/2udIjUrpK_CPzYSxRVzD4Q.ttf:tlg:regular" => esc_html__( "Romanesco - regular", "tlg_framework"),"Ropa Sans:tlg://fonts.gstatic.com/s/ropasans/v5/Gba7ZzVBuhg6nX_AoSwlkQ.ttf:tlg:regular" => esc_html__( "Ropa Sans - regular", "tlg_framework"),"Ropa Sans:tlg://fonts.gstatic.com/s/ropasans/v5/V1zbhZQscNrh63dy5Jk2nqCWcynf_cDxXwCLxiixG1c.ttf:tlg:italic" => esc_html__( "Ropa Sans - italic", "tlg_framework"),"Rosario:tlg://fonts.gstatic.com/s/rosario/v11/bL-cEh8dXtDupB2WccA2LA.ttf:tlg:regular" => esc_html__( "Rosario - regular", "tlg_framework"),"Rosario:tlg://fonts.gstatic.com/s/rosario/v11/pkflNy18HEuVVx4EOjeb_Q.ttf:tlg:italic" => esc_html__( "Rosario - italic", "tlg_framework"),"Rosario:tlg://fonts.gstatic.com/s/rosario/v11/nrS6PJvDWN42RP4TFWccd_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Rosario - 700", "tlg_framework"),"Rosario:tlg://fonts.gstatic.com/s/rosario/v11/EOgFX2Va5VGrkhn_eDpIRS3USBnSvpkopQaUR-2r7iU.ttf:tlg:700italic" => esc_html__( "Rosario - 700italic", "tlg_framework"),"Rosarivo:tlg://fonts.gstatic.com/s/rosarivo/v4/EmPiINK0qyqc7KSsNjJamA.ttf:tlg:regular" => esc_html__( "Rosarivo - regular", "tlg_framework"),"Rosarivo:tlg://fonts.gstatic.com/s/rosarivo/v4/u3VuWsWQlX1pDqsbz4paNPesZW2xOQ-xsNqO47m55DA.ttf:tlg:italic" => esc_html__( "Rosarivo - italic", "tlg_framework"),"Rouge Script:tlg://fonts.gstatic.com/s/rougescript/v5/AgXDSqZJmy12qS0ixjs6Vy3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Rouge Script - regular", "tlg_framework"),"Rozha One:tlg://fonts.gstatic.com/s/rozhaone/v2/PyrMHQ6lucEIxwKmhqsX8A.ttf:tlg:regular" => esc_html__( "Rozha One - regular", "tlg_framework"),"Rubik:tlg://fonts.gstatic.com/s/rubik/v1/o1vXYO8YwDpErHEAPAxpOg.ttf:tlg:300" => esc_html__( "Rubik - 300", "tlg_framework"),"Rubik:tlg://fonts.gstatic.com/s/rubik/v1/NyXDvUhvZLSWiVfGa5KM-vesZW2xOQ-xsNqO47m55DA.ttf:tlg:300italic" => esc_html__( "Rubik - 300italic", "tlg_framework"),"Rubik:tlg://fonts.gstatic.com/s/rubik/v1/4sMyW_teKWHB3K8Hm-Il6A.ttf:tlg:regular" => esc_html__( "Rubik - regular", "tlg_framework"),"Rubik:tlg://fonts.gstatic.com/s/rubik/v1/elD65ddI0qvNcCh42b1Iqg.ttf:tlg:italic" => esc_html__( "Rubik - italic", "tlg_framework"),"Rubik:tlg://fonts.gstatic.com/s/rubik/v1/D4HihERG27s-BJrQ4dvkbw.ttf:tlg:500" => esc_html__( "Rubik - 500", "tlg_framework"),"Rubik:tlg://fonts.gstatic.com/s/rubik/v1/0hcxMdoMbXtHiEM1ebdN6PesZW2xOQ-xsNqO47m55DA.ttf:tlg:500italic" => esc_html__( "Rubik - 500italic", "tlg_framework"),"Rubik:tlg://fonts.gstatic.com/s/rubik/v1/m1GGHcpLe6Mb0_sAyjXE4g.ttf:tlg:700" => esc_html__( "Rubik - 700", "tlg_framework"),"Rubik:tlg://fonts.gstatic.com/s/rubik/v1/R4g_rs714cUXVZcdnRdHw_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700italic" => esc_html__( "Rubik - 700italic", "tlg_framework"),"Rubik:tlg://fonts.gstatic.com/s/rubik/v1/mOHfPRl5uP4vw7-5-dbnng.ttf:tlg:900" => esc_html__( "Rubik - 900", "tlg_framework"),"Rubik:tlg://fonts.gstatic.com/s/rubik/v1/HH1b7kBbwInqlw8OQxRE5vesZW2xOQ-xsNqO47m55DA.ttf:tlg:900italic" => esc_html__( "Rubik - 900italic", "tlg_framework"),"Rubik Mono One:tlg://fonts.gstatic.com/s/rubikmonoone/v5/e_cupPtD4BrZzotubJD7UbAREgn5xbW23GEXXnhMQ5Y.ttf:tlg:regular" => esc_html__( "Rubik Mono One - regular", "tlg_framework"),"Rubik One:tlg://fonts.gstatic.com/s/rubikone/v4/Zs6TtctNRSIR8T5PO018rQ.ttf:tlg:regular" => esc_html__( "Rubik One - regular", "tlg_framework"),"Ruda:tlg://fonts.gstatic.com/s/ruda/v7/jPEIPB7DM2DNK_uBGv2HGw.ttf:tlg:regular" => esc_html__( "Ruda - regular", "tlg_framework"),"Ruda:tlg://fonts.gstatic.com/s/ruda/v7/JABOu1SYOHcGXVejUq4w6g.ttf:tlg:700" => esc_html__( "Ruda - 700", "tlg_framework"),"Ruda:tlg://fonts.gstatic.com/s/ruda/v7/Uzusv-enCjoIrznlJJaBRw.ttf:tlg:900" => esc_html__( "Ruda - 900", "tlg_framework"),"Rufina:tlg://fonts.gstatic.com/s/rufina/v4/s9IFr_fIemiohfZS-ZRDbQ.ttf:tlg:regular" => esc_html__( "Rufina - regular", "tlg_framework"),"Rufina:tlg://fonts.gstatic.com/s/rufina/v4/D0RUjXFr55y4MVZY2Ww_RA.ttf:tlg:700" => esc_html__( "Rufina - 700", "tlg_framework"),"Ruge Boogie:tlg://fonts.gstatic.com/s/rugeboogie/v7/U-TTmltL8aENLVIqYbI5QaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Ruge Boogie - regular", "tlg_framework"),"Ruluko:tlg://fonts.gstatic.com/s/ruluko/v4/lv4cMwJtrx_dzmlK5SDc1g.ttf:tlg:regular" => esc_html__( "Ruluko - regular", "tlg_framework"),"Rum Raisin:tlg://fonts.gstatic.com/s/rumraisin/v4/kDiL-ntDOEq26B7kYM7cx_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Rum Raisin - regular", "tlg_framework"),"Ruslan Display:tlg://fonts.gstatic.com/s/ruslandisplay/v7/SREdhlyLNUfU1VssRBfs3rgH88D3l9N4auRNHrNS708.ttf:tlg:regular" => esc_html__( "Ruslan Display - regular", "tlg_framework"),"Russo One:tlg://fonts.gstatic.com/s/russoone/v5/zfwxZ--UhUc7FVfgT21PRQ.ttf:tlg:regular" => esc_html__( "Russo One - regular", "tlg_framework"),"Ruthie:tlg://fonts.gstatic.com/s/ruthie/v6/vJ2LorukHSbWYoEs5juivg.ttf:tlg:regular" => esc_html__( "Ruthie - regular", "tlg_framework"),"Rye:tlg://fonts.gstatic.com/s/rye/v4/VUrJlpPpSZxspl3w_yNOrQ.ttf:tlg:regular" => esc_html__( "Rye - regular", "tlg_framework"),"Sacramento:tlg://fonts.gstatic.com/s/sacramento/v4/_kv-qycSHMNdhjiv0Kj7BvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Sacramento - regular", "tlg_framework"),"Sahitya:tlg://fonts.gstatic.com/s/sahitya/v1/wQWULcDbZqljdTfjOUtDvw.ttf:tlg:regular" => esc_html__( "Sahitya - regular", "tlg_framework"),"Sahitya:tlg://fonts.gstatic.com/s/sahitya/v1/Zm5hNvMwUyN3tC4GMkH1l_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Sahitya - 700", "tlg_framework"),"Sail:tlg://fonts.gstatic.com/s/sail/v7/iuEoG6kt-bePGvtdpL0GUQ.ttf:tlg:regular" => esc_html__( "Sail - regular", "tlg_framework"),"Salsa:tlg://fonts.gstatic.com/s/salsa/v6/BnpUCBmYdvggScEPs5JbpA.ttf:tlg:regular" => esc_html__( "Salsa - regular", "tlg_framework"),"Sanchez:tlg://fonts.gstatic.com/s/sanchez/v4/BEL8ao-E2LJ5eHPLB2UAiw.ttf:tlg:regular" => esc_html__( "Sanchez - regular", "tlg_framework"),"Sanchez:tlg://fonts.gstatic.com/s/sanchez/v4/iSrhkWLexUZzDeNxNEHtzA.ttf:tlg:italic" => esc_html__( "Sanchez - italic", "tlg_framework"),"Sancreek:tlg://fonts.gstatic.com/s/sancreek/v7/8ZacBMraWMvHly4IJI3esw.ttf:tlg:regular" => esc_html__( "Sancreek - regular", "tlg_framework"),"Sansita One:tlg://fonts.gstatic.com/s/sansitaone/v6/xWqf68oB50JXqGIRR0h2hqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Sansita One - regular", "tlg_framework"),"Sarala:tlg://fonts.gstatic.com/s/sarala/v1/ohip9lixCHoBab7hTtgLnw.ttf:tlg:regular" => esc_html__( "Sarala - regular", "tlg_framework"),"Sarala:tlg://fonts.gstatic.com/s/sarala/v1/hpc9cz8KYsazwq2In_oJYw.ttf:tlg:700" => esc_html__( "Sarala - 700", "tlg_framework"),"Sarina:tlg://fonts.gstatic.com/s/sarina/v5/XYtRfaSknHIU3NHdfTdXoQ.ttf:tlg:regular" => esc_html__( "Sarina - regular", "tlg_framework"),"Sarpanch:tlg://fonts.gstatic.com/s/sarpanch/v1/YMBZdT27b6O5a1DADbAGSg.ttf:tlg:regular" => esc_html__( "Sarpanch - regular", "tlg_framework"),"Sarpanch:tlg://fonts.gstatic.com/s/sarpanch/v1/Ov7BxSrFSZYrfuJxL1LzQaCWcynf_cDxXwCLxiixG1c.ttf:tlg:500" => esc_html__( "Sarpanch - 500", "tlg_framework"),"Sarpanch:tlg://fonts.gstatic.com/s/sarpanch/v1/WTnP2wnc0qSbUaaDG-2OQ6CWcynf_cDxXwCLxiixG1c.ttf:tlg:600" => esc_html__( "Sarpanch - 600", "tlg_framework"),"Sarpanch:tlg://fonts.gstatic.com/s/sarpanch/v1/57kYsSpovYmFaEt2hsZhv6CWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Sarpanch - 700", "tlg_framework"),"Sarpanch:tlg://fonts.gstatic.com/s/sarpanch/v1/OKyqPLjdnuVghR-1TV6RzaCWcynf_cDxXwCLxiixG1c.ttf:tlg:800" => esc_html__( "Sarpanch - 800", "tlg_framework"),"Sarpanch:tlg://fonts.gstatic.com/s/sarpanch/v1/JhYc2cr6kqWTo_P0vfvJR6CWcynf_cDxXwCLxiixG1c.ttf:tlg:900" => esc_html__( "Sarpanch - 900", "tlg_framework"),"Satisfy:tlg://fonts.gstatic.com/s/satisfy/v6/PRlyepkd-JCGHiN8e9WV2w.ttf:tlg:regular" => esc_html__( "Satisfy - regular", "tlg_framework"),"Scada:tlg://fonts.gstatic.com/s/scada/v4/iZNC3ZEYwe3je6H-28d5Ug.ttf:tlg:regular" => esc_html__( "Scada - regular", "tlg_framework"),"Scada:tlg://fonts.gstatic.com/s/scada/v4/PCGyLT1qNawkOUQ3uHFhBw.ttf:tlg:italic" => esc_html__( "Scada - italic", "tlg_framework"),"Scada:tlg://fonts.gstatic.com/s/scada/v4/t6XNWdMdVWUz93EuRVmifQ.ttf:tlg:700" => esc_html__( "Scada - 700", "tlg_framework"),"Scada:tlg://fonts.gstatic.com/s/scada/v4/kLrBIf7V4mDMwcd_Yw7-D_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700italic" => esc_html__( "Scada - 700italic", "tlg_framework"),"Scheherazade:tlg://fonts.gstatic.com/s/scheherazade/v11/AuKlqGWzUC-8XqMOmsqXiy3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Scheherazade - regular", "tlg_framework"),"Scheherazade:tlg://fonts.gstatic.com/s/scheherazade/v11/C1wtT46acJkQxc6mPHwvHED2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Scheherazade - 700", "tlg_framework"),"Schoolbell:tlg://fonts.gstatic.com/s/schoolbell/v6/95-3djEuubb3cJx-6E7j4vesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Schoolbell - regular", "tlg_framework"),"Seaweed Script:tlg://fonts.gstatic.com/s/seaweedscript/v4/eorWAPpOvvWrPw5IHwE60BnpV0hQCek3EmWnCPrvGRM.ttf:tlg:regular" => esc_html__( "Seaweed Script - regular", "tlg_framework"),"Sevillana:tlg://fonts.gstatic.com/s/sevillana/v4/6m1Nh35oP7YEt00U80Smiw.ttf:tlg:regular" => esc_html__( "Sevillana - regular", "tlg_framework"),"Seymour One:tlg://fonts.gstatic.com/s/seymourone/v4/HrdG2AEG_870Xb7xBVv6C6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Seymour One - regular", "tlg_framework"),"Shadows Into Light:tlg://fonts.gstatic.com/s/shadowsintolight/v6/clhLqOv7MXn459PTh0gXYAW_5bEze-iLRNvGrRpJsfM.ttf:tlg:regular" => esc_html__( "Shadows Into Light - regular", "tlg_framework"),"Shadows Into Light Two:tlg://fonts.gstatic.com/s/shadowsintolighttwo/v4/gDxHeefcXIo-lOuZFCn2xVQrZk-Pga5KeEE_oZjkQjQ.ttf:tlg:regular" => esc_html__( "Shadows Into Light Two - regular", "tlg_framework"),"Shanti:tlg://fonts.gstatic.com/s/shanti/v8/lc4nG_JG6Q-2FQSOMMhb_w.ttf:tlg:regular" => esc_html__( "Shanti - regular", "tlg_framework"),"Share:tlg://fonts.gstatic.com/s/share/v5/1ytD7zSb_-g9I2GG67vmVw.ttf:tlg:regular" => esc_html__( "Share - regular", "tlg_framework"),"Share:tlg://fonts.gstatic.com/s/share/v5/a9YGdQWFRlNJ0zClJVaY3Q.ttf:tlg:italic" => esc_html__( "Share - italic", "tlg_framework"),"Share:tlg://fonts.gstatic.com/s/share/v5/XrU8e7a1YKurguyY2azk1Q.ttf:tlg:700" => esc_html__( "Share - 700", "tlg_framework"),"Share:tlg://fonts.gstatic.com/s/share/v5/A992-bLVYwAflKu6iaznufesZW2xOQ-xsNqO47m55DA.ttf:tlg:700italic" => esc_html__( "Share - 700italic", "tlg_framework"),"Share Tech:tlg://fonts.gstatic.com/s/sharetech/v4/Dq3DuZ5_0SW3oEfAWFpen_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Share Tech - regular", "tlg_framework"),"Share Tech Mono:tlg://fonts.gstatic.com/s/sharetechmono/v5/RQxK-3RA0Lnf3gnnnNrAscwD6PD0c3_abh9zHKQtbGU.ttf:tlg:regular" => esc_html__( "Share Tech Mono - regular", "tlg_framework"),"Shojumaru:tlg://fonts.gstatic.com/s/shojumaru/v4/WP8cxonzQQVAoI3RJQ2wug.ttf:tlg:regular" => esc_html__( "Shojumaru - regular", "tlg_framework"),"Short Stack:tlg://fonts.gstatic.com/s/shortstack/v6/v4dXPI0Rm8XN9gk4SDdqlqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Short Stack - regular", "tlg_framework"),"Siemreap:tlg://fonts.gstatic.com/s/siemreap/v9/JSK-mOIsXwxo-zE9XDDl_g.ttf:tlg:regular" => esc_html__( "Siemreap - regular", "tlg_framework"),"Sigmar One:tlg://fonts.gstatic.com/s/sigmarone/v6/oh_5NxD5JBZksdo2EntKefesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Sigmar One - regular", "tlg_framework"),"Signika:tlg://fonts.gstatic.com/s/signika/v6/0wDPonOzsYeEo-1KO78w4fesZW2xOQ-xsNqO47m55DA.ttf:tlg:300" => esc_html__( "Signika - 300", "tlg_framework"),"Signika:tlg://fonts.gstatic.com/s/signika/v6/WvDswbww0oAtvBg2l1L-9w.ttf:tlg:regular" => esc_html__( "Signika - regular", "tlg_framework"),"Signika:tlg://fonts.gstatic.com/s/signika/v6/lQMOF6NUN2ooR7WvB7tADvesZW2xOQ-xsNqO47m55DA.ttf:tlg:600" => esc_html__( "Signika - 600", "tlg_framework"),"Signika:tlg://fonts.gstatic.com/s/signika/v6/lEcnfPBICWJPv5BbVNnFJPesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Signika - 700", "tlg_framework"),"Signika Negative:tlg://fonts.gstatic.com/s/signikanegative/v5/q5TOjIw4CenPw6C-TW06FjYFXpUPtCmIEFDvjUnLLaI.ttf:tlg:300" => esc_html__( "Signika Negative - 300", "tlg_framework"),"Signika Negative:tlg://fonts.gstatic.com/s/signikanegative/v5/Z-Q1hzbY8uAo3TpTyPFMXVM1lnCWMnren5_v6047e5A.ttf:tlg:regular" => esc_html__( "Signika Negative - regular", "tlg_framework"),"Signika Negative:tlg://fonts.gstatic.com/s/signikanegative/v5/q5TOjIw4CenPw6C-TW06FrKLaDJM01OezSVA2R_O3qI.ttf:tlg:600" => esc_html__( "Signika Negative - 600", "tlg_framework"),"Signika Negative:tlg://fonts.gstatic.com/s/signikanegative/v5/q5TOjIw4CenPw6C-TW06FpYzPxtVvobH1w3hEppR8WI.ttf:tlg:700" => esc_html__( "Signika Negative - 700", "tlg_framework"),"Simonetta:tlg://fonts.gstatic.com/s/simonetta/v5/fN8puNuahBo4EYMQgp12Yg.ttf:tlg:regular" => esc_html__( "Simonetta - regular", "tlg_framework"),"Simonetta:tlg://fonts.gstatic.com/s/simonetta/v5/ynxQ3FqfF_Nziwy3T9ZwL6CWcynf_cDxXwCLxiixG1c.ttf:tlg:italic" => esc_html__( "Simonetta - italic", "tlg_framework"),"Simonetta:tlg://fonts.gstatic.com/s/simonetta/v5/22EwvvJ2r1VwVCxit5LcVi3USBnSvpkopQaUR-2r7iU.ttf:tlg:900" => esc_html__( "Simonetta - 900", "tlg_framework"),"Simonetta:tlg://fonts.gstatic.com/s/simonetta/v5/WUXOpCgBZaRPrWtMCpeKoienaqEuufTBk9XMKnKmgDA.ttf:tlg:900italic" => esc_html__( "Simonetta - 900italic", "tlg_framework"),"Sintony:tlg://fonts.gstatic.com/s/sintony/v4/IDhCijoIMev2L6Lg5QsduQ.ttf:tlg:regular" => esc_html__( "Sintony - regular", "tlg_framework"),"Sintony:tlg://fonts.gstatic.com/s/sintony/v4/zVXQB1wqJn6PE4dWXoYpvPesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Sintony - 700", "tlg_framework"),"Sirin Stencil:tlg://fonts.gstatic.com/s/sirinstencil/v5/pRpLdo0SawzO7MoBpvowsImg74kgS1F7KeR8rWhYwkU.ttf:tlg:regular" => esc_html__( "Sirin Stencil - regular", "tlg_framework"),"Six Caps:tlg://fonts.gstatic.com/s/sixcaps/v7/_XeDnO0HOV8Er9u97If1tQ.ttf:tlg:regular" => esc_html__( "Six Caps - regular", "tlg_framework"),"Skranji:tlg://fonts.gstatic.com/s/skranji/v4/jnOLPS0iZmDL7dfWnW3nIw.ttf:tlg:regular" => esc_html__( "Skranji - regular", "tlg_framework"),"Skranji:tlg://fonts.gstatic.com/s/skranji/v4/Lcrhg-fviVkxiEgoadsI1vesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Skranji - 700", "tlg_framework"),"Slabo 13px:tlg://fonts.gstatic.com/s/slabo13px/v3/jPGWFTjRXfCSzy0qd1nqdvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Slabo 13px - regular", "tlg_framework"),"Slabo 27px:tlg://fonts.gstatic.com/s/slabo27px/v3/gC0o8B9eU21EafNkXlRAfPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Slabo 27px - regular", "tlg_framework"),"Slackey:tlg://fonts.gstatic.com/s/slackey/v6/evRIMNhGVCRJvCPv4kteeA.ttf:tlg:regular" => esc_html__( "Slackey - regular", "tlg_framework"),"Smokum:tlg://fonts.gstatic.com/s/smokum/v6/8YP4BuAcy97X8WfdKfxVRw.ttf:tlg:regular" => esc_html__( "Smokum - regular", "tlg_framework"),"Smythe:tlg://fonts.gstatic.com/s/smythe/v7/yACD1gy_MpbB9Ft42fUvYw.ttf:tlg:regular" => esc_html__( "Smythe - regular", "tlg_framework"),"Sniglet:tlg://fonts.gstatic.com/s/sniglet/v7/XWhyQLHH4SpCVsHRPRgu9w.ttf:tlg:regular" => esc_html__( "Sniglet - regular", "tlg_framework"),"Sniglet:tlg://fonts.gstatic.com/s/sniglet/v7/NLF91nBmcEfkBgcEWbHFa_esZW2xOQ-xsNqO47m55DA.ttf:tlg:800" => esc_html__( "Sniglet - 800", "tlg_framework"),"Snippet:tlg://fonts.gstatic.com/s/snippet/v6/eUcYMLq2GtHZovLlQH_9kA.ttf:tlg:regular" => esc_html__( "Snippet - regular", "tlg_framework"),"Snowburst One:tlg://fonts.gstatic.com/s/snowburstone/v4/zSQzKOPukXRux2oTqfYJjIjjx0o0jr6fNXxPgYh_a8Q.ttf:tlg:regular" => esc_html__( "Snowburst One - regular", "tlg_framework"),"Sofadi One:tlg://fonts.gstatic.com/s/sofadione/v4/nirf4G12IcJ6KI8Eoj119fesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Sofadi One - regular", "tlg_framework"),"Sofia:tlg://fonts.gstatic.com/s/sofia/v5/Imnvx0Ag9r6iDBFUY5_RaQ.ttf:tlg:regular" => esc_html__( "Sofia - regular", "tlg_framework"),"Sonsie One:tlg://fonts.gstatic.com/s/sonsieone/v5/KSP7xT1OSy0q2ob6RQOTWPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Sonsie One - regular", "tlg_framework"),"Sorts Mill Goudy:tlg://fonts.gstatic.com/s/sortsmillgoudy/v6/JzRrPKdwEnE8F1TDmDLMUlIL2Qjg-Xlsg_fhGbe2P5U.ttf:tlg:regular" => esc_html__( "Sorts Mill Goudy - regular", "tlg_framework"),"Sorts Mill Goudy:tlg://fonts.gstatic.com/s/sortsmillgoudy/v6/UUu1lKiy4hRmBWk599VL1TYNkCNSzLyoucKmbTguvr0.ttf:tlg:italic" => esc_html__( "Sorts Mill Goudy - italic", "tlg_framework"),"Source Code Pro:tlg://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqaXvKVW_haheDNrHjziJZVk.ttf:tlg:200" => esc_html__( "Source Code Pro - 200", "tlg_framework"),"Source Code Pro:tlg://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqVP7R5lD_au4SZC6Ks_vyWs.ttf:tlg:300" => esc_html__( "Source Code Pro - 300", "tlg_framework"),"Source Code Pro:tlg://fonts.gstatic.com/s/sourcecodepro/v6/mrl8jkM18OlOQN8JLgasD9Rl0pGnog23EMYRrBmUzJQ.ttf:tlg:regular" => esc_html__( "Source Code Pro - regular", "tlg_framework"),"Source Code Pro:tlg://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqX63uKwMO11Of4rJWV582wg.ttf:tlg:500" => esc_html__( "Source Code Pro - 500", "tlg_framework"),"Source Code Pro:tlg://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqeiMeWyi5E_-XkTgB5psiDg.ttf:tlg:600" => esc_html__( "Source Code Pro - 600", "tlg_framework"),"Source Code Pro:tlg://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqfgXsetDviZcdR5OzC1KPcw.ttf:tlg:700" => esc_html__( "Source Code Pro - 700", "tlg_framework"),"Source Code Pro:tlg://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqRA_awHl7mXRjE_LQVochcU.ttf:tlg:900" => esc_html__( "Source Code Pro - 900", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/toadOcfmlt9b38dHJxOBGKXvKVW_haheDNrHjziJZVk.ttf:tlg:200" => esc_html__( "Source Sans Pro - 200", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/fpTVHK8qsXbIeTHTrnQH6OptKU7UIBg2hLM7eMTU8bI.ttf:tlg:200italic" => esc_html__( "Source Sans Pro - 200italic", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/toadOcfmlt9b38dHJxOBGFP7R5lD_au4SZC6Ks_vyWs.ttf:tlg:300" => esc_html__( "Source Sans Pro - 300", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/fpTVHK8qsXbIeTHTrnQH6DUpNKoQAsDux-Todp8f29w.ttf:tlg:300italic" => esc_html__( "Source Sans Pro - 300italic", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/ODelI1aHBYDBqgeIAH2zlNRl0pGnog23EMYRrBmUzJQ.ttf:tlg:regular" => esc_html__( "Source Sans Pro - regular", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/M2Jd71oPJhLKp0zdtTvoMwRX4TIfMQQEXLu74GftruE.ttf:tlg:italic" => esc_html__( "Source Sans Pro - italic", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/toadOcfmlt9b38dHJxOBGOiMeWyi5E_-XkTgB5psiDg.ttf:tlg:600" => esc_html__( "Source Sans Pro - 600", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/fpTVHK8qsXbIeTHTrnQH6Pp6lGoTTgjlW0sC4r900Co.ttf:tlg:600italic" => esc_html__( "Source Sans Pro - 600italic", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/toadOcfmlt9b38dHJxOBGPgXsetDviZcdR5OzC1KPcw.ttf:tlg:700" => esc_html__( "Source Sans Pro - 700", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/fpTVHK8qsXbIeTHTrnQH6LVT4locI09aamSzFGQlDMY.ttf:tlg:700italic" => esc_html__( "Source Sans Pro - 700italic", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/toadOcfmlt9b38dHJxOBGBA_awHl7mXRjE_LQVochcU.ttf:tlg:900" => esc_html__( "Source Sans Pro - 900", "tlg_framework"),"Source Sans Pro:tlg://fonts.gstatic.com/s/sourcesanspro/v9/fpTVHK8qsXbIeTHTrnQH6A0NcF6HPGWR298uWIdxWv0.ttf:tlg:900italic" => esc_html__( "Source Sans Pro - 900italic", "tlg_framework"),"Source Serif Pro:tlg://fonts.gstatic.com/s/sourceserifpro/v4/CeUM4np2c42DV49nanp55YGL0S0YDpKs5GpLtZIQ0m4.ttf:tlg:regular" => esc_html__( "Source Serif Pro - regular", "tlg_framework"),"Source Serif Pro:tlg://fonts.gstatic.com/s/sourceserifpro/v4/yd5lDMt8Sva2PE17yiLarGi4cQnvCGV11m1KlXh97aQ.ttf:tlg:600" => esc_html__( "Source Serif Pro - 600", "tlg_framework"),"Source Serif Pro:tlg://fonts.gstatic.com/s/sourceserifpro/v4/yd5lDMt8Sva2PE17yiLarEkpYHRvxGNSCrR82n_RDNk.ttf:tlg:700" => esc_html__( "Source Serif Pro - 700", "tlg_framework"),"Special Elite:tlg://fonts.gstatic.com/s/specialelite/v6/9-wW4zu3WNoD5Fjka35Jm4jjx0o0jr6fNXxPgYh_a8Q.ttf:tlg:regular" => esc_html__( "Special Elite - regular", "tlg_framework"),"Spicy Rice:tlg://fonts.gstatic.com/s/spicyrice/v5/WGCtz7cLoggXARPi9OGD6_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Spicy Rice - regular", "tlg_framework"),"Spinnaker:tlg://fonts.gstatic.com/s/spinnaker/v8/MQdIXivKITpjROUdiN6Jgg.ttf:tlg:regular" => esc_html__( "Spinnaker - regular", "tlg_framework"),"Spirax:tlg://fonts.gstatic.com/s/spirax/v5/IOKqhk-Ccl7y31yDsePPkw.ttf:tlg:regular" => esc_html__( "Spirax - regular", "tlg_framework"),"Squada One:tlg://fonts.gstatic.com/s/squadaone/v5/3tzGuaJdD65cZVgfQzN8uvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Squada One - regular", "tlg_framework"),"Sree Krushnadevaraya:tlg://fonts.gstatic.com/s/sreekrushnadevaraya/v4/CdsXmnHyEqVl1ahzOh5qnzjDZVem5Eb4d0dXjXa0F_Q.ttf:tlg:regular" => esc_html__( "Sree Krushnadevaraya - regular", "tlg_framework"),"Stalemate:tlg://fonts.gstatic.com/s/stalemate/v4/wQLCnG0qB6mOu2Wit2dt_w.ttf:tlg:regular" => esc_html__( "Stalemate - regular", "tlg_framework"),"Stalinist One:tlg://fonts.gstatic.com/s/stalinistone/v8/MQpS-WezM9W4Dd7D3B7I-UT7eZ8.ttf:tlg:regular" => esc_html__( "Stalinist One - regular", "tlg_framework"),"Stardos Stencil:tlg://fonts.gstatic.com/s/stardosstencil/v6/ygEOyTW9a6u4fi4OXEZeTFf2eT4jUldwg_9fgfY_tHc.ttf:tlg:regular" => esc_html__( "Stardos Stencil - regular", "tlg_framework"),"Stardos Stencil:tlg://fonts.gstatic.com/s/stardosstencil/v6/h4ExtgvoXhPtv9Ieqd-XC81wDCbBgmIo8UyjIhmkeSM.ttf:tlg:700" => esc_html__( "Stardos Stencil - 700", "tlg_framework"),"Stint Ultra Condensed:tlg://fonts.gstatic.com/s/stintultracondensed/v5/8DqLK6-YSClFZt3u3EgOUYelbRYnLTTQA1Z5cVLnsI4.ttf:tlg:regular" => esc_html__( "Stint Ultra Condensed - regular", "tlg_framework"),"Stint Ultra Expanded:tlg://fonts.gstatic.com/s/stintultraexpanded/v4/FeigX-wDDgHMCKuhekhedQ7dxr0N5HY0cZKknTIL6n4.ttf:tlg:regular" => esc_html__( "Stint Ultra Expanded - regular", "tlg_framework"),"Stoke:tlg://fonts.gstatic.com/s/stoke/v6/Sell9475FOS8jUqQsfFsUQ.ttf:tlg:300" => esc_html__( "Stoke - 300", "tlg_framework"),"Stoke:tlg://fonts.gstatic.com/s/stoke/v6/A7qJNoqOm2d6o1E6e0yUFg.ttf:tlg:regular" => esc_html__( "Stoke - regular", "tlg_framework"),"Strait:tlg://fonts.gstatic.com/s/strait/v4/m4W73ViNmProETY2ybc-Bg.ttf:tlg:regular" => esc_html__( "Strait - regular", "tlg_framework"),"Sue Ellen Francisco:tlg://fonts.gstatic.com/s/sueellenfrancisco/v7/TwHX4vSxMUnJUdEz1JIgrhzazJzPVbGl8jnf1tisRz4.ttf:tlg:regular" => esc_html__( "Sue Ellen Francisco - regular", "tlg_framework"),"Sumana:tlg://fonts.gstatic.com/s/sumana/v1/wgdl__wAK7pzliiWs0Nlog.ttf:tlg:regular" => esc_html__( "Sumana - regular", "tlg_framework"),"Sumana:tlg://fonts.gstatic.com/s/sumana/v1/8AcM-KAproitONSBBHj3sQ.ttf:tlg:700" => esc_html__( "Sumana - 700", "tlg_framework"),"Sunshiney:tlg://fonts.gstatic.com/s/sunshiney/v6/kaWOb4pGbwNijM7CkxK1sQ.ttf:tlg:regular" => esc_html__( "Sunshiney - regular", "tlg_framework"),"Supermercado One:tlg://fonts.gstatic.com/s/supermercadoone/v6/kMGPVTNFiFEp1U274uBMb4mm5hmSKNFf3C5YoMa-lrM.ttf:tlg:regular" => esc_html__( "Supermercado One - regular", "tlg_framework"),"Sura:tlg://fonts.gstatic.com/s/sura/v1/jznKrhTH5NezYxb0-Q5zzA.ttf:tlg:regular" => esc_html__( "Sura - regular", "tlg_framework"),"Sura:tlg://fonts.gstatic.com/s/sura/v1/Z5bXQaFGmoWicN1WlcncxA.ttf:tlg:700" => esc_html__( "Sura - 700", "tlg_framework"),"Suranna:tlg://fonts.gstatic.com/s/suranna/v4/PYmfr6TQeTqZ-r8HnPM-kA.ttf:tlg:regular" => esc_html__( "Suranna - regular", "tlg_framework"),"Suravaram:tlg://fonts.gstatic.com/s/suravaram/v3/G4dPee4pel_w2HqzavW4MA.ttf:tlg:regular" => esc_html__( "Suravaram - regular", "tlg_framework"),"Suwannaphum:tlg://fonts.gstatic.com/s/suwannaphum/v9/1jIPOyXied3T79GCnSlCN6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Suwannaphum - regular", "tlg_framework"),"Swanky and Moo Moo:tlg://fonts.gstatic.com/s/swankyandmoomoo/v6/orVNZ9kDeE3lWp3U3YELu9DVLKqNC3_XMNHhr8S94FU.ttf:tlg:regular" => esc_html__( "Swanky and Moo Moo - regular", "tlg_framework"),"Syncopate:tlg://fonts.gstatic.com/s/syncopate/v7/RQVwO52fAH6MI764EcaYtw.ttf:tlg:regular" => esc_html__( "Syncopate - regular", "tlg_framework"),"Syncopate:tlg://fonts.gstatic.com/s/syncopate/v7/S5z8ixiOoC4WJ1im6jAlYC3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Syncopate - 700", "tlg_framework"),"Tangerine:tlg://fonts.gstatic.com/s/tangerine/v7/DTPeM3IROhnkz7aYG2a9sA.ttf:tlg:regular" => esc_html__( "Tangerine - regular", "tlg_framework"),"Tangerine:tlg://fonts.gstatic.com/s/tangerine/v7/UkFsr-RwJB_d2l9fIWsx3i3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Tangerine - 700", "tlg_framework"),"Taprom:tlg://fonts.gstatic.com/s/taprom/v8/-KByU3BaUsyIvQs79qFObg.ttf:tlg:regular" => esc_html__( "Taprom - regular", "tlg_framework"),"Tauri:tlg://fonts.gstatic.com/s/tauri/v4/XIWeYJDXNqiVNej0zEqtGg.ttf:tlg:regular" => esc_html__( "Tauri - regular", "tlg_framework"),"Teko:tlg://fonts.gstatic.com/s/teko/v5/OobFGE9eo24rcBpN6zXDaQ.ttf:tlg:300" => esc_html__( "Teko - 300", "tlg_framework"),"Teko:tlg://fonts.gstatic.com/s/teko/v5/UtekqODEqZXSN2L-njejpA.ttf:tlg:regular" => esc_html__( "Teko - regular", "tlg_framework"),"Teko:tlg://fonts.gstatic.com/s/teko/v5/FQ0duU7gWM4cSaImOfAjBA.ttf:tlg:500" => esc_html__( "Teko - 500", "tlg_framework"),"Teko:tlg://fonts.gstatic.com/s/teko/v5/QDx_i8H-TZ1IK1JEVrqwEQ.ttf:tlg:600" => esc_html__( "Teko - 600", "tlg_framework"),"Teko:tlg://fonts.gstatic.com/s/teko/v5/xKfTxe_SWpH4xU75vmvylA.ttf:tlg:700" => esc_html__( "Teko - 700", "tlg_framework"),"Telex:tlg://fonts.gstatic.com/s/telex/v4/24-3xP9ywYeHOcFU3iGk8A.ttf:tlg:regular" => esc_html__( "Telex - regular", "tlg_framework"),"Tenali Ramakrishna:tlg://fonts.gstatic.com/s/tenaliramakrishna/v3/M0nTmDqv2M7AGoGh-c946BZak5pSBHqWX6uyVMiMFoA.ttf:tlg:regular" => esc_html__( "Tenali Ramakrishna - regular", "tlg_framework"),"Tenor Sans:tlg://fonts.gstatic.com/s/tenorsans/v7/dUBulmjNJJInvK5vL7O9yfesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Tenor Sans - regular", "tlg_framework"),"Text Me One:tlg://fonts.gstatic.com/s/textmeone/v4/9em_3ckd_P5PQkP4aDyDLqCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Text Me One - regular", "tlg_framework"),"The Girl Next Door:tlg://fonts.gstatic.com/s/thegirlnextdoor/v7/cWRA4JVGeEcHGcPl5hmX7kzo0nFFoM60ux_D9BUymX4.ttf:tlg:regular" => esc_html__( "The Girl Next Door - regular", "tlg_framework"),"Tienne:tlg://fonts.gstatic.com/s/tienne/v8/-IIfDl701C0z7-fy2kmGvA.ttf:tlg:regular" => esc_html__( "Tienne - regular", "tlg_framework"),"Tienne:tlg://fonts.gstatic.com/s/tienne/v8/JvoCDOlyOSEyYGRwCyfs3g.ttf:tlg:700" => esc_html__( "Tienne - 700", "tlg_framework"),"Tienne:tlg://fonts.gstatic.com/s/tienne/v8/FBano5T521OWexj2iRYLMw.ttf:tlg:900" => esc_html__( "Tienne - 900", "tlg_framework"),"Tillana:tlg://fonts.gstatic.com/s/tillana/v1/zN0D-jDPsr1HzU3VRFLY5g.ttf:tlg:regular" => esc_html__( "Tillana - regular", "tlg_framework"),"Tillana:tlg://fonts.gstatic.com/s/tillana/v1/gqdUngSIcY9tSla5eCZky_esZW2xOQ-xsNqO47m55DA.ttf:tlg:500" => esc_html__( "Tillana - 500", "tlg_framework"),"Tillana:tlg://fonts.gstatic.com/s/tillana/v1/fqon6-r15hy8M1cyiYfQBvesZW2xOQ-xsNqO47m55DA.ttf:tlg:600" => esc_html__( "Tillana - 600", "tlg_framework"),"Tillana:tlg://fonts.gstatic.com/s/tillana/v1/jGARMTxLrMerzTCpGBpMffesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Tillana - 700", "tlg_framework"),"Tillana:tlg://fonts.gstatic.com/s/tillana/v1/pmTtNH_Ibktj5Cyc1XrP6vesZW2xOQ-xsNqO47m55DA.ttf:tlg:800" => esc_html__( "Tillana - 800", "tlg_framework"),"Timmana:tlg://fonts.gstatic.com/s/timmana/v1/T25SicsJUJkc2s2sbBsDnA.ttf:tlg:regular" => esc_html__( "Timmana - regular", "tlg_framework"),"Tinos:tlg://fonts.gstatic.com/s/tinos/v9/EqpUbkVmutfwZ0PjpoGwCg.ttf:tlg:regular" => esc_html__( "Tinos - regular", "tlg_framework"),"Tinos:tlg://fonts.gstatic.com/s/tinos/v9/slfyzlasCr9vTsaP4lUh9A.ttf:tlg:italic" => esc_html__( "Tinos - italic", "tlg_framework"),"Tinos:tlg://fonts.gstatic.com/s/tinos/v9/vHXfhX8jZuQruowfon93yQ.ttf:tlg:700" => esc_html__( "Tinos - 700", "tlg_framework"),"Tinos:tlg://fonts.gstatic.com/s/tinos/v9/M6kfzvDMM0CdxdraoFpG6vesZW2xOQ-xsNqO47m55DA.ttf:tlg:700italic" => esc_html__( "Tinos - 700italic", "tlg_framework"),"Titan One:tlg://fonts.gstatic.com/s/titanone/v4/FbvpRvzfV_oipS0De3iAZg.ttf:tlg:regular" => esc_html__( "Titan One - regular", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/anMUvcNT0H1YN4FII8wprzOdCrLccoxq42eaxM802O0.ttf:tlg:200" => esc_html__( "Titillium Web - 200", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/RZunN20OBmkvrU7sA4GPPj4N98U-66ThNJvtgddRfBE.ttf:tlg:200italic" => esc_html__( "Titillium Web - 200italic", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/anMUvcNT0H1YN4FII8wpr9ZAkYT8DuUZELiKLwMGWAo.ttf:tlg:300" => esc_html__( "Titillium Web - 300", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/RZunN20OBmkvrU7sA4GPPrfzCkqg7ORZlRf2cc4mXu8.ttf:tlg:300italic" => esc_html__( "Titillium Web - 300italic", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/7XUFZ5tgS-tD6QamInJTcTyagQBwYgYywpS70xNq8SQ.ttf:tlg:regular" => esc_html__( "Titillium Web - regular", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/r9OmwyQxrgzUAhaLET_KO-ixohbIP6lHkU-1Mgq95cY.ttf:tlg:italic" => esc_html__( "Titillium Web - italic", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/anMUvcNT0H1YN4FII8wpr28K9dEd5Ue-HTQrlA7E2xQ.ttf:tlg:600" => esc_html__( "Titillium Web - 600", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/RZunN20OBmkvrU7sA4GPPgOhzTSndyK8UWja2yJjKLc.ttf:tlg:600italic" => esc_html__( "Titillium Web - 600italic", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/anMUvcNT0H1YN4FII8wpr2-6tpSbB9YhmWtmd1_gi_U.ttf:tlg:700" => esc_html__( "Titillium Web - 700", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/RZunN20OBmkvrU7sA4GPPio3LEw-4MM8Ao2j9wPOfpw.ttf:tlg:700italic" => esc_html__( "Titillium Web - 700italic", "tlg_framework"),"Titillium Web:tlg://fonts.gstatic.com/s/titilliumweb/v4/anMUvcNT0H1YN4FII8wpr7L0GmZLri-m-nfoo0Vul4Y.ttf:tlg:900" => esc_html__( "Titillium Web - 900", "tlg_framework"),"Trade Winds:tlg://fonts.gstatic.com/s/tradewinds/v5/sDOCVgAxw6PEUi2xdMsoDaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Trade Winds - regular", "tlg_framework"),"Trocchi:tlg://fonts.gstatic.com/s/trocchi/v4/uldNPaKrUGVeGCVsmacLwA.ttf:tlg:regular" => esc_html__( "Trocchi - regular", "tlg_framework"),"Trochut:tlg://fonts.gstatic.com/s/trochut/v4/6Y65B0x-2JsnYt16OH5omw.ttf:tlg:regular" => esc_html__( "Trochut - regular", "tlg_framework"),"Trochut:tlg://fonts.gstatic.com/s/trochut/v4/pczUwr4ZFvC79TgNO5cZng.ttf:tlg:italic" => esc_html__( "Trochut - italic", "tlg_framework"),"Trochut:tlg://fonts.gstatic.com/s/trochut/v4/lWqNOv6ISR8ehNzGLFLnJ_esZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Trochut - 700", "tlg_framework"),"Trykker:tlg://fonts.gstatic.com/s/trykker/v5/YiVrVJpBFN7I1l_CWk6yYQ.ttf:tlg:regular" => esc_html__( "Trykker - regular", "tlg_framework"),"Tulpen One:tlg://fonts.gstatic.com/s/tulpenone/v6/lwcTfVIEVxpZLZlWzR5baPesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Tulpen One - regular", "tlg_framework"),"Ubuntu:tlg://fonts.gstatic.com/s/ubuntu/v9/7-wH0j2QCTHKgp7vLh9-sQ.ttf:tlg:300" => esc_html__( "Ubuntu - 300", "tlg_framework"),"Ubuntu:tlg://fonts.gstatic.com/s/ubuntu/v9/j-TYDdXcC_eQzhhp386SjaCWcynf_cDxXwCLxiixG1c.ttf:tlg:300italic" => esc_html__( "Ubuntu - 300italic", "tlg_framework"),"Ubuntu:tlg://fonts.gstatic.com/s/ubuntu/v9/lhhB5ZCwEkBRbHMSnYuKyA.ttf:tlg:regular" => esc_html__( "Ubuntu - regular", "tlg_framework"),"Ubuntu:tlg://fonts.gstatic.com/s/ubuntu/v9/b9hP8wd30SygxZjGGk4DCQ.ttf:tlg:italic" => esc_html__( "Ubuntu - italic", "tlg_framework"),"Ubuntu:tlg://fonts.gstatic.com/s/ubuntu/v9/bMbHEMwSUmkzcK2x_74QbA.ttf:tlg:500" => esc_html__( "Ubuntu - 500", "tlg_framework"),"Ubuntu:tlg://fonts.gstatic.com/s/ubuntu/v9/NWdMogIO7U6AtEM4dDdf_aCWcynf_cDxXwCLxiixG1c.ttf:tlg:500italic" => esc_html__( "Ubuntu - 500italic", "tlg_framework"),"Ubuntu:tlg://fonts.gstatic.com/s/ubuntu/v9/B7BtHjNYwAp3HgLNagENOQ.ttf:tlg:700" => esc_html__( "Ubuntu - 700", "tlg_framework"),"Ubuntu:tlg://fonts.gstatic.com/s/ubuntu/v9/pqisLQoeO9YTDCNnlQ9bf6CWcynf_cDxXwCLxiixG1c.ttf:tlg:700italic" => esc_html__( "Ubuntu - 700italic", "tlg_framework"),"Ubuntu Condensed:tlg://fonts.gstatic.com/s/ubuntucondensed/v7/DBCt-NXN57MTAFjitYxdrKDbm6fPDOZJsR8PmdG62gY.ttf:tlg:regular" => esc_html__( "Ubuntu Condensed - regular", "tlg_framework"),"Ubuntu Mono:tlg://fonts.gstatic.com/s/ubuntumono/v6/EgeuS9OtEmA0y_JRo03MQaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Ubuntu Mono - regular", "tlg_framework"),"Ubuntu Mono:tlg://fonts.gstatic.com/s/ubuntumono/v6/KAKuHXAHZOeECOWAHsRKA0eOrDcLawS7-ssYqLr2Xp4.ttf:tlg:italic" => esc_html__( "Ubuntu Mono - italic", "tlg_framework"),"Ubuntu Mono:tlg://fonts.gstatic.com/s/ubuntumono/v6/ceqTZGKHipo8pJj4molytne1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Ubuntu Mono - 700", "tlg_framework"),"Ubuntu Mono:tlg://fonts.gstatic.com/s/ubuntumono/v6/n_d8tv_JOIiYyMXR4eaV9c_zJjSACmk0BRPxQqhnNLU.ttf:tlg:700italic" => esc_html__( "Ubuntu Mono - 700italic", "tlg_framework"),"Ultra:tlg://fonts.gstatic.com/s/ultra/v8/OW8uXkOstRADuhEmGOFQLA.ttf:tlg:regular" => esc_html__( "Ultra - regular", "tlg_framework"),"Uncial Antiqua:tlg://fonts.gstatic.com/s/uncialantiqua/v4/F-leefDiFwQXsyd6eaSllqrFJ4O13IHVxZbM6yoslpo.ttf:tlg:regular" => esc_html__( "Uncial Antiqua - regular", "tlg_framework"),"Underdog:tlg://fonts.gstatic.com/s/underdog/v5/gBv9yjez_-5PnTprHWq0ig.ttf:tlg:regular" => esc_html__( "Underdog - regular", "tlg_framework"),"Unica One:tlg://fonts.gstatic.com/s/unicaone/v4/KbYKlhWMDpatWViqDkNQgA.ttf:tlg:regular" => esc_html__( "Unica One - regular", "tlg_framework"),"UnifrakturCook:tlg://fonts.gstatic.com/s/unifrakturcook/v8/ASwh69ykD8iaoYijVEU6RrWZkcsCTHKV51zmcUsafQ0.ttf:tlg:700" => esc_html__( "UnifrakturCook - 700", "tlg_framework"),"UnifrakturMaguntia:tlg://fonts.gstatic.com/s/unifrakturmaguntia/v7/7KWy3ymCVR_xfAvvcIXm3-kdNg30GQauG_DE-tMYtWk.ttf:tlg:regular" => esc_html__( "UnifrakturMaguntia - regular", "tlg_framework"),"Unkempt:tlg://fonts.gstatic.com/s/unkempt/v7/NLLBeNSspr0RGs71R5LHWA.ttf:tlg:regular" => esc_html__( "Unkempt - regular", "tlg_framework"),"Unkempt:tlg://fonts.gstatic.com/s/unkempt/v7/V7H-GCl9bgwGwqFqTTgDHvesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Unkempt - 700", "tlg_framework"),"Unlock:tlg://fonts.gstatic.com/s/unlock/v6/rXEQzK7uIAlhoyoAEiMy1w.ttf:tlg:regular" => esc_html__( "Unlock - regular", "tlg_framework"),"Unna:tlg://fonts.gstatic.com/s/unna/v8/UAS0AM7AmbdCNY_80xyAZQ.ttf:tlg:regular" => esc_html__( "Unna - regular", "tlg_framework"),"VT323:tlg://fonts.gstatic.com/s/vt323/v7/ITU2YQfM073o1iYK3nSOmQ.ttf:tlg:regular" => esc_html__( "VT323 - regular", "tlg_framework"),"Vampiro One:tlg://fonts.gstatic.com/s/vampiroone/v7/OVDs4gY4WpS5u3Qd1gXRW6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Vampiro One - regular", "tlg_framework"),"Varela:tlg://fonts.gstatic.com/s/varela/v7/ON7qs0cKUUixhhDFXlZUjw.ttf:tlg:regular" => esc_html__( "Varela - regular", "tlg_framework"),"Varela Round:tlg://fonts.gstatic.com/s/varelaround/v6/APH4jr0uSos5wiut5cpjri3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Varela Round - regular", "tlg_framework"),"Vast Shadow:tlg://fonts.gstatic.com/s/vastshadow/v6/io4hqKX3ibiqQQjYfW0-h6CWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Vast Shadow - regular", "tlg_framework"),"Vesper Libre:tlg://fonts.gstatic.com/s/vesperlibre/v7/Cg-TeZFsqV8BaOcoVwzu2C3USBnSvpkopQaUR-2r7iU.ttf:tlg:regular" => esc_html__( "Vesper Libre - regular", "tlg_framework"),"Vesper Libre:tlg://fonts.gstatic.com/s/vesperlibre/v7/0liLgNkygqH6EOtsVjZDsZMQuUSAwdHsY8ov_6tk1oA.ttf:tlg:500" => esc_html__( "Vesper Libre - 500", "tlg_framework"),"Vesper Libre:tlg://fonts.gstatic.com/s/vesperlibre/v7/0liLgNkygqH6EOtsVjZDsUD2ttfZwueP-QU272T9-k4.ttf:tlg:700" => esc_html__( "Vesper Libre - 700", "tlg_framework"),"Vesper Libre:tlg://fonts.gstatic.com/s/vesperlibre/v7/0liLgNkygqH6EOtsVjZDsaObDOjC3UL77puoeHsE3fw.ttf:tlg:900" => esc_html__( "Vesper Libre - 900", "tlg_framework"),"Vibur:tlg://fonts.gstatic.com/s/vibur/v7/xB9aKsUbJo68XP0bAg2iLw.ttf:tlg:regular" => esc_html__( "Vibur - regular", "tlg_framework"),"Vidaloka:tlg://fonts.gstatic.com/s/vidaloka/v8/C6Nul0ogKUWkx356rrt9RA.ttf:tlg:regular" => esc_html__( "Vidaloka - regular", "tlg_framework"),"Viga:tlg://fonts.gstatic.com/s/viga/v5/uD87gDbhS7frHLX4uL6agg.ttf:tlg:regular" => esc_html__( "Viga - regular", "tlg_framework"),"Voces:tlg://fonts.gstatic.com/s/voces/v5/QoBH6g6yKgNIgvL8A2aE2Q.ttf:tlg:regular" => esc_html__( "Voces - regular", "tlg_framework"),"Volkhov:tlg://fonts.gstatic.com/s/volkhov/v8/MDIZAofe1T_J3un5Kgo8zg.ttf:tlg:regular" => esc_html__( "Volkhov - regular", "tlg_framework"),"Volkhov:tlg://fonts.gstatic.com/s/volkhov/v8/1rTjmztKEpbkKH06JwF8Yw.ttf:tlg:italic" => esc_html__( "Volkhov - italic", "tlg_framework"),"Volkhov:tlg://fonts.gstatic.com/s/volkhov/v8/L8PbKS-kEoLHm7nP--NCzPesZW2xOQ-xsNqO47m55DA.ttf:tlg:700" => esc_html__( "Volkhov - 700", "tlg_framework"),"Volkhov:tlg://fonts.gstatic.com/s/volkhov/v8/W6oG0QDDjCgj0gmsHE520C3USBnSvpkopQaUR-2r7iU.ttf:tlg:700italic" => esc_html__( "Volkhov - 700italic", "tlg_framework"),"Vollkorn:tlg://fonts.gstatic.com/s/vollkorn/v6/IiexqYAeh8uII223thYx3w.ttf:tlg:regular" => esc_html__( "Vollkorn - regular", "tlg_framework"),"Vollkorn:tlg://fonts.gstatic.com/s/vollkorn/v6/UuIzosgR1ovBhJFdwVp3fvesZW2xOQ-xsNqO47m55DA.ttf:tlg:italic" => esc_html__( "Vollkorn - italic", "tlg_framework"),"Vollkorn:tlg://fonts.gstatic.com/s/vollkorn/v6/gOwQjJVGXlDOONC12hVoBqCWcynf_cDxXwCLxiixG1c.ttf:tlg:700" => esc_html__( "Vollkorn - 700", "tlg_framework"),"Vollkorn:tlg://fonts.gstatic.com/s/vollkorn/v6/KNiAlx6phRqXCwnZZG51JAJKKGfqHaYFsRG-T3ceEVo.ttf:tlg:700italic" => esc_html__( "Vollkorn - 700italic", "tlg_framework"),"Voltaire:tlg://fonts.gstatic.com/s/voltaire/v6/WvqBzaGEBbRV-hrahwO2cA.ttf:tlg:regular" => esc_html__( "Voltaire - regular", "tlg_framework"),"Waiting for the Sunrise:tlg://fonts.gstatic.com/s/waitingforthesunrise/v7/eNfH7kLpF1PZWpsetF-ha9TChrNgrDiT3Zy6yGf3FnM.ttf:tlg:regular" => esc_html__( "Waiting for the Sunrise - regular", "tlg_framework"),"Wallpoet:tlg://fonts.gstatic.com/s/wallpoet/v8/hmum4WuBN4A0Z_7367NDIg.ttf:tlg:regular" => esc_html__( "Wallpoet - regular", "tlg_framework"),"Walter Turncoat:tlg://fonts.gstatic.com/s/walterturncoat/v6/sG9su5g4GXy1KP73cU3hvQplL2YwNeota48DxFlGDUo.ttf:tlg:regular" => esc_html__( "Walter Turncoat - regular", "tlg_framework"),"Warnes:tlg://fonts.gstatic.com/s/warnes/v6/MXG7_Phj4YpzAXxKGItuBw.ttf:tlg:regular" => esc_html__( "Warnes - regular", "tlg_framework"),"Wellfleet:tlg://fonts.gstatic.com/s/wellfleet/v4/J5tOx72iFRPgHYpbK9J4XQ.ttf:tlg:regular" => esc_html__( "Wellfleet - regular", "tlg_framework"),"Wendy One:tlg://fonts.gstatic.com/s/wendyone/v4/R8CJT2oDXdMk_ZtuHTxoxw.ttf:tlg:regular" => esc_html__( "Wendy One - regular", "tlg_framework"),"Wire One:tlg://fonts.gstatic.com/s/wireone/v7/sRLhaQOQpWnvXwIx0CycQw.ttf:tlg:regular" => esc_html__( "Wire One - regular", "tlg_framework"),"Work Sans:tlg://fonts.gstatic.com/s/worksans/v2/ZAhtNqLaAViKjGLajtuwWaCWcynf_cDxXwCLxiixG1c.ttf:tlg:100" => esc_html__( "Work Sans - 100", "tlg_framework"),"Work Sans:tlg://fonts.gstatic.com/s/worksans/v2/u_mYNr_qYP37m7vgvmIYZy3USBnSvpkopQaUR-2r7iU.ttf:tlg:200" => esc_html__( "Work Sans - 200", "tlg_framework"),"Work Sans:tlg://fonts.gstatic.com/s/worksans/v2/FD_Udbezj8EHXbdsqLUply3USBnSvpkopQaUR-2r7iU.ttf:tlg:300" => esc_html__( "Work Sans - 300", "tlg_framework"),"Work Sans:tlg://fonts.gstatic.com/s/worksans/v2/zVvigUiMvx7JVEnrJgc-5Q.ttf:tlg:regular" => esc_html__( "Work Sans - regular", "tlg_framework"),"Work Sans:tlg://fonts.gstatic.com/s/worksans/v2/Nbre-U_bp6Xktt8cpgwaJC3USBnSvpkopQaUR-2r7iU.ttf:tlg:500" => esc_html__( "Work Sans - 500", "tlg_framework"),"Work Sans:tlg://fonts.gstatic.com/s/worksans/v2/z9rX03Xuz9ZNHTMg1_ghGS3USBnSvpkopQaUR-2r7iU.ttf:tlg:600" => esc_html__( "Work Sans - 600", "tlg_framework"),"Work Sans:tlg://fonts.gstatic.com/s/worksans/v2/4udXuXg54JlPEP5iKO5AmS3USBnSvpkopQaUR-2r7iU.ttf:tlg:700" => esc_html__( "Work Sans - 700", "tlg_framework"),"Work Sans:tlg://fonts.gstatic.com/s/worksans/v2/IQh-ap2Uqs7kl1YINeeEGi3USBnSvpkopQaUR-2r7iU.ttf:tlg:800" => esc_html__( "Work Sans - 800", "tlg_framework"),"Work Sans:tlg://fonts.gstatic.com/s/worksans/v2/Hjn0acvjHfjY_vAK9Uc6gi3USBnSvpkopQaUR-2r7iU.ttf:tlg:900" => esc_html__( "Work Sans - 900", "tlg_framework"),"Yanone Kaffeesatz:tlg://fonts.gstatic.com/s/yanonekaffeesatz/v7/We_iSDqttE3etzfdfhuPRbq92v6XxU4pSv06GI0NsGc.ttf:tlg:200" => esc_html__( "Yanone Kaffeesatz - 200", "tlg_framework"),"Yanone Kaffeesatz:tlg://fonts.gstatic.com/s/yanonekaffeesatz/v7/We_iSDqttE3etzfdfhuPRZlIwXPiNoNT_wxzJ2t3mTE.ttf:tlg:300" => esc_html__( "Yanone Kaffeesatz - 300", "tlg_framework"),"Yanone Kaffeesatz:tlg://fonts.gstatic.com/s/yanonekaffeesatz/v7/YDAoLskQQ5MOAgvHUQCcLdXn3cHbFGWU4T2HrSN6JF4.ttf:tlg:regular" => esc_html__( "Yanone Kaffeesatz - regular", "tlg_framework"),"Yanone Kaffeesatz:tlg://fonts.gstatic.com/s/yanonekaffeesatz/v7/We_iSDqttE3etzfdfhuPRf2R4S6PlKaGXWPfWpHpcl0.ttf:tlg:700" => esc_html__( "Yanone Kaffeesatz - 700", "tlg_framework"),"Yantramanav:tlg://fonts.gstatic.com/s/yantramanav/v1/Rs1I2PF4Z8GAb6qjgvr8wIAWxXGWZ3yJw6KhWS7MxOk.ttf:tlg:100" => esc_html__( "Yantramanav - 100", "tlg_framework"),"Yantramanav:tlg://fonts.gstatic.com/s/yantramanav/v1/HSfbC4Z8I8BZ00wiXeA5bC9-WlPSxbfiI49GsXo3q0g.ttf:tlg:300" => esc_html__( "Yantramanav - 300", "tlg_framework"),"Yantramanav:tlg://fonts.gstatic.com/s/yantramanav/v1/FwdziO-qWAO8pZg8e376kaCWcynf_cDxXwCLxiixG1c.ttf:tlg:regular" => esc_html__( "Yantramanav - regular", "tlg_framework"),"Yantramanav:tlg://fonts.gstatic.com/s/yantramanav/v1/HSfbC4Z8I8BZ00wiXeA5bMCNfqCYlB_eIx7H1TVXe60.ttf:tlg:500" => esc_html__( "Yantramanav - 500", "tlg_framework"),"Yantramanav:tlg://fonts.gstatic.com/s/yantramanav/v1/HSfbC4Z8I8BZ00wiXeA5bHe1Pd76Vl7zRpE7NLJQ7XU.ttf:tlg:700" => esc_html__( "Yantramanav - 700", "tlg_framework"),"Yantramanav:tlg://fonts.gstatic.com/s/yantramanav/v1/HSfbC4Z8I8BZ00wiXeA5bCenaqEuufTBk9XMKnKmgDA.ttf:tlg:900" => esc_html__( "Yantramanav - 900", "tlg_framework"),"Yellowtail:tlg://fonts.gstatic.com/s/yellowtail/v6/HLrU6lhCTjXfLZ7X60LcB_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Yellowtail - regular", "tlg_framework"),"Yeseva One:tlg://fonts.gstatic.com/s/yesevaone/v10/eenQQxvpzSA80JmisGcgX_esZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Yeseva One - regular", "tlg_framework"),"Yesteryear:tlg://fonts.gstatic.com/s/yesteryear/v5/dv09hP_ZrdjVOfZQXKXuZvesZW2xOQ-xsNqO47m55DA.ttf:tlg:regular" => esc_html__( "Yesteryear - regular", "tlg_framework"),"Zeyada:tlg://fonts.gstatic.com/s/zeyada/v6/hmonmGYYFwqTZQfG2nRswQ.ttf:tlg:regular" => esc_html__( "Zeyada - regular", "tlg_framework"),
		);
		$custom_fonts = get_option( 'tlg_framework_custom_fonts', '' );
		$pieces_fonts = explode(",", $custom_fonts);
		if (!empty($pieces_fonts)) {
			foreach ($pieces_fonts as $font) {
				$font_array = explode("|", $font);
				if (!empty($font_array) & count($font_array) == 3) {
					$key = $font_array[0].":tlg:".$font_array[1].":tlg:".$font_array[2];
					$value = $font_array[0]." - ".$font_array[2];
					$fonts[$key] = $value;
				}
			}
		}
		return $fonts;
	}
}