<?php
/**
 * Theme Modules
 *
 * @package TLG Framework
 *
 */

class TLGFrameworkVCModules 
{
	public $modules = null;

	public function __construct() 
	{
		$this->modules = tlg_framework_get_theme_modules();
		add_action( 'vc_backend_editor_render', array($this, 'tlg_framework_vc_backend_editor_render') );
		add_action( 'wp_ajax_tlg_vc_ajax_backend_load', array($this, 'tlg_framework_vc_ajax_backend_load') );
	}

	public function tlg_framework_vc_backend_editor_render() 
	{
		$modules = array();
        if (! empty($this->modules)) {
        	foreach ($this->modules as $module) {
        		if (isset($module['category'])) {
        			$modules[$module['category']][] = $module;
        		}
	        }
        }
		$categories = array_keys($modules);
		?>
		<div class="vc_ui-font-open-sans vc_ui-panel-window vc_templates-panel vc_media-xs vc_ui-panel ui-draggable vc_media-sm vc_media-md vc_media-lg" data-vc-panel=".vc_ui-panel-header-header" data-vc-ui-element="panel-templates" id="tlg-vc_ui-panel-modules">
			<div class="vc_ui-panel-window-inner">
				<div class="vc_ui-template-panel-header-container vc_ui-panel-header-container vc_ui-panel-header-o-stacked-bottom">
					<div class="vc_ui-panel-header">
						<div class="vc_ui-panel-header-controls">
							<button id="tlg-module-close-button" type="button" class="vc_general vc_ui-control-button vc_ui-close-button" data-vc-ui-element="button-close">
								<i class="vc-composer-icon vc-c-icon-close"></i>
							</button>
						</div>
						<div class="vc_ui-panel-header-header vc_ui-grid-gap" data-vc-panel-container=".vc_ui-panel-header-container">
							<h3 class="vc_ui-panel-header-heading"><?php echo wp_get_theme()->get( 'Name' ) . ' ' . esc_html__( 'Studio', 'tlg_framework' ); ?></h3>
						</div>
						<div class="vc_ui-panel-header-content" data-vc-ui-element="panel-header-content">
							<ul class="vc_general vc_ui-tabs-line" data-vc-ui-element="panel-tabs-controls">
								<?php
								if (! empty($categories)) {
									$currentTab = 1;
									foreach ($categories as $category) {
										echo '<li class="vc_panel-tabs-control '.($currentTab++ == 1 ? 'vc_active' : '').'"><button data-vc-ui-element-target="[data-tab=tlg_tab_'.$currentTab.']" class="vc_ui-tabs-line-trigger" data-vc-ui-element="panel-tab-control">'. $category .'</button></li>';
									}
								}
								?>
							</ul>
						</div>
					</div>
				</div>
				<div class="vc_ui-panel-content-container">
					<div class="vc_ui-panel-content" data-vc-ui-element="panel-content">
						<div class="vc_panel-tabs">
						<?php
						if (! empty($modules)) {
							$currentTab = 1;
							foreach ($modules as $category ) {
								echo '<div class="vc_edit-form-tab vc_row vc_ui-flex-row ' . ( $currentTab++ == 1 ? ' vc_active' : '' ) . '" data-vc-ui-element="panel-edit-element-tab" data-tab="tlg_tab_'.$currentTab.'">';
								if (isset($category[0]['category']) && in_array($category[0]['category'], array('Homepage', 'Pages'))) { ?>
									<div class="vc_message_box vc_message_box-standard vc_message_box-rounded vc_color-warning">
										<div class="vc_message_box-icon"><i class="fa fa-info-circle"></i>
										</div><p class="messagebox_text"><?php echo esc_html__( 'The Navian wireframe template below comes with sample elements layout only, you\'ll need add your own actual content/image in each element settings. Those templates do not include header menu setting, you can change it in Appearances > Customize > Header, or using individual page options Header Layout & Page Title Layout at bottom of the page editor.', 'tlg_framework' ); ?></p>
									</div>
								<?php }
								foreach ($category as $module ) {
									$columnClass = '';
									if ($module['col'] == 2) {
										$columnClass = 'vc_col-sm-6';
									} elseif ($module['col'] == 3) {
										$columnClass = 'vc_col-sm-4';
									} elseif ($module['col'] == 4) {
										$columnClass = 'vc_col-sm-3';
									}
									echo '<div class="tlg-module-item vc_column vc_col-xs-12 '.esc_attr($columnClass).'" data-module-id="' . $module['id'] . '">';
									echo '<div class="tlg-module-inner">';
									echo '<div class="tlg-module-img">';
									echo '<img data-src="' . esc_url( $module['img'] ) . '" alt="' . esc_attr( $module['name'] ) . '" />';
									echo '<div class="tlg_preloader"><span class="tlg_spinner"></span></div>';
									echo '</div>';
									echo $module['name'] ? '<h3>' . esc_html( $module['name'] ) . '</h3>' : '';
									echo isset($module['desc']) && $module['desc'] ? '<p class="vc_description">'.esc_html($module['desc']).'</p>' : '';
									echo '</div>';
									echo '</div>';
								}
								echo '</div>';
							}
						}
						?>
						</div>
					</div>
				</div>
			</div>
		</div><?php
	}

	public function tlg_framework_vc_ajax_backend_load() 
	{
		$id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
		if ($id) {
			$key = array_search($id, array_column($this->modules, 'id'));
			if (isset($this->modules[$key]['code'])) {
				echo trim($this->modules[$key]['code']);
			}
		}
		die();
	}
}

require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_header_single.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_header_slider.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_page_title.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_headings.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_spacer.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_blog.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_portfolio.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_team.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_clients.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_testimonials.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_icon_box.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_icons.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_icon_title_list.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_buttons.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_buttons_modal.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_alert.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_skill_bar.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_counter.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_accordion.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_tabs.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_showcase.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_gmap.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_intro_content.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_intro_carousel.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_image_caption.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_pricing_table.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_countdown.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_cta.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_instagram.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_timeline.php' );
require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_steps.php' );
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
	require_once( TLG_FRAMEWORK_PATH . 'includes/vc_shortcodes/tlg_shop.php' );
}
if (function_exists( 'vc_add_shortcode_param')) {
	if (!function_exists('tlg_framework_vc_font_field')) {		
		function tlg_framework_vc_font_field($settings, $value) 
		{
			$list_fonts = array_flip(tlg_framework_get_font_options());
			$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
			$output = '<select name="'.esc_attr($param_name).'" class="wpb_vc_param_value wpb-input wpb-select">';
			foreach ($list_fonts as $name => $font) {
				$output .= '<option '.($font == $value ? 'selected="selected"' : '').' value="'.esc_attr($font).'">'.esc_attr($name).'</option>';
			}
			$output .= '</select>';
			return $output;
		}
		vc_add_shortcode_param( 'tlg_font', 'tlg_framework_vc_font_field' );
	}

	if (! function_exists('tlg_framework_vc_number_field')) {
		function tlg_framework_vc_number_field($settings, $value) 
		{
			$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
			$type = isset($settings['type']) ? $settings['type'] : '';
			$min = isset($settings['min']) ? $settings['min'] : '';
			$max = isset($settings['max']) ? $settings['max'] : '';
			$step = isset($settings['step']) ? $settings['step'] : '';
			$suffix = isset($settings['suffix']) ? $settings['suffix'] : '';
			return '<input type="number" min="'.esc_attr($min).'" max="'.esc_attr($max).'" step="'.esc_attr($step).'" class="wpb_vc_param_value ' . esc_attr($param_name) . ' ' . esc_attr($type) . '" name="' . esc_attr($param_name) . '" value="'.esc_attr($value).'" style="max-width:100px; margin-right: 10px;" />'.$suffix;
		}
		vc_add_shortcode_param( 'tlg_number', 'tlg_framework_vc_number_field' );
	}

	if (! function_exists('tlg_framework_vc_icons_field')) {
		function tlg_framework_vc_icons_field($settings, $value) 
		{
			$icons  = tlg_framework_get_icons();
			$output = '<div class="tlg-icons"><div class="tlg-icons-wrapper">';
			foreach( $icons as $icon ) {
				if (!empty($icon)) {
					$active  = $value == $icon ? ' active' : '';
					$output .= '<i class="icon '. $icon . $active .'" data-icon-class="'. $icon .'"></i>';
				}
			}
			$output .= '</div><input name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-textinput tlg-icon-value ' .esc_attr( $settings['param_name'] ) . ' ' . esc_attr( $settings['type'] ) . '_field" type="text" value="' . esc_attr( $value ) . '" />' . '</div>';
		    return $output;
		}
		vc_add_shortcode_param( 'tlg_icons', 'tlg_framework_vc_icons_field' );
	}

	if (! function_exists('tlg_framework_vc_datetime_field')) {
		function tlg_framework_vc_datetime_field($settings, $value) 
		{
			$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
			$type = isset($settings['type']) ? $settings['type'] : '';
			$class = isset($settings['class']) ? $settings['class'] : '';
			$uid = uniqid('datetimepicker-'.esc_attr(rand()));
			return '<div><input id="datetimepicker'.esc_attr( $uid ).'" type="text" size="16" readonly class="wpb_vc_param_value ' . esc_attr( $param_name . ' ' . $type . ' ' . $class ) . '" name="' . esc_attr( $param_name ) . '" value="'. esc_attr( $value ) .'"/></div><script type="text/javascript">jQuery(document).ready(function(){jQuery("#datetimepicker'.esc_attr( $uid ).'").datetimepicker();})</script>';
		}
		vc_add_shortcode_param( 'tlg_datetime', 'tlg_framework_vc_datetime_field' );
	}
}
if (!function_exists('tlg_framework_get_theme_modules')) {
	function tlg_framework_get_theme_modules() 
	{
		$modules = array();
		$category = array(
			'home' => esc_html__( 'Homepage' , 'tlg_framework' ),
			'page' => esc_html__( 'Pages' , 'tlg_framework' ),
			'element' => esc_html__( 'Elements' , 'tlg_framework' ),
			'icon' => esc_html__( 'Icon Boxes' , 'tlg_framework' ),
		);
		$homepage = array(
			'demo-1' => esc_html__( 'Business' , 'tlg_framework' ), 'demo-1-desc' => esc_html__( 'Main Demo' , 'tlg_framework' ),
			'demo-2' => esc_html__( 'Corporate' , 'tlg_framework' ), 'demo-2-desc' => esc_html__( 'Center Left Transparent' , 'tlg_framework' ),
			'demo-3' => esc_html__( 'Digital Agency' , 'tlg_framework' ), 'demo-3-desc' => esc_html__( 'Standard Header' , 'tlg_framework' ),
			'demo-4' => esc_html__( 'Photos Agency' , 'tlg_framework' ), 'demo-4-desc' => esc_html__( 'Minimal Transparent' , 'tlg_framework' ),
			'demo-5' => esc_html__( 'News' , 'tlg_framework' ), 'demo-5-desc' => esc_html__( 'Left Menu' , 'tlg_framework' ),
			'demo-6' => esc_html__( 'Startup Agency' , 'tlg_framework' ), 'demo-6-desc' => esc_html__( 'Standard Header' , 'tlg_framework' ),
			'demo-7' => esc_html__( 'Restaurant' , 'tlg_framework' ), 'demo-7-desc' => esc_html__( 'Transparent Header' , 'tlg_framework' ),
			'demo-8' => esc_html__( 'E-Commerce' , 'tlg_framework' ), 'demo-8-desc' => esc_html__( 'Minimal Header' , 'tlg_framework' ),
			'demo-9' => esc_html__( 'Hotel & Resorts' , 'tlg_framework' ), 'demo-9-desc' => esc_html__( 'Standard Header' , 'tlg_framework' ),
			'demo-10' => esc_html__( 'Gym & Fitness' , 'tlg_framework' ), 'demo-10-desc' => esc_html__( 'Slider Header' , 'tlg_framework' ),
			'demo-11' => esc_html__( 'Barber' , 'tlg_framework' ), 'demo-11-desc' => esc_html__( 'Background Header' , 'tlg_framework' ),
			'demo-12' => esc_html__( 'Construction' , 'tlg_framework' ), 'demo-12-desc' => esc_html__( 'Transparent Header' , 'tlg_framework' ),
			'demo-13' => esc_html__( 'Freelancer' , 'tlg_framework' ), 'demo-13-desc' => esc_html__( 'Creative Portfolio' , 'tlg_framework' ),
			'demo-14' => esc_html__( 'Creative Portfolio' , 'tlg_framework' ), 'demo-14-desc' => esc_html__( 'Minimal Header' , 'tlg_framework' ),
			'demo-15' => esc_html__( 'Minimal Portfolio' , 'tlg_framework' ), 'demo-15-desc' => esc_html__( 'Classic Landing' , 'tlg_framework' ),
			'demo-16' => esc_html__( 'Photography' , 'tlg_framework' ), 'demo-16-desc' => esc_html__( 'Resume Photo' , 'tlg_framework' ),
			'demo-17' => esc_html__( 'Coming Soon' , 'tlg_framework' ), 'demo-17-desc' => esc_html__( 'Boxed Countdown' , 'tlg_framework' ),
			'demo-18' => esc_html__( 'Maintenance' , 'tlg_framework' ), 'demo-18-desc' => esc_html__( 'Classic Countdown' , 'tlg_framework' ),
		);
		$page = array(
			'page-1' => esc_html__( 'About Company' , 'tlg_framework' ), 'page-1-desc' => esc_html__( 'About' , 'tlg_framework' ),
			'page-2' => esc_html__( 'About Me' , 'tlg_framework' ), 'page-2-desc' => esc_html__( 'About' , 'tlg_framework' ),
			'page-3' => esc_html__( 'About Us' , 'tlg_framework' ), 'page-3-desc' => esc_html__( 'About' , 'tlg_framework' ),
			'page-4' => esc_html__( 'Our Team' , 'tlg_framework' ), 'page-4-desc' => esc_html__( 'Team Members' , 'tlg_framework' ),
			'page-5' => esc_html__( 'Our Service 1' , 'tlg_framework' ), 'page-5-desc' => esc_html__( 'Services' , 'tlg_framework' ),
			'page-6' => esc_html__( 'Our Service 2' , 'tlg_framework' ), 'page-6-desc' => esc_html__( 'Services' , 'tlg_framework' ),
			'page-7' => esc_html__( 'Contact Us 1' , 'tlg_framework' ), 'page-7-desc' => esc_html__( 'Contact' , 'tlg_framework' ),
			'page-8' => esc_html__( 'Contact Us 2' , 'tlg_framework' ), 'page-8-desc' => esc_html__( 'Contact' , 'tlg_framework' ),
			'page-9' => esc_html__( 'Contact Us 3' , 'tlg_framework' ), 'page-9-desc' => esc_html__( 'Contact' , 'tlg_framework' ),
			'page-10' => esc_html__( 'Pricing Table' , 'tlg_framework' ), 'page-10-desc' => esc_html__( 'Pricing' , 'tlg_framework' ),
		);
		$element = array(
			'el-1' => esc_html__( 'Call To Action 1' , 'tlg_framework' ),
			'el-2' => esc_html__( 'Call To Action 2' , 'tlg_framework' ),
			'el-3' => esc_html__( 'Call To Action 3' , 'tlg_framework' ),
			'el-4' => esc_html__( 'Call To Action 4' , 'tlg_framework' ),
			'el-5' => esc_html__( 'Accordion 1' , 'tlg_framework' ),
			'el-6' => esc_html__( 'Accordion 2' , 'tlg_framework' ),
			'el-7' => esc_html__( 'Tabs 1' , 'tlg_framework' ),
			'el-8' => esc_html__( 'Tabs 2' , 'tlg_framework' ),
			'el-9' => esc_html__( 'Content Image 1' , 'tlg_framework' ),
			'el-10' => esc_html__( 'Content Image 2' , 'tlg_framework' ),
			'el-11' => esc_html__( 'Content Image 3' , 'tlg_framework' ),
			'el-12' => esc_html__( 'Content Image 4' , 'tlg_framework' ),
			'el-13' => esc_html__( 'Content Carousel 1' , 'tlg_framework' ),
			'el-14' => esc_html__( 'Content Carousel 2' , 'tlg_framework' ),
			'el-15' => esc_html__( 'Counter 1' , 'tlg_framework' ),
			'el-16' => esc_html__( 'Counter 2' , 'tlg_framework' ),
			'el-17' => esc_html__( 'Pricing Table 1' , 'tlg_framework' ),
			'el-18' => esc_html__( 'Pricing Table 2' , 'tlg_framework' ),
		);
		$icon = array(
			'icon-1' => esc_html__( 'Icon Hover' , 'tlg_framework' ),
			'icon-2' => esc_html__( 'Icon Animate Boxed' , 'tlg_framework' ),
			'icon-3' => esc_html__( 'Icon Standard' , 'tlg_framework' ),
			'icon-4' => esc_html__( 'Icon Left' , 'tlg_framework' ),
			'icon-5' => esc_html__( 'Icon Right' , 'tlg_framework' ),
			'icon-6' => esc_html__( 'Icon Center' , 'tlg_framework' ),
			'icon-7' => esc_html__( 'Icon Color' , 'tlg_framework' ),
			'icon-8' => esc_html__( 'Icon Subtitle' , 'tlg_framework' ),
			'icon-9' => esc_html__( 'Icon Image' , 'tlg_framework' ),
			'icon-10' => esc_html__( 'Icon Image Zoom' , 'tlg_framework' ),
			'icon-11' => esc_html__( 'Icon Image Scroll' , 'tlg_framework' ),
			'icon-12' => esc_html__( 'Icon Content' , 'tlg_framework' ),
			'icon-13' => esc_html__( 'Icon Color Box' , 'tlg_framework' ),
		);
// HOMEPAGE ---------------------------------------------------

	// Home Pages 1 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column][rev_slider alias="home-slider-1"][/vc_column][/vc_row][vc_row tlg_padding="pb0" el_id="main"][vc_column][tlg_headings layout="bottom" title="The perfect WordPress theme
for a <cite><i>Startup Business</i></cite>" subtitle="OUR SERVICES" icon_color="#f4c300" divider_color="#f4c300"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-pencil-alt" title="Consulting Company" button_text="View More" btn_icon="ti-angle-right" image="8302"]Whether you want an promo video we can provide the services you require.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-crown" title="Software Development" button_text="View More" btn_icon="ti-angle-right" image="8301"]The range of areas by the term consultant is wide to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-timer" title="Training Program" button_text="View More" btn_icon="ti-angle-right" image="8306"]The consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_carousel style="intro-left"][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8301" title="Use these business marketing and management templates" button_text="Discover Now"]

Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.

Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.

[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8306" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]

Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.

Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.

[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" title="The people behind your success
get to know <cite><i>Our Team</i></cite>" subtitle="MEET OUR TEAM" icon_color="#f4c300" divider_color="#f4c300"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_padding="pt0"][vc_column][tlg_team pppage="4" layout="fullwidth" column="4col" filter="249"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" title="We offer flexible support to make sure
your business runs <cite><i>Smoothly</i></cite>" subtitle="FEATURED BUSINESS" icon_color="#f4c300" divider_color="#f4c300"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt0"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-world" title="Content Creatio" image="8304" icon_color="#49c5b6" box_bg_color_hover="#49c5b6" button_text="Read More" btn_icon="ti-angle-right"]The requirement for an experience is to meet the needs of the customer.[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-gift" title="The Lifestyle" image="8308" icon_color="#ff4040" box_bg_color_hover="#ff4040" button_text="Read More" btn_icon="ti-angle-right"]The range of areas by the term is wide to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-bookmark-alt" title="The Experiment" icon_color="#87c70f" image="8302" box_bg_color_hover="#87c70f" button_text="Read More" btn_icon="ti-angle-right"]The suggests the design layouts to the user’s behavior[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-blackboard" title="Seminar Business" icon_color="#194bed" image="8307" box_bg_color_hover="#194bed" button_text="Read More" btn_icon="ti-angle-right"]The consultant is engaged according to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-package" title="Growth Workshop" icon_color="#ffa3b5" image="8301" box_bg_color_hover="#ffa3b5" button_text="Read More" btn_icon="ti-angle-right"]WordPress Page Builder plugin with drag &amp; drop interface.[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-zoom-in" title="Target Market" icon_color="#fb7a46" image="8306" box_bg_color_hover="#fb7a46" button_text="Read More" btn_icon="ti-angle-right"]Responsive design is an approach to the user's behavior.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt64 pb64"][vc_column][tlg_clients layout="carousel-auto"][/vc_column][/vc_row][vc_row tlg_text_align="text-center"][vc_column][tlg_headings layout="bottom" title="Get to know the case studies
in our featured <cite><i>Portfolio</i></cite>" subtitle="OUR PROJECTS" icon_color="#f4c300" divider_color="#f4c300"][tlg_portfolio pppage="6" layout="modern-3col" show_filter="No" order="ASC"][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column css_animation="bottom-to-top" width="1/2" css=".vc_custom_1564593145407{padding-right: 12% !important;}"][tlg_headings alignment="left" separator="line" spacing="mb16" title="Businessman pointing to a growth chart showing success"][vc_column_text]We take great pride in the quality of our content. Our writers create original content that is free of ethical concerns.[/vc_column_text][tlg_spacer height="15"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-light-bulb" title="Innovative Ideas"]Our most popular service is our Virtual Receptionist. We know that sometimes it’s difficult to get to the phone.[/tlg_icon_box][tlg_spacer height="8"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-headphone-alt" title="Information Survey"]You don’t want to miss that important call that could be the start of an exciting new business opportunity.[/tlg_icon_box][/vc_column][vc_column css_animation="bottom-to-top" width="1/2"][tlg_intro_content layout="video" video_hover="shadow" image="8305" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4"][/tlg_intro_content][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" title="Things that matter to us
from our latest <cite><i>Articles</i></cite>" subtitle="OUR BLOG" icon_color="#f4c300" divider_color="#f4c300"][tlg_blog layout="carouseldetail-3col" pppage="12"][/vc_column][/vc_row][vc_row tlg_enable_overlay="yes" css=".vc_custom_1543246601368{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2018/10/leone-venter.jpg?id=7771) !important;}" tlg_bg_overlay_value="0"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" title="Here are just a few reviews
from our satisfied <cite><i>Clients</i></cite>" subtitle="OUR TESTIMONIALS" icon_color="#f4c300" divider_color="#f4c300"][tlg_testimonial layout="carousel" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_enable_overlay="yes" el_id="contact" css=".vc_custom_1563726979727{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/partnerss.jpg?id=8309) !important;}" tlg_bg_overlay="#000000" tlg_bg_overlay_value="8.4" el_class="white-form"][vc_column width="1/2" css=".vc_custom_1561994135727{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][tlg_gmap zoom="14" style="dark_blue" locations="Str. 151, Washington, NY" height="740" marker_image="5403"][/vc_column][vc_column width="1/2" css=".vc_custom_1561999440205{padding-top: 8% !important;padding-right: 19% !important;padding-bottom: 8% !important;padding-left: 10% !important;}"][tlg_headings alignment="left" layout="bottom" spacing="mb40" title="Need help finding information, we would love to hear <cite><i>from you</i></cite>" icon="ti-slice" divider_color="#49c5b6"][vc_column_text]Please complete the form and we'll get back to you within 1 – 2 business days. We look forward to working with you.[/vc_column_text][contact-form-7 id="681"][vc_column_text]For any question contact our 24/7 call center: <span class="primary-color">+001 345 6889</span>[/vc_column_text][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-1'], 'desc' => $homepage['demo-1-desc'], 'id' => 'demo-1', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d1.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 2 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_vertical_align="yes"][vc_column][rev_slider alias="home-slider-2"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" title="<u>Business Planning</u>" subtitle="OUR SERVICES"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/2"][tlg_icon_box customize_icon="yes" box_layout="animate" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-world" title="Video Interactive Production" subtitle="Fantastic onsite" image="8308" icon_color="#49c5b6" box_bg_color_hover="#49c5b6" button_text="Read More" btn_icon="ti-angle-right"]The first requirement for an user experience is to meet the exact needs of the customer.[/tlg_icon_box][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-user" title="Practice" subtitle="Industry" icon_color="#ff3a2d" image="8310" box_bg_color_hover="#ff3a2d"]Responsive is an approach that suggests the design[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-pie-chart" title="Consulting" subtitle="Program" icon_color="#87c70f" image="8300" box_bg_color_hover="#87c70f"]Page Builder plugin with drag &amp; drop interface[/tlg_icon_box][/vc_column_inner][vc_column_inner width="1/2"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-shield" title="Security" subtitle="Sercure" icon_color="#ffa3b5" image="8303" box_bg_color_hover="#ffa3b5"]Suggests the design to the user’s behavior[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-layers" title="Financial" subtitle="Statement" icon_color="#ddb833" image="8301" box_bg_color_hover="#ddb833"]Build any page layout fast and easy[/tlg_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings layout="bottom" title="<u>Our Projects</u>" subtitle="CASE STUDIES"][vc_column_text]To see a selection of my designs and sketches, which is how all our best designs start, take a look at our portfolio page. To see who I have worked with see our client list and stockists.[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-primary"][vc_column][tlg_intro_carousel style="intro-left"][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8301" title="Use these business marketing and management templates" button_text="Discover Now"]</p>
<p>Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.</p>
<p>Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.</p>
<p>[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8306" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]</p>
<p>Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.</p>
<p>Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.</p>
<p>[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_carousel][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8308" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]</p>
<p>Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.</p>
<p>Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.</p>
<p>[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8300" title="Use these business marketing and management templates" button_text="Discover Now"]</p>
<p>Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.</p>
<p>Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.</p>
<p>[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_background_style="bg-primary"][vc_column width="1/4"][tlg_counter to="2450" suffix_text="+" title="Launched Projects" layout="side" icon="ti-layers"][/vc_column][vc_column width="1/4"][tlg_counter to="320" suffix_text="+" title="Codes in Month" layout="side" icon="ti-panel"][/vc_column][vc_column width="1/4"][tlg_counter to="54" suffix_text="+" title="Awards Winning" layout="side" icon="ti-world"][/vc_column][vc_column width="1/4"][tlg_counter to="98" suffix_text="%" title="Satisfy Customer" layout="side" icon="ti-user"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" title="<u>Our Partners</u>" subtitle="WE CREATE STUNNING PRODUCTS"][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][tlg_team pppage="4" layout="fullwidth" column="4col" filter="249"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" title="<u>See Real Results</u>" subtitle="OUR GREAT MEMBERS"][tlg_testimonial pppage="3" filter="251"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0 pb0"][vc_column][tlg_headings layout="bottom" title="<u>Our Offerings</u>" subtitle="FEATURED SERVICES"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box icon_layout="circle-icon" box_layout="center-box" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-ruler-pencil" title="Consulting Company" icon_color="#ffffff" box_bg_color="#9cdc78" button_text="View More" btn_icon="ti-angle-right" title_color="#ffffff" subtitle_color="#ffffff" content_color="#ffffff" box_bg_gradient_color="#77dcae"]Consulting and the means by which the consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_layout="circle-icon" box_layout="center-box" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-shield" title="Software Development" icon_color="#ffffff" box_bg_color="#ffbe9e" button_text="View More" btn_icon="ti-angle-right" title_color="#ffffff" subtitle_color="#ffffff" content_color="#ffffff" box_bg_gradient_color="#ff8e9e"]Consulting and the means by which the consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_layout="circle-icon" box_layout="center-box" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-thought" title="Training Program" box_bg_color="#55efcb" button_text="View More" btn_icon="ti-angle-right" icon_color="#ffffff" title_color="#ffffff" subtitle_color="#ffffff" content_color="#ffffff" box_bg_gradient_color="#5bcaff"]Consulting and the means by which the consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][/vc_row][vc_row full_width="stretch_row_content" tlg_background_style="bg-dark" tlg_enable_overlay="yes" tlg_bg_gradient_type="rotate" css=".vc_custom_1566467751881{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/friend-connections.jpg?id=8305) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#0000ef"][vc_column][tlg_cta btn_link="url:%23||" button_layout="btn btn-filled btn-rounded" icon="ti-user" title="Create your stunning website" subtitle="Let's create something great together!" url="#" button_text="Start a Project"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt64 pb64"][vc_column][tlg_clients layout="carousel-auto"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" title="<u>Our Blog</u>" subtitle="THE LATEST NEWS"][tlg_blog layout="carouseldetail-3col" pppage="10"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" title="<u>Our Services</u>" subtitle="FEATURED RESOURCES"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt0"][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-crown" title="Content Creation Services" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" image="8304" animate_bg_color="#49c5b6" animate_gd_color="#3451fb"]Consulting and the means by which the consultant[/tlg_icon_box][tlg_spacer height="40"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-gift" title="Income Resources and Billing" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" image="8310" animate_bg_color="#49c5b6" animate_gd_color="#3451fb"]Use these business planning, finance, marketing[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-layers" title="Software Add-ons For Developers" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8309"]Use these business planning, finance, marketing[/tlg_icon_box][tlg_spacer height="40"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-blackboard" title="Costs Finding Presenters" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8302"]Consulting and the means by which the consultant[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-desktop" title="Training Program Event Growth" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8306"]Engaged vary according to industry and practice[/tlg_icon_box][tlg_spacer height="40"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-settings" title="Continued growth and success" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8301"]Your first step towards small business success[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-reload" title="Financial Statement Market Tutorial" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8307"]Your first step towards small business success[/tlg_icon_box][tlg_spacer height="40"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-user" title="Seeking personal and growth" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8306"]Engaged vary according to industry and practice[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt0"][vc_column][tlg_headings layout="bottom" title="<u>Our Projects</u>" subtitle="THE CASE STUDIES"][tlg_portfolio pppage="6" layout="grid-3col" show_filter="No"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt180 pb180 pt-xs-80 pb-xs-80" tlg_enable_overlay="yes" tlg_text_align="text-center" css=".vc_custom_1563043855073{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/friend-connections.jpg?id=8305) !important;}" el_class="contact-line" tlg_bg_overlay="#fa4e40" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#0000ef" el_id="contact"][vc_column width="1/2"][tlg_headings alignment="left" layout="bottom" title="<u>Contact Us</u>" subtitle="SO WHAT’S NEXT?"][contact-form-7 id="681"][/vc_column][vc_column width="1/2" css=".vc_custom_1547052266827{padding-left: 10% !important;}"][tlg_headings alignment="left" layout="bottom" title="<u>Testimonials</u>" subtitle="SUCCESS STORIES"][tlg_testimonial layout="carousel-column" filter="251"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-2'], 'desc' => $homepage['demo-2-desc'], 'id' => 'demo-2', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d2.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 3 ----------------------------------------------------		
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_vertical_align="yes" el_class="white-form"][vc_column][tlg_header_single title_style="bold" cf7_shortcode="518" btn_link="url:%23|||" button_layout="play" enable_button_2="yes" btn_link_2="url:%23|||" button_layout_2="btn-text" hide_on_scroll="scrolled-no-hide" overlay="yes" title="A Digital Marketing <cite>Agency</cite>
Creative &amp; Technology" image="8308" header_text_color="#ffffff" button_text="Play" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4" button_text_2="Start your online business" button_size_2="14" button_text_color_2="#ffffff" button_text_hover_2="#ffffff" header_overlay_color="#0a0a0a" header_overlay_value="7"]The range of areas by the term consultant is wide digital marketing agency.
Consulting and the means by which the consultant is engaged.[/tlg_header_single][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="<u>What we do</u>" subtitle="OUR SERVICES" icon="ti-cup"][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-world" title="Content Creatio" image="8304" icon_color="#49c5b6" box_bg_color_hover="#49c5b6" button_text="Read More" btn_icon="ti-angle-right"]The requirement for an experience is to meet the needs of the customer.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-bookmark-alt" title="The Experiment" icon_color="#87c70f" image="8302" box_bg_color_hover="#87c70f" button_text="Read More" btn_icon="ti-angle-right"]The suggests the design layouts to the user’s behavior[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-package" title="Growth Workshop" icon_color="#ffa3b5" image="8301" box_bg_color_hover="#ffa3b5" button_text="Read More" btn_icon="ti-angle-right"]WordPress Page Builder plugin with drag &amp; drop interface.[/tlg_icon_box][/vc_column][/vc_row][vc_row][vc_column css_animation="bottom-to-top" width="1/2" css=".vc_custom_1564593145407{padding-right: 12% !important;}"][tlg_headings alignment="left" separator="line" spacing="mb16" title="Businessman pointing to a growth chart showing success"][vc_column_text]We take great pride in the quality of our content. Our writers create original content that is free of ethical concerns.[/vc_column_text][tlg_spacer height="15"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-light-bulb" title="Innovative Ideas"]Our most popular service is our Virtual Receptionist. We know that sometimes it’s difficult to get to the phone.[/tlg_icon_box][tlg_spacer height="8"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-headphone-alt" title="Information Survey"]You don’t want to miss that important call that could be the start of an exciting new business opportunity.[/tlg_icon_box][/vc_column][vc_column css_animation="bottom-to-top" width="1/2"][tlg_intro_content layout="video" video_hover="shadow" image="8305" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4"][/tlg_intro_content][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="<u>Meet Our Team</u>" subtitle="INNOVATORS" icon="ti-user"][tlg_team pppage="6" layout="fullwidth" filter="249"][tlg_spacer height="70"][tlg_headings layout="bottom" separator="line_icon" title="<u>Facts &amp; Statistics</u>" subtitle="OUR STATISTICS" icon="ti-stats-up"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0"][vc_column width="1/4"][tlg_counter to="2450" suffix_text="+" title="Launched Projects" layout="side" icon_color_primary="primary-color" icon="ti-layers"][/vc_column][vc_column width="1/4"][tlg_counter to="320" suffix_text="+" title="Codes in Month" layout="side" icon_color_primary="primary-color" icon="ti-panel"][/vc_column][vc_column width="1/4"][tlg_counter to="54" suffix_text="+" title="Awards Winning" layout="side" icon_color_primary="primary-color" icon="ti-world"][/vc_column][vc_column width="1/4"][tlg_counter to="98" suffix_text="%" title="Satisfied Customers" layout="side" icon_color_primary="primary-color" icon="ti-user"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" tlg_background_style="bg-primary" tlg_enable_overlay="yes" css=".vc_custom_1566450163693{padding-top: 5% !important;padding-bottom: 5% !important;background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/woman-phones.jpg?id=8310) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#5766d3"][vc_column][tlg_cta layout="center" btn_link="url:%23||" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-package" title="Create your stunning website" subtitle="MEET NAVIAN THEME" url="#" button_text="Purchase Now"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0" tlg_text_align="text-center"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" separator="line_icon" spacing="mb0" title="<u>Our Work</u>" subtitle="CASE STUDIES" icon="ti-bag"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_portfolio pppage="6" layout="grid-3col" show_filter="No"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0" tlg_text_align="text-center"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" separator="line_icon" title="<u>Pricing Options</u>" subtitle="PLAN PRICING" icon="ti-receipt"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0"][vc_column width="1/3"][tlg_pricing_table amount="29" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-thought" tbl_custom_layout="border-radius-m" title="Starter" subtitle="Best price" btn_color="#ffffff" btn_bg="#fa4e40" btn_border="#fa4e40" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#fa4e40" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>Unlimited hours of support</li>
 	<li>Social media integration</li>
 	<li>Analytic integration</li>
 	<li>Unlimited storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="49" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-package" tbl_custom_layout="border-radius-m" title="Business" subtitle="Most popular" tbl_price_color="#ffffff" btn_color="#ffffff" btn_bg="#49c5b6" btn_border="#49c5b6" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_price_bg_color="#49c5b6" tbl_icon_bgcolor="#49c5b6" tbl_icon_color="#ffffff" tbl_border="#49c5b6"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>10 hours of support</li>
 	<li>Social media integration</li>
 	<li>Advanced analytic</li>
 	<li>1GB of storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="69" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-world" tbl_custom_layout="border-radius-m" title="Enterprise" subtitle="Best choice" tbl_price_color="#5766d3" btn_color="#ffffff" btn_bg="#5766d3" btn_border="#5766d3" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#5766d3" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>Unlimited of support</li>
 	<li>Social media integration</li>
 	<li>Basic analytic</li>
 	<li>40TB of storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][/vc_row][vc_row tlg_large_container="small-container" tlg_background_style="bg-secondary"][vc_column][tlg_clients layout="carousel-auto"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1566449935422{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/collaboratings.jpg?id=8304) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#5766d3"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" separator="line_icon" title="<u>Our Testimonials</u>" subtitle="OUR CUSTOMERS" icon="ti-comments"][tlg_testimonial layout="carousel-quote" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0" tlg_text_align="text-center"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" separator="line_icon" spacing="mb16" title="<u>Our Blog</u>" subtitle="LATEST NEWS" icon="ti-notepad"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_blog layout="carouseldetail-3col"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" el_id="contact" el_class="white-form" css=".vc_custom_1566450240210{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/woman-phones.jpg?id=8310) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#5766d3"][vc_column width="1/2" css=".vc_custom_1560073067352{padding-right: 8% !important;}"][tlg_headings alignment="left" layout="bottom" separator="line" title="<u>Let work together</u>" subtitle="CONTACT US" icon="ti-email"][contact-form-7 id="681"][/vc_column][vc_column width="1/2"][tlg_headings alignment="left" layout="bottom" separator="line" title="<u>Questions &amp; Answers</u>" subtitle="FAQS" icon="ti-email"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="Software Development" icon="ti-desktop"]Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_accordion_content][tlg_accordion_content title="Training Program" icon="ti-user"]Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_accordion_content][tlg_accordion_content title="International Projects" icon="ti-world"]Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_accordion_content][/tlg_accordion][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-3'], 'desc' => $homepage['demo-3-desc'], 'id' => 'demo-3',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d3.jpg', 'col' => 4, 'code' => $code, 
		);
	// Home Pages 4 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row" el_class="header-contact" tlg_background_style="bg-dark"][vc_column][tlg_header_single layout="2-columns" alignment="text-left" title_style="thin" cf7_shortcode="7829" title="<strong>It is the photo</strong> that makes everything different that builds the trust factor." subtitle="Relationships are always built on trust. It is not the advertisement that may enhance the trust factor." image="8310" header_overlay_color="#0a0a0a" header_overlay_value="7"][/tlg_header_single][/vc_column][/vc_row][vc_row tlg_padding="pb0" tlg_text_align="text-center"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" css_animation="bottom-to-top" title="<u>Our experiences</u>" icon="ti-shield" subtitle="OUR SERVICES"][vc_column_text css_animation="bottom-to-top"]Cicero famously orated against his political opponent Lucius Sergius Catilina. Occasionally the first Oration against Catiline is taken for type specimens.[/vc_column_text][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row css_animation="bottom-to-top" tlg_padding="pb0"][vc_column width="1/2"][tlg_image_caption style="visible-caption" image_link="url:%23|||" image="8303" title="Interactive" subtitle="Summer in the city" button_text="Collection" bgcolor="rgba(213,37,23,0.83)"][tlg_spacer height="40"][tlg_image_caption style="visible-caption" image_link="url:%23|||" image="8301" title="Interactive" subtitle="Summer in the city" button_text="Collection" bgcolor="rgba(10,10,10,0.83)"][/vc_column][vc_column width="1/2"][tlg_image_caption style="visible-caption" image_link="url:%23|||" image="8306" title="Mid Classic" subtitle="A Design Piece" button_text="Shop Now" bgcolor="rgba(0,0,239,0.83)"][tlg_spacer height="40"][tlg_image_caption style="visible-caption" image_link="url:%23|||" image="8309" title="Mid Classic" subtitle="A Design Piece" button_text="Shop Now" bgcolor="rgba(66,168,15,0.83)"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_padding="pt0"][vc_column][tlg_spacer layout="line" line_style="spacer-large"][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column css_animation="bottom-to-top" width="1/2" css=".vc_custom_1564593145407{padding-right: 12% !important;}"][tlg_headings alignment="left" separator="line" spacing="mb16" title="Businessman pointing to a growth chart showing success"][vc_column_text]We take great pride in the quality of our content. Our writers create original content that is free of ethical concerns.[/vc_column_text][tlg_spacer height="15"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-light-bulb" title="Innovative Ideas"]Our most popular service is our Virtual Receptionist. We know that sometimes it’s difficult to get to the phone.[/tlg_icon_box][tlg_spacer height="8"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-headphone-alt" title="Information Survey"]You don’t want to miss that important call that could be the start of an exciting new business opportunity.[/tlg_icon_box][/vc_column][vc_column css_animation="bottom-to-top" width="1/2"][tlg_intro_content layout="video" video_hover="shadow" image="8305" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4"][/tlg_intro_content][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_content layout="box-text-center" btn_link="url:%23|||" button_layout="btn-action" image="8302" title="The Visual Drag &amp; Drop Page Builder" button_text="READ MORE"]Analysis of your customers is key in responding to your promotional needs.[/tlg_intro_content][/vc_column][/vc_row][vc_row][vc_column width="1/3" css=".vc_custom_1496397557245{padding-right: 15% !important;}"][tlg_headings alignment="left" layout="bottom" spacing="mb40" title="<u>Our clients</u>" subtitle="WORK WITH US"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="Multiple Demos" icon="ti-layers"]Torquent lacinia elementum sodales facilisis eleifend ultricies.[/tlg_accordion_content][tlg_accordion_content title="Visual Page Builder" icon="ti-map"]Sociosqu feugiat nisi metus varius himenaeos ac ultricies fusce.[/tlg_accordion_content][tlg_accordion_content title="1-Click Import" icon="ti-import"]Torquent lacinia elementum sodales facilisis eleifend ultricies.</p>
<p>&nbsp;[/tlg_accordion_content][/tlg_accordion][/vc_column][vc_column width="2/3"][tlg_clients][tlg_spacer height="60"][vc_row_inner][vc_column_inner width="1/3"][tlg_counter to="80" suffix_text="%" title="Complete Projects" layout="side" icon="ti-check-box" icon_color="#49c5b6"][/vc_column_inner][vc_column_inner width="1/3"][tlg_counter to="36" suffix_text="+" title="Case Studies" layout="side" icon="ti-bookmark-alt" icon_color="#49c5b6"][/vc_column_inner][vc_column_inner width="1/3"][tlg_counter to="180" title="Work in progress" layout="side" icon="ti-pencil-alt" icon_color="#49c5b6"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" tlg_text_align="text-center" css=".vc_custom_1566405329036{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/collaboratings.jpg?id=8304) !important;}" tlg_bg_overlay="#fa4e40" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#49c5b6"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" css_animation="bottom-to-top" title="<u>Our testimonials</u>" subtitle="ABOUT US" icon="ti-thought"][tlg_testimonial layout="carousel-quote" css_animation="flipInX" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row][vc_column][tlg_headings layout="bottom" css_animation="bottom-to-top" title="<u>Latest news from us</u>" subtitle="OUR BLOG" icon="ti-bookmark-alt"][tlg_blog layout="carousel-3col" pppage="-1" css_animation="bottom-to-top"][tlg_spacer layout="line" line_style="spacer-large"][tlg_headings layout="bottom" css_animation="bottom-to-top" title="<u>Our activities</u>" subtitle="PHOTO GALLERY" icon="ti-image"][vc_column_text css_animation="bottom-to-top"][gallery layout="lightbox-fullwidth" ids="8309,8308,8307,8306,8305,8304"][/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content" tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1566405662406{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/01/mobile.jpg?id=7911) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#fa4e40"][vc_column][tlg_cta btn_link="url:%23||" button_layout="btn btn-rounded" title="Crafting beautiful brands and websites." subtitle="Let's create something great together!" url="#" button_text="Start a Project"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-4'], 'desc' => $homepage['demo-4-desc'], 'id' => 'demo-4',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d4.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 5 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row" el_class="white-form"][vc_column][tlg_header_single layout="3-columns" alignment="text-right" fullscreen="fullscreen-off" title_style="bold" cf7_shortcode="3409" btn_link="|||" btn_position="bottom" customize_font="yes" title="Your <u>Personal</u> Blog" subtitle="Get more stuff on theme design &amp; development" image="5500" title_font="Lora:tlg://fonts.gstatic.com/s/lora/v9/enKND5SfzQKkggBA_VnT1A.ttf:tlg:700" title_size="80" subtitle_font="Arvo:tlg://fonts.gstatic.com/s/arvo/v9/vvWPwz-PlZEwjOOIKqoZzA.ttf:tlg:regular" subtitle_size="21" content_font="0" subtitle_pb="40" header_overlay_value="0" title_text_color="#0c0c0c" subtitle_text_color="#616a66"][/tlg_header_single][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" el_id="main"][vc_column][tlg_blog layout="masonry-3col" pppage="12" order="ASC"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" el_class="white-form"][vc_column][tlg_header_single fullscreen="fullscreen-off" padding="pt240 pb240 pt-xs-80 pb-xs-80" title_style="thin" cf7_shortcode="518" parallax="parallax-off" btn_link="|||" title="Never miss <strong>a story</strong>!" image="8304" subtitle="Sign up and get the best of our news." header_overlay_color="#49c5b6" header_overlay_value="9" header_gradient_color="#0000ef"][/tlg_header_single][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_text_align="text-center"][vc_column width="1/3" css=".vc_custom_1493975877886{margin-top: -150px !important;}"][tlg_icon_box box_layout="center-box-left" btn_link="url:%23|||" button_layout="btn-action" color="primary-color-icon" icon="ti-palette" title="Be the first to know" subtitle="Sign up the newsletter" button_text="READ MORE"]Whether you want an video we can provide the services.

[/tlg_icon_box][/vc_column][vc_column width="1/3" css=".vc_custom_1493976389079{margin-top: -150px !important;}"][tlg_icon_box box_layout="center-box-left" btn_link="url:%23|||" button_layout="btn-action" color="primary-color-icon" icon="ti-vector" title="Inspiration Category" subtitle="Discover the world" box_bg_color="#f0f0f0" button_text="READ MORE"]The range of areas by the term consultant is to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3" css=".vc_custom_1493976939644{margin-top: -150px !important;}"][tlg_icon_box box_layout="center-box-left" btn_link="url:%23|||" button_layout="btn-action" icon="ti-thought" title="Get in touch" subtitle="+(106) 209-311-50" box_bg_color="#0a0a0a" title_color="#ffffff" subtitle_color="#ffffff" content_color="#ffffff" icon_color="#ffffff" button_text="READ MORE"]The consultant is engaged vary according to industry.[/tlg_icon_box][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" separator="line_icon" icon="ti-instagram" title="Follow our Inst@gram" subtitle="LATEST UPDATES"][tlg_instagram number="12" username="envato"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-5'], 'desc' => $homepage['demo-5-desc'], 'id' => 'demo-5',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d5.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 6 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_background_style="bg-primary" tlg_enable_overlay="yes" tlg_parallax="not-parallax" tlg_text_align="text-center" css=".vc_custom_1560074575199{padding-top: 180px !important;background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/partnerss.jpg?id=8309) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#5766d3"][vc_column][vc_row_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][tlg_spacer height="50" height_mobile="0"][tlg_headings spacing="mb40" customize_font="yes" title="The <u><cite>#Startup</cite></u><br />
Branding Agency" subtitle="We will work with you to fully understand your business strategy." title_size="80" subtitle_size="19" subtitle_spacing="0"][tlg_spacer height="50"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][tlg_intro_content layout="video" btn_link="url:%23|||" button_layout="btn-text" box_shadow="yes" image="7819" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4"][/tlg_intro_content][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row tlg_padding="pb0" el_id="main"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="We offer flexible support to make sure<br> your business runs <cite><i>Smoothly</i></cite>" subtitle="OUR SERVICES" icon="ti-cup"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-pencil-alt" title="Consulting Company" button_text="View More" btn_icon="ti-angle-right" image="8302"]Consulting and the means by which the consultant is according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-crown" title="Software Development" button_text="View More" btn_icon="ti-angle-right" image="8301"]The range of areas by the term consultant is wide to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-timer" title="Training Program" button_text="View More" btn_icon="ti-angle-right" image="8306"]The consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][/vc_row][vc_row][vc_column width="1/2" css=".vc_custom_1566214636249{padding-right: 12% !important;}"][tlg_headings alignment="left" separator="line" spacing="mb16" title="Businessman pointing to a growth chart showing success"][vc_column_text]We take great pride in the quality of our content. Our writers create original content that is free of ethical concerns.[/vc_column_text][tlg_spacer height="15"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-light-bulb" title="Innovative Ideas"]Our most popular service is our Virtual Receptionist. We know that sometimes it’s difficult to get to the phone.[/tlg_icon_box][tlg_spacer height="8"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-headphone-alt" title="Information Survey"]You don’t want to miss that important call that could be the start of an exciting new business opportunity.[/tlg_icon_box][/vc_column][vc_column width="1/2"][tlg_intro_content layout="video" video_hover="shadow" image="8305" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4"][/tlg_intro_content][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_text_align="text-center"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="The startup company <br>with their process <cite><i>Steps</i></cite>" subtitle="HOW WE WORK" icon="ti-briefcase"][tlg_steps style="steps-style-2"][tlg_steps_content step_link="url:%23|||" icon="ti-user" title="Sign In" line_color="" icon_color_hover="#ffffff" bg_color_hover="#01acff" subtitle="Process the desire"][tlg_steps_content step_link="url:%23|||" icon="ti-shopping-cart" title="Cart" line_color="" subtitle="Evaluation staff" icon_color_hover="#ffffff" bg_color_hover="#0ab78f"][tlg_steps_content step_link="url:%23|||" icon="ti-truck" title="Shipping" line_color="" subtitle="Process the capabilities" icon_color_hover="#ffffff" bg_color_hover="#0f37ff"][tlg_steps_content step_link="url:%23|||" icon="ti-receipt" title="Payment" line_color="" subtitle="Perfomance objectives" icon_color_hover="#ffffff" bg_color_hover="#f6653c"][tlg_steps_content step_link="url:%23|||" icon="ti-check" title="All Done" line_color="" subtitle="Business performance" icon_color_hover="#ffffff" bg_color_hover="#4caf50"][/tlg_steps][/vc_column][/vc_row][vc_row full_width="stretch_row_content" tlg_text_align="text-center"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="Get to know the case studies<br> in our featured <cite><i>Portfolio</i></cite>" subtitle="OUR WORK" icon="ti-world"][tlg_portfolio pppage="6" layout="modern-3col"][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column css=".vc_custom_1488341145859{background-color: #f4f4f4 !important;}"][tlg_cta btn_link="url:%23||" button_layout="btn btn-filled btn-rounded" customize_font="yes" title_uppercase="no" icon="ti-arrow-circle-right" title="Crafting beautiful brands and websites." subtitle="Let's create something great together!" url="#" button_text="Start a Project" title_size="30" title_color="#0c0c0c"][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="Things that matter to us<br> from our latest <cite><i>Articles</i></cite>" subtitle="OUR BLOG" icon="ti-slice"][tlg_blog layout="carousel"][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="The great team of corporate <br>business template <cite><i>Members</i></cite>" subtitle="OUR TEAM" icon="ti-user"][tlg_team pppage="6" layout="fullwidth" order="ASC" filter="227"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="We offer various services <br>to improve <cite><i>your sites</i></cite>" subtitle="BUSINESS PROCESS" icon="ti-direction-alt"][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0"][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-crown" title="Content Creation Services" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" image="8304" animate_bg_color="#49c5b6" animate_gd_color="#3451fb"]Consulting and the means by which the consultant[/tlg_icon_box][tlg_spacer height="40"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-gift" title="Income Resources and Billing" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" image="8310" animate_bg_color="#49c5b6" animate_gd_color="#3451fb"]Consulting and the means by which the consultant[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-layers" title="Software Add-ons For Developers" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8309"]Use these business planning, finance, marketing[/tlg_icon_box][tlg_spacer height="40"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-blackboard" title="Costs Finding Presenters" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8302"]Use these business planning, finance, marketing[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-desktop" title="Training Program Event Growth" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8306"]Engaged vary according to industry and practice[/tlg_icon_box][tlg_spacer height="40"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-settings" title="Continued growth and success" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8301"]Engaged vary according to industry and practice[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-reload" title="Financial Statement Market Tutorial" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8307"]Your first step towards small business success[/tlg_icon_box][tlg_spacer height="40"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-user" title="Seeking personal and growth" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8306"]Your first step towards small business success[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="Here are just a few reviews<br> from our satisfied <cite><i>Clients</i></cite>" subtitle="OUR TESTIMONIALS" icon="ti-thought"][tlg_testimonial filter="251"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="Our startup app service <br>template plan and <cite><i>Price</i></cite>" subtitle="OUR PRICE" icon="ti-map"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][tlg_pricing_table amount="29" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-thought" tbl_custom_layout="border-radius-m" title="Starter" subtitle="Best price" btn_color="#ffffff" btn_bg="#fa4e40" btn_border="#fa4e40" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#fa4e40" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>Unlimited hours of support</li>
<li>Social media integration</li>
<li>Analytic integration</li>
<li>Unlimited storage space</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="49" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-package" tbl_custom_layout="border-radius-m" title="Business" subtitle="Most popular" tbl_price_color="#ffffff" btn_color="#ffffff" btn_bg="#49c5b6" btn_border="#49c5b6" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_price_bg_color="#49c5b6" tbl_icon_bgcolor="#49c5b6" tbl_icon_color="#ffffff" tbl_border="#49c5b6"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>10 hours of support</li>
<li>Social media integration</li>
<li>Advanced analytic</li>
<li>1GB of storage space</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="69" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-world" tbl_custom_layout="border-radius-m" title="Enterprise" subtitle="Best choice" tbl_price_color="#5766d3" btn_color="#ffffff" btn_bg="#5766d3" btn_border="#5766d3" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#5766d3" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>Unlimited of support</li>
<li>Social media integration</li>
<li>Basic analytic</li>
<li>40TB of storage space</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt64 pb64"][vc_column][tlg_clients layout="carousel-auto"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" tlg_background_style="bg-primary" tlg_enable_overlay="yes" css=".vc_custom_1566213475421{padding-top: 5% !important;padding-bottom: 5% !important;background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/collaboratings.jpg?id=8304) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#5766d3"][vc_column][tlg_cta layout="center" btn_link="url:%23||" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-package" title="Create your stunning website" subtitle="MEET NAVIAN THEME" url="#" button_text="Purchase Now"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-6'], 'desc' => $homepage['demo-6-desc'], 'id' => 'demo-6',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d6.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 7 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column][rev_slider_vc alias="home-slider-3"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" el_id="menu"][vc_column][tlg_headings layout="bottom" separator="line_icon" css_animation="bottom-to-top" title="Restaurant Menu" subtitle="Try out your own dishes" icon="ti-map" icon_color="#b18435" divider_color="#b18435"][tlg_intro_carousel style="box-top"][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_layout="btn-read-more" subtitle_link="|||" subtitle_first="yes" image="6112" title="GOAT BURNET <cite>SALAD</cite>" subtitle="$12.4 / 250G" button_text="Order Online"]Goat and burnet served on your looking bed of lettuce.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="6113" title="MUSTARD AND <cite>SPAGHETTI</cite>" subtitle="$21.5 / 180G" button_text="Order Online"]A crunchy salad culture child featuring baby plum tomatoes.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="6114" title="ELDERBERRY <cite>CRESS</cite>" subtitle="$22.5 / 180G" button_text="Order Online"]A crunchy traditional salad featuring fresh spring onion.[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" tlg_parallax="not-parallax" tlg_text_align="text-center" el_id="deal" css=".vc_custom_1560251310579{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/couple-in-loves.jpg?id=8337) !important;}" tlg_bg_overlay_value="9" tlg_bg_overlay="#444444" tlg_bg_gradient_color="#b18435"][vc_column][tlg_headings layout="bottom" separator="line" css_animation="bottom-to-top" title="Catalogues &amp; specials" subtitle="Amazing food recipes" icon="ti-gift" icon_color="#b18435" divider_color="#b18435"][vc_row_inner][vc_column_inner width="1/4"][tlg_icon_box customize_icon="yes" icon_box_link="url:%23|||" css_animation="flipInX" icon="ti-check-box" title="Dinner Lemon Cake" subtitle="Meat" image="7598" content_color="#ffffff"]We are a specialist food retailer and we have been selling high quality cake.[/tlg_icon_box][/vc_column_inner][vc_column_inner width="1/4"][tlg_icon_box customize_icon="yes" icon_box_link="url:%23|||" css_animation="flipInX" icon="ti-bookmark-alt" title="Steak" subtitle="Beef" image="7599" content_color="#ffffff"]A perfect healthy snack cake rice or a nice slim cake topping for your cereal.[/tlg_icon_box][/vc_column_inner][vc_column_inner width="1/4"][tlg_icon_box customize_icon="yes" icon_box_link="url:%23|||" css_animation="flipInX" icon="ti-heart" title="Marron Cake" subtitle="Layered" image="7601" content_color="#ffffff"]Ordering your shopping online is just a click away cake rice into the store.[/tlg_icon_box][/vc_column_inner][vc_column_inner width="1/4"][tlg_icon_box customize_icon="yes" icon_box_link="url:%23|||" css_animation="flipInX" icon="ti-reload" title="Rice Cake" subtitle="Circle style" image="7600" content_color="#ffffff"]A perfect healthy snack cake rice or a nice slim cake topping.[/tlg_icon_box][/vc_column_inner][/vc_row_inner][tlg_spacer height="40"][tlg_button title="Open Table" btn_link="url:%23reserve|||" layout="btn btn-filled btn-rounded"][/vc_column][/vc_row][vc_row tlg_background_style="bg-primary" tlg_padding="pt64 pb64" tlg_text_align="text-center"][vc_column][tlg_headings layout="bottom" spacing="mb0" icon="ti-shield" title="MONDAY — FRIDAY 9AM TO 6:30PM
SATURDAY — SUNDAY 9AM TO 4PM"][/vc_column][/vc_row][vc_row][vc_column][tlg_intro_content btn_link="url:%23||" button_layout="btn btn-filled btn-rounded" modal_button_layout="play" image="8339" title="The Restaurant Top Worthy Tasting <cite><i>Menus</i></cite>" btn_text="Learn more" button_text="View More" subtitle="Best restaurant" modal_embed="https://vimeo.com/117403415"]We have the skills to create professional films. Whether you want an promo video we can provide the services you require.[/tlg_intro_content][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" css_animation="appear" color="primary-color-icon" icon="ti-gift" title="Parties &amp; Weddings" subtitle="Give a delicious gift" image="7969"]We have a new range of truly mouthwatering.[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" css_animation="appear" color="primary-color-icon" icon="ti-home" title="Home Entertaining" subtitle="Delivery discounts" image="7970"]Get half price delivery this month over £40.[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" css_animation="appear" color="primary-color-icon" icon="ti-panel" title="Gift Cards" subtitle="Sponsored juggle" image="7968"]First week you will see our cashiers taking part.[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" css_animation="appear" color="primary-color-icon" icon="ti-tablet" title="Online Reserve" subtitle="Table booking" image="8335"]In a professional context it often happens that clients.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_padding="pb0" tlg_text_align="text-center" el_id="testimonial"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" separator="line_icon" css_animation="bottom-to-top" title="Our Testimonials" subtitle="What our clients say" icon="ti-comments" icon_color="#b18435" divider_color="#b18435"][tlg_testimonial layout="carousel-quote" css_animation="flipInX" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column][tlg_spacer layout="line" line_style="spacer-large"][tlg_headings layout="bottom" separator="line_icon" css_animation="bottom-to-top" title="Meet Our Team" subtitle="The successful and professional team" icon="ti-user" icon_color="#b18435" divider_color="#b18435"][vc_single_image image="8336" img_size="full" alignment="center"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_carousel][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" image="8337" title="<cite>Restaurant.</cite>
Ordering system" subtitle="Pre-order or book a table" button_text="Learn More" icon="ti-angle-right"]

We are a specialist food retailer and we have been selling high quality food products to our customers for 50 years.

We have been trading online for the last 3 years so it's now even easier for our customers to get great, fresh produce.

[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" image="8335" title="<cite>Private Events.</cite>
Host With Us!" subtitle="Our range of fruit smoothies" button_text="Learn More" icon="ti-angle-right"]

We have been trading online for the last 3 years so it's now even easier for our customers to get great, fresh produce.

We are a specialist food retailer and we have been selling high quality food products to our customers for 50 years.

[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][tlg_intro_content layout="halfscreen-left" btn_link="url:%23reserve|||" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-angle-right" image="8338" title="Worthy <cite>Tasting Menus</cite>" button_text="Make A Reservation" subtitle="Book your table now!"]

Our product of the month is our range of fruit smoothies and if your order them now you can benefit from our 25% discount.

We are a specialist food retailer and we have been selling high quality food products to our customers for 50 years.

[/tlg_intro_content][/vc_column][/vc_row][vc_row tlg_background_style="bg-primary" el_id="contact"][vc_column width="1/3"][tlg_headings alignment="left" layout="bottom" spacing="mb16" css_animation="top-to-bottom" title="Contact Info" subtitle="Our restaurants in Italy"][/vc_column][vc_column width="1/3"][vc_column_text]Piazza Navian, 24, 808209
Napoli, Italy

<strong>Phone</strong>: +209 1006 0411 310
<strong>Fax</strong>: (209) 1006 0411 310
<strong>E-mail</strong>: contact@yourcompany.com
<strong>Website</strong>: yourcompany.com[/vc_column_text][/vc_column][vc_column width="1/3"][tlg_icon_title_list][tlg_icon_title_list_content icon_layout="circle-icon list-icon" icon="ti-cup" title="Give a delicious gift"][tlg_icon_title_list_content icon_layout="circle-icon list-icon" icon="ti-cut" title="Delivery discounts this month"][tlg_icon_title_list_content icon_layout="circle-icon list-icon" icon="ti-thought" title="Sponsored juggle"][tlg_icon_title_list_content icon_layout="circle-icon list-icon" icon="ti-hand-point-right" title="Home entertaining"][tlg_icon_title_list_content icon_layout="circle-icon list-icon" icon="ti-star" title="Gift cards"][/tlg_icon_title_list][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_gmap zoom="14" style="brown" locations="Napoli, Italy" height="550" marker_image="6092"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" tlg_text_align="text-center" css=".vc_custom_1564763681333{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/02/best-chefs.jpg?id=7968) !important;}" el_id="reserve" el_class="white-form" tlg_bg_overlay="#444444" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#b18435"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings layout="bottom" separator="line" css_animation="bottom-to-top" title="Make a reservation" subtitle="Find a table"][contact-form-7 id="6125"][tlg_spacer height="70"][vc_row_inner el_class="text-left"][vc_column_inner width="1/2"][vc_column_text css_animation="fadeInUp"]
<h3>Reserve by Phone</h3>
We take reservations for brunch, lunch and dinner. To make a reservation, please call us at (209) 1006 0411 310 between 7 a.m. and 9 p.m.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text css_animation="fadeInUp"]
<h3>Private Dining &amp; Events</h3>
Whatever your event or celebration, we are here to make it a truly memorable one. Please call us at (209) 1006 0411 310 for more information.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-7'], 'desc' => $homepage['demo-7-desc'], 'id' => 'demo-7',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d7.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 8 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_vertical_align="yes"][vc_column][tlg_header_single layout="3-columns" alignment="text-left" title_style="bold" btn_link="url:%23||" button_layout="play-primary" hide_on_scroll="scrolled-no-hide" overlay="yes" title="FIND INDOOR <cite><i>&amp;</i></cite> OUTDOOR FURNITURE" button_text="Play" image="8303" header_text_color="#ffffff" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4" subtitle="Discover the best agencies" header_overlay_value="6"]We will work with you to fully understand your business and your target audience to inform our marketing strategy.</p>
<p>We can create a brand that stands out and truly reflects your business. The range of areas by the term consultant is wide.[/tlg_header_single][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0" el_id="main"][vc_column][tlg_headings layout="bottom" title="<u>Premier shopping</u>" subtitle="THE COLLECTIONS"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0"][vc_column width="1/3"][tlg_image_caption style="visible-caption" image_link="url:%23|||" image="7511" title="Lamp collection" subtitle="From $28" button_text="Collection" bgcolor="rgba(213,37,23,0.5)"][tlg_spacer height="40"][tlg_image_caption style="visible-caption" image_link="url:%23|||" image="7513" title="Box Daily" subtitle="From $30" button_text="Discover" bgcolor="rgba(37,37,37,0.5)"][/vc_column][vc_column width="1/3"][tlg_image_caption style="visible-caption" image_link="url:%23|||" image="7516" title="Molded Chair" subtitle="From $15" button_text="Shop Now" bgcolor="rgba(0,0,239,0.5)"][tlg_spacer height="40"][tlg_image_caption style="visible-caption" image_link="url:%23|||" image="7509" title="Mid Lamp" subtitle="From $50" button_text="Shop Now" bgcolor="rgba(73,197,182,0.8)"][/vc_column][vc_column width="1/3"][tlg_image_caption style="visible-caption" image_link="url:%23|||" image="7525" title="Classic Phone" subtitle="From $34" button_text="Learn More" bgcolor="rgba(66,168,15,0.5)"][tlg_spacer height="40"][tlg_image_caption style="visible-caption" image_link="url:%23|||" image="7520" title="Blue Lamp" subtitle="From $28" button_text="Learn More" bgcolor="rgba(247,190,104,0.7)"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" title="<u>Discover our stocks</u>" subtitle="FEATURED PRODUCTS"][tlg_shop layout="carouseldetail-4col" pppage="10" orderby="comment_count"][/vc_column][/vc_row][vc_row tlg_background_style="bg-primary" tlg_padding="pt0 pb0" tlg_text_align="text-center" css=".vc_custom_1507115482667{padding-top: 40px !important;padding-bottom: 12px !important;}"][vc_column width="1/3"][tlg_icon_title_list][tlg_icon_title_list_content icon_layout="circle-icon circle-icon-bg list-icon" icon="ti-package" title="<strong>FREE SHIPPING OVER $35 WITH FREE CODE</strong>" title_link="|||" icon_color="#ffffff" icon_bg_color="#000000"][/tlg_icon_title_list][/vc_column][vc_column width="1/3"][tlg_icon_title_list][tlg_icon_title_list_content icon_layout="circle-icon circle-icon-bg list-icon" icon="ti-split-h" title="<strong>FREE RETURNS IN STORE</strong>" title_link="|||" icon_color="#ffffff" icon_bg_color="#000000"][/tlg_icon_title_list][/vc_column][vc_column width="1/3"][tlg_icon_title_list][tlg_icon_title_list_content icon_layout="circle-icon circle-icon-bg list-icon" icon="ti-truck" title="<strong>FAST DELIVERY SERVICE</strong>" title_link="|||" icon_color="#ffffff" icon_bg_color="#000000"][/tlg_icon_title_list][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1566202143480{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/friend-connections.jpg?id=8305) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#444444"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" title="<u>Testimonials</u>" subtitle="OUR CUSTOMERS SAY"][tlg_testimonial layout="carousel" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" title="<u>Latest Products</u>" subtitle="THE LOOKBOOK"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0"][vc_column][tlg_shop layout="carouseldetail-3col" pppage="10"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_clients layout="carousel-auto"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_content layout="box-text-center" btn_link="url:%23|||" button_layout="btn-action" image="5942" title="New Arrivals in Clothing for Women" subtitle="Shop all New Arrivals" button_text="TAKE A LOOK"]Check out everything new enjoy free shipping and returns.[/tlg_intro_content][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" title="<u>Our Blog</u>" subtitle="LATEST POSTS"][tlg_blog layout="carouseldetail-3col" pppage="10"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column][tlg_intro_carousel style="intro-left"][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="5940" title="Discover our favorites fashionable discoveries" button_text="Discover Now"]</p>
<p>Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.</p>
<p>Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.&lt;&gt;[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="5942" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]</p>
<p>Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.</p>
<p>Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.</p>
<p>[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_carousel][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="7912" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]</p>
<p>Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.</p>
<p>Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.</p>
<p>[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="7812" title="Use these business marketing and management templates" button_text="Discover Now"]</p>
<p>Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.</p>
<p>Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.</p>
<p>[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_padding="pt180 pb180 pt-xs-80 pb-xs-80" tlg_enable_overlay="yes" css=".vc_custom_1566201862015{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2018/10/leone-venter.jpg?id=7771) !important;}" tlg_bg_overlay_value="0" el_class="white-form"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings layout="bottom" title="<u>Subscribe to our newsletter</u>" subtitle="EXCLUSIVE OFFERS"][contact-form-7 id="518"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-8'], 'desc' => $homepage['demo-8-desc'],'id' => 'demo-8', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d8.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 9 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_background_style="bg-dark" el_class="white-form"][vc_column][tlg_header_single cf7_shortcode="3851" cf7_position="bottom" btn_link="|||" btn_position="bottom" customize_font="yes" title="Hotel &amp; Resort" subtitle="We have more than 10 rooms of various types to suit all budgets." image="6082" title_font="Playfair Display:tlg://fonts.gstatic.com/s/playfairdisplay/v10/n7G4PqJvFP2Kubl0VBLDECsYW3XoOVcYyYdp9NzzS9E.ttf:tlg:700italic" title_size="110" subtitle_font="0" content_font="0" subtitle_bg_color="#ddb833" subtitle_text_color="#ffffff" header_overlay_value="2"][/tlg_header_single][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line_icon" css_animation="none" title="Choose your experience" subtitle="DISCOVER NOW" icon="ti-user" icon_color="#ddb833" divider_color="#ddb833"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/2"][tlg_icon_box customize_icon="yes" box_layout="animate" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-world" title="Explore the World" subtitle="Fantastic onsite" image="7773" icon_color="#31aafe" box_bg_color_hover="#31aafe" button_text="Read More" btn_icon="ti-angle-right"]The first requirement for an user experience is to meet the exact needs of the customer.[/tlg_icon_box][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-user" title="SPA Time" subtitle="Weekend stay" icon_color="#ddb833" image="6079" box_bg_color_hover="#ddb833"]Responsive design is an approach the design[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-notepad" title="Safe for valuables" subtitle="Santorini" icon_color="#31aafe" image="6076" box_bg_color_hover="#31aafe"]Page Builder plugin with drag &amp; drop interface[/tlg_icon_box][/vc_column_inner][vc_column_inner width="1/2"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-reload" title="Beautiful Beach" subtitle="Multiscreen" icon_color="#31aafe" image="6082" box_bg_color_hover="#31aafe"]Suggests the design to the user’s behavior[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-video-camera" title="Swimming Pool" subtitle="Traditional setting" icon_color="#ddb833" image="6083" box_bg_color_hover="#ddb833"]Build any pages and posts fast and easy.[/tlg_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0" el_id="main"][vc_column][tlg_headings layout="bottom" separator="line_icon" css_animation="bottom-to-top" title="All available rooms" subtitle="ROOM TYPE" icon="ti-crown" icon_color="#ddb833" divider_color="#ddb833"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0"][vc_column][tlg_intro_carousel style="box-top"][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="7793" title="LUXURY <cite>ROOM</cite>" subtitle="$200 / NIGHT" button_text="Reserve Now"]We have a team of writers who specialise in writing end of year.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="7792" title="DELUXE <cite>ONE-BEDROOM</cite>" subtitle="$80 / NIGHT" button_text="Reserve Now"]We have the skills and resources to create professional films.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="7331" title="SUPERIOR <cite>APARTMENT</cite>" subtitle="$150 / NIGHT" button_text="Reserve Now"]We have the skills and resources to create professional films.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="7795" title="BUNK <cite>BEDROOM</cite>" subtitle="$22 / NIGHT" button_text="Reserve Now"]We also create creative content based on the customer purposes.[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1566015813063{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2017/05/book.jpg?id=6080) !important;}" tlg_bg_overlay="#31aafe" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#444444"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" separator="line" title="Our guests experience" subtitle="100% VERIFIED"][tlg_testimonial layout="carousel-quote" css_animation="flipInX" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" el_id="accommodation"][vc_column][tlg_intro_carousel style="intro-left"][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-rounded" icon="ti-angle-right" image="7808" title="Luxury Room
with Garden <cite><i>View</i></cite>" button_text="Show Prices" subtitle="Stay flexible"]

Family rooms: the perfect space for you and the kids. Meals grab a bite before you go!

For more intimate experiences, a private chef can be arranged to help cook delicious meals for guests in the villa.

[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-rounded" icon="ti-angle-right" image="6071" title="Beaches hotels
in the <cite><i>Caribbean</i></cite>" button_text="Show Prices" subtitle="Swimming, Water sports, Food and drink, Surfing"]

For more intimate experiences, a private chef can be arranged to help cook delicious meals for guests in the villa.

Family rooms: the perfect space for you and the kids. Meals grab a bite before you go!

[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][tlg_intro_carousel][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-rounded" icon="ti-angle-right" image="6075" title="Family Room
with View <cite><i>Garden</i></cite>" button_text="Show Prices" subtitle="Food and drink, Surfing"]

For more intimate experiences, a private chef can be arranged to help cook delicious meals for guests in the villa.

Family rooms: the perfect space for you and the kids. Meals grab a bite before you go!

[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-rounded" icon="ti-angle-right" image="7794" title="Premium Deluxe
with View <cite><i>City</i></cite>" button_text="Show Prices" subtitle="Stay flexible"]

Family rooms: the perfect space for you and the kids. Meals grab a bite before you go!

For more intimate experiences, a private chef can be arranged to help cook delicious meals for guests in the villa.

[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" separator="line_icon" spacing="mb16" css_animation="bottom-to-top" title="What makes these trips different?" subtitle="EXPLORE NOW" icon="ti-heart" icon_color="#ddb833" divider_color="#ddb833"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" btn_link="|||" btn_size="btn-sm" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-package" title="Pool and wellness" image="7794"]Test your mettle with a challenging new twist.[/tlg_icon_box][tlg_spacer height="70"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" btn_link="|||" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-shine" title="Outdoors" image="7334"]How to make floating panels to movement.[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" btn_link="|||" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-harddrives" title="Food &amp; Drink" image="7968"]How to accurately install hinges ebony lift.[/tlg_icon_box][tlg_spacer height="70"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" btn_link="|||" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-rss" title="Internet" image="7795"]Learn a safer way to cut our video workshop.[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" btn_link="|||" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-world" title="Transport" image="7323"]A tried and true finish. Learn about applying it.[/tlg_icon_box][tlg_spacer height="70"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" btn_link="|||" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-notepad" title="Reception services" image="7969"]How to get a perfect match of our boxmaking.[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" btn_link="|||" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-panel" title="Deposit Box" image="7808"]We are a short walk from a town by car.[/tlg_icon_box][tlg_spacer height="70"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" btn_link="|||" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-home" title="Family Room" image="7597"]Whether you are looking for a short weekend.[/tlg_icon_box][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][tlg_gmap zoom="14" style="light_blue_2" locations="Santorini Greece" height="500" marker_image="5403"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_text_align="text-center"][vc_column width="1/3" css=".vc_custom_1493975877886{margin-top: -150px !important;}"][tlg_icon_box box_layout="center-box-left" btn_link="url:%23|||" button_layout="btn-action" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-palette" title="From the road" subtitle="Talk to our expert" button_text="READ MORE"]You will benefit from beautiful accommodation. Superior Double.[/tlg_icon_box][/vc_column][vc_column width="1/3" css=".vc_custom_1493976389079{margin-top: -150px !important;}"][tlg_icon_box box_layout="center-box-left" btn_link="url:%23|||" button_layout="btn-action" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-vector" title="Our destinations" subtitle="Discover the world" box_bg_color="#f0f0f0" button_text="READ MORE"]At the moment we are offering two nights for the price  on all rooms.[/tlg_icon_box][/vc_column][vc_column width="1/3" css=".vc_custom_1493976939644{margin-top: -150px !important;}"][tlg_icon_box box_layout="center-box-left" btn_link="url:%23|||" button_layout="btn-action" css_animation="bottom-to-top" icon="ti-thought" title="Call us at" subtitle="+(106) 209-311-50" box_bg_color="#0a0a0a" title_color="#ffffff" subtitle_color="#ffffff" content_color="#ffffff" icon_color="#ffffff" button_text="READ MORE"]Our guests have access to all of our fantastic onsite family facilitie.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0" tlg_text_align="text-center"][vc_column][tlg_headings layout="bottom" separator="line_icon" css_animation="bottom-to-top" title="Begin Your Adventure" subtitle="GET STARTED" icon="ti-world" icon_color="#ddb833" divider_color="#ddb833"][tlg_steps style="steps-style-2" css_animation="bottom-to-top"][tlg_steps_content step_link="url:%23|||" icon="ti-user" title="Inspiration" line_color="" icon_color_hover="#555555" bg_color_hover="#ffffff" subtitle="Process the desire" icon_color="#ffffff" bg_color="#31aafe"][tlg_steps_content step_link="url:%23|||" icon="ti-notepad" title="Planning" line_color="" subtitle="Evaluation staff" icon_color_hover="#555555" bg_color_hover="#ffffff" icon_color="#ffffff" bg_color="#ddb833"][tlg_steps_content step_link="url:%23|||" icon="ti-check-box" title="Booking" line_color="" subtitle="Process the capabilities" icon_color_hover="#555555" bg_color_hover="#ffffff" icon_color="#ffffff" bg_color="#31aafe"][tlg_steps_content step_link="url:%23|||" icon="ti-world" title="Travel" line_color="" subtitle="Perfomance objectives" icon_color_hover="#555555" bg_color_hover="#ffffff" icon_color="#ffffff" bg_color="#ddb833"][tlg_steps_content step_link="url:%23|||" icon="ti-thought" title="Sharing" line_color="" subtitle="Your experience" icon_color_hover="#555555" bg_color_hover="#ffffff" icon_color="#ffffff" bg_color="#31aafe"][/tlg_steps][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1566015184450{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2018/10/bill-anastas.jpg?id=7792) !important;}" el_class="contact-line-white" tlg_bg_overlay="#31aafe" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#444444"][vc_column width="1/2" css=".vc_custom_1475563303386{padding-right: 10% !important;}"][tlg_headings alignment="left" layout="bottom" css_animation="bottom-to-top" title="Make Reservations" subtitle="CONTACT" icon="ti-pencil-alt" icon_color="#ddb833" divider_color="#ddb833"][contact-form-7 id="4626"][/vc_column][vc_column width="1/2"][tlg_headings alignment="left" layout="bottom" css_animation="bottom-to-top" title="Question &amp; Answer" subtitle="FAQS" icon="ti-pencil-alt" icon_color="#ddb833" divider_color="#ddb833"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="Do you sell hotel reservations ?" icon="ti-layers"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content title="What is an affordable hotel ?" icon="ti-map"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content title="Is breakfast included in the price ?" icon="ti-import"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-9'], 'desc' => $homepage['demo-9-desc'], 'id' => 'demo-9',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d9.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 10 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column][rev_slider alias="home-slider-4"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column][tlg_intro_carousel style="intro-left"][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="6040" title="Use these business marketing and management templates" button_text="Discover Now"]</p>
<p>Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.</p>
<p>Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.</p>
<p>[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="6044" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]</p>
<p>Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.</p>
<p>Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.</p>
<p>[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][tlg_intro_carousel][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="6029" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]</p>
<p>Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.</p>
<p>Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.</p>
<p>[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="6046" title="Use these business marketing and management templates" button_text="Discover Now"]</p>
<p>Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.</p>
<p>Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.</p>
<p>[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="Gym Instructor Courses and<br />
6 units included in the <cite><i>Course</i></cite>" subtitle="OUR SERVICES" icon="ti-server"][tlg_intro_carousel style="box-top"][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="6054" title="Public relations refers to the activities used to promote" subtitle="ABOUT US" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="6055" title="All program will be an excellent public relations move" subtitle="MEET UP" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="6057" title="After-sales service refers to the service maintenance" subtitle="CONTACT" button_text="Read More" icon="ti-angle-right"]Our teams are up to date with the media trends to prove themselves.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="6058" title="The branch refers to the office or shop of a company" subtitle="MEETING" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt180 pb180 pt-xs-80 pb-xs-80" tlg_text_align="text-center" css=".vc_custom_1555413481414{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2016/02/woman-fits.jpg?id=6043) !important;}"][vc_column][tlg_headings customize_font="yes" title="Kick-start your fitness" subtitle="Join us today to receive special bonus" title_size="80" title_spacing="0" subtitle_size="20" subtitle_spacing="0"][tlg_button title="TRY A FIT-PASS" btn_link="url:%23|||" btn_size="btn-lg" layout="btn btn-filled btn-flat" button_icon_hover="yes" icon="ti-angle-right"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_text_align="text-center"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="A typical gym fitness system split<br />
would be like this <cite><i>Process</i></cite>" subtitle="PROCESS" icon="ti-direction-alt"][tlg_steps size="steps-large"][tlg_steps_content step_link="url:%23|||" icon="ti-server" title="Parking" text_color="#ffffff" icon_color="#ffffff" bg_color_hover="#ffffff" text_color_hover="#252525" icon_color_hover="#999999" subtitle="Multiple Location" bg_color="#49c5b6"][tlg_steps_content step_link="url:%23|||" icon="ti-user" title="Crossfit" text_color="#ffffff" icon_color="#ffffff" bg_color_hover="#ffffff" text_color_hover="#252525" icon_color_hover="#999999" subtitle="Personal training" bg_color="#fa4e40"][tlg_steps_content step_link="url:%23|||" icon="ti-bag" title="Upkeep" text_color="#ffffff" icon_color="#ffffff" bg_color_hover="#ffffff" text_color_hover="#252525" icon_color_hover="#999999" subtitle="Machine time" bg_color="#49c5b6"][tlg_steps_content step_link="url:%23|||" icon="ti-reload" title="Freezes" text_color="#ffffff" icon_color="#ffffff" bg_color_hover="#ffffff" text_color_hover="#252525" icon_color_hover="#999999" subtitle="Cancellation" bg_color="#fa4e40"][/tlg_steps][/vc_column][/vc_row][vc_row][vc_column][tlg_headings layout="bottom" separator="line_icon" title="Meet our personal training team<br />
for all the type of the <cite><i>Club</i></cite>" subtitle="OUR TRAINERS" icon="ti-user"][tlg_team pppage="3" layout="fullwidth" orderby="ID" order="ASC" filter="231"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="Read all the real success stories below <br> from our great <cite><i>Members</i></cite>" subtitle="REAL RESULTS" icon="ti-blackboard"][tlg_testimonial pppage="3" filter="251"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1539859960337{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2016/02/dumbbell.jpg?id=6029) !important;}" el_id="timetable" tlg_bg_overlay="#000000" tlg_bg_overlay_value="5.4"][vc_column][tlg_headings layout="bottom" separator="line" title="Choose your fitness, gym courses below<br />
to fit your <cite><i>Timetable </i></cite>" subtitle="TIMETABLE"][vc_row_inner][vc_column_inner width="1/2"][tlg_timeline][tlg_timeline_content style="text" icon="ti-user" text="Crossfit" icon_color="#49c5b6" icon_color_hover="#444444" title="Personal Traning"]07:40 - Dance Rhythms<br />
09:10 - Step &amp; Crunch<br />
10:15 - Body Combat<br />
10.15 - FX Stomp<br />
11.20 - Body Pump[/tlg_timeline_content][tlg_timeline_content style="text" icon="ti-server" text="Parking" icon_color="#49c5b6" icon_color_hover="#444444" title="Multiple location"]07:40 - Body Combat<br />
09:10 - RPM<br />
10:15 - Bums N Tums<br />
10.15 - Pole Fit<br />
11.20 - Cycling[/tlg_timeline_content][/tlg_timeline][/vc_column_inner][vc_column_inner width="1/2"][tlg_timeline][tlg_timeline_content style="text" icon="ti-bag" text="Upkeep" title="Machine time" icon_color="#fa4e40" icon_color_hover="#444444"]07:40 - Body Combat<br />
09:10 - RPM<br />
10:15 - Bums N Tums<br />
10.15 - Pole Fit<br />
11.20 - Cycling[/tlg_timeline_content][tlg_timeline_content style="text" icon="ti-reload" text="Freezes" title="Cancellation" icon_color="#fa4e40" icon_color_hover="#444444"]07:40 - Dance Rhythms<br />
09:10 - Step &amp; Crunch<br />
10:15 - BodyCombat<br />
10.15 - FX Stomp<br />
11.20 - Body Pump[/tlg_timeline_content][/tlg_timeline][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="Find below the details table for<br />
all training sections Gym <cite><i>Pricing</i></cite>" subtitle="PRICE PLAN" icon="ti-receipt"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0"][vc_column width="1/3"][tlg_pricing_table amount="19" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_layout="btn btn-filled btn-flat" btn_size="btn-block" customize_button="yes" btn_custom_layout="btn border-radius-0" title="Personal" btn_color="#ffffff" btn_bg="#fa4e40" btn_border="#fa4e40" btn_color_hover="#222222" btn_bg_hover="#dddddd" btn_border_hover="#dddddd"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>Unlimited hours of support</li>
<li>Social media integration</li>
<li>Analytic integration</li>
<li>More Innovation</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="39" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_layout="btn btn-filled btn-flat" btn_size="btn-block" customize_button="yes" btn_custom_layout="btn border-radius-0" customize_table="yes" title="Standard" tbl_price_bg_color="#49c5b6" tbl_price_color="#ffffff" btn_color="#ffffff" btn_bg="#49c5b6" btn_border="#49c5b6" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>10 hours of support</li>
<li>Social media integration</li>
<li>Advanced analytic</li>
<li>Group Fitness</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="60" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_layout="btn btn-filled btn-flat" btn_size="btn-block" customize_button="yes" btn_custom_layout="btn border-radius-0" title="Premium" btn_color="#ffffff" btn_bg="#fa4e40" btn_border="#fa4e40" btn_color_hover="#222222" btn_bg_hover="#dddddd" btn_border_hover="#dddddd"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>Unlimited hours of support</li>
<li>Social media integration</li>
<li>Analytic integration</li>
<li>Access To All Clubs</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][vc_column_text][gallery layout="lightbox-fullwidth" columns="5" ids="6054,6055,6056,6058"][/vc_column_text][/vc_column][/vc_row][vc_row tlg_text_align="text-center"][vc_column][tlg_headings layout="bottom" separator="line_icon" title="We are always looking for new talent<br />
do you want to join our journey of <cite><i>Performance</i></cite>" subtitle="OWN A GYM" icon="ti-email"][contact-form-7 id="3851"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-10'], 'desc' => $homepage['demo-10-desc'], 'id' => 'demo-10',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d10.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 11 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column][tlg_header_single btn_link="url:%23book|||" button_layout="btn btn-filled btn-flat" button_icon_hover="yes" enable_button_2="yes" btn_link_2="url:%23main|||" button_layout_2="btn-text" btn_position_2="bottom" customize_font="yes" icon="ti-angle-right" icon_2="ti-arrow-circle-down" title="Hairstyle &amp; Beard" subtitle="If you're patient, everything will come" image="6145" button_text="Make an appointment" button_size_2="35" button_text_color_2="#ffffff" button_text_hover_2="#ffffff" title_font="Playfair Display:tlg://fonts.gstatic.com/s/playfairdisplay/v10/2NBgzUtEeyB-Xtpr9bm1CV6uyC_qD11hrFQ6EGgTJWI.ttf:tlg:regular" title_size="100" subtitle_font="0" content_font="0" title_spacing="10" subtitle_size="25"][/tlg_header_single][/vc_column][/vc_row][vc_row el_id="main"][vc_column][tlg_intro_content btn_link="url:%23||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-flat" modal_button_layout="play" icon="ti-angle-right" image="6148" title="Welcome to our Hair <cite><i>Shop</i></cite>" button_text="Find the Nearest Barber Spa" btn_text="Learn more" subtitle="A better service"]We will put together a detailed and specific style guide that covers all areas to ensure that anything produced in the future.[/tlg_intro_content][tlg_spacer height="72"][tlg_intro_content layout="standard-left" btn_link="url:%23||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-flat" modal_button_layout="play" icon="ti-angle-right" image="6143" title="Not like any other <cite><i>Barbers</i></cite>" btn_text="Learn more" button_text="Book an appointment" subtitle="Well-groomed and relaxed" modal_embed="https://vimeo.com/86498288"]We have the skills to create professional films. Whether you want an promo video we can provide the services you require.[/tlg_intro_content][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0" el_id="services"][vc_column][tlg_headings layout="bottom" title="<u>Featured products</u>" subtitle="EXCLUSIVE OFFERS"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-cut" title="Men Haircuts" button_text="View More" btn_icon="ti-angle-right" image="6145"]Consulting and the means by which the consultant is according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-user" title="Shaved Head" button_text="View More" btn_icon="ti-angle-right" image="6144"]The range of areas by the term consultant is wide to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-spray" title="Hair Wash" button_text="View More" btn_icon="ti-angle-right" image="6143"]The consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" title="<u>Our Range Of Services</u>" subtitle="SALON PRICES"][tlg_intro_carousel style="box-top"][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="6149" title="Public relations refers to the activities used to promote" subtitle="From $25" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="6148" title="All program will be an excellent public relations move" subtitle="From $22" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="6147" title="After-sales service refers to the service maintenance" subtitle="From $9" button_text="Read More" icon="ti-angle-right"]Our teams are up to date with the media trends to prove themselves.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" subtitle_style="box" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="6146" title="The branch refers to the office or shop of a company" subtitle="From $19" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_padding="pb0" el_id="feature"][vc_column][tlg_headings layout="bottom" title="<u>Ultimate services</u>" subtitle="WHY CHOOSE US"][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column width="1/2" css=".vc_custom_1494932778372{padding-right: 8% !important;}"][tlg_image_caption style="hover-caption-2" image_link="url:%23|||" image="6142" title="Experience an expert haircut" subtitle="We can talk through some ideas"][/vc_column][vc_column width="1/2" css=".vc_custom_1494932787921{padding-left: 8% !important;}"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-desktop" title="Sporting a HDTV in the lobby"]Whether you want a trim, a completely new style, a change of colour or to go straight or curly we can do that for you.[/tlg_icon_box][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-cut" title="Relaxing Steam Towels, Shampoos, &amp; Scalp Massage"]If you’re apprehensive about your little one having their first hair cut then you know where to come.[/tlg_icon_box][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-user" title="Chair Massage While you Wait"]As well as giving you a fantastic experience in the salon we also sell a range of products for you to take away.[/tlg_icon_box][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-bookmark-alt" title="Licenced Massage Therapists"]We are Only Hair For You and no matter your age or style we can make you feel fab about your hair.[/tlg_icon_box][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-mobile" title="Online &amp; Call Ahead Check-in"]We have a team of stylists who between them have too many years experience to count![/tlg_icon_box][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-check-box" title="A completely new style, a change of colors"]If you’re not sure about what you want then come in for a chat, we can talk through some ideas.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column width="1/2" css=".vc_custom_1494932778372{padding-right: 8% !important;}"][tlg_image_caption style="hover-caption-2" image_link="url:%23|||" image="6149" title="Schedule an Appointment" subtitle="Well-groomed and relaxed."][/vc_column][vc_column width="1/2" css=".vc_custom_1494932787921{padding-left: 8% !important;}"][tlg_image_caption style="hover-caption-2" image_link="url:%23|||" image="6147" title="London barber of choice" subtitle="We can talk through some ideas"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1565952131657{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2016/02/beard-treatment.jpg?id=6160) !important;}" el_id="testimonial" tlg_bg_overlay="#0a0a0a" tlg_bg_overlay_value="8"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" css_animation="bottom-to-top" title="<u>Our customers</u>" subtitle="TESTIMONIALS" icon_color="#bf9457"][tlg_testimonial layout="carousel-quote" css_animation="bottom-to-top" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_enable_overlay="yes" el_id="contact" css=".vc_custom_1563726979727{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/partnerss.jpg?id=8309) !important;}" tlg_bg_overlay="#000000" tlg_bg_overlay_value="8.4" el_class="white-form"][vc_column width="1/2" css=".vc_custom_1561994135727{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][tlg_gmap zoom="14" style="brown" locations="Str. 151, Washington, NY" height="740" marker_image="5404"][/vc_column][vc_column width="1/2" css=".vc_custom_1561999440205{padding-top: 8% !important;padding-right: 19% !important;padding-bottom: 8% !important;padding-left: 10% !important;}"][tlg_headings alignment="left" layout="bottom" spacing="mb40" title="Book an Appointment, we would love to hear <cite><i>from you</i></cite>" icon="ti-slice" divider_color="#49c5b6"][vc_column_text]Please complete the form and we'll get back to you within 1 – 2 business days. We look forward to working with you.[/vc_column_text][contact-form-7 id="681"][vc_column_text]For any question contact our 24/7 call center: <span class="primary-color">+001 345 6889</span>[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column width="1/4" css=".vc_custom_1548954925214{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #a18c62 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-facebook"][/tlg_icons][/vc_column][vc_column width="1/4" css=".vc_custom_1548954934076{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #222222 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-instagram"][/tlg_icons][/vc_column][vc_column width="1/4" css=".vc_custom_1548954941644{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #a18c62 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-twitter-alt"][/tlg_icons][/vc_column][vc_column width="1/4" css=".vc_custom_1548954948789{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #222222 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-dribbble"][/tlg_icons][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-11'], 'desc' => $homepage['demo-11-desc'], 'id' => 'demo-11',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d11.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 12 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column][rev_slider alias="home-slider-5"][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0"][vc_column width="1/3" css=".vc_custom_1493266864175{padding-top: 30px !important;padding-bottom: 30px !important;}"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-vector" title="Leaders In Construction" subtitle="Meet the exact needs of the customer"][/tlg_icon_box][/vc_column][vc_column width="1/3" css=".vc_custom_1507189050694{padding-top: 30px !important;padding-bottom: 30px !important;background-color: #f6f6f8 !important;}"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-home" title="We Deliver Quality" subtitle="Design to the user's behavior"][/tlg_icon_box][/vc_column][vc_column width="1/3" css=".vc_custom_1493266885439{padding-top: 30px !important;padding-bottom: 30px !important;}"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-paint-roller" title="We Love To Build" subtitle="Trusted certificate provider"][/tlg_icon_box][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column][tlg_intro_carousel style="intro-left"][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="5964" title="Use these business marketing and management templates" button_text="Discover Now"]Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.</p>
<p>Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="5962" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.</p>
<p>Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][tlg_intro_carousel][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="5961" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.</p>
<p>Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="5967" title="Use these business marketing and management templates" button_text="Discover Now"]Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.</p>
<p>Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings alignment="left" layout="mid" separator="split" title="01 ―|Main features" subtitle="Our Works"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0"][vc_column][tlg_intro_carousel style="box-top"][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="5981" title="Public relations refers to the activities used to promote" subtitle="ABOUT US" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="5963" title="All program will be an excellent public relations move" subtitle="MEET UP" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="5962" title="After-sales service refers to the service maintenance" subtitle="CONTACT" button_text="Read More" icon="ti-angle-right"]Our teams are up to date with the media trends to prove themselves.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="5966" title="The branch refers to the office or shop of a company" subtitle="MEETING" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings alignment="left" layout="mid" separator="split" title="02 ―|Our team" subtitle="Meet our great people"][tlg_team pppage="4" column="4col" filter="249" hover_bg_color="#6cbd10"][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0"][vc_column][tlg_spacer layout="line" line_style="spacer-large"][tlg_headings alignment="left" layout="mid" separator="split" title="03 ―|Latest Projects" subtitle="View our case studies"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_padding="pt0 pb0"][vc_column][vc_column_text]</p>
<p>[gallery size="full" layout="lightbox-fullwidth" link="none" columns="4" ids="7808,7794,7793,7792"]</p>
<p>[/vc_column_text][/vc_column][/vc_row][vc_row tlg_background_style="bg-primary" tlg_padding="pt64 pb64"][vc_column][tlg_cta btn_link="url:%23contact|||" button_layout="btn btn-flat" button_text="Contact Us" title="We design and build things!" subtitle="Put on your hard hat and let's get to work"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt180 pb180 pt-xs-80 pb-xs-80" tlg_enable_overlay="yes" tlg_text_align="text-center" css=".vc_custom_1562321069283{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2017/04/supportss.jpg?id=5967) !important;}" tlg_bg_overlay="#0000ef" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#28824c"][vc_column width="1/4"][tlg_counter to="960" suffix_text="k" title="Annual Revenue" icon="ti-pulse" icon_color="#6cbd10"][/vc_column][vc_column width="1/4"][tlg_counter to="6670" title="General Contractors" icon="ti-clipboard" icon_color="#6cbd10"][/vc_column][vc_column width="1/4"][tlg_counter to="98" suffix_text="%" title="Satisfy Customer" icon="ti-user" icon_color="#6cbd10"][/vc_column][vc_column width="1/4"][tlg_counter to="828" title="Construction Projects" icon="ti-home" icon_color="#6cbd10"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings alignment="left" layout="mid" separator="split" title="04 ―|From Our blog" subtitle="Get latest news from our blog"][tlg_blog layout="carousel-3col" pppage="6"][tlg_spacer layout="line" line_style="spacer-large"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_headings alignment="left" layout="bottom" separator="line" spacing="mb0" title="Stay on top of things" subtitle="NEWSLETTER"][/vc_column][vc_column width="2/3"][contact-form-7 id="518" title="Subscribe for latest updates"][tlg_spacer height="60"][tlg_testimonial layout="carousel-column" filter="251"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt180 pb180 pt-xs-80 pb-xs-80" tlg_enable_overlay="yes" tlg_parallax="not-parallax" css=".vc_custom_1565951230255{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2017/04/support-mans.jpg?id=5966) !important;}" el_id="main" tlg_bg_overlay="#0000ef" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#28824c" el_class="white-form"][vc_column width="1/2" css=".vc_custom_1493291850882{padding-right: 5% !important;}"][tlg_spacer height="50"][tlg_icon_box box_layout="left" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-vector" title="Coordinate and work" icon_size="46" title_color="#ffffff" subtitle_color="#ffffff" content_color="#eeeeee"]Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur.[/tlg_icon_box][tlg_spacer height="20"][tlg_icon_box box_layout="left" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-user" title="Work personally" icon_size="46" title_color="#ffffff" subtitle_color="#ffffff" content_color="#eeeeee"]Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.[/tlg_icon_box][tlg_spacer height="20"][tlg_icon_box box_layout="left" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-bar-chart-alt" title="Other buildings" icon_size="46" title_color="#ffffff" subtitle_color="#ffffff" content_color="#eeeeee"]Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.[/tlg_icon_box][/vc_column][vc_column css_animation="bottom-to-top" width="1/2" css=".vc_custom_1493291859271{padding-left: 5% !important;}"][tlg_headings alignment="left" spacing="mb16" css_animation="bottom-to-top" title="We would love to hear from you"][vc_column_text]Fill out the form below to get in touch with us.[/vc_column_text][contact-form-7 id="681"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt64 pb64"][vc_column][tlg_clients layout="carousel-auto"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-12'], 'desc' => $homepage['demo-12-desc'], 'id' => 'demo-12',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d12.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 13 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row" el_class="header-contact"][vc_column][tlg_header_single layout="2-columns" alignment="text-left" title_style="thin" cf7_shortcode="7829" btn_link="url:%23about|||" button_layout="btn btn-filled btn-rounded" button_icon_hover="yes" icon="ti-angle-right" hide_on_scroll="scrolled-no-hide" overlay="yes" title="<strong>Hello!</strong><br />
My Name is<br />
<u><strong>Éric Orial</strong></u>" subtitle="UX/UI DESIGNER &amp; WEB DEVELOPER" button_text="Learn more" image="5502" header_text_color="#ffffff"][/tlg_header_single][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_equal_height="equal-height" el_id="about"][vc_column width="1/2" css=".vc_custom_1562313933349{padding-top: 100px !important;padding-right: 15% !important;padding-bottom: 100px !important;padding-left: 15% !important;background-color: #321e41 !important;}"][tlg_headings alignment="left" layout="bottom" title="<u>About Me</u>" subtitle="THE RESUME"][vc_row_inner][vc_column_inner width="1/3" css=".vc_custom_1568137283039{padding-bottom: 24px !important;}"][vc_single_image image="5812"][/vc_column_inner][vc_column_inner width="2/3"][tlg_icon_title_list][tlg_icon_title_list_content title="Name: Éric Orial" title_link="url:%23|||" icon="ti-user"][tlg_icon_title_list_content title="Birthday: January 04, 1980" title_link="url:%23|||" icon="ti-receipt"][tlg_icon_title_list_content title="Address: King Street, Melbourne, Vic" title_link="url:%23|||" icon="ti-home"][tlg_icon_title_list_content title="Email: hello@naviantheme.com" title_link="url:%23|||" icon="ti-email"][tlg_icon_title_list_content title="Phone: (012) - 567 - 8910" title_link="url:%23|||" icon="ti-mobile"][/tlg_icon_title_list][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" css=".vc_custom_1562313872595{padding-top: 100px !important;padding-right: 15% !important;padding-bottom: 100px !important;padding-left: 15% !important;background-color: #5d13e7 !important;}"][tlg_headings alignment="left" layout="bottom" title="<u>Éric Orial</u>" subtitle="UX/UI DIRECTOR"][vc_column_text]My designs have been sold all over Europe and the USA and I have worked with some of the biggest designers in the industry. I'm also currently working with a big supermarket to develop a gorgeous, yet affordable, range of beautifully printed key pieces that no one wardrobe should be without![/vc_column_text][vc_single_image image="7845" img_size="full"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" spacing="mb0" title="<u>Knowledge &amp; Skills</u>" subtitle="MY PROFILE"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column width="1/2"][tlg_skill_bar color="primary" alignment="text-left" align="" title="Designs" amount="80"][tlg_skill_bar color="primary" alignment="text-left" align="" title="Photoshop" amount="58"][tlg_skill_bar color="primary" alignment="text-left" align="" title="Illustrator" amount="87"][tlg_skill_bar color="primary" alignment="text-left" align="" title="Movie Making" amount="64"][/vc_column][vc_column width="1/2"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="Multiple Services" icon="ti-layers"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content title="Professional Skills" icon="ti-map"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content title="5-stars rating feedback" icon="ti-import"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_equal_height="equal-height" el_id="education"][vc_column width="1/2" css=".vc_custom_1543658594576{padding-top: 100px !important;padding-right: 15% !important;padding-bottom: 100px !important;padding-left: 15% !important;background-color: #321e41 !important;}"][tlg_headings alignment="left" layout="bottom" title="<u>Education</u>" subtitle="SHORT HISTORY"][tlg_timeline][tlg_timeline_content datetime="2012/03/14 16:47" icon="ti-vector" title="Diploma High School, San Antonio" icon_color="#00d646" icon_color_hover="#febe34"]Majored in general education.[/tlg_timeline_content][tlg_timeline_content datetime="2014/03/18 16:47" icon="ti-receipt" title="University of Illinois" icon_color="#00d646" icon_color_hover="#febe34"]Majored in design interaction education.[/tlg_timeline_content][tlg_timeline_content datetime="2016/04/06 16:47" icon="ti-user" title="University of Design Master" icon_color="#00d646" icon_color_hover="#febe34"]Majored in architecture education.[/tlg_timeline_content][tlg_timeline_content datetime="2017/02/15 16:47" icon="ti-world" title="Intern learning in USA" icon_color="#00d646" icon_color_hover="#febe34"]Distribute to clients and investors, both current and potential.[/tlg_timeline_content][/tlg_timeline][/vc_column][vc_column width="1/2" css=".vc_custom_1562313947799{padding-top: 100px !important;padding-right: 15% !important;padding-bottom: 100px !important;padding-left: 15% !important;background-color: #5d13e7 !important;}"][tlg_headings alignment="left" layout="bottom" title="<u>Experience</u>" subtitle="EMPLOYMENT"][tlg_timeline][tlg_timeline_content style="image" icon="ti-desktop" title="Frontend designer in MMA Design" icon_color="#00d646" icon_color_hover="#febe34" image="7743"]I believe that analysis of your company and your customers is key in responding effective.[/tlg_timeline_content][tlg_timeline_content style="image" icon="ti-bookmark-alt" title="Content design in Bond News" icon_color="#00d646" icon_color_hover="#febe34" image="7742"]We have a number of different teams within our agency that specialise in different areas of business.[/tlg_timeline_content][tlg_timeline_content style="image" icon="ti-panel" title="R&amp;D team leader at W Development" icon_color="#00d646" icon_color_hover="#febe34" image="7740"]Whether you require large banners and posters to promote your company or some more subtle letter heads.[/tlg_timeline_content][/tlg_timeline][/vc_column][/vc_row][vc_row tlg_padding="pb0" tlg_text_align="text-center" el_id="project"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" title="<u>My Projects</u>" subtitle="CASE STUDIES"][vc_column_text]To see a selection of my designs and sketches, which is how all my best designs start, take a look at my portfolio page. To see who I have worked with see my client list and stockists.[/vc_column_text][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row][vc_column][tlg_portfolio pppage="6" layout="modern-3col"][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1488341145859{background-color: #f4f4f4 !important;}"][tlg_cta btn_link="url:%23||" button_layout="btn btn-filled btn-rounded" customize_font="yes" title_uppercase="no" icon="ti-arrow-circle-right" title="Crafting beautiful brands and websites." subtitle="Let's create something great together!" url="#" button_text="Start a Project" title_size="30" title_color="#0c0c0c"][/vc_column][/vc_row][vc_row el_id="client"][vc_column][tlg_headings layout="bottom" title="<u>My Clients</u>" subtitle="THE GREAT BRANDS"][tlg_clients][/vc_column][/vc_row][vc_row][vc_column][tlg_headings layout="bottom" title="<u>The Facts</u>" subtitle="FACTS &amp; STATISTICS"][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0" tlg_text_align="text-center"][vc_column width="1/4"][tlg_counter to="2450" suffix_text="+" title="Launched Projects" icon_color_primary="primary-color" subtitle="Counter number" icon="ti-harddrives"][/vc_column][vc_column width="1/4"][tlg_counter to="320" suffix_text="+" title="Codes In Month" icon_color_primary="primary-color" subtitle="Counter number" icon="ti-ruler-pencil"][/vc_column][vc_column width="1/4"][tlg_counter to="54" suffix_text="+" title="Awards Winning" icon_color_primary="primary-color" subtitle="Counter number" icon="ti-shield"][/vc_column][vc_column width="1/4"][tlg_counter to="98" suffix_text="%" title="Customer Satisfaction" icon_color_primary="primary-color" subtitle="Counter number" icon="ti-user"][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column][tlg_spacer layout="line" line_style="spacer-large"][tlg_headings layout="bottom" title="<u>My Blog</u>" subtitle="THE LATEST NEWS"][tlg_blog layout="carouseldetail-3col"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_equal_height="equal-height"][vc_column width="2/3" css=".vc_custom_1543658594576{padding-top: 100px !important;padding-right: 15% !important;padding-bottom: 100px !important;padding-left: 15% !important;background-color: #321e41 !important;}"][tlg_headings alignment="left" layout="bottom" title="<u>Testimonials</u>" subtitle="SUCCESS STORIES"][tlg_testimonial pppage="3" layout="carousel-column" filter="251"][/vc_column][vc_column width="1/3" css=".vc_custom_1562313955321{padding-top: 100px !important;padding-right: 15% !important;padding-bottom: 100px !important;padding-left: 15% !important;background-color: #5d13e7 !important;}"][tlg_spacer height="70" height_mobile="0"][tlg_headings alignment="left" layout="bottom" customize_font="yes" subtitle_uppercase="yes" title="<u>hello@naviantheme.com</u>" subtitle="LET’S WORK TOGETHER" title_size="30" subtitle_size="25"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_enable_overlay="yes" tlg_parallax="not-parallax" el_id="contact" tlg_bg_overlay="#0000ef" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#28824c" el_class="white-form"][vc_column width="1/2" css=".vc_custom_1493291850882{padding-right: 5% !important;}"][tlg_spacer height="110" height_tablet="50" height_mobile="50"][tlg_icon_box box_layout="left" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-vector" title="Coordinate and work" icon_size="46"]Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur.[/tlg_icon_box][tlg_spacer height="20"][tlg_icon_box box_layout="left" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-user" title="Work personally" icon_size="46"]Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.[/tlg_icon_box][tlg_spacer height="20"][tlg_icon_box box_layout="left" css_animation="bottom-to-top" color="primary-color-icon" icon="ti-bar-chart-alt" title="Other buildings" icon_size="46"]Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.[/tlg_icon_box][/vc_column][vc_column css_animation="bottom-to-top" width="1/2" css=".vc_custom_1493291859271{padding-left: 5% !important;}"][tlg_headings alignment="left" layout="bottom" spacing="mb40" title="<u>Contact</u>" subtitle="SO WHAT’S NEXT?"][vc_column_text]Fill out the form below to get in touch with us.[/vc_column_text][contact-form-7 id="681"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column width="1/4" css=".vc_custom_1507627207316{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #3b5998 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-facebook"][/tlg_icons][/vc_column][vc_column width="1/4" css=".vc_custom_1559471153294{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #bf6f31 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-instagram"][/tlg_icons][/vc_column][vc_column width="1/4" css=".vc_custom_1507627339023{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #08c1e2 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-twitter-alt"][/tlg_icons][/vc_column][vc_column width="1/4" css=".vc_custom_1523445722480{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #ea4c89 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-dribbble"][/tlg_icons][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-13'], 'desc' => $homepage['demo-13-desc'], 'id' => 'demo-13',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d13.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 14 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column][tlg_header_single alignment="text-left" title_style="thin" btn_link="url:%23main|||" button_layout="btn btn-filled btn-rounded" enable_button_2="yes" btn_link_2="url:%23|||" button_layout_2="btn btn-rounded" button_icon_hover_2="yes" customize_font="yes" title_uppercase="yes" title="We're Navian
<strong>An Award-winning
design studio</strong>" image="8301" title_font="0" title_size="80" subtitle_font="0" content_font="0" button_text="Learn More" modal_embed_2="https://www.youtube.com/watch?v=qZEPs3vmYB4" icon_2="ti-control-play" button_text_2="Watch Now" header_overlay_color="#dc324f" header_overlay_value="9" header_gradient_color="#ffde36" subtitle="We will work with you to fully understand your business.
We have a number of different teams within our agency." subtitle_size="19"][/tlg_header_single][/vc_column][/vc_row][vc_row tlg_padding="pb0" el_id="main"][vc_column][tlg_headings alignment="left" separator="split" title="01—|Case studies" subtitle="Redesign and get to market"][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][tlg_portfolio pppage="12" layout="full-grid-4col" show_filter="No" orderby="title" order="ASC"][/vc_column][/vc_row][vc_row][vc_column][tlg_headings alignment="left" separator="split" title="02—|Our Progress" subtitle="Technology branding agency"][/vc_column][/vc_row][vc_row tlg_large_container="wide-container" tlg_padding="pt0"][vc_column width="1/3" css=".vc_custom_1546667844781{padding-right: 5% !important;padding-left: 5% !important;}"][tlg_icon_box box_layout="behind" icon_box_link="||" color="primary-color-icon" icon="ti-world" title="Resources Experience" subtitle="01" subtitle_color="#49c5b6"]We have a number of different development teams within our agency.[/tlg_icon_box][/vc_column][vc_column width="1/3" css=".vc_custom_1546667851580{padding-right: 5% !important;padding-left: 5% !important;}"][tlg_icon_box box_layout="behind" icon_box_link="||" color="primary-color-icon" icon="ti-thought" title="Creative Workshop" subtitle="02" subtitle_color="#6effbf"]Responsive design is an approach suggests the design to the  behavior.[/tlg_icon_box][/vc_column][vc_column width="1/3" css=".vc_custom_1546667856578{padding-right: 5% !important;padding-left: 5% !important;}"][tlg_icon_box box_layout="behind" icon_box_link="||" color="primary-color-icon" icon="ti-package" title="Interactive Designer" subtitle="03" subtitle_color="#dcaee8"]Page Builder plugin with drag &amp; drop. Build any page fast and easy.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings alignment="left" separator="split" title="03—|Our Team" subtitle="A team of digital designers"][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][tlg_team pppage="4" layout="fullwidth" column="4col" order="ASC" filter="249"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_equal_height="equal-height"][vc_column width="2/3" css=".vc_custom_1559468934083{padding-top: 100px !important;padding-right: 15% !important;padding-bottom: 100px !important;padding-left: 15% !important;background-color: #5d13e7 !important;}"][tlg_headings alignment="left" layout="bottom" title="<u>Testimonials</u>" subtitle="SUCCESS STORIES"][tlg_testimonial pppage="3" layout="carousel-column" filter="251"][/vc_column][vc_column width="1/3" css=".vc_custom_1560096631048{padding-top: 100px !important;padding-right: 15% !important;padding-bottom: 100px !important;padding-left: 15% !important;background-color: #8c64eb !important;}"][tlg_spacer height="70" height_mobile="0"][tlg_headings alignment="left" layout="bottom" customize_font="yes" subtitle_uppercase="yes" title="<u>hello@naviantheme.com</u>" subtitle="LET’S WORK TOGETHER" title_size="30" subtitle_size="25"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0" tlg_enable_overlay="yes" tlg_text_align="text-center" tlg_bg_overlay_value="0"][vc_column][tlg_headings alignment="left" separator="split" title="04—|Our Statistics" subtitle="The facts and statistics"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/4"][tlg_counter to="2450" title="Complete Projects" layout="boxed" title_color_primary="primary-color" subtitle="Counter number" icon="ti-harddrives"][/vc_column][vc_column width="1/4"][tlg_counter to="320" suffix_text="+" title="Codes in month" layout="boxed" title_color_primary="primary-color" subtitle="Counter number" icon="ti-ruler-pencil"][/vc_column][vc_column width="1/4"][tlg_counter to="54" title="Awards Winning" layout="boxed" title_color_primary="primary-color" subtitle="Counter number" icon="ti-shield"][/vc_column][vc_column width="1/4"][tlg_counter to="300" title="Custom Elements" layout="boxed" title_color_primary="primary-color" subtitle="Counter number" icon="ti-ruler-alt-2"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0" tlg_enable_overlay="yes" tlg_text_align="text-center" tlg_bg_overlay_value="0"][vc_column][tlg_clients layout="carousel-auto"][/vc_column][/vc_row][vc_row tlg_padding="pb0" tlg_enable_overlay="yes" tlg_text_align="text-center" tlg_bg_overlay_value="0"][vc_column][tlg_headings alignment="left" separator="split" title="04—|Our Services" subtitle="Design for a better experience"][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-crown" title="Content Creation Services" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" image="8304" animate_bg_color="#49c5b6" animate_gd_color="#3451fb"]Consulting and the means by which the consultant[/tlg_icon_box][tlg_spacer height="60"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-user" title="Human Resource Management" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" image="8308" animate_bg_color="#49c5b6" animate_gd_color="#3451fb"]Consulting and the means by which the consultant[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-layers" title="Software Add-ons For Developers" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8309"]Use these business planning, finance, marketing[/tlg_icon_box][tlg_spacer height="60"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-bookmark-alt" title="Mobile App Development" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8310"]Use these business planning, finance, marketing[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-desktop" title="Training Program Event Growth" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8306"]Engaged vary according to industry and practice[/tlg_icon_box][tlg_spacer height="60"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-pencil-alt" title="Program Training Documentation" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8302"]Engaged vary according to industry and practice[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-reload" title="Financial Statement Market Tutorial" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8307"]Your first step towards small business success[/tlg_icon_box][tlg_spacer height="60"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-reload" title="Statement Online Marketplace" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8300"]Your first step towards small business success[/tlg_icon_box][/vc_column][/vc_row][vc_row][vc_column][tlg_headings alignment="left" separator="split" title="05—|Our Blog" subtitle="The latest news from us"][tlg_blog layout="carousel-3col" pppage="10"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1564757970174{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/friend-connections.jpg?id=8305) !important;}" tlg_bg_overlay="#dc324f" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#ffde36" el_class="white-form"][vc_column width="1/2" css=".vc_custom_1495619052912{padding-right: 8% !important;}"][tlg_headings alignment="left" separator="split" title="06—|Get in touch" subtitle="Contact us"][contact-form-7 id="681"][/vc_column][vc_column width="1/2"][tlg_headings alignment="left" separator="split" title="07—|FAQs" subtitle="The questions"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content icon="ti-vector" title="General Info"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content icon="ti-thought" title="Career Info"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content icon="ti-notepad" title="New Business"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-14'], 'desc' => $homepage['demo-14-desc'], 'id' => 'demo-14', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d14.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 15 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row][vc_column width="2/3"][tlg_headings alignment="left" customize_font="yes" title_uppercase="no" title="<strong>We develop <cite><i>stunning websites </i></cite> &amp; mobile apps.</strong>" title_size="48" title_spacing="0"][vc_column_text]We will work with you to fully understand your business to achieve the greatest amount of publicity possible so that you can see a return from the advertising.[/vc_column_text][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0"][vc_column][tlg_portfolio pppage="-1" layout="modern-3col" orderby="title" order="ASC"][tlg_spacer layout="line" line_style="spacer-large"][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column css_animation="bottom-to-top" width="1/2" css=".vc_custom_1564593145407{padding-right: 12% !important;}"][tlg_headings alignment="left" separator="line" spacing="mb16" title="Businessman pointing to a growth chart showing success"][vc_column_text]We take great pride in the quality of our content. Our writers create original content that is free of ethical concerns.[/vc_column_text][tlg_spacer height="15"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-light-bulb" title="Innovative Ideas"]Our most popular service is our Virtual Receptionist. We know that sometimes it’s difficult to get to the phone.[/tlg_icon_box][tlg_spacer height="8"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-headphone-alt" title="Information Survey"]You don’t want to miss that important call that could be the start of an exciting new business opportunity.[/tlg_icon_box][/vc_column][vc_column css_animation="bottom-to-top" width="1/2"][tlg_intro_content layout="video" video_hover="shadow" image="8305" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4"][/tlg_intro_content][/vc_column][/vc_row][vc_row tlg_enable_overlay="yes" css=".vc_custom_1543246601368{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2018/10/leone-venter.jpg?id=7771) !important;}" tlg_bg_overlay_value="0"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" title="What our customers <cite><i>say</i></cite>" subtitle="TESTIMONIALS"][tlg_testimonial layout="carousel" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line" title="We offer flexible <cite><i>support</i></cite>" subtitle="OUR SERVICES"][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-pencil-alt" title="Consulting Company" button_text="View More" btn_icon="ti-angle-right" image="8302"]Consulting and the means by which the consultant is according to industry.[/tlg_icon_box][tlg_spacer height="70"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-bookmark-alt" title="Creative Content" button_text="View More" btn_icon="ti-angle-right" image="8370"]Consulting and the means by which the consultant is according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-crown" title="Software Development" button_text="View More" btn_icon="ti-angle-right" image="8301"]The range of areas by the term consultant is wide to industry and practice.[/tlg_icon_box][tlg_spacer height="70"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-mobile" title="Mobile Solutions" button_text="View More" btn_icon="ti-angle-right" image="8309"]The range of areas by the term consultant is wide to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-timer" title="Training Program" button_text="View More" btn_icon="ti-angle-right" image="8306"]The consultant is engaged vary according to industry and practice.[/tlg_icon_box][tlg_spacer height="70"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-blackboard" title="Case Studies" button_text="View More" btn_icon="ti-angle-right" image="8304"]The consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column][tlg_spacer layout="line" line_style="spacer-large"][tlg_headings layout="bottom" separator="line" title="The latest news from <cite><i>us</i></cite>" subtitle="OUR BLOG"][tlg_blog layout="carousel"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" separator="line" title="The people behind your <cite><i>success</i></cite>" subtitle="MEET OUR TEAM"][tlg_team pppage="3" layout="circle" order="ASC"][tlg_spacer height="70"][tlg_clients layout="carousel-auto"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column width="1/3" css=".vc_custom_1495619052912{padding-right: 8% !important;}"][tlg_headings alignment="left" layout="bottom" separator="line" title="Let’s work <cite><i>together</i></cite>" subtitle="FAQS"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content icon="ti-vector" title="General Info"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique.[/tlg_accordion_content][tlg_accordion_content icon="ti-thought" title="Career Info"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu.[/tlg_accordion_content][tlg_accordion_content icon="ti-notepad" title="New Business"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique.[/tlg_accordion_content][/tlg_accordion][/vc_column][vc_column width="2/3" css=".vc_custom_1495619058844{padding-left: 8% !important;}"][tlg_headings alignment="left" layout="bottom" separator="line" title="We would love to hear <cite><i>from you</i></cite>" subtitle="CONTACT US"][contact-form-7 id="681"][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1538277998365{background-color: #dff1ef !important;}"][tlg_cta btn_link="url:%23||" button_layout="btn btn-filled btn-dark btn-rounded" customize_font="yes" title_uppercase="no" icon="ti-user" title="Crafting beautiful brands and websites." subtitle="Let's create something great together!" url="#" button_text="Start a Project" title_size="30" title_color="#0c0c0c"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-15'], 'desc' => $homepage['demo-15-desc'], 'id' => 'demo-15',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d15.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 16 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row tlg_background_style="bg-dark" el_id="intro" css=".vc_custom_1548691927310{background-color: #222222 !important;}"][vc_column width="1/3" css=".vc_custom_1506361386120{padding-right: 10% !important;}" el_class="text-center"][vc_single_image image="5811" alignment="center" style="vc_box_circle_2"][tlg_headings spacing="mb40" title="Thomas Henry" subtitle="Freelance Photographer"][tlg_icons][tlg_icons_content link="url:%23|||" layout="circle-icon circle-icon-bg small-icon" size="18" spacer="10" icon="ti-facebook" title="Follow me on Facebook" color="#ffffff" hover_color="#3b5998" bg_color="#3b5998" border_color="#3b5998" hover_bg_color="#ffffff" hover_border_color="#cccccc"][tlg_icons_content link="url:%23|||" layout="circle-icon circle-icon-bg small-icon" size="18" spacer="10" icon="ti-dribbble" title="Follow me on Dribbble" color="#ffffff" hover_color="#ea4c89" bg_color="#ea4c89" border_color="#ea4c89" hover_bg_color="#ffffff" hover_border_color="#cccccc"][tlg_icons_content link="url:%23|||" layout="circle-icon circle-icon-bg small-icon" size="18" spacer="10" icon="ti-instagram" title="Follow me on Instagram" color="#ffffff" hover_color="#517fa4" bg_color="#517fa4" border_color="#517fa4" hover_bg_color="#ffffff" hover_border_color="#cccccc"][/tlg_icons][/vc_column][vc_column width="2/3"][vc_column_text]I am a civil partnership and portrait photography with many years experience in the industry. I work with my clients to ensure that their experience of being photographed is right for them. I ensure that studio sessions are laid back and informal because the best photographs of you will be when you’re looking relaxed, not when you’re sitting at a silly angle with a posed smile on your face (we all remember those old school photos!).</p>
<p><strong>My photography skills:</strong>[/vc_column_text][tlg_skill_bar color="primary" alignment="text-left" align="" title="Designs" amount="80"][tlg_skill_bar color="success" alignment="text-left" align="" title="Photoshop" amount="58"][tlg_skill_bar alignment="text-left" align="" title="Illustrator" amount="87"][tlg_skill_bar color="danger" alignment="text-left" align="" title="Movie Making" amount="64"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt0" el_id="work" css=".vc_custom_1548691943419{background-color: #222222 !important;}"][vc_column][vc_column_text]</p>
<p>[gallery layout="flip-photoswipe-center" ids="6195,6196,6199,6198,6201,6197,6202,6200,6203"]</p>
<p>[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content" tlg_background_style="bg-dark" css=".vc_custom_1548777904881{background-color: #222222 !important;}"][vc_column width="1/2" css=".vc_custom_1565884888978{padding-right: 15% !important;}"][tlg_headings layout="bottom" title="<u>Introduction</u>" subtitle="ABOUT ME"][vc_column_text]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged vary according to industry and practice.[/vc_column_text][tlg_spacer height="15"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-light-bulb" title="Innovative Ideas"]Our most popular service is our Virtual Receptionist. We know that sometimes it’s difficult to get to the phone.[/tlg_icon_box][tlg_spacer height="8"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-headphone-alt" title="Information Survey"]You don’t want to miss that important call that could be the start of an exciting new business opportunity.[/tlg_icon_box][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" title="<u>FAQs</u>" subtitle="FREQUENTLY ASKED QUESTIONS"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="Multiple Services" icon="ti-layers"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content title="Professional Skills" icon="ti-map"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content title="5-stars rating feedback" icon="ti-import"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][/vc_column][/vc_row][vc_row full_width="stretch_row_content" tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1565885535476{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/collaboratings.jpg?id=8304) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#f53763"][vc_column][tlg_cta layout="center" btn_link="url:%23||" button_layout="btn-action" icon="ti-camera" title="Crafting beautiful brands" subtitle="Let's create something great together!" url="#" button_text="Start a Project"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" title="<u>Our Services</u>" subtitle="FEATURED PRODUCTS"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt0"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-world" title="Content Creatio" image="8304" icon_color="#49c5b6" box_bg_color_hover="#49c5b6" button_text="Read More" btn_icon="ti-angle-right"]The requirement for an experience is to meet the needs of the customer.[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-gift" title="The Lifestyle" image="8308" icon_color="#ff4040" box_bg_color_hover="#ff4040" button_text="Read More" btn_icon="ti-angle-right"]The range of areas by the term is wide to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-bookmark-alt" title="The Experiment" icon_color="#87c70f" image="8302" box_bg_color_hover="#87c70f" button_text="Read More" btn_icon="ti-angle-right"]The suggests the design layouts to the user’s behavior[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-blackboard" title="Seminar Business" icon_color="#194bed" image="8307" box_bg_color_hover="#194bed" button_text="Read More" btn_icon="ti-angle-right"]The consultant is engaged according to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-package" title="Growth Workshop" icon_color="#ffa3b5" image="8301" box_bg_color_hover="#ffa3b5" button_text="Read More" btn_icon="ti-angle-right"]WordPress Page Builder plugin with drag &amp; drop interface.[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-zoom-in" title="Target Market" icon_color="#fb7a46" image="8306" box_bg_color_hover="#fb7a46" button_text="Read More" btn_icon="ti-angle-right"]Responsive design is an approach to the user's behavior.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt64 pb64"][vc_column][tlg_clients layout="carousel-auto"][/vc_column][/vc_row][vc_row tlg_large_container="wide-container" tlg_enable_overlay="yes" tlg_parallax="not-parallax" tlg_bg_overlay="#000000" tlg_bg_overlay_value="8" tlg_bg_gradient_color="#444444"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings layout="bottom" title="<u>Testimonials</u>" subtitle="WE'RE TRUSTED BY CLIENTS"][tlg_testimonial layout="carousel" filter="251"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_text_align="text-center" el_id="contact" css=".vc_custom_1548691809304{background-color: #222222 !important;}"][vc_column width="1/4" css=".vc_custom_1488442095320{padding-top: 5% !important;padding-right: 10% !important;padding-bottom: 5% !important;padding-left: 10% !important;}"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" title="<u>Contact</u>" subtitle="SO WHAT’S NEXT?"][vc_column_text]Have you got any great idea in mind?<br />
Let's work together now![/vc_column_text][contact-form-7 id="681"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][tlg_instagram number="12" username="envato"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column width="1/4" css=".vc_custom_1507627207316{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #3b5998 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-facebook"][/tlg_icons][/vc_column][vc_column width="1/4" css=".vc_custom_1559461490007{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #9a8f62 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-instagram"][/tlg_icons][/vc_column][vc_column width="1/4" css=".vc_custom_1507627339023{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #08c1e2 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-twitter-alt"][/tlg_icons][/vc_column][vc_column width="1/4" css=".vc_custom_1523445722480{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;background-color: #ea4c89 !important;}"][tlg_icons][tlg_icons_content link="url:%23|||" hover="hvr-push" size="32" spacer="10" icon="ti-dribbble"][/tlg_icons][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-16'], 'desc' => $homepage['demo-16-desc'], 'id' => 'demo-16',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d16.jpg', 'col' => 4, 'code' => $code,
		);
	// Home Pages 17 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_height="yes" tlg_background_style="bg-dark" tlg_enable_overlay="yes" tlg_bg_gradient_type="rotate" tlg_parallax="not-parallax" tlg_text_align="text-center" css=".vc_custom_1565882683463{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/friend-connections.jpg?id=8305) !important;}" tlg_bg_overlay_value="9" tlg_bg_overlay="#ffa3b5" tlg_bg_gradient_color="#0000ef" el_class="white-form"][vc_column][tlg_headings layout="bottom" separator="line" subtitle_font="0" title="Coming soon!" subtitle="Welcome to our site"][tlg_countdown datetime="2028/01/08 14:16" layout="boxed"][tlg_spacer height="80" height_mobile="20"][vc_row_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][contact-form-7 id="518"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][tlg_spacer height="70"][tlg_icons][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" hover="hvr-grow" size="" spacer="10" icon="ti-instagram" color="#ffffff" hover_color="#ffffff" hover_bg_color="#9b6954" hover_border_color="#9b6954"][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" hover="hvr-grow" size="" spacer="10" icon="ti-facebook" color="#ffffff" hover_color="#ffffff" hover_bg_color="#6a75c8" hover_border_color="#6a75c8"][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" hover="hvr-grow" size="" spacer="10" icon="ti-twitter" color="#ffffff" hover_color="#ffffff" hover_bg_color="#6abaf7" hover_border_color="#6abaf7"][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" hover="hvr-grow" size="" spacer="10" icon="ti-google" color="#ffffff" hover_color="#ffffff" hover_bg_color="#f05660" hover_border_color="#f05660"][/tlg_icons][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-17'], 'desc' => $homepage['demo-17-desc'], 'id' => 'demo-17',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d17.jpg', 'col' => 4, 'code' => $code,
			
		);
	// Home Pages 18 ----------------------------------------------------	
		$code = <<<CODE
		[vc_row full_height="yes" tlg_enable_overlay="yes" css=".vc_custom_1566724433047{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2015/12/groupwalls.jpg?id=5309) !important;}" tlg_bg_overlay_value="0"][vc_column width="2/3"][tlg_headings alignment="left" layout="bottom" spacing="mb40" customize_font="yes" subtitle_font="0" title="Under Construction" title_size="65" subtitle="MAINTENANCE"][tlg_countdown datetime="2026/01/20 17:00" align="text-left" color="#000000"][tlg_spacer height="40" height_mobile="20"][vc_column_text el_class="dark-color"]The administrators are performing scheduled maintenance. If you have any questions, please contact <u><a href="mailto:help@yoursite.com">help@yoursite.com</a></u>.<br />
Or you can follow our twitter so we can happily announce it to your timeline.[/vc_column_text][tlg_button title="NOTIFY ME" btn_link="url:%23|||" layout="btn-action"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['home'], 'name' => $homepage['demo-18'], 'desc' => $homepage['demo-18-desc'], 'id' => 'demo-18',
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/d18.jpg', 'col' => 4, 'code' => $code,
		);

// PAGE ---------------------------------------------------

	// Page 1 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_text_align="text-center"][vc_column][tlg_header_single same_title="yes" title_style="bold" btn_link="url:%23main|||" button_layout="btn btn-filled btn-rounded" enable_button_2="yes" btn_link_2="url:%23|||" button_layout_2="btn btn-rounded" icon_2="ti-control-play" hide_on_scroll="scrolled-no-hide" overlay="yes" title="Businesses <cite><i>&amp;</i></cite> Organizations" image="8301" header_text_color="#ffffff" button_text="View More" button_text_2="Take a tour" modal_embed_2="https://www.youtube.com/watch?v=qZEPs3vmYB4" header_overlay_color="#49c5b6" header_overlay_value="9" header_gradient_color="#0000ef"]With our custom elements content, you can create nearly unlimited layouts as you wish.[/tlg_header_single][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column][tlg_intro_carousel style="intro-left"][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8306" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]

Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.

Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.

[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8302" title="Use these business marketing and management templates" button_text="Discover Now"]

Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.

Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.

[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_carousel][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8308" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]

Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.

Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.

[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8300" title="Use these business marketing and management templates" button_text="Discover Now"]

Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.

Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.

[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line" title="Featured Services" subtitle="OUR SERVICES"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-pencil-alt" title="Consulting Company" button_text="View More" btn_icon="ti-angle-right" image="8302"]Consulting and the means by which the consultant is according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-crown" title="Software Development" button_text="View More" btn_icon="ti-angle-right" image="8301"]The range of areas by the term consultant is wide to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-timer" title="Training Program" button_text="View More" btn_icon="ti-angle-right" image="8306"]The consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column][tlg_headings layout="bottom" separator="line" title="The Latest News" subtitle="OUR BLOG"][tlg_blog layout="carouseldetail-3col" pppage="3"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1564744123657{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/group-laps.jpg?id=8306) !important;}" tlg_bg_overlay_value="9" tlg_bg_overlay="#49c5b6" tlg_bg_gradient_color="#0000ef"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" separator="line" title="We're Trusted By Clients" subtitle="TESTIMINIALS"][tlg_testimonial layout="carousel-quote" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line" title="Our Pricing" subtitle="PLAN POLICY"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column width="1/3"][tlg_pricing_table amount="29" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-thought" tbl_custom_layout="border-radius-m" title="Starter" subtitle="Best price" btn_color="#ffffff" btn_bg="#fa4e40" btn_border="#fa4e40" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#fa4e40" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>Unlimited hours of support</li>
 	<li>Social media integration</li>
 	<li>Analytic integration</li>
 	<li>Unlimited storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="49" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-package" tbl_custom_layout="border-radius-m" title="Business" subtitle="Most popular" tbl_price_color="#ffffff" btn_color="#ffffff" btn_bg="#49c5b6" btn_border="#49c5b6" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_price_bg_color="#49c5b6" tbl_icon_bgcolor="#49c5b6" tbl_icon_color="#ffffff" tbl_border="#49c5b6"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>10 hours of support</li>
 	<li>Social media integration</li>
 	<li>Advanced analytic</li>
 	<li>1GB of storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="69" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-world" tbl_custom_layout="border-radius-m" title="Enterprise" subtitle="Best choice" tbl_price_color="#5766d3" btn_color="#ffffff" btn_bg="#5766d3" btn_border="#5766d3" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#5766d3" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>Unlimited of support</li>
 	<li>Social media integration</li>
 	<li>Basic analytic</li>
 	<li>40TB of storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt64 pb64"][vc_column][tlg_clients layout="carousel-auto"][/vc_column][/vc_row][vc_row tlg_large_container="small-container" tlg_background_style="bg-dark" tlg_enable_overlay="yes" tlg_bg_gradient_type="rotate" tlg_text_align="text-center" css=".vc_custom_1564744168629{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/collaboratings.jpg?id=8304) !important;}" tlg_bg_overlay="#0000ef" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#49c5b6" el_class="white-form"][vc_column][tlg_spacer height="80" height_mobile="10"][tlg_headings layout="bottom" separator="line" title="Signup For Free Tips &amp; Resources" subtitle="SUBSCRIBE NOW"][contact-form-7 id="3851"][tlg_spacer height="35" height_mobile="10"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['page'], 'name' => $page['page-1'], 'desc' => $page['page-1-desc'], 'id' => 'page-1', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/p1.jpg', 'col' => 4, 'code' => $code,
		);
	// Page 2 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column][tlg_header_single layout="2-columns" alignment="text-left" subtitle_before="yes" title_style="bold" btn_link="url:%23contact|||" button_layout="btn btn-filled btn-rounded" button_icon_hover="yes" icon="ti-angle-right" title="I'm Kaelyn. A <cite><i>front-end designer</i></cite> from New York." subtitle="Welcome!" image="8370" button_text="Contact Now" header_overlay_value="8"]In a professional context it often happens that private or corporate clients coder a publication to be made and presented with the actual content still not being ready.[/tlg_header_single][/vc_column][/vc_row][vc_row tlg_text_align="text-center"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings separator="line" spacing="mb40" title="About Me"][vc_column_text]My designs have been sold all over Europe and the USA and I have worked with some of the biggest designers in the industry. I’m also currently working with a big supermarket to develop a gorgeous, yet affordable, range of beautifully printed key pieces that no women’s wardrobe should be without![/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary" tlg_equal_height="equal-height" el_id="education"][vc_column width="1/2" css=".vc_custom_1565629849300{padding-top: 100px !important;padding-right: 15% !important;padding-bottom: 100px !important;padding-left: 15% !important;}"][tlg_headings alignment="left" spacing="mb40" title="Education"][tlg_timeline][tlg_timeline_content datetime="2012/03/14 16:47" icon="ti-vector" title="Diploma High School, San Antonio" icon_color="#49c5b6" icon_color_hover="#333"]Majored in general education.[/tlg_timeline_content][tlg_timeline_content datetime="2014/03/18 16:47" icon="ti-receipt" title="University of Illinois" icon_color="#49c5b6" icon_color_hover="#333"]Majored in design interaction education.[/tlg_timeline_content][tlg_timeline_content datetime="2016/04/06 16:47" icon="ti-user" title="University of Design Master" icon_color="#49c5b6" icon_color_hover="#333"]Majored in architecture education.[/tlg_timeline_content][tlg_timeline_content datetime="2017/02/15 16:47" icon="ti-world" title="Intern learning in USA" icon_color="#49c5b6" icon_color_hover="#333"]Distribute to clients and investors, both current and potential.[/tlg_timeline_content][/tlg_timeline][/vc_column][vc_column width="1/2" css=".vc_custom_1565630249454{padding-top: 100px !important;padding-right: 15% !important;padding-bottom: 100px !important;padding-left: 15% !important;background-color: #efefef !important;}"][tlg_headings alignment="left" spacing="mb40" title="Experience"][tlg_timeline][tlg_timeline_content style="image" icon="ti-desktop" title="Frontend designer in MMA Design" icon_color="#49c5b6" icon_color_hover="#333" image="7743"]I believe that analysis of your company and your customers is key in responding effective.[/tlg_timeline_content][tlg_timeline_content style="image" icon="ti-bookmark-alt" title="Content design in Bond News" icon_color="#49c5b6" icon_color_hover="#333" image="7742"]We have a number of different teams within our agency that specialise in different areas within teams of business.[/tlg_timeline_content][tlg_timeline_content style="image" icon="ti-panel" title="R&amp;D team leader at W Development" icon_color="#49c5b6" icon_color_hover="#333" image="7740"]Whether you require large banners and posters to promote your company or some require  more subtle large letter heads.[/tlg_timeline_content][/tlg_timeline][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings separator="line" spacing="mb0" title="Knowledge &amp; Skills"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" tlg_padding="pb0"][vc_column width="1/2"][tlg_skill_bar color="primary" alignment="text-left" align="" title="Designs" amount="80"][tlg_skill_bar color="primary" alignment="text-left" align="" title="Photoshop" amount="58"][tlg_skill_bar color="primary" alignment="text-left" align="" title="Illustrator" amount="87"][tlg_skill_bar color="primary" alignment="text-left" align="" title="Movie Making" amount="64"][/vc_column][vc_column width="1/2"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="Multiple Services" icon="ti-layers"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales.[/tlg_accordion_content][tlg_accordion_content title="Professional Skills" icon="ti-map"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius.[/tlg_accordion_content][tlg_accordion_content title="5-stars rating feedback" icon="ti-import"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae.[/tlg_accordion_content][/tlg_accordion][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0" tlg_text_align="text-center"][vc_column][tlg_spacer layout="line" line_style="spacer-large"][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0" tlg_text_align="text-center"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings separator="line" spacing="mb40" title="My Projects"][vc_column_text]To see a selection of my designs and sketches, which is how all my best designs start, take a look at my portfolio page.[/vc_column_text][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_text_align="text-center"][vc_column][tlg_portfolio pppage="6" layout="modern-3col"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column css=".vc_custom_1488341145859{background-color: #f4f4f4 !important;}"][tlg_cta btn_link="url:%23||" button_layout="btn btn-filled btn-rounded" customize_font="yes" title_uppercase="no" icon="ti-arrow-circle-right" title="Crafting beautiful brands and websites." subtitle="Let's create something great together!" url="#" button_text="Start a Project" title_size="30" title_color="#0c0c0c"][/vc_column][/vc_row][vc_row tlg_padding="pt0 pb0" tlg_text_align="text-center"][vc_column][tlg_spacer layout="line" line_style="spacer-large"][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings separator="line" title="Testimonials"][tlg_testimonial pppage="3" layout="carousel" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt180 pb180 pt-xs-80 pb-xs-80" tlg_enable_overlay="yes" tlg_parallax="not-parallax" tlg_text_align="text-center" css=".vc_custom_1565629702935{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2015/12/groupwalls.jpg?id=5309) !important;}" el_class="white-form" el_id="contact" tlg_bg_overlay_value="8"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings separator="line" spacing="mb40" title="Get In Touch"][vc_column_text]Fill out the contact form below to get in touch with me.[/vc_column_text][contact-form-7 id="681"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['page'], 'name' => $page['page-2'], 'desc' => $page['page-2-desc'], 'id' => 'page-2', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/p2.jpg', 'col' => 4, 'code' => $code,
		);
	// Page 3 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column][tlg_header_single fullscreen="fullscreen-off" padding="pt240 pb240 pt-xs-80 pb-xs-80" bg_video_style="youtube" bg_youtube_url="yLGfPNhtS2U" btn_link="url:%23main|||" button_layout="btn btn-filled btn-light btn-rounded" title="About Us" image="7316" button_text="Explore" subtitle="Get To Know Our Story"][/tlg_header_single][/vc_column][/vc_row][vc_row el_id="main"][vc_column][tlg_headings alignment="left" separator="split" title="01 —|What we do" subtitle="We make it simple"][vc_row_inner][vc_column_inner width="1/2"][tlg_icon_box icon_layout="square-icon square-icon-bg" box_layout="left" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" bg_color="primary-bgcolor-icon" icon="ti-ruler-pencil" title="Consulting Company" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged.[/tlg_icon_box][tlg_spacer height="60"][tlg_icon_box icon_layout="square-icon square-icon-bg" box_layout="left" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" bg_color="primary-bgcolor-icon" icon="ti-ruler-alt-2" title="Training Program" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged.[/tlg_icon_box][/vc_column_inner][vc_column_inner width="1/2"][tlg_icon_box icon_layout="square-icon square-icon-bg" box_layout="left" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" bg_color="primary-bgcolor-icon" icon="ti-shield" title="Software Development" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged.[/tlg_icon_box][tlg_spacer height="60"][tlg_icon_box icon_layout="square-icon square-icon-bg" box_layout="left" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" bg_color="primary-bgcolor-icon" icon="ti-cup" title="Awards Winning" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged.[/tlg_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings separator="split" title="02 —|Our capabilities" subtitle="Setting standards"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0"][vc_column][tlg_intro_carousel style="box-top"][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="8308" title="Public relations refers to the activities used to promote" subtitle="ABOUT US" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="8301" title="All program will be an excellent public relations move" subtitle="MEET UP" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="8310" title="After-sales service refers to the service maintenance" subtitle="CONTACT" button_text="Read More" icon="ti-angle-right"]Our teams are up to date with the media trends to prove themselves.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="8302" title="The branch refers to the office or shop of a company" subtitle="MEETING" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_padding="pt64 pb64"][vc_column][tlg_headings separator="split" title="03 —|Our Partners" subtitle="Friends on the journey"][tlg_clients][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings separator="split" title="04 —|Our Team" subtitle="We're here to help"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary" tlg_padding="pt0"][vc_column][tlg_team pppage="4" layout="fullwidth" column="4col" order="ASC" filter="249"][/vc_column][/vc_row][vc_row][vc_column][tlg_headings separator="split" title="05 —|Our Blog" subtitle="The latest news"][tlg_blog layout="carousel"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt180 pb180 pt-xs-80 pb-xs-80" tlg_enable_overlay="yes" css=".vc_custom_1565800930610{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/collaboratings.jpg?id=8304) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#fa4e40"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings layout="bottom" separator="line" spacing="mb16" title="What Our Clients Say" subtitle="Testimonials"][tlg_testimonial layout="carousel-column" filter="251"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_text_align="text-center" css=".vc_custom_1565801007019{background-color: #444444 !important;}"][vc_column width="1/4" css=".vc_custom_1471073259090{padding-top: 5% !important;padding-right: 10% !important;padding-bottom: 5% !important;padding-left: 10% !important;}"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" separator="line" spacing="mb16" title="We love to hear from you" subtitle="Get In Touch"][vc_column_text]If you enjoy our collection of travel news and information, you'll want to subscribe to our newsletters.[/vc_column_text][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt0" css=".vc_custom_1565801000259{background-color: #444444 !important;}"][vc_column width="1/3" css=".vc_custom_1557680467869{padding-right: 20% !important;}"][tlg_icon_box box_layout="left" icon_box_link="||" btn_link="|||" color="primary-color-icon" icon="ti-world" title="Location"]Haltern am See, Weseler Str. 151, Washington, NY, USA[/tlg_icon_box][tlg_spacer layout="line" line_width="100%" height="40"][tlg_icon_box box_layout="left" icon_box_link="||" btn_link="|||" color="primary-color-icon" icon="ti-user" title="Call support"](+68) 10062016 5555<br />
(+68) 11062014 6666[/tlg_icon_box][tlg_spacer layout="line" line_width="100%" height="40"][tlg_icon_box box_layout="left" icon_box_link="||" btn_link="|||" color="primary-color-icon" icon="ti-email" title="Our Email"]contact@yourwebsite.com[/tlg_icon_box][tlg_spacer height="40"][tlg_icons align="text-left"][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" size="15" spacer="5" icon="ti-instagram" color="#616a66" bg_color="#f2f2f2" hover_color="#ffffff" hover_bg_color="#517fa4" hover_border_color="#517fa4"][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" size="15" spacer="5" icon="ti-twitter" color="#616a66" bg_color="#f2f2f2" hover_color="#ffffff" hover_bg_color="#08c1e2" hover_border_color="#08c1e2"][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" size="15" spacer="5" icon="ti-dribbble" color="#616a66" bg_color="#f2f2f2" hover_color="#ffffff" hover_bg_color="#ea4c89" hover_border_color="#ea4c89"][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" size="15" spacer="5" icon="ti-facebook" color="#616a66" bg_color="#f2f2f2" hover_color="#ffffff" hover_bg_color="#3b5998" hover_border_color="#3b5998"][/tlg_icons][/vc_column][vc_column width="2/3"][contact-form-7 id="8228"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['page'], 'name' => $page['page-3'], 'desc' => $page['page-3-desc'], 'id' => 'page-3', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/p3.jpg', 'col' => 4, 'code' => $code,
		);
	// Page 4 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row" el_class="white-form"][vc_column][tlg_header_single fullscreen="fullscreen-off" padding="pt240 pb240 pt-xs-80 pb-xs-80" title_style="bold" cf7_shortcode="3409" btn_link="|||" title="Who We Are" subtitle="Keep up with the latest daily news with our newsletter!" image="8308" header_overlay_color="#0a0a0a" header_overlay_value="8.3"][/tlg_header_single][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_text_align="text-center"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings title="We Made The Team"][vc_column_text]We have a number of different teams within our agency. We have a number of different teams within our agency. We also create creative content based on the customer purposes.[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_team pppage="4" layout="fullwidth" column="4col" filter="249"][/vc_column][/vc_row][vc_row tlg_text_align="text-center"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings separator="line" title="Our Offices"][vc_column_text]We have the skills and resources to create professional films, we also create creative content based on the customer purposes. Our teams are up to date with the latest technologies.[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column][tlg_intro_carousel style="intro-left"][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8301" title="Use these business marketing and management templates" button_text="Discover Now"]

Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.

Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.

[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8306" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]

Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.

Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.

[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_carousel][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8308" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]

Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.

Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.

[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8300" title="Use these business marketing and management templates" button_text="Discover Now"]

Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.

Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.

[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_text_align="text-center"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings separator="line" title="Join The Team"][vc_column_text]We have a number of different teams within our agency.
Our teams are up to date with the latest technologies.[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt0"][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-crown" title="Content Creation Services" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" image="8304" animate_bg_color="#49c5b6" animate_gd_color="#3451fb"]Consulting and the means by which the consultant[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-layers" title="Software Add-ons For Developers" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8309"]Use these business planning, finance, marketing[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-desktop" title="Training Program Event Growth" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8306"]Engaged vary according to industry and practice[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-reload" title="Financial Statement Market Tutorial" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8307"]Your first step towards small business success[/tlg_icon_box][/vc_column][/vc_row][vc_row][vc_column css_animation="bottom-to-top" width="1/2" css=".vc_custom_1564593145407{padding-right: 12% !important;}"][tlg_headings alignment="left" separator="line" spacing="mb16" title="Businessman pointing to a growth chart showing success"][vc_column_text]We take great pride in the quality of our content. Our writers create original content that is free of ethical concerns.[/vc_column_text][tlg_spacer height="15"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-light-bulb" title="Innovative Ideas"]Our most popular service is our Virtual Receptionist. We know that sometimes it’s difficult to get to the phone.[/tlg_icon_box][tlg_spacer height="8"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-headphone-alt" title="Information Survey"]You don’t want to miss that important call that could be the start of an exciting new business opportunity.[/tlg_icon_box][/vc_column][vc_column css_animation="bottom-to-top" width="1/2"][tlg_intro_content layout="video" video_hover="shadow" image="8305" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4"][/tlg_intro_content][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_equal_height="equal-height"][vc_column width="1/2" css=".vc_custom_1526889933039{padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;background-color: #333333 !important;}"][tlg_headings alignment="left" layout="bottom" title="New York, USA" subtitle="Join us in"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="Account Management Intern" icon="ti-cup"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content title="Full Stack Developer" icon="ti-server"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content title="Director of New Business" icon="ti-bag"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][/vc_column][vc_column width="1/2" css=".vc_custom_1526889650016{padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;background-color: #404040 !important;}"][tlg_headings alignment="left" layout="bottom" title="London, UK" subtitle="Join us in"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="Senior Developer" icon="ti-layers"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content title="Senior Designer" icon="ti-map"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content title="Junior Developer" icon="ti-import"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_enable_overlay="yes" tlg_parallax="not-parallax" el_id="contact" css=".vc_custom_1565802227372{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/partnerss.jpg?id=8309) !important;}" tlg_bg_overlay="#000000" tlg_bg_overlay_value="8.4" el_class="white-form"][vc_column width="1/2" css=".vc_custom_1561994135727{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][tlg_gmap zoom="14" style="dark_blue" locations="Str. 151, Washington, NY" height="740" marker_image="5403"][/vc_column][vc_column width="1/2" css=".vc_custom_1561999440205{padding-top: 8% !important;padding-right: 19% !important;padding-bottom: 8% !important;padding-left: 10% !important;}"][tlg_headings alignment="left" layout="bottom" spacing="mb40" title="Need help finding information, we would love to hear <cite><i>from you</i></cite>" icon="ti-slice" divider_color="#49c5b6"][vc_column_text]Please complete the form and we'll get back to you within 1 – 2 business days. We look forward to working with you.[/vc_column_text][contact-form-7 id="681"][vc_column_text]For any question contact our 24/7 call center: <span class="primary-color">+001 345 6889</span>[/vc_column_text][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['page'], 'name' => $page['page-4'], 'desc' => $page['page-4-desc'], 'id' => 'page-4', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/p4.jpg', 'col' => 4, 'code' => $code,
		);
	// Page 5 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column][tlg_header_single title_style="bold" cf7_shortcode="681" btn_link="url:%23main|||" button_layout="btn-text" btn_position="bottom" title="Our Services" subtitle="We offers experienced and comprehensive help for your projects." image="8337" button_size="30" button_text_color="#ffffff" button_text_hover="#ffffff" icon="ti-angle-down" header_overlay_value="8"][/tlg_header_single][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" el_id="main"][vc_column][tlg_intro_content layout="halfscreen-left" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-angle-right" image="8309" title="Working business plan for your startup company <cite><i>Services</i></cite>" subtitle="People and Organisation" button_text="View More"]We have the skills to create professional films. Whether you want an promo video we can provide the services you require.

We will put together a detailed and specific style guide that covers all areas to ensure that anything produced in the future.[/tlg_intro_content][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_content layout="halfscreen-right" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" icon="ti-angle-right" image="7970" title="Explains ways you may need to modify your plan <cite><i>Experience</i></cite>" subtitle="Table meal service" button_text="View More"]We have the skills to create professional films. Whether you want an promo video we can provide the services you require.

We will put together a detailed and specific style guide that covers all areas to ensure that anything produced in the future.[/tlg_intro_content][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-primary"][vc_column][tlg_intro_content layout="halfscreen-left" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-angle-right" image="8304" title="Learn about one of the newest business <cite><i>Planning</i></cite>" subtitle="Sustainability" button_text="View More"]

We have the skills to create professional films. Whether you want an promo video we can provide the services you require.

We will put together a detailed and specific style guide that covers all areas to ensure that anything produced in the future.

[/tlg_intro_content][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][tlg_intro_content layout="halfscreen-right" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" icon="ti-angle-right" image="8306" title="Writing your company business plan is a good <cite><i>opportunity</i></cite>" subtitle="Cloud Choice" button_text="View More"]

We have the skills to create professional films. Whether you want an promo video we can provide the services you require.

We will put together a detailed and specific style guide that covers all areas to ensure that anything produced in the future.

[/tlg_intro_content][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['page'], 'name' => $page['page-5'], 'desc' => $page['page-5-desc'], 'id' => 'page-5', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/p5.jpg', 'col' => 4, 'code' => $code,
		);
	// Page 6 ----------------------------------------------------
		$code = <<<CODE
		[vc_row][vc_column css_animation="bottom-to-top" width="1/2" css=".vc_custom_1564593145407{padding-right: 12% !important;}"][tlg_headings alignment="left" separator="line" spacing="mb16" title="Businessman pointing to a growth chart showing success"][vc_column_text]We take great pride in the quality of our content. Our writers create original content that is free of ethical concerns.[/vc_column_text][tlg_spacer height="15"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-light-bulb" title="Innovative Ideas"]Our most popular service is our Virtual Receptionist. We know that sometimes it’s difficult to get to the phone.[/tlg_icon_box][tlg_spacer height="8"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-headphone-alt" title="Information Survey"]You don’t want to miss that important call that could be the start of an exciting new business opportunity.[/tlg_icon_box][/vc_column][vc_column css_animation="bottom-to-top" width="1/2"][tlg_intro_content layout="video" video_hover="shadow" image="8305" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4"][/tlg_intro_content][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings alignment="left" separator="line" title="What we offer"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0"][vc_column width="1/3"][tlg_icon_box box_layout="left" icon="ti-package" title="International Projects" icon_size="32"]Test your mettle with a challenging because new twist on dovetails.[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box box_layout="left" icon="ti-filter" title="Designed for You" icon_size="32"]How to make floating development panels to seasonal wood movement.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box box_layout="left" icon="ti-email" title="Shipping &amp; Mailing" icon_size="32"]How to accurately install hinges and add a shop-made ebony lift.[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box box_layout="left" icon="ti-map-alt" title="Location Intelligence" icon_size="32"]Learn a safer way to cut small parts in part seven of our video workshop.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box box_layout="left" icon="ti-stats-up" title="Groundbreaking" icon_size="32"]A tried and true finish. Learn about applying it in the final segment.[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box box_layout="left" icon="ti-panel" title="Design &amp; develope" icon_size="32"]How to get a perfect four-corner match in part one of our boxmaking.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pb0"][vc_column][tlg_headings alignment="left" separator="line" title="Business growth"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt0"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-mobile" title="Mobile Solutions" subtitle="UI/UX" image="8304" icon_color="#ff3363" box_bg_color_hover="#ff3363"]The first requirement for an user experience is to meet the exact.[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-shield" title="Cybersecurity" subtitle="Procurement" image="8301" icon_color="#fa4e40" box_bg_color_hover="#fa4e40"]The first requirement for an user experience is to meet the exact.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-thought" title="Service Integration" subtitle="Green IT" icon_color="#87c70f" image="8303" box_bg_color_hover="#87c70f"]Responsive design is an approach that suggests to the user’s behavior.[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-cloud" title="Cloud Choice" subtitle="Insights &amp; Data" icon_color="#5766d3" image="8305" box_bg_color_hover="#5766d3"]Deliver to the high standard that you would want for your business.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-package" title="Consulting Services" subtitle="Drag'Drop" icon_color="#ffa3b5" image="8302" box_bg_color_hover="#ffa3b5"]WordPress Page Builder plugin with drag &amp; drop interface.[/tlg_icon_box][tlg_spacer height="30"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" icon="ti-panel" title="Digital Manufacturing" subtitle="Multiscreen" icon_color="#0000ef" image="8300" box_bg_color_hover="#0000ef"]We are sure that we will have a package that meets your needs.[/tlg_icon_box][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings alignment="left" separator="line" title="Our Pricing Plan"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column width="1/3"][tlg_pricing_table amount="29" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-thought" tbl_custom_layout="border-radius-m" title="Starter" subtitle="Best price" btn_color="#ffffff" btn_bg="#fa4e40" btn_border="#fa4e40" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#fa4e40" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>Unlimited hours of support</li>
 	<li>Social media integration</li>
 	<li>Analytic integration</li>
 	<li>Unlimited storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="49" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-package" tbl_custom_layout="border-radius-m" title="Business" subtitle="Most popular" tbl_price_color="#ffffff" btn_color="#ffffff" btn_bg="#49c5b6" btn_border="#49c5b6" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_price_bg_color="#49c5b6" tbl_icon_bgcolor="#49c5b6" tbl_icon_color="#ffffff" tbl_border="#49c5b6"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>10 hours of support</li>
 	<li>Social media integration</li>
 	<li>Advanced analytic</li>
 	<li>1GB of storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="69" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-world" tbl_custom_layout="border-radius-m" title="Enterprise" subtitle="Best choice" tbl_price_color="#5766d3" btn_color="#ffffff" btn_bg="#5766d3" btn_border="#5766d3" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#5766d3" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>Unlimited of support</li>
 	<li>Social media integration</li>
 	<li>Basic analytic</li>
 	<li>40TB of storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][/vc_row][vc_row full_width="stretch_row_content" tlg_background_style="bg-primary" tlg_enable_overlay="yes" tlg_bg_overlay="#fa4e40" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#49c5b6" css=".vc_custom_1565803527196{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/collaboratings.jpg?id=8304) !important;}"][vc_column][tlg_cta layout="center" btn_link="url:%23||" button_layout="btn-action" icon="ti-cup" title="Crafting beautiful brands and websites." subtitle="Let's create something great together!" url="#" button_text="Start a Project"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['page'], 'name' => $page['page-6'], 'desc' => $page['page-6-desc'], 'id' => 'page-6', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/p6.jpg', 'col' => 4, 'code' => $code,
		);
	// Page 7 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column][tlg_gmap zoom="14" style="dark_gray" locations="Haltern am See, Weseler Str. 151" height="550" marker_image="5404"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0" el_class="contact-line"][vc_column width="1/2"][tlg_headings alignment="left" spacing="mb40" title="Whether you have a comment to share, we look forward to hearing <cite><i>from you</i></cite>"][/vc_column][vc_column width="1/2"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0" el_class="contact-line"][vc_column width="1/2"][vc_column_text]Please complete the form and we'll get back to you within 1 – 2 business days. We look forward to working with you.[/vc_column_text][tlg_icon_title_list style="icon-list-large"][tlg_icon_title_list_content title="Haltern am See, Weseler Str. 151, Washington, NY" icon="ti-location-pin" icon_color="#49c5b6"][tlg_icon_title_list_content title="+205 735001 214" icon="ti-mobile" icon_color="#49c5b6"][tlg_icon_title_list_content title="hi@yourcompany.com" icon="fa fa-envelope" icon_color="#49c5b6"][/tlg_icon_title_list][/vc_column][vc_column width="1/2" css=".vc_custom_1491983121937{padding-left: 8% !important;}"][contact-form-7 id="681"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['page'], 'name' => $page['page-7'], 'desc' => $page['page-7-desc'], 'id' => 'page-7', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/p7.jpg', 'col' => 4, 'code' => $code,
		);
	// Page 8 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column][tlg_header_single fullscreen="fullscreen-off" padding="pt240 pb240 pt-xs-80 pb-xs-80" title_style="bold" btn_link="url:%23main|||" button_layout="btn-text" btn_position="bottom" title="We love to hear from <i>you</i>" image="8307" button_size="30" button_text_color="#ffffff" button_text_hover="#ffffff" icon="ti-angle-down" header_overlay_color="#49c5b6" header_overlay_value="9" header_gradient_color="#3897f0"]If you enjoy our collection of travel news and information, you’ll want to subscribe to our newsletters.[/tlg_header_single][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" el_id="main"][vc_column width="1/3"][tlg_intro_content layout="box-top" btn_link="url:%23contact|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" image="8305" title="Los Angeles, USA" btn_text="Learn more" subtitle="Head Office" button_text="Join Us" icon="ti-angle-right"]6010 W 3rd St,, Los Angeles, CA 90039
contact@yourcompany.com
+209 1006 0411 310[/tlg_intro_content][/vc_column][vc_column width="1/3"][tlg_intro_content layout="box-top" btn_link="url:%23contact|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" image="8308" title="London, UK" btn_text="Learn more" subtitle="Euro Office" button_text="Join Us" icon="ti-angle-right"]20 Knightsbridge, London SW1X 7LA, UK
contact@yourcompany.com
+209 1006 0411 310[/tlg_intro_content][/vc_column][vc_column width="1/3"][tlg_intro_content layout="box-top" btn_link="url:%23contact|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" image="8302" title="Paris, FR" btn_text="Learn more" subtitle="Euro Office" button_text="Join Us" icon="ti-angle-right"]Avenue République, Montrouge, FR
contact@yourcompany.com
+209 1006 0411 310[/tlg_intro_content][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-dark" tlg_enable_overlay="yes" tlg_parallax="not-parallax" el_id="contact" css=".vc_custom_1565858274357{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/partnerss.jpg?id=8309) !important;}" tlg_bg_overlay="#000000" tlg_bg_overlay_value="8.4" el_class="white-form"][vc_column width="1/2" css=".vc_custom_1561994135727{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][tlg_gmap zoom="14" style="dark_blue" locations="Str. 151, Washington, NY" height="740" marker_image="5403"][/vc_column][vc_column width="1/2" css=".vc_custom_1561999440205{padding-top: 8% !important;padding-right: 19% !important;padding-bottom: 8% !important;padding-left: 10% !important;}"][tlg_headings alignment="left" layout="bottom" spacing="mb40" title="Need help finding information, we would love to hear <cite><i>from you</i></cite>" icon="ti-slice" divider_color="#49c5b6"][vc_column_text]Please complete the form and we'll get back to you within 1 – 2 business days. We look forward to working with you.[/vc_column_text][contact-form-7 id="681"][vc_column_text]For any question contact our 24/7 call center: <span class="primary-color">+001 345 6889</span>[/vc_column_text][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['page'], 'name' => $page['page-8'], 'desc' => $page['page-8-desc'], 'id' => 'page-8', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/p8.jpg', 'col' => 4, 'code' => $code,
		);
	// Page 9 ----------------------------------------------------
		$code = <<<CODE
		[vc_row][vc_column width="1/2" css=".vc_custom_1491994738990{padding-right: 5% !important;}"][tlg_headings alignment="left" title="Contact Info"][vc_column_text]Please complete the form and we'll get back to you within 1 - 2 business days. We look forward to working with you.[/vc_column_text][tlg_gmap zoom="14" style="dark_gray" locations="Str. 151, Washington, NY" height="300" marker_image="5403"][tlg_spacer height="40"][tlg_icon_title_list][tlg_icon_title_list_content icon="ti-mobile" title="+249 358927 350" icon_color="#0ab78f"][tlg_icon_title_list_content icon="ti-world" title="yourcompany.com" icon_color="#0ab78f"][tlg_icon_title_list_content icon="ti-location-pin" title="Haltern am See, Weseler Str. 151, Washington, NY" icon_color="#0ab78f"][/tlg_icon_title_list][/vc_column][vc_column width="1/2" css=".vc_custom_1491994746061{padding-left: 5% !important;}"][tlg_headings alignment="left" title="Things To Know"][tlg_accordion style="accordion-style-2 accordion-auto-close"][tlg_accordion_content icon="ti-layers" title="Getting Started"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content icon="ti-panel" title="Contact Details"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content icon="ti-notepad" title="Terms &amp; Conditions"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][tlg_testimonial layout="carousel-widget" filter="251"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" tlg_text_align="text-center" css=".vc_custom_1565859283575{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/bizsees.jpg?id=8301) !important;}" el_class="white-form" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9.5" tlg_bg_gradient_color="#eb8817"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_icons][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" size="15" spacer="15" icon="ti-instagram" color="#ffffff" bg_color="#517fa4" title="Instagram" border_color="#517fa4" hover_color="#517fa4" hover_bg_color="#ffffff" hover_border_color="#eeeeee"][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" size="15" spacer="15" icon="ti-twitter" color="#ffffff" bg_color="#08c1e2" border_color="#08c1e2" hover_color="#08c1e2" hover_bg_color="#ffffff" hover_border_color="#eeeeee" title="Twitter"][tlg_icons_content link="url:%23||" layout="circle-icon small-icon" size="15" spacer="15" icon="ti-facebook" color="#ffffff" bg_color="#3b5998" title="Facebook" border_color="#3b5998" hover_color="#3b5998" hover_bg_color="#ffffff" hover_border_color="#eeeeee"][/tlg_icons][tlg_spacer height="60"][tlg_headings separator="line" icon="ti-email" title="Send Us A Message" subtitle="We create creative content based on the customer purposes"][contact-form-7 id="678"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['page'], 'name' => $page['page-9'], 'desc' => $page['page-9-desc'], 'id' => 'page-9', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/p9.jpg', 'col' => 4, 'code' => $code,
		);
	// Page 10 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column][tlg_header_single fullscreen="fullscreen-off" padding="pt240 pb240 pt-xs-80 pb-xs-80" btn_link="url:%23main|||" button_layout="btn btn-primary-line btn-rounded" button_icon_hover="yes" icon="ti-angle-right" title="The <strong>Pricing</strong>" subtitle="A plan that's right for your business." image="8306" button_text="Build Yours" header_overlay_color="#49c5b6" header_overlay_value="9" header_gradient_color="#eb2f5b"][/tlg_header_single][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pb0" el_id="main"][vc_column][tlg_headings layout="bottom" separator="line" title="Choose the right plan for you" subtitle="PRICING &amp; PLANS"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column width="1/3"][tlg_pricing_table amount="19" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-thought" tbl_custom_layout="border-radius-m" title="Starter" subtitle="Best price" btn_color="#ffffff" btn_bg="#111111" btn_border="#111111" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#111111" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>Unlimited hours of support</li>
 	<li>Social media integration</li>
 	<li>Analytic integration</li>
 	<li>Unlimited storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="29" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-package" tbl_custom_layout="border-radius-m" title="Business" subtitle="Most popular" tbl_price_color="#ffffff" btn_color="#ffffff" btn_bg="#49c5b6" btn_border="#49c5b6" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_price_bg_color="#49c5b6" tbl_icon_bgcolor="#49c5b6" tbl_icon_color="#ffffff" tbl_border="#49c5b6"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>10 hours of support</li>
 	<li>Social media integration</li>
 	<li>Advanced analytic</li>
 	<li>1GB of storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="59" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-world" tbl_custom_layout="border-radius-m" title="Enterprise" subtitle="Best choice" tbl_price_color="#eb2f5b" btn_color="#ffffff" btn_bg="#eb2f5b" btn_border="#eb2f5b" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#eb2f5b" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]
<ul>
 	<li>Unlimited calls</li>
 	<li>Free hosting</li>
 	<li>Unlimited of support</li>
 	<li>Social media integration</li>
 	<li>Basic analytic</li>
 	<li>40TB of storage space</li>
</ul>
[/tlg_pricing_table][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt64 pb64"][vc_column][tlg_clients layout="carousel-auto"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_enable_overlay="yes" css=".vc_custom_1565864630737{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/collaboratings.jpg?id=8304) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#eb2f5b"][vc_column width="1/4"][/vc_column][vc_column width="1/2"][tlg_headings layout="bottom" separator="line" title="What Our Clients Say" subtitle="TESTIMONIALS"][tlg_testimonial layout="carousel-quote" filter="251"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row tlg_padding="pb0"][vc_column][tlg_headings layout="bottom" separator="line" title="Common Questions" subtitle="FAQs"][/vc_column][/vc_row][vc_row tlg_padding="pt0"][vc_column width="1/2"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="How can I get started?" icon="ti-layers"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content title="Does this require a contract?" icon="ti-map"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content title="How much does it cost?" icon="ti-import"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][/vc_column][vc_column width="1/2"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="Is my data secured? Who owns the content?" icon="ti-blackboard"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content title="Do you have Enterprise options available?" icon="ti-settings"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content title="Which platforms does it support?" icon="ti-layers"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][tlg_headings layout="bottom" separator="line" title="Join The Fastest-Growing Brands" subtitle="SUBSCRIBE NOW"][contact-form-7 id="518"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['page'], 'name' => $page['page-10'], 'desc' => $page['page-10-desc'], 'id' => 'page-10', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/p10.jpg', 'col' => 4, 'code' => $code,
		);

// ELEMENT ---------------------------------------------------

	// Element 1 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_padding="pb0"][vc_column css=".vc_custom_1488341145859{background-color: #f4f4f4 !important;}"][tlg_cta btn_link="url:%23||" button_layout="btn btn-filled btn-rounded" icon="ti-arrow-circle-right" title="Create your stunning website" subtitle="Let's create something great together!" url="#" button_text="Start a Project"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-1'], 'desc' => '', 'id' => 'el-1', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_1.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 2 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row_content" tlg_background_style="bg-primary" css=".vc_custom_1560521453212{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/friend-connections.jpg?id=8305) !important;}"][vc_column][tlg_cta btn_link="url:%23||" button_layout="btn btn-rounded" icon="ti-direction" title="Create your stunning website" subtitle="Let's create something great together!" url="#" button_text="Start a Project"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-2'], 'desc' => '', 'id' => 'el-2', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_2.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 3 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row_content" tlg_background_style="bg-primary"][vc_column][tlg_cta btn_link="url:%23||" button_layout="btn btn-rounded" title="Create your stunning website" subtitle="Let's create something great together!" url="#" button_text="Start a Project"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-3'], 'desc' => '', 'id' => 'el-3', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_3.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 4 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row_content" tlg_background_style="bg-primary" tlg_enable_overlay="yes" css=".vc_custom_1560521497343{padding-top: 5% !important;padding-bottom: 5% !important;background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/collaboratings.jpg?id=8304) !important;}" tlg_bg_overlay="#49c5b6" tlg_bg_overlay_value="9" tlg_bg_gradient_color="#0000ef"][vc_column][tlg_cta layout="center" btn_link="url:%23||" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-package" title="Create your stunning website" subtitle="MEET NAVIAN THEME" url="#" button_text="Purchase Now"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-4'], 'desc' => '', 'id' => 'el-4', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_4.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 5 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row"][vc_column width="1/4" css=".vc_custom_1470128891008{padding-top: 10% !important;padding-right: 10% !important;padding-bottom: 10% !important;padding-left: 10% !important;}"][/vc_column][vc_column width="1/2" css=".vc_custom_1462517024884{padding-top: 10% !important;padding-right: 10% !important;padding-bottom: 10% !important;padding-left: 10% !important;}"][tlg_headings separator="line" title="Standard Style"][tlg_accordion style="accordion-style-1 accordion-auto-close"][tlg_accordion_content title="Multiple Demos" icon="ti-layers"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content title="Visual Page Builder" icon="ti-map"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content title="1-Click Import" icon="ti-import"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][/vc_column][vc_column width="1/4"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-5'], 'desc' => '', 'id' => 'el-5', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_5.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 6 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_background_style="bg-secondary" tlg_parallax="not-parallax"][vc_column width="1/4" css=".vc_custom_1470128891008{padding-top: 10% !important;padding-right: 10% !important;padding-bottom: 10% !important;padding-left: 10% !important;}"][/vc_column][vc_column width="1/2" css=".vc_custom_1462517024884{padding-top: 10% !important;padding-right: 10% !important;padding-bottom: 10% !important;padding-left: 10% !important;}"][tlg_headings separator="line" title="Simple Style"][tlg_accordion style="accordion-style-2 accordion-auto-close"][tlg_accordion_content title="Multiple Demos" icon="ti-layers"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][tlg_accordion_content title="Visual Page Builder" icon="ti-map"]Auctor sem ultrices laoreet sagittis massa maecenas quisque lacinia leo lobortis, sem curae quisque donec etiam integer est ultrices curabitur, sociosqu feugiat nisi metus varius himenaeos leo ac fusce.[/tlg_accordion_content][tlg_accordion_content title="1-Click Import" icon="ti-import"]Torquent lacinia elementum sodales facilisis eleifend ultricies neque ipsum litora, habitasse euismod vel ut egestas viverra at suspendisse ut tristique, donec fusce nisi venenatis aptent vitae libero taciti sodales justo dictum pharetra.[/tlg_accordion_content][/tlg_accordion][/vc_column][vc_column width="1/4"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-6'], 'desc' => '', 'id' => 'el-6', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_6.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 7 ----------------------------------------------------
		$code = <<<CODE
		[vc_row][vc_column width="1/4" css=".vc_custom_1536595098870{padding-top: 8% !important;padding-right: 8% !important;padding-bottom: 8% !important;padding-left: 8% !important;}"][/vc_column][vc_column width="1/2"][tlg_headings separator="line" spacing="mb40" title="Simple style"][tlg_spacer height="60"][tlg_tabs style="tabs-style-3"][tlg_tabs_content icon="ti-layers" title="Multiple Demos"]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea ut labore et dolore.[/tlg_tabs_content][tlg_tabs_content icon="ti-map" title="Visual Page Builder"]Quinoa nesciunt laborum eiusmod. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus. Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, ut labore et dolore magna non cupidatat skateboard dolor brunch.[/tlg_tabs_content][tlg_tabs_content icon="ti-import" title="1-Click Import"]At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus. Food truck quinoa nesciunt laborum eiusmod. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch.[/tlg_tabs_content][/tlg_tabs][/vc_column][vc_column width="1/4"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-7'], 'desc' => '', 'id' => 'el-7', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_7.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 8 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_background_style="bg-secondary" css=".vc_custom_1536595247352{background-color: #f7f8f9 !important;}"][vc_column width="1/4"][/vc_column][vc_column width="1/2" css=".vc_custom_1470133485883{padding-top: 10% !important;padding-right: 10% !important;padding-bottom: 10% !important;padding-left: 10% !important;}"][tlg_headings separator="line" spacing="mb40" title="Icon style"][tlg_spacer height="60"][tlg_tabs style="tabs-style-2 tabs-style-title"][tlg_tabs_content icon="ti-layers" title="Multiple Demos"]Quinoa nesciunt laborum eiusmod. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Anim pariatur cliche reprehenderit.[/tlg_tabs_content][tlg_tabs_content icon="ti-map" title="Visual Page Builder"]Invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Non cupidatat skateboard dolor brunch. Quinoa nesciunt laborum eiusmod.Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Sed diam nonumy eirmod tempor invidunt ut labore et dolore.[/tlg_tabs_content][tlg_tabs_content icon="ti-import" title="1-Click Import"]Pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Quinoa nesciunt laborum eiusmod. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.[/tlg_tabs_content][/tlg_tabs][/vc_column][vc_column width="1/4"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-8'], 'desc' => '', 'id' => 'el-8', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_8.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 9 ----------------------------------------------------
		$code = <<<CODE
		[vc_row][vc_column width="1/3"][tlg_intro_content layout="box-top" subtitle_style="box" btn_link="url:%23||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" image="8370" title="Public relations refers to the activities used to promote" button_text="Read More" btn_text="Learn more" subtitle="Startups" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_content][/vc_column][vc_column width="1/3"][tlg_intro_content layout="box-top" subtitle_style="box" btn_link="url:%23||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" image="8304" title="All program will be an excellent public relations move" button_text="Read More" btn_text="Learn more" subtitle="Creative" title_link="|||" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_content][/vc_column][vc_column width="1/3"][tlg_intro_content layout="box-top" subtitle_style="box" btn_link="url:%23||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" image="8310" title="After-sales service refers to the service maintenance" button_text="Read More" btn_text="Learn more" subtitle="Business" icon="ti-angle-right"]Our teams are up to date with the media trends to prove themselves.[/tlg_intro_content][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-9'], 'desc' => '', 'id' => 'el-9', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_9.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 10 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_background_style="bg-secondary"][vc_column width="1/3"][tlg_intro_content layout="box-top" btn_link="url:%23||" button_layout="btn-read-more" image="8303" title="Public relations refers to the activities used to promote" button_text="Read More" btn_text="Learn more" subtitle="Startups"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_content][/vc_column][vc_column width="1/3"][tlg_intro_content layout="box-top" btn_link="url:%23||" button_layout="btn-read-more" image="8301" title="All program will be an excellent public relations move" button_text="Read More" btn_text="Learn more" subtitle="Creative" title_link="url:%23|||"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_content][/vc_column][vc_column width="1/3"][tlg_intro_content layout="box-top" btn_link="url:%23||" button_layout="btn-read-more" image="8300" title="After-sales service refers to the service maintenance" button_text="Read More" btn_text="Learn more" subtitle="Business"]Our teams are up to date with the media trends to prove themselves.[/tlg_intro_content][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-10'], 'desc' => '', 'id' => 'el-10', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_10.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 11 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_content layout="halfscreen-left" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" modal_button_layout="play" icon="ti-angle-right" image="8308" title="Use these business marketing and management templates" subtitle="ABOUT US" button_text="Discover Now" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4"]Third night i hath hath. Midst dominion whales won’t heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.

Saw also they’re good make living kind, moved herb face was for midst i. Had brought green have his likeness.[/tlg_intro_content][tlg_intro_content layout="halfscreen-right" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" icon="ti-angle-right" image="8306" title="Writing a business plan is to carefully think through every step" subtitle="OUR EXPERTS" button_text="Read More"]

Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They’re she’d two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.

Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.

[/tlg_intro_content][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-11'], 'desc' => '', 'id' => 'el-11', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_11.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 12 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_content layout="box-text-center" btn_link="url:%23|||" button_layout="btn-action" image="8302" title="The Visual Drag &amp; Drop Page Builder" button_text="READ MORE"]Analysis of your customers is key in responding to your promotional needs.[/tlg_intro_content][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-12'], 'desc' => '', 'id' => 'el-12', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_12.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 13 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_background_style="bg-secondary"][vc_column][tlg_intro_carousel style="box-top"][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="8308" title="Public relations refers to the activities used to promote" subtitle="ABOUT US" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="8301" title="All program will be an excellent public relations move" subtitle="MEET UP" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="8310" title="After-sales service refers to the service maintenance" subtitle="CONTACT" button_text="Read More" icon="ti-angle-right"]Our teams are up to date with the media trends to prove themselves.[/tlg_intro_carousel_content][tlg_intro_carousel_content layout="boxed" btn_link="url:%23||" button_icon_hover="yes" button_layout="btn-read-more" subtitle_link="url:%23|||" subtitle_first="yes" image="8302" title="The branch refers to the office or shop of a company" subtitle="MEETING" button_text="Read More" icon="ti-angle-right"]Analysis of your customers is key in responding to your promotional.[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-13'], 'desc' => '', 'id' => 'el-13', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_13.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 14 ----------------------------------------------------
		$code = <<<CODE
		[vc_row full_width="stretch_row" tlg_background_style="bg-dark"][vc_column][tlg_intro_carousel style="intro-left"][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8301" title="Use these business marketing and management templates" button_text="Discover Now"]</p>
<p>Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.</p>
<p>Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.</p>
<p>[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8306" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]</p>
<p>Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.</p>
<p>Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.</p>
<p>[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row][vc_row full_width="stretch_row" tlg_background_style="bg-secondary"][vc_column][tlg_intro_carousel][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8308" title="Writing a business plan is to carefully think through every step" button_text="Discover Now"]</p>
<p>Fourth fruitful his, be it for unto he fourth. Deep abundantly, wherein. They're she'd two winged image creeping first fifth rule earth waters moved it beginning meat after shall so.</p>
<p>Under after hath so stars cattle you us life for midst a life midst given lights fly. Forth seas fly moving rule whales.</p>
<p>[/tlg_intro_carousel_content][tlg_intro_carousel_content btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" subtitle_first="yes" icon="ti-angle-right" style="left" image="8300" title="Use these business marketing and management templates" button_text="Discover Now"]</p>
<p>Third night i hath hath. Midst dominion whales won't heaven unto. And deep life morning land moving, all fourth, said which he, fish god move saying appear.</p>
<p>Saw also they're good make living kind, moved herb face was for midst i. Had brought green have his likeness.</p>
<p>[/tlg_intro_carousel_content][/tlg_intro_carousel][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-14'], 'desc' => '', 'id' => 'el-14', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_14.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 15 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings separator="line" title="Left Style" subtitle="Icon left"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0"][vc_column width="1/4"][tlg_counter to="2450" suffix_text="+" title="Launched Projects" subtitle="Counter number" layout="side" icon="ti-harddrives"][/vc_column][vc_column width="1/4"][tlg_counter to="320" suffix_text="+" title="Codes in Month" subtitle="Counter number" layout="side" icon="ti-ruler-pencil"][/vc_column][vc_column width="1/4"][tlg_counter to="54" suffix_text="+" title="Awards Winning" subtitle="Counter number" layout="side" icon="ti-shield"][/vc_column][vc_column width="1/4"][tlg_counter to="98" suffix_text="%" title="Satisfied Clients" subtitle="Counter number" layout="side" icon="ti-user"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-15'], 'desc' => '', 'id' => 'el-15', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_15.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 16 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_padding="pb0"][vc_column][tlg_headings separator="line" title="Standard layout" subtitle="Icon with text"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/4"][tlg_counter to="2450" suffix_text="+" title="Launched Projects" subtitle="Counter number" icon_color_primary="primary-color" icon="ti-harddrives"][/vc_column][vc_column width="1/4"][tlg_counter to="320" suffix_text="+" title="Codes In Month" subtitle="Counter number" icon_color_primary="primary-color" icon="ti-ruler-pencil"][/vc_column][vc_column width="1/4"][tlg_counter to="54" suffix_text="+" title="Awards Winning" subtitle="Counter number" icon_color_primary="primary-color" icon="ti-shield"][/vc_column][vc_column width="1/4"][tlg_counter to="98" suffix_text="%" title="Satisfied Clients" subtitle="Counter number" icon_color_primary="primary-color" icon="ti-user"][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-16'], 'desc' => '', 'id' => 'el-16', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_16.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 17 ----------------------------------------------------
		$code = <<<CODE
		[vc_row][vc_column width="1/3"][tlg_pricing_table amount="29" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_layout="btn btn-filled btn-flat" btn_size="btn-block" customize_button="yes" title="Personal" btn_color="#222222" btn_bg="#eeeeee" btn_border="#eeeeee" btn_color_hover="#222222" btn_bg_hover="#dddddd" btn_border_hover="#dddddd"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>Unlimited hours of support</li>
<li>Social media integration</li>
<li>Analytic integration</li>
<li>Unlimited storage space</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="49" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_layout="btn btn-filled btn-flat" btn_size="btn-block" customize_button="yes" customize_table="yes" title="Standard" tbl_price_bg_color="#49c5b6" tbl_price_color="#ffffff" btn_color="#ffffff" btn_bg="#49c5b6" btn_border="#49c5b6" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>10 hours of support</li>
<li>Social media integration</li>
<li>Advanced analytic</li>
<li>1GB of storage space</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="69" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_layout="btn btn-filled btn-flat" btn_size="btn-block" customize_button="yes" title="Ultra" btn_color="#222222" btn_bg="#eeeeee" btn_border="#eeeeee" btn_color_hover="#222222" btn_bg_hover="#dddddd" btn_border_hover="#dddddd"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>Unlimited hours of support</li>
<li>Social media integration</li>
<li>Analytic integration</li>
<li>Unlimited storage space</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-17'], 'desc' => '', 'id' => 'el-17', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_17.jpg', 'col' => 2, 'code' => $code,
		);
	// Element 18 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_background_style="bg-secondary"][vc_column width="1/3"][tlg_pricing_table amount="29" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-thought" tbl_custom_layout="border-radius-m" title="Starter" subtitle="Best price" btn_color="#ffffff" btn_bg="#fa4e40" btn_border="#fa4e40" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#fa4e40" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>Unlimited hours of support</li>
<li>Social media integration</li>
<li>Analytic integration</li>
<li>Unlimited storage space</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="49" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-package" tbl_custom_layout="border-radius-m" title="Business" subtitle="Most popular" tbl_price_color="#ffffff" btn_color="#ffffff" btn_bg="#49c5b6" btn_border="#49c5b6" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_price_bg_color="#49c5b6" tbl_icon_bgcolor="#49c5b6" tbl_icon_color="#ffffff" tbl_border="#49c5b6"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>10 hours of support</li>
<li>Social media integration</li>
<li>Advanced analytic</li>
<li>1GB of storage space</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][vc_column width="1/3"][tlg_pricing_table amount="69" period="per month" btn_text="Order Now" btn_link="url:%23||" btn_size="btn-block" customize_button="yes" customize_table="yes" icon="ti-world" tbl_custom_layout="border-radius-m" title="Enterprise" subtitle="Best choice" tbl_price_color="#5766d3" btn_color="#ffffff" btn_bg="#5766d3" btn_border="#5766d3" btn_color_hover="#222222" btn_bg_hover="#eeeeee" btn_border_hover="#eeeeee" tbl_icon_bgcolor="#5766d3" tbl_icon_color="#ffffff" tbl_price_bg_color="#ffffff"]</p>
<ul>
<li>Unlimited calls</li>
<li>Free hosting</li>
<li>Unlimited of support</li>
<li>Social media integration</li>
<li>Basic analytic</li>
<li>40TB of storage space</li>
</ul>
<p>[/tlg_pricing_table][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['element'], 'name' => $element['el-18'], 'desc' => '', 'id' => 'el-18', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/el_18.jpg', 'col' => 2, 'code' => $code,
		);

// ICON BOX ----------------------------------------------------

	// Icon 1 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_padding="pb0"][vc_column][tlg_headings separator="line" title="Hover Style"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-pencil-alt" title="Consulting Company" button_text="View More" btn_icon="ti-angle-right" image="8302"]Consulting and the means by which the consultant is according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-crown" title="Software Development" button_text="View More" btn_icon="ti-angle-right" image="8301"]The range of areas by the term consultant is wide to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-rounded" icon="ti-timer" title="Training Program" button_text="View More" btn_icon="ti-angle-right" image="8306"]The consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-1'], 'desc' => '', 'id' => 'icon-1', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_1.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 2 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_background_style="bg-dark" tlg_padding="pb0"][vc_column][tlg_headings separator="line" title="Animate boxed"][/vc_column][/vc_row][vc_row tlg_background_style="bg-dark" tlg_padding="pt0"][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-crown" title="Content Creation Services" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" image="8304" animate_bg_color="#49c5b6" animate_gd_color="#3451fb"]Consulting and the means by which the consultant[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-layers" title="Software Add-ons For Developers" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8309"]Use these business planning, finance, marketing[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-desktop" title="Training Program Event Growth" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8306"]Engaged vary according to industry and practice[/tlg_icon_box][/vc_column][vc_column width="1/4"][tlg_icon_box customize_icon="yes" box_layout="animate-box" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-reload" title="Financial Statement Market Tutorial" box_bg_color="#f6f6f6" button_text="View More" btn_icon="ti-angle-right" animate_bg_color="#49c5b6" animate_gd_color="#3451fb" image="8307"]Your first step towards small business success[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-2'], 'desc' => '', 'id' => 'icon-2', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_2.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 3 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_padding="pb0"][vc_column][tlg_headings separator="line" title="Standard Style"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-ruler-pencil" title="Consulting Company" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-shield" title="Software Development" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-ruler-alt-2" title="Training Program" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged industry.[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-3'], 'desc' => '', 'id' => 'icon-3', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_3.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 4 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings separator="line" title="Left Style"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box icon_layout="square-icon" box_layout="left" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-ruler-pencil" title="Consulting Company" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_layout="square-icon" box_layout="left" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-shield" title="Software Development" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_layout="square-icon" box_layout="left" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" color="primary-color-icon" icon="ti-ruler-alt-2" title="Training Program" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged industry.[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-4'], 'desc' => '', 'id' => 'icon-4', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_4.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 5 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_padding="pb0"][vc_column][tlg_headings separator="line" title="Right Style"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box icon_layout="circle-icon circle-icon-bg" box_layout="right" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" bg_color="primary-bgcolor-icon" icon="ti-ruler-pencil" title="Consulting Company" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_layout="circle-icon circle-icon-bg" box_layout="right" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" bg_color="primary-bgcolor-icon" icon="ti-shield" title="Software Development" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_layout="circle-icon circle-icon-bg" box_layout="right" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" bg_color="primary-bgcolor-icon" icon="ti-ruler-alt-2" title="Training Program" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged industry.[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-5'], 'desc' => '', 'id' => 'icon-5', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_5.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 6 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings separator="line" title="Center Style"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box icon_layout="square-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line" icon="ti-ruler-pencil" title="Consulting Company" icon_color="#49c5b6" icon_border_color="#49c5b6" icon_color_hover="#ffffff" icon_bg_color_hover="#49c5b6" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_layout="square-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line" icon="ti-shield" title="Software Development" icon_color="#49c5b6" icon_border_color="#49c5b6" icon_color_hover="#ffffff" icon_bg_color_hover="#49c5b6" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_layout="square-icon" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line" icon="ti-ruler-alt-2" title="Training Program" icon_color="#49c5b6" icon_border_color="#49c5b6" icon_color_hover="#ffffff" icon_bg_color_hover="#49c5b6" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-6'], 'desc' => '', 'id' => 'icon-6', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_6.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 7 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_padding="pb0"][vc_column][tlg_headings separator="line" title="Color Style"][/vc_column][/vc_row][vc_row tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box box_layout="left" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" icon="ti-ruler-pencil" title="Consulting Company" title_color="#49c5b6" button_text="View More" btn_icon="ti-check"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box box_layout="left" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" customize_button="yes" btn_custom_layout="btn btn-rounded" icon="ti-shield" title="Software Development" title_color="rgba(213,37,23,0.5)" btn_border="rgba(213,37,23,0.5)" btn_color_hover="#ffffff" btn_bg_hover="rgba(213,37,23,0.5)" btn_border_hover="rgba(213,37,23,0.5)" button_text="View More" btn_icon="ti-check" btn_color="#0c0c0c"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box box_layout="left" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" customize_button="yes" btn_custom_layout="btn btn-rounded" icon="ti-ruler-alt-2" title="Training Program" title_color="rgba(66,168,15,0.5)" button_text="View More" btn_icon="ti-check" btn_color="#0c0c0c" btn_border="rgba(66,168,15,0.5)" btn_color_hover="#ffffff" btn_bg_hover="rgba(66,168,15,0.5)" btn_border_hover="rgba(66,168,15,0.5)"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-7'], 'desc' => '', 'id' => 'icon-7', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_7.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 8 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_background_style="bg-dark" tlg_padding="pt180 pb180 pt-xs-80 pb-xs-80" tlg_enable_overlay="yes" css=".vc_custom_1562063778654{background-image: url(http://demo.themelogi.com/navian/wp-content/uploads_dummy/2019/06/friend-connections.jpg?id=8305) !important;}" tlg_bg_overlay_value="8" tlg_bg_overlay="#000000"][vc_column width="1/3"][tlg_icon_box box_layout="behind" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-ruler-pencil" title="Consulting Company" subtitle="1" subtitle_color="#49c5b6" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box box_layout="behind" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-shield" title="Software Development" subtitle="2" subtitle_color="#fa4e40" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box box_layout="behind" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-ruler-alt-2" title="The Training Program" subtitle="3" subtitle_color="#42a80f" button_text="View More" btn_icon="ti-angle-right"]The range of areas by the term consultant is wide. Consulting and the means by which the consultant is engaged vary according to industry.[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-8'], 'desc' => '', 'id' => 'icon-8', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_8.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 9 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" icon="ti-world" title="Content Creation" image="8301" box_bg_color_hover="#0f37ff" button_text="Read More" btn_icon="ti-angle-right"]The first requirement for an user experience is to meet the exact needs of the customer.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" icon="ti-thought" title="The Experiment" icon_color_hover="#ffffff" image="8302" box_bg_color_hover="#0f37ff" button_text="Read More" btn_icon="ti-angle-right"]Responsive design is an approach that suggests the design to the user’s behavior.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" icon_box_link="||" btn_link="url:%23|||" btn_size="btn-sm" button_icon_hover="yes" button_layout="btn btn-primary-line btn-rounded" icon="ti-package" title="Growth Workshop" icon_color_hover="#ffffff" image="8304" box_bg_color_hover="#0f37ff" button_text="Read More" btn_icon="ti-angle-right"]WordPress Page Builder plugin with drag &amp; drop interface. Build any page fast and easy.[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-9'], 'desc' => '', 'id' => 'icon-9', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_9.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 10 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_text_align="text-left"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-world" title="Content" subtitle="Creation" image="8306" icon_color="#ff3363" box_bg_color_hover="#ff3363" button_text="Read More" btn_icon="ti-angle-right"]The first content requirement for an user experience[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-thought" title="Experiment" subtitle="Working" icon_color="#87c70f" image="8310" box_bg_color_hover="#87c70f" button_text="Read More" btn_icon="ti-angle-right"]Suggests the design layouts to the user’s behavior[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-package" title="Workshops" subtitle="Growth" icon_color="#ffa3b5" image="8308" box_bg_color_hover="#ffa3b5" button_text="Read More" btn_icon="ti-angle-right"]WordPress Page Builder plugin with drag &amp; drop interface[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-10'], 'desc' => '', 'id' => 'icon-10', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_10.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 11 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_background_style="bg-secondary"][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-world" title="Content Creation" image="8304" icon_color="#49c5b6" box_bg_color_hover="#49c5b6" button_text="Read More" btn_icon="ti-angle-right"]The requirement for an experience is to meet the needs of the customer.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-bookmark-alt" title="The Experiment" icon_color="#87c70f" image="8302" box_bg_color_hover="#87c70f" button_text="Read More" btn_icon="ti-angle-right"]The suggests the design layouts to the user’s behavior[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box customize_icon="yes" box_layout="animate-scroll" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-package" title="Growth Workshop" icon_color="#ffa3b5" image="8301" box_bg_color_hover="#ffa3b5" button_text="Read More" btn_icon="ti-angle-right"]WordPress Page Builder plugin with drag &amp; drop interface.[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-11'], 'desc' => '', 'id' => 'icon-11', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_11.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 12 ----------------------------------------------------
		$code = <<<CODE
		[vc_row][vc_column css_animation="bottom-to-top" width="1/2" css=".vc_custom_1564593145407{padding-right: 12% !important;}"][tlg_headings alignment="left" separator="line" spacing="mb16" title="Businessman pointing to a growth chart showing success"][vc_column_text]We take great pride in the quality of our content. Our writers create original content that is free of ethical concerns.[/vc_column_text][tlg_spacer height="15"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-light-bulb" title="Innovative Ideas"]Our most popular service is our Virtual Receptionist. We know that sometimes it’s difficult to get to the phone.[/tlg_icon_box][tlg_spacer height="8"][tlg_icon_box box_layout="left" color="primary-color-icon" icon="ti-headphone-alt" title="Information Survey"]You don’t want to miss that important call that could be the start of an exciting new business opportunity.[/tlg_icon_box][/vc_column][vc_column css_animation="bottom-to-top" width="1/2"][tlg_intro_content layout="video" video_hover="shadow" image="8305" modal_embed="https://www.youtube.com/watch?v=qZEPs3vmYB4"][/tlg_intro_content][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-12'], 'desc' => '', 'id' => 'icon-12', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_12.jpg', 'col' => 2, 'code' => $code,
		);
	// Icon 13 ----------------------------------------------------
		$code = <<<CODE
		[vc_row tlg_background_style="bg-secondary" tlg_padding="pb0"][vc_column][tlg_headings separator="line" title="Box Style"][/vc_column][/vc_row][vc_row tlg_background_style="bg-secondary" tlg_padding="pt0" tlg_text_align="text-center"][vc_column width="1/3"][tlg_icon_box icon_layout="circle-icon" box_layout="center-box" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-ruler-pencil" title="Consulting Company" icon_color="#ffffff" box_bg_color="#9cdc78" button_text="View More" btn_icon="ti-angle-right" title_color="#ffffff" subtitle_color="#ffffff" content_color="#ffffff" box_bg_gradient_color="#77dcae"]Consulting and the means by which the consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_layout="circle-icon" box_layout="center-box" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-shield" title="Software Development" icon_color="#ffffff" box_bg_color="#ffbe9e" button_text="View More" btn_icon="ti-angle-right" title_color="#ffffff" subtitle_color="#ffffff" content_color="#ffffff" box_bg_gradient_color="#ff8e9e"]Consulting and the means by which the consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][vc_column width="1/3"][tlg_icon_box icon_layout="circle-icon" box_layout="center-box" icon_box_link="||" btn_link="url:%23|||" button_icon_hover="yes" button_layout="btn btn-filled btn-light btn-rounded" icon="ti-thought" title="Training Program" box_bg_color="#55efcb" button_text="View More" btn_icon="ti-angle-right" icon_color="#ffffff" title_color="#ffffff" subtitle_color="#ffffff" content_color="#ffffff" box_bg_gradient_color="#5bcaff"]Consulting and the means by which the consultant is engaged vary according to industry and practice.[/tlg_icon_box][/vc_column][/vc_row]
CODE;
		$modules[] = array(
			'category' => $category['icon'], 'name' => $icon['icon-13'], 'desc' => '', 'id' => 'icon-13', 
			'img' => TLG_FRAMEWORK_URL . 'assets/img/vc-elements/icon_13.jpg', 'col' => 2, 'code' => $code,
		);

		return $modules;
	}
}